/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.SuppressFBWarnings;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class ProcessEvent
extends Event {
    ProcessEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return new EventBody(this.jsonData.getJSONObject("body"));
    }

    public ProcessEvent setBody(EventBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessEvent other = (ProcessEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.getEvent());
        hash = 83 * hash + Objects.hashCode(this.getBody());
        hash = 83 * hash + Objects.hashCode(this.getType());
        hash = 83 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ProcessEvent create(EventBody body, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", (Object)"process");
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"event");
        json.put("seq", (Object)seq);
        return new ProcessEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getName() {
            return this.jsonData.getString("name");
        }

        public EventBody setName(String name) {
            this.jsonData.put("name", (Object)name);
            return this;
        }

        public Integer getSystemProcessId() {
            return this.jsonData.has("systemProcessId") ? Integer.valueOf(this.jsonData.getInt("systemProcessId")) : null;
        }

        public EventBody setSystemProcessId(Integer systemProcessId) {
            this.jsonData.putOpt("systemProcessId", (Object)systemProcessId);
            return this;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getIsLocalProcess() {
            return this.jsonData.has("isLocalProcess") ? Boolean.valueOf(this.jsonData.getBoolean("isLocalProcess")) : null;
        }

        public EventBody setIsLocalProcess(Boolean isLocalProcess) {
            this.jsonData.putOpt("isLocalProcess", (Object)isLocalProcess);
            return this;
        }

        public String getStartMethod() {
            return this.jsonData.optString("startMethod", null);
        }

        public EventBody setStartMethod(String startMethod) {
            this.jsonData.putOpt("startMethod", (Object)startMethod);
            return this;
        }

        public Integer getPointerSize() {
            return this.jsonData.has("pointerSize") ? Integer.valueOf(this.jsonData.getInt("pointerSize")) : null;
        }

        public EventBody setPointerSize(Integer pointerSize) {
            this.jsonData.putOpt("pointerSize", (Object)pointerSize);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            if (!Objects.equals(this.getName(), other.getName())) {
                return false;
            }
            if (!Objects.equals(this.getSystemProcessId(), other.getSystemProcessId())) {
                return false;
            }
            if (!Objects.equals(this.getIsLocalProcess(), other.getIsLocalProcess())) {
                return false;
            }
            if (!Objects.equals(this.getStartMethod(), other.getStartMethod())) {
                return false;
            }
            return Objects.equals(this.getPointerSize(), other.getPointerSize());
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + Objects.hashCode(this.getName());
            if (this.getSystemProcessId() != null) {
                hash = 89 * hash + Integer.hashCode(this.getSystemProcessId());
            }
            if (this.getIsLocalProcess() != null) {
                hash = 89 * hash + Boolean.hashCode(this.getIsLocalProcess());
            }
            if (this.getStartMethod() != null) {
                hash = 89 * hash + Objects.hashCode(this.getStartMethod());
            }
            if (this.getPointerSize() != null) {
                hash = 89 * hash + Integer.hashCode(this.getPointerSize());
            }
            return hash;
        }

        public static EventBody create(String name) {
            JSONObject json = new JSONObject();
            json.put("name", (Object)name);
            return new EventBody(json);
        }
    }
}

