/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.SuppressFBWarnings;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class ProgressStartEvent
extends Event {
    ProgressStartEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return new EventBody(this.jsonData.getJSONObject("body"));
    }

    public ProgressStartEvent setBody(EventBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProgressStartEvent other = (ProgressStartEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.getEvent());
        hash = 67 * hash + Objects.hashCode(this.getBody());
        hash = 67 * hash + Objects.hashCode(this.getType());
        hash = 67 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ProgressStartEvent create(EventBody body, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", (Object)"progressStart");
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"event");
        json.put("seq", (Object)seq);
        return new ProgressStartEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getProgressId() {
            return this.jsonData.getString("progressId");
        }

        public EventBody setProgressId(String progressId) {
            this.jsonData.put("progressId", (Object)progressId);
            return this;
        }

        public String getTitle() {
            return this.jsonData.getString("title");
        }

        public EventBody setTitle(String title) {
            this.jsonData.put("title", (Object)title);
            return this;
        }

        public Integer getRequestId() {
            return this.jsonData.has("requestId") ? Integer.valueOf(this.jsonData.getInt("requestId")) : null;
        }

        public EventBody setRequestId(Integer requestId) {
            this.jsonData.putOpt("requestId", (Object)requestId);
            return this;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getCancellable() {
            return this.jsonData.has("cancellable") ? Boolean.valueOf(this.jsonData.getBoolean("cancellable")) : null;
        }

        public EventBody setCancellable(Boolean cancellable) {
            this.jsonData.putOpt("cancellable", (Object)cancellable);
            return this;
        }

        public String getMessage() {
            return this.jsonData.optString("message", null);
        }

        public EventBody setMessage(String message) {
            this.jsonData.putOpt("message", (Object)message);
            return this;
        }

        public Integer getPercentage() {
            return this.jsonData.has("percentage") ? Integer.valueOf(this.jsonData.getInt("percentage")) : null;
        }

        public EventBody setPercentage(Integer percentage) {
            this.jsonData.putOpt("percentage", (Object)percentage);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            if (!Objects.equals(this.getProgressId(), other.getProgressId())) {
                return false;
            }
            if (!Objects.equals(this.getTitle(), other.getTitle())) {
                return false;
            }
            if (!Objects.equals(this.getRequestId(), other.getRequestId())) {
                return false;
            }
            if (!Objects.equals(this.getCancellable(), other.getCancellable())) {
                return false;
            }
            if (!Objects.equals(this.getMessage(), other.getMessage())) {
                return false;
            }
            return Objects.equals(this.getPercentage(), other.getPercentage());
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + Objects.hashCode(this.getProgressId());
            hash = 89 * hash + Objects.hashCode(this.getTitle());
            if (this.getRequestId() != null) {
                hash = 89 * hash + Integer.hashCode(this.getRequestId());
            }
            if (this.getCancellable() != null) {
                hash = 89 * hash + Boolean.hashCode(this.getCancellable());
            }
            if (this.getMessage() != null) {
                hash = 89 * hash + Objects.hashCode(this.getMessage());
            }
            if (this.getPercentage() != null) {
                hash = 89 * hash + Integer.hashCode(this.getPercentage());
            }
            return hash;
        }

        public static EventBody create(String progressId, String title) {
            JSONObject json = new JSONObject();
            json.put("progressId", (Object)progressId);
            json.put("title", (Object)title);
            return new EventBody(json);
        }
    }
}

