/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Source;
import com.oracle.truffle.tools.dap.types.SourceBreakpoint;
import com.oracle.truffle.tools.dap.types.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class SetBreakpointsArguments
extends JSONBase {
    SetBreakpointsArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public Source getSource() {
        return new Source(this.jsonData.getJSONObject("source"));
    }

    public SetBreakpointsArguments setSource(Source source) {
        this.jsonData.put("source", (Object)source.jsonData);
        return this;
    }

    public List<SourceBreakpoint> getBreakpoints() {
        JSONArray json = this.jsonData.optJSONArray("breakpoints");
        if (json == null) {
            return null;
        }
        ArrayList<SourceBreakpoint> list = new ArrayList<SourceBreakpoint>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new SourceBreakpoint(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public SetBreakpointsArguments setBreakpoints(List<SourceBreakpoint> breakpoints) {
        if (breakpoints != null) {
            JSONArray json = new JSONArray();
            for (SourceBreakpoint sourceBreakpoint : breakpoints) {
                json.put((Object)sourceBreakpoint.jsonData);
            }
            this.jsonData.put("breakpoints", (Object)json);
        }
        return this;
    }

    public List<Integer> getLines() {
        JSONArray json = this.jsonData.optJSONArray("lines");
        if (json == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getInt(i));
        }
        return Collections.unmodifiableList(list);
    }

    public SetBreakpointsArguments setLines(List<Integer> lines) {
        if (lines != null) {
            JSONArray json = new JSONArray();
            for (int intValue : lines) {
                json.put(intValue);
            }
            this.jsonData.put("lines", (Object)json);
        }
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSourceModified() {
        return this.jsonData.has("sourceModified") ? Boolean.valueOf(this.jsonData.getBoolean("sourceModified")) : null;
    }

    public SetBreakpointsArguments setSourceModified(Boolean sourceModified) {
        this.jsonData.putOpt("sourceModified", (Object)sourceModified);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetBreakpointsArguments other = (SetBreakpointsArguments)obj;
        if (!Objects.equals(this.getSource(), other.getSource())) {
            return false;
        }
        if (!Objects.equals(this.getBreakpoints(), other.getBreakpoints())) {
            return false;
        }
        if (!Objects.equals(this.getLines(), other.getLines())) {
            return false;
        }
        return Objects.equals(this.getSourceModified(), other.getSourceModified());
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(this.getSource());
        if (this.getBreakpoints() != null) {
            hash = 59 * hash + Objects.hashCode(this.getBreakpoints());
        }
        if (this.getLines() != null) {
            hash = 59 * hash + Objects.hashCode(this.getLines());
        }
        if (this.getSourceModified() != null) {
            hash = 59 * hash + Boolean.hashCode(this.getSourceModified());
        }
        return hash;
    }

    public static SetBreakpointsArguments create(Source source) {
        JSONObject json = new JSONObject();
        json.put("source", (Object)source.jsonData);
        return new SetBreakpointsArguments(json);
    }
}

