/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.ValueFormat;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class SetExpressionArguments
extends JSONBase {
    SetExpressionArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public String getExpression() {
        return this.jsonData.getString("expression");
    }

    public SetExpressionArguments setExpression(String expression) {
        this.jsonData.put("expression", (Object)expression);
        return this;
    }

    public String getValue() {
        return this.jsonData.getString("value");
    }

    public SetExpressionArguments setValue(String value) {
        this.jsonData.put("value", (Object)value);
        return this;
    }

    public Integer getFrameId() {
        return this.jsonData.has("frameId") ? Integer.valueOf(this.jsonData.getInt("frameId")) : null;
    }

    public SetExpressionArguments setFrameId(Integer frameId) {
        this.jsonData.putOpt("frameId", (Object)frameId);
        return this;
    }

    public ValueFormat getFormat() {
        return this.jsonData.has("format") ? new ValueFormat(this.jsonData.optJSONObject("format")) : null;
    }

    public SetExpressionArguments setFormat(ValueFormat format) {
        this.jsonData.putOpt("format", (Object)(format != null ? format.jsonData : null));
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetExpressionArguments other = (SetExpressionArguments)obj;
        if (!Objects.equals(this.getExpression(), other.getExpression())) {
            return false;
        }
        if (!Objects.equals(this.getValue(), other.getValue())) {
            return false;
        }
        if (!Objects.equals(this.getFrameId(), other.getFrameId())) {
            return false;
        }
        return Objects.equals(this.getFormat(), other.getFormat());
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Objects.hashCode(this.getExpression());
        hash = 53 * hash + Objects.hashCode(this.getValue());
        if (this.getFrameId() != null) {
            hash = 53 * hash + Integer.hashCode(this.getFrameId());
        }
        if (this.getFormat() != null) {
            hash = 53 * hash + Objects.hashCode(this.getFormat());
        }
        return hash;
    }

    public static SetExpressionArguments create(String expression, String value) {
        JSONObject json = new JSONObject();
        json.put("expression", (Object)expression);
        json.put("value", (Object)value);
        return new SetExpressionArguments(json);
    }
}

