/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.dap.types.VariablePresentationHint;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class SetExpressionResponse
extends Response {
    SetExpressionResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public SetExpressionResponse setBody(ResponseBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetExpressionResponse other = (SetExpressionResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + Objects.hashCode(this.getBody());
        hash = 17 * hash + Objects.hashCode(this.getType());
        hash = 17 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 17 * hash + Boolean.hashCode(this.isSuccess());
        hash = 17 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 17 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 17 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static SetExpressionResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new SetExpressionResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getValue() {
            return this.jsonData.getString("value");
        }

        public ResponseBody setValue(String value) {
            this.jsonData.put("value", (Object)value);
            return this;
        }

        public String getType() {
            return this.jsonData.optString("type", null);
        }

        public ResponseBody setType(String type) {
            this.jsonData.putOpt("type", (Object)type);
            return this;
        }

        public VariablePresentationHint getPresentationHint() {
            return this.jsonData.has("presentationHint") ? new VariablePresentationHint(this.jsonData.optJSONObject("presentationHint")) : null;
        }

        public ResponseBody setPresentationHint(VariablePresentationHint presentationHint) {
            this.jsonData.putOpt("presentationHint", (Object)(presentationHint != null ? presentationHint.jsonData : null));
            return this;
        }

        public Integer getVariablesReference() {
            return this.jsonData.has("variablesReference") ? Integer.valueOf(this.jsonData.getInt("variablesReference")) : null;
        }

        public ResponseBody setVariablesReference(Integer variablesReference) {
            this.jsonData.putOpt("variablesReference", (Object)variablesReference);
            return this;
        }

        public Integer getNamedVariables() {
            return this.jsonData.has("namedVariables") ? Integer.valueOf(this.jsonData.getInt("namedVariables")) : null;
        }

        public ResponseBody setNamedVariables(Integer namedVariables) {
            this.jsonData.putOpt("namedVariables", (Object)namedVariables);
            return this;
        }

        public Integer getIndexedVariables() {
            return this.jsonData.has("indexedVariables") ? Integer.valueOf(this.jsonData.getInt("indexedVariables")) : null;
        }

        public ResponseBody setIndexedVariables(Integer indexedVariables) {
            this.jsonData.putOpt("indexedVariables", (Object)indexedVariables);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            if (!Objects.equals(this.getValue(), other.getValue())) {
                return false;
            }
            if (!Objects.equals(this.getType(), other.getType())) {
                return false;
            }
            if (!Objects.equals(this.getPresentationHint(), other.getPresentationHint())) {
                return false;
            }
            if (!Objects.equals(this.getVariablesReference(), other.getVariablesReference())) {
                return false;
            }
            if (!Objects.equals(this.getNamedVariables(), other.getNamedVariables())) {
                return false;
            }
            return Objects.equals(this.getIndexedVariables(), other.getIndexedVariables());
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + Objects.hashCode(this.getValue());
            if (this.getType() != null) {
                hash = 41 * hash + Objects.hashCode(this.getType());
            }
            if (this.getPresentationHint() != null) {
                hash = 41 * hash + Objects.hashCode(this.getPresentationHint());
            }
            if (this.getVariablesReference() != null) {
                hash = 41 * hash + Integer.hashCode(this.getVariablesReference());
            }
            if (this.getNamedVariables() != null) {
                hash = 41 * hash + Integer.hashCode(this.getNamedVariables());
            }
            if (this.getIndexedVariables() != null) {
                hash = 41 * hash + Integer.hashCode(this.getIndexedVariables());
            }
            return hash;
        }

        public static ResponseBody create(String value) {
            JSONObject json = new JSONObject();
            json.put("value", (Object)value);
            return new ResponseBody(json);
        }
    }
}

