/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class VariablePresentationHint
extends JSONBase {
    VariablePresentationHint(JSONObject jsonData) {
        super(jsonData);
    }

    public String getKind() {
        return this.jsonData.optString("kind", null);
    }

    public VariablePresentationHint setKind(String kind) {
        this.jsonData.putOpt("kind", (Object)kind);
        return this;
    }

    public List<String> getAttributes() {
        JSONArray json = this.jsonData.optJSONArray("attributes");
        if (json == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getString(i));
        }
        return Collections.unmodifiableList(list);
    }

    public VariablePresentationHint setAttributes(List<String> attributes) {
        if (attributes != null) {
            JSONArray json = new JSONArray();
            for (String string : attributes) {
                json.put((Object)string);
            }
            this.jsonData.put("attributes", (Object)json);
        }
        return this;
    }

    public String getVisibility() {
        return this.jsonData.optString("visibility", null);
    }

    public VariablePresentationHint setVisibility(String visibility) {
        this.jsonData.putOpt("visibility", (Object)visibility);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariablePresentationHint other = (VariablePresentationHint)obj;
        if (!Objects.equals(this.getKind(), other.getKind())) {
            return false;
        }
        if (!Objects.equals(this.getAttributes(), other.getAttributes())) {
            return false;
        }
        return Objects.equals(this.getVisibility(), other.getVisibility());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getKind() != null) {
            hash = 89 * hash + Objects.hashCode(this.getKind());
        }
        if (this.getAttributes() != null) {
            hash = 89 * hash + Objects.hashCode(this.getAttributes());
        }
        if (this.getVisibility() != null) {
            hash = 89 * hash + Objects.hashCode(this.getVisibility());
        }
        return hash;
    }

    public static VariablePresentationHint create() {
        JSONObject json = new JSONObject();
        return new VariablePresentationHint(json);
    }
}

