/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Source;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class Breakpoint
extends JSONBase {
    Breakpoint(JSONObject jsonData) {
        super(jsonData);
    }

    public Integer getId() {
        return this.jsonData.has("id") ? Integer.valueOf(this.jsonData.getInt("id")) : null;
    }

    public Breakpoint setId(Integer id) {
        this.jsonData.putOpt("id", (Object)id);
        return this;
    }

    public boolean isVerified() {
        return this.jsonData.getBoolean("verified");
    }

    public Breakpoint setVerified(boolean verified) {
        this.jsonData.put("verified", verified);
        return this;
    }

    public String getMessage() {
        return this.jsonData.optString("message", null);
    }

    public Breakpoint setMessage(String message) {
        this.jsonData.putOpt("message", (Object)message);
        return this;
    }

    public Source getSource() {
        return this.jsonData.has("source") ? new Source(this.jsonData.optJSONObject("source")) : null;
    }

    public Breakpoint setSource(Source source) {
        this.jsonData.putOpt("source", (Object)(source != null ? source.jsonData : null));
        return this;
    }

    public Integer getLine() {
        return this.jsonData.has("line") ? Integer.valueOf(this.jsonData.getInt("line")) : null;
    }

    public Breakpoint setLine(Integer line) {
        this.jsonData.putOpt("line", (Object)line);
        return this;
    }

    public Integer getColumn() {
        return this.jsonData.has("column") ? Integer.valueOf(this.jsonData.getInt("column")) : null;
    }

    public Breakpoint setColumn(Integer column) {
        this.jsonData.putOpt("column", (Object)column);
        return this;
    }

    public Integer getEndLine() {
        return this.jsonData.has("endLine") ? Integer.valueOf(this.jsonData.getInt("endLine")) : null;
    }

    public Breakpoint setEndLine(Integer endLine) {
        this.jsonData.putOpt("endLine", (Object)endLine);
        return this;
    }

    public Integer getEndColumn() {
        return this.jsonData.has("endColumn") ? Integer.valueOf(this.jsonData.getInt("endColumn")) : null;
    }

    public Breakpoint setEndColumn(Integer endColumn) {
        this.jsonData.putOpt("endColumn", (Object)endColumn);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Breakpoint other = (Breakpoint)obj;
        if (!Objects.equals(this.getId(), other.getId())) {
            return false;
        }
        if (this.isVerified() != other.isVerified()) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        if (!Objects.equals(this.getSource(), other.getSource())) {
            return false;
        }
        if (!Objects.equals(this.getLine(), other.getLine())) {
            return false;
        }
        if (!Objects.equals(this.getColumn(), other.getColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEndLine(), other.getEndLine())) {
            return false;
        }
        return Objects.equals(this.getEndColumn(), other.getEndColumn());
    }

    public int hashCode() {
        int hash = 5;
        if (this.getId() != null) {
            hash = 29 * hash + Integer.hashCode(this.getId());
        }
        hash = 29 * hash + Boolean.hashCode(this.isVerified());
        if (this.getMessage() != null) {
            hash = 29 * hash + Objects.hashCode(this.getMessage());
        }
        if (this.getSource() != null) {
            hash = 29 * hash + Objects.hashCode(this.getSource());
        }
        if (this.getLine() != null) {
            hash = 29 * hash + Integer.hashCode(this.getLine());
        }
        if (this.getColumn() != null) {
            hash = 29 * hash + Integer.hashCode(this.getColumn());
        }
        if (this.getEndLine() != null) {
            hash = 29 * hash + Integer.hashCode(this.getEndLine());
        }
        if (this.getEndColumn() != null) {
            hash = 29 * hash + Integer.hashCode(this.getEndColumn());
        }
        return hash;
    }

    public static Breakpoint create(Boolean verified) {
        JSONObject json = new JSONObject();
        json.put("verified", (Object)verified);
        return new Breakpoint(json);
    }
}

