/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.ColumnDescriptor;
import com.oracle.truffle.tools.dap.types.ExceptionBreakpointsFilter;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class Capabilities
extends JSONBase {
    Capabilities(JSONObject jsonData) {
        super(jsonData);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsConfigurationDoneRequest() {
        return this.jsonData.has("supportsConfigurationDoneRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsConfigurationDoneRequest")) : null;
    }

    public Capabilities setSupportsConfigurationDoneRequest(Boolean supportsConfigurationDoneRequest) {
        this.jsonData.putOpt("supportsConfigurationDoneRequest", (Object)supportsConfigurationDoneRequest);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsFunctionBreakpoints() {
        return this.jsonData.has("supportsFunctionBreakpoints") ? Boolean.valueOf(this.jsonData.getBoolean("supportsFunctionBreakpoints")) : null;
    }

    public Capabilities setSupportsFunctionBreakpoints(Boolean supportsFunctionBreakpoints) {
        this.jsonData.putOpt("supportsFunctionBreakpoints", (Object)supportsFunctionBreakpoints);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsConditionalBreakpoints() {
        return this.jsonData.has("supportsConditionalBreakpoints") ? Boolean.valueOf(this.jsonData.getBoolean("supportsConditionalBreakpoints")) : null;
    }

    public Capabilities setSupportsConditionalBreakpoints(Boolean supportsConditionalBreakpoints) {
        this.jsonData.putOpt("supportsConditionalBreakpoints", (Object)supportsConditionalBreakpoints);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsHitConditionalBreakpoints() {
        return this.jsonData.has("supportsHitConditionalBreakpoints") ? Boolean.valueOf(this.jsonData.getBoolean("supportsHitConditionalBreakpoints")) : null;
    }

    public Capabilities setSupportsHitConditionalBreakpoints(Boolean supportsHitConditionalBreakpoints) {
        this.jsonData.putOpt("supportsHitConditionalBreakpoints", (Object)supportsHitConditionalBreakpoints);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsEvaluateForHovers() {
        return this.jsonData.has("supportsEvaluateForHovers") ? Boolean.valueOf(this.jsonData.getBoolean("supportsEvaluateForHovers")) : null;
    }

    public Capabilities setSupportsEvaluateForHovers(Boolean supportsEvaluateForHovers) {
        this.jsonData.putOpt("supportsEvaluateForHovers", (Object)supportsEvaluateForHovers);
        return this;
    }

    public List<ExceptionBreakpointsFilter> getExceptionBreakpointFilters() {
        JSONArray json = this.jsonData.optJSONArray("exceptionBreakpointFilters");
        if (json == null) {
            return null;
        }
        ArrayList<ExceptionBreakpointsFilter> list = new ArrayList<ExceptionBreakpointsFilter>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new ExceptionBreakpointsFilter(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public Capabilities setExceptionBreakpointFilters(List<ExceptionBreakpointsFilter> exceptionBreakpointFilters) {
        if (exceptionBreakpointFilters != null) {
            JSONArray json = new JSONArray();
            for (ExceptionBreakpointsFilter exceptionBreakpointsFilter : exceptionBreakpointFilters) {
                json.put((Object)exceptionBreakpointsFilter.jsonData);
            }
            this.jsonData.put("exceptionBreakpointFilters", (Object)json);
        }
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsStepBack() {
        return this.jsonData.has("supportsStepBack") ? Boolean.valueOf(this.jsonData.getBoolean("supportsStepBack")) : null;
    }

    public Capabilities setSupportsStepBack(Boolean supportsStepBack) {
        this.jsonData.putOpt("supportsStepBack", (Object)supportsStepBack);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsSetVariable() {
        return this.jsonData.has("supportsSetVariable") ? Boolean.valueOf(this.jsonData.getBoolean("supportsSetVariable")) : null;
    }

    public Capabilities setSupportsSetVariable(Boolean supportsSetVariable) {
        this.jsonData.putOpt("supportsSetVariable", (Object)supportsSetVariable);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsRestartFrame() {
        return this.jsonData.has("supportsRestartFrame") ? Boolean.valueOf(this.jsonData.getBoolean("supportsRestartFrame")) : null;
    }

    public Capabilities setSupportsRestartFrame(Boolean supportsRestartFrame) {
        this.jsonData.putOpt("supportsRestartFrame", (Object)supportsRestartFrame);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsGotoTargetsRequest() {
        return this.jsonData.has("supportsGotoTargetsRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsGotoTargetsRequest")) : null;
    }

    public Capabilities setSupportsGotoTargetsRequest(Boolean supportsGotoTargetsRequest) {
        this.jsonData.putOpt("supportsGotoTargetsRequest", (Object)supportsGotoTargetsRequest);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsStepInTargetsRequest() {
        return this.jsonData.has("supportsStepInTargetsRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsStepInTargetsRequest")) : null;
    }

    public Capabilities setSupportsStepInTargetsRequest(Boolean supportsStepInTargetsRequest) {
        this.jsonData.putOpt("supportsStepInTargetsRequest", (Object)supportsStepInTargetsRequest);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsCompletionsRequest() {
        return this.jsonData.has("supportsCompletionsRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsCompletionsRequest")) : null;
    }

    public Capabilities setSupportsCompletionsRequest(Boolean supportsCompletionsRequest) {
        this.jsonData.putOpt("supportsCompletionsRequest", (Object)supportsCompletionsRequest);
        return this;
    }

    public List<String> getCompletionTriggerCharacters() {
        JSONArray json = this.jsonData.optJSONArray("completionTriggerCharacters");
        if (json == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getString(i));
        }
        return Collections.unmodifiableList(list);
    }

    public Capabilities setCompletionTriggerCharacters(List<String> completionTriggerCharacters) {
        if (completionTriggerCharacters != null) {
            JSONArray json = new JSONArray();
            for (String string : completionTriggerCharacters) {
                json.put((Object)string);
            }
            this.jsonData.put("completionTriggerCharacters", (Object)json);
        }
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsModulesRequest() {
        return this.jsonData.has("supportsModulesRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsModulesRequest")) : null;
    }

    public Capabilities setSupportsModulesRequest(Boolean supportsModulesRequest) {
        this.jsonData.putOpt("supportsModulesRequest", (Object)supportsModulesRequest);
        return this;
    }

    public List<ColumnDescriptor> getAdditionalModuleColumns() {
        JSONArray json = this.jsonData.optJSONArray("additionalModuleColumns");
        if (json == null) {
            return null;
        }
        ArrayList<ColumnDescriptor> list = new ArrayList<ColumnDescriptor>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new ColumnDescriptor(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public Capabilities setAdditionalModuleColumns(List<ColumnDescriptor> additionalModuleColumns) {
        if (additionalModuleColumns != null) {
            JSONArray json = new JSONArray();
            for (ColumnDescriptor columnDescriptor : additionalModuleColumns) {
                json.put((Object)columnDescriptor.jsonData);
            }
            this.jsonData.put("additionalModuleColumns", (Object)json);
        }
        return this;
    }

    public List<String> getSupportedChecksumAlgorithms() {
        JSONArray json = this.jsonData.optJSONArray("supportedChecksumAlgorithms");
        if (json == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getString(i));
        }
        return Collections.unmodifiableList(list);
    }

    public Capabilities setSupportedChecksumAlgorithms(List<String> supportedChecksumAlgorithms) {
        if (supportedChecksumAlgorithms != null) {
            JSONArray json = new JSONArray();
            for (String string : supportedChecksumAlgorithms) {
                json.put((Object)string);
            }
            this.jsonData.put("supportedChecksumAlgorithms", (Object)json);
        }
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsRestartRequest() {
        return this.jsonData.has("supportsRestartRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsRestartRequest")) : null;
    }

    public Capabilities setSupportsRestartRequest(Boolean supportsRestartRequest) {
        this.jsonData.putOpt("supportsRestartRequest", (Object)supportsRestartRequest);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsExceptionOptions() {
        return this.jsonData.has("supportsExceptionOptions") ? Boolean.valueOf(this.jsonData.getBoolean("supportsExceptionOptions")) : null;
    }

    public Capabilities setSupportsExceptionOptions(Boolean supportsExceptionOptions) {
        this.jsonData.putOpt("supportsExceptionOptions", (Object)supportsExceptionOptions);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsValueFormattingOptions() {
        return this.jsonData.has("supportsValueFormattingOptions") ? Boolean.valueOf(this.jsonData.getBoolean("supportsValueFormattingOptions")) : null;
    }

    public Capabilities setSupportsValueFormattingOptions(Boolean supportsValueFormattingOptions) {
        this.jsonData.putOpt("supportsValueFormattingOptions", (Object)supportsValueFormattingOptions);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsExceptionInfoRequest() {
        return this.jsonData.has("supportsExceptionInfoRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsExceptionInfoRequest")) : null;
    }

    public Capabilities setSupportsExceptionInfoRequest(Boolean supportsExceptionInfoRequest) {
        this.jsonData.putOpt("supportsExceptionInfoRequest", (Object)supportsExceptionInfoRequest);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportTerminateDebuggee() {
        return this.jsonData.has("supportTerminateDebuggee") ? Boolean.valueOf(this.jsonData.getBoolean("supportTerminateDebuggee")) : null;
    }

    public Capabilities setSupportTerminateDebuggee(Boolean supportTerminateDebuggee) {
        this.jsonData.putOpt("supportTerminateDebuggee", (Object)supportTerminateDebuggee);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsDelayedStackTraceLoading() {
        return this.jsonData.has("supportsDelayedStackTraceLoading") ? Boolean.valueOf(this.jsonData.getBoolean("supportsDelayedStackTraceLoading")) : null;
    }

    public Capabilities setSupportsDelayedStackTraceLoading(Boolean supportsDelayedStackTraceLoading) {
        this.jsonData.putOpt("supportsDelayedStackTraceLoading", (Object)supportsDelayedStackTraceLoading);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsLoadedSourcesRequest() {
        return this.jsonData.has("supportsLoadedSourcesRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsLoadedSourcesRequest")) : null;
    }

    public Capabilities setSupportsLoadedSourcesRequest(Boolean supportsLoadedSourcesRequest) {
        this.jsonData.putOpt("supportsLoadedSourcesRequest", (Object)supportsLoadedSourcesRequest);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsLogPoints() {
        return this.jsonData.has("supportsLogPoints") ? Boolean.valueOf(this.jsonData.getBoolean("supportsLogPoints")) : null;
    }

    public Capabilities setSupportsLogPoints(Boolean supportsLogPoints) {
        this.jsonData.putOpt("supportsLogPoints", (Object)supportsLogPoints);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsTerminateThreadsRequest() {
        return this.jsonData.has("supportsTerminateThreadsRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsTerminateThreadsRequest")) : null;
    }

    public Capabilities setSupportsTerminateThreadsRequest(Boolean supportsTerminateThreadsRequest) {
        this.jsonData.putOpt("supportsTerminateThreadsRequest", (Object)supportsTerminateThreadsRequest);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsSetExpression() {
        return this.jsonData.has("supportsSetExpression") ? Boolean.valueOf(this.jsonData.getBoolean("supportsSetExpression")) : null;
    }

    public Capabilities setSupportsSetExpression(Boolean supportsSetExpression) {
        this.jsonData.putOpt("supportsSetExpression", (Object)supportsSetExpression);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsTerminateRequest() {
        return this.jsonData.has("supportsTerminateRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsTerminateRequest")) : null;
    }

    public Capabilities setSupportsTerminateRequest(Boolean supportsTerminateRequest) {
        this.jsonData.putOpt("supportsTerminateRequest", (Object)supportsTerminateRequest);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsDataBreakpoints() {
        return this.jsonData.has("supportsDataBreakpoints") ? Boolean.valueOf(this.jsonData.getBoolean("supportsDataBreakpoints")) : null;
    }

    public Capabilities setSupportsDataBreakpoints(Boolean supportsDataBreakpoints) {
        this.jsonData.putOpt("supportsDataBreakpoints", (Object)supportsDataBreakpoints);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsReadMemoryRequest() {
        return this.jsonData.has("supportsReadMemoryRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsReadMemoryRequest")) : null;
    }

    public Capabilities setSupportsReadMemoryRequest(Boolean supportsReadMemoryRequest) {
        this.jsonData.putOpt("supportsReadMemoryRequest", (Object)supportsReadMemoryRequest);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsDisassembleRequest() {
        return this.jsonData.has("supportsDisassembleRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsDisassembleRequest")) : null;
    }

    public Capabilities setSupportsDisassembleRequest(Boolean supportsDisassembleRequest) {
        this.jsonData.putOpt("supportsDisassembleRequest", (Object)supportsDisassembleRequest);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsCancelRequest() {
        return this.jsonData.has("supportsCancelRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsCancelRequest")) : null;
    }

    public Capabilities setSupportsCancelRequest(Boolean supportsCancelRequest) {
        this.jsonData.putOpt("supportsCancelRequest", (Object)supportsCancelRequest);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsBreakpointLocationsRequest() {
        return this.jsonData.has("supportsBreakpointLocationsRequest") ? Boolean.valueOf(this.jsonData.getBoolean("supportsBreakpointLocationsRequest")) : null;
    }

    public Capabilities setSupportsBreakpointLocationsRequest(Boolean supportsBreakpointLocationsRequest) {
        this.jsonData.putOpt("supportsBreakpointLocationsRequest", (Object)supportsBreakpointLocationsRequest);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSupportsClipboardContext() {
        return this.jsonData.has("supportsClipboardContext") ? Boolean.valueOf(this.jsonData.getBoolean("supportsClipboardContext")) : null;
    }

    public Capabilities setSupportsClipboardContext(Boolean supportsClipboardContext) {
        this.jsonData.putOpt("supportsClipboardContext", (Object)supportsClipboardContext);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Capabilities other = (Capabilities)obj;
        if (!Objects.equals(this.getSupportsConfigurationDoneRequest(), other.getSupportsConfigurationDoneRequest())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsFunctionBreakpoints(), other.getSupportsFunctionBreakpoints())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsConditionalBreakpoints(), other.getSupportsConditionalBreakpoints())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsHitConditionalBreakpoints(), other.getSupportsHitConditionalBreakpoints())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsEvaluateForHovers(), other.getSupportsEvaluateForHovers())) {
            return false;
        }
        if (!Objects.equals(this.getExceptionBreakpointFilters(), other.getExceptionBreakpointFilters())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsStepBack(), other.getSupportsStepBack())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsSetVariable(), other.getSupportsSetVariable())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsRestartFrame(), other.getSupportsRestartFrame())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsGotoTargetsRequest(), other.getSupportsGotoTargetsRequest())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsStepInTargetsRequest(), other.getSupportsStepInTargetsRequest())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsCompletionsRequest(), other.getSupportsCompletionsRequest())) {
            return false;
        }
        if (!Objects.equals(this.getCompletionTriggerCharacters(), other.getCompletionTriggerCharacters())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsModulesRequest(), other.getSupportsModulesRequest())) {
            return false;
        }
        if (!Objects.equals(this.getAdditionalModuleColumns(), other.getAdditionalModuleColumns())) {
            return false;
        }
        if (!Objects.equals(this.getSupportedChecksumAlgorithms(), other.getSupportedChecksumAlgorithms())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsRestartRequest(), other.getSupportsRestartRequest())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsExceptionOptions(), other.getSupportsExceptionOptions())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsValueFormattingOptions(), other.getSupportsValueFormattingOptions())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsExceptionInfoRequest(), other.getSupportsExceptionInfoRequest())) {
            return false;
        }
        if (!Objects.equals(this.getSupportTerminateDebuggee(), other.getSupportTerminateDebuggee())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsDelayedStackTraceLoading(), other.getSupportsDelayedStackTraceLoading())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsLoadedSourcesRequest(), other.getSupportsLoadedSourcesRequest())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsLogPoints(), other.getSupportsLogPoints())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsTerminateThreadsRequest(), other.getSupportsTerminateThreadsRequest())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsSetExpression(), other.getSupportsSetExpression())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsTerminateRequest(), other.getSupportsTerminateRequest())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsDataBreakpoints(), other.getSupportsDataBreakpoints())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsReadMemoryRequest(), other.getSupportsReadMemoryRequest())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsDisassembleRequest(), other.getSupportsDisassembleRequest())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsCancelRequest(), other.getSupportsCancelRequest())) {
            return false;
        }
        if (!Objects.equals(this.getSupportsBreakpointLocationsRequest(), other.getSupportsBreakpointLocationsRequest())) {
            return false;
        }
        return Objects.equals(this.getSupportsClipboardContext(), other.getSupportsClipboardContext());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getSupportsConfigurationDoneRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsConfigurationDoneRequest());
        }
        if (this.getSupportsFunctionBreakpoints() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsFunctionBreakpoints());
        }
        if (this.getSupportsConditionalBreakpoints() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsConditionalBreakpoints());
        }
        if (this.getSupportsHitConditionalBreakpoints() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsHitConditionalBreakpoints());
        }
        if (this.getSupportsEvaluateForHovers() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsEvaluateForHovers());
        }
        if (this.getExceptionBreakpointFilters() != null) {
            hash = 97 * hash + Objects.hashCode(this.getExceptionBreakpointFilters());
        }
        if (this.getSupportsStepBack() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsStepBack());
        }
        if (this.getSupportsSetVariable() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsSetVariable());
        }
        if (this.getSupportsRestartFrame() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsRestartFrame());
        }
        if (this.getSupportsGotoTargetsRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsGotoTargetsRequest());
        }
        if (this.getSupportsStepInTargetsRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsStepInTargetsRequest());
        }
        if (this.getSupportsCompletionsRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsCompletionsRequest());
        }
        if (this.getCompletionTriggerCharacters() != null) {
            hash = 97 * hash + Objects.hashCode(this.getCompletionTriggerCharacters());
        }
        if (this.getSupportsModulesRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsModulesRequest());
        }
        if (this.getAdditionalModuleColumns() != null) {
            hash = 97 * hash + Objects.hashCode(this.getAdditionalModuleColumns());
        }
        if (this.getSupportedChecksumAlgorithms() != null) {
            hash = 97 * hash + Objects.hashCode(this.getSupportedChecksumAlgorithms());
        }
        if (this.getSupportsRestartRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsRestartRequest());
        }
        if (this.getSupportsExceptionOptions() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsExceptionOptions());
        }
        if (this.getSupportsValueFormattingOptions() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsValueFormattingOptions());
        }
        if (this.getSupportsExceptionInfoRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsExceptionInfoRequest());
        }
        if (this.getSupportTerminateDebuggee() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportTerminateDebuggee());
        }
        if (this.getSupportsDelayedStackTraceLoading() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsDelayedStackTraceLoading());
        }
        if (this.getSupportsLoadedSourcesRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsLoadedSourcesRequest());
        }
        if (this.getSupportsLogPoints() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsLogPoints());
        }
        if (this.getSupportsTerminateThreadsRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsTerminateThreadsRequest());
        }
        if (this.getSupportsSetExpression() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsSetExpression());
        }
        if (this.getSupportsTerminateRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsTerminateRequest());
        }
        if (this.getSupportsDataBreakpoints() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsDataBreakpoints());
        }
        if (this.getSupportsReadMemoryRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsReadMemoryRequest());
        }
        if (this.getSupportsDisassembleRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsDisassembleRequest());
        }
        if (this.getSupportsCancelRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsCancelRequest());
        }
        if (this.getSupportsBreakpointLocationsRequest() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsBreakpointLocationsRequest());
        }
        if (this.getSupportsClipboardContext() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSupportsClipboardContext());
        }
        return hash;
    }

    public static Capabilities create() {
        JSONObject json = new JSONObject();
        return new Capabilities(json);
    }
}

