/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Module;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class ModuleEvent
extends Event {
    ModuleEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return new EventBody(this.jsonData.getJSONObject("body"));
    }

    public ModuleEvent setBody(EventBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleEvent other = (ModuleEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Objects.hashCode(this.getEvent());
        hash = 41 * hash + Objects.hashCode(this.getBody());
        hash = 41 * hash + Objects.hashCode(this.getType());
        hash = 41 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ModuleEvent create(EventBody body, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", (Object)"module");
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"event");
        json.put("seq", (Object)seq);
        return new ModuleEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getReason() {
            return this.jsonData.getString("reason");
        }

        public EventBody setReason(String reason) {
            this.jsonData.put("reason", (Object)reason);
            return this;
        }

        public Module getModule() {
            return new Module(this.jsonData.getJSONObject("module"));
        }

        public EventBody setModule(Module module) {
            this.jsonData.put("module", (Object)module.jsonData);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            if (!Objects.equals(this.getReason(), other.getReason())) {
                return false;
            }
            return Objects.equals(this.getModule(), other.getModule());
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + Objects.hashCode(this.getReason());
            hash = 53 * hash + Objects.hashCode(this.getModule());
            return hash;
        }

        public static EventBody create(String reason, Module module) {
            JSONObject json = new JSONObject();
            json.put("reason", (Object)reason);
            json.put("module", (Object)module.jsonData);
            return new EventBody(json);
        }
    }
}

