/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class ReadMemoryArguments
extends JSONBase {
    ReadMemoryArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public String getMemoryReference() {
        return this.jsonData.getString("memoryReference");
    }

    public ReadMemoryArguments setMemoryReference(String memoryReference) {
        this.jsonData.put("memoryReference", (Object)memoryReference);
        return this;
    }

    public Integer getOffset() {
        return this.jsonData.has("offset") ? Integer.valueOf(this.jsonData.getInt("offset")) : null;
    }

    public ReadMemoryArguments setOffset(Integer offset) {
        this.jsonData.putOpt("offset", (Object)offset);
        return this;
    }

    public int getCount() {
        return this.jsonData.getInt("count");
    }

    public ReadMemoryArguments setCount(int count) {
        this.jsonData.put("count", count);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReadMemoryArguments other = (ReadMemoryArguments)obj;
        if (!Objects.equals(this.getMemoryReference(), other.getMemoryReference())) {
            return false;
        }
        if (!Objects.equals(this.getOffset(), other.getOffset())) {
            return false;
        }
        return this.getCount() == other.getCount();
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.getMemoryReference());
        if (this.getOffset() != null) {
            hash = 59 * hash + Integer.hashCode(this.getOffset());
        }
        hash = 59 * hash + Integer.hashCode(this.getCount());
        return hash;
    }

    public static ReadMemoryArguments create(String memoryReference, Integer count) {
        JSONObject json = new JSONObject();
        json.put("memoryReference", (Object)memoryReference);
        json.put("count", (Object)count);
        return new ReadMemoryArguments(json);
    }
}

