/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Source;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class SourceArguments
extends JSONBase {
    SourceArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public Source getSource() {
        return this.jsonData.has("source") ? new Source(this.jsonData.optJSONObject("source")) : null;
    }

    public SourceArguments setSource(Source source) {
        this.jsonData.putOpt("source", (Object)(source != null ? source.jsonData : null));
        return this;
    }

    public int getSourceReference() {
        return this.jsonData.getInt("sourceReference");
    }

    public SourceArguments setSourceReference(int sourceReference) {
        this.jsonData.put("sourceReference", sourceReference);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceArguments other = (SourceArguments)obj;
        if (!Objects.equals(this.getSource(), other.getSource())) {
            return false;
        }
        return this.getSourceReference() == other.getSourceReference();
    }

    public int hashCode() {
        int hash = 7;
        if (this.getSource() != null) {
            hash = 23 * hash + Objects.hashCode(this.getSource());
        }
        hash = 23 * hash + Integer.hashCode(this.getSourceReference());
        return hash;
    }

    public static SourceArguments create(Integer sourceReference) {
        JSONObject json = new JSONObject();
        json.put("sourceReference", (Object)sourceReference);
        return new SourceArguments(json);
    }
}

