/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.StackFrameFormat;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class StackTraceArguments
extends JSONBase {
    StackTraceArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public int getThreadId() {
        return this.jsonData.getInt("threadId");
    }

    public StackTraceArguments setThreadId(int threadId) {
        this.jsonData.put("threadId", threadId);
        return this;
    }

    public Integer getStartFrame() {
        return this.jsonData.has("startFrame") ? Integer.valueOf(this.jsonData.getInt("startFrame")) : null;
    }

    public StackTraceArguments setStartFrame(Integer startFrame) {
        this.jsonData.putOpt("startFrame", (Object)startFrame);
        return this;
    }

    public Integer getLevels() {
        return this.jsonData.has("levels") ? Integer.valueOf(this.jsonData.getInt("levels")) : null;
    }

    public StackTraceArguments setLevels(Integer levels) {
        this.jsonData.putOpt("levels", (Object)levels);
        return this;
    }

    public StackFrameFormat getFormat() {
        return this.jsonData.has("format") ? new StackFrameFormat(this.jsonData.optJSONObject("format")) : null;
    }

    public StackTraceArguments setFormat(StackFrameFormat format) {
        this.jsonData.putOpt("format", (Object)(format != null ? format.jsonData : null));
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StackTraceArguments other = (StackTraceArguments)obj;
        if (this.getThreadId() != other.getThreadId()) {
            return false;
        }
        if (!Objects.equals(this.getStartFrame(), other.getStartFrame())) {
            return false;
        }
        if (!Objects.equals(this.getLevels(), other.getLevels())) {
            return false;
        }
        return Objects.equals(this.getFormat(), other.getFormat());
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Integer.hashCode(this.getThreadId());
        if (this.getStartFrame() != null) {
            hash = 97 * hash + Integer.hashCode(this.getStartFrame());
        }
        if (this.getLevels() != null) {
            hash = 97 * hash + Integer.hashCode(this.getLevels());
        }
        if (this.getFormat() != null) {
            hash = 97 * hash + Objects.hashCode(this.getFormat());
        }
        return hash;
    }

    public static StackTraceArguments create(Integer threadId) {
        JSONObject json = new JSONObject();
        json.put("threadId", (Object)threadId);
        return new StackTraceArguments(json);
    }
}

