/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Response;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class StepInResponse
extends Response {
    StepInResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StepInResponse other = (StepInResponse)obj;
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Objects.hashCode(this.getType());
        hash = 13 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 13 * hash + Boolean.hashCode(this.isSuccess());
        hash = 13 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 13 * hash + Objects.hashCode(this.getMessage());
        }
        if (this.getBody() != null) {
            hash = 13 * hash + Objects.hashCode(this.getBody());
        }
        hash = 13 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static StepInResponse create(Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new StepInResponse(json);
    }
}

