/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.SuppressFBWarnings;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class StoppedEvent
extends Event {
    StoppedEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return new EventBody(this.jsonData.getJSONObject("body"));
    }

    public StoppedEvent setBody(EventBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoppedEvent other = (StoppedEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.getEvent());
        hash = 71 * hash + Objects.hashCode(this.getBody());
        hash = 71 * hash + Objects.hashCode(this.getType());
        hash = 71 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static StoppedEvent create(EventBody body, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", (Object)"stopped");
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"event");
        json.put("seq", (Object)seq);
        return new StoppedEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getReason() {
            return this.jsonData.getString("reason");
        }

        public EventBody setReason(String reason) {
            this.jsonData.put("reason", (Object)reason);
            return this;
        }

        public String getDescription() {
            return this.jsonData.optString("description", null);
        }

        public EventBody setDescription(String description) {
            this.jsonData.putOpt("description", (Object)description);
            return this;
        }

        public Integer getThreadId() {
            return this.jsonData.has("threadId") ? Integer.valueOf(this.jsonData.getInt("threadId")) : null;
        }

        public EventBody setThreadId(Integer threadId) {
            this.jsonData.putOpt("threadId", (Object)threadId);
            return this;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getPreserveFocusHint() {
            return this.jsonData.has("preserveFocusHint") ? Boolean.valueOf(this.jsonData.getBoolean("preserveFocusHint")) : null;
        }

        public EventBody setPreserveFocusHint(Boolean preserveFocusHint) {
            this.jsonData.putOpt("preserveFocusHint", (Object)preserveFocusHint);
            return this;
        }

        public String getText() {
            return this.jsonData.optString("text", null);
        }

        public EventBody setText(String text) {
            this.jsonData.putOpt("text", (Object)text);
            return this;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getAllThreadsStopped() {
            return this.jsonData.has("allThreadsStopped") ? Boolean.valueOf(this.jsonData.getBoolean("allThreadsStopped")) : null;
        }

        public EventBody setAllThreadsStopped(Boolean allThreadsStopped) {
            this.jsonData.putOpt("allThreadsStopped", (Object)allThreadsStopped);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            if (!Objects.equals(this.getReason(), other.getReason())) {
                return false;
            }
            if (!Objects.equals(this.getDescription(), other.getDescription())) {
                return false;
            }
            if (!Objects.equals(this.getThreadId(), other.getThreadId())) {
                return false;
            }
            if (!Objects.equals(this.getPreserveFocusHint(), other.getPreserveFocusHint())) {
                return false;
            }
            if (!Objects.equals(this.getText(), other.getText())) {
                return false;
            }
            return Objects.equals(this.getAllThreadsStopped(), other.getAllThreadsStopped());
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + Objects.hashCode(this.getReason());
            if (this.getDescription() != null) {
                hash = 11 * hash + Objects.hashCode(this.getDescription());
            }
            if (this.getThreadId() != null) {
                hash = 11 * hash + Integer.hashCode(this.getThreadId());
            }
            if (this.getPreserveFocusHint() != null) {
                hash = 11 * hash + Boolean.hashCode(this.getPreserveFocusHint());
            }
            if (this.getText() != null) {
                hash = 11 * hash + Objects.hashCode(this.getText());
            }
            if (this.getAllThreadsStopped() != null) {
                hash = 11 * hash + Boolean.hashCode(this.getAllThreadsStopped());
            }
            return hash;
        }

        public static EventBody create(String reason) {
            JSONObject json = new JSONObject();
            json.put("reason", (Object)reason);
            return new EventBody(json);
        }
    }
}

