/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public final class OutputHandler {
    final ListeneableOutputStream out = new ListeneableOutputStream();
    final ListeneableOutputStream err = new ListeneableOutputStream();

    public OutputStream getOut() {
        return this.out;
    }

    public OutputStream getErr() {
        return this.err;
    }

    void setOutListener(Listener l) {
        this.out.l = l;
    }

    void setErrListener(Listener l) {
        this.err.l = l;
    }

    private static final class ListeneableOutputStream
    extends OutputStream {
        private final CharBuffer cb = CharBuffer.allocate(8192);
        private final RBCH rbch = new RBCH();
        private final Reader r = Channels.newReader((ReadableByteChannel)this.rbch, "UTF-8");
        volatile Listener l;

        private ListeneableOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.rbch.put((byte)b);
            this.wl();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.rbch.put(b);
            this.wl();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.rbch.put(b, off, len);
            this.wl();
        }

        private void wl() throws IOException {
            int n;
            if (this.l == null) {
                return;
            }
            while (!this.rbch.isEmpty() && (n = this.r.read(this.cb)) != 0) {
                this.cb.flip();
                String str = this.cb.toString();
                this.l.outputText(str);
                this.cb.clear();
            }
        }

        private final class RBCH
        implements ReadableByteChannel {
            private byte[] b;
            private int off;
            private int len;

            private RBCH() {
            }

            void put(int b) {
                this.b = new byte[]{(byte)b};
                this.off = 0;
                this.len = 1;
            }

            void put(byte[] b) {
                this.put(b, 0, b.length);
            }

            void put(byte[] b, int off, int len) {
                this.b = b;
                this.off = off;
                this.len = len;
            }

            boolean isEmpty() {
                return this.len == 0;
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                if (this.len == 0) {
                    return 0;
                }
                int n = dst.remaining();
                n = Math.min(n, this.len);
                dst.put(this.b, this.off, n);
                this.off += n;
                this.len -= n;
                return n;
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() throws IOException {
            }
        }
    }

    static interface Listener {
        public void outputText(String var1);
    }

    public static interface Provider {
        public OutputHandler getOutputHandler();
    }
}

