/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.dap.types.VariablePresentationHint;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class EvaluateResponse
extends Response {
    EvaluateResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public EvaluateResponse setBody(ResponseBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvaluateResponse other = (EvaluateResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.getBody());
        hash = 59 * hash + Objects.hashCode(this.getType());
        hash = 59 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 59 * hash + Boolean.hashCode(this.isSuccess());
        hash = 59 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 59 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 59 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static EvaluateResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new EvaluateResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getResult() {
            return this.jsonData.getString("result");
        }

        public ResponseBody setResult(String result) {
            this.jsonData.put("result", (Object)result);
            return this;
        }

        public String getType() {
            return this.jsonData.optString("type", null);
        }

        public ResponseBody setType(String type) {
            this.jsonData.putOpt("type", (Object)type);
            return this;
        }

        public VariablePresentationHint getPresentationHint() {
            return this.jsonData.has("presentationHint") ? new VariablePresentationHint(this.jsonData.optJSONObject("presentationHint")) : null;
        }

        public ResponseBody setPresentationHint(VariablePresentationHint presentationHint) {
            this.jsonData.putOpt("presentationHint", (Object)(presentationHint != null ? presentationHint.jsonData : null));
            return this;
        }

        public int getVariablesReference() {
            return this.jsonData.getInt("variablesReference");
        }

        public ResponseBody setVariablesReference(int variablesReference) {
            this.jsonData.put("variablesReference", variablesReference);
            return this;
        }

        public Integer getNamedVariables() {
            return this.jsonData.has("namedVariables") ? Integer.valueOf(this.jsonData.getInt("namedVariables")) : null;
        }

        public ResponseBody setNamedVariables(Integer namedVariables) {
            this.jsonData.putOpt("namedVariables", (Object)namedVariables);
            return this;
        }

        public Integer getIndexedVariables() {
            return this.jsonData.has("indexedVariables") ? Integer.valueOf(this.jsonData.getInt("indexedVariables")) : null;
        }

        public ResponseBody setIndexedVariables(Integer indexedVariables) {
            this.jsonData.putOpt("indexedVariables", (Object)indexedVariables);
            return this;
        }

        public String getMemoryReference() {
            return this.jsonData.optString("memoryReference", null);
        }

        public ResponseBody setMemoryReference(String memoryReference) {
            this.jsonData.putOpt("memoryReference", (Object)memoryReference);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            if (!Objects.equals(this.getResult(), other.getResult())) {
                return false;
            }
            if (!Objects.equals(this.getType(), other.getType())) {
                return false;
            }
            if (!Objects.equals(this.getPresentationHint(), other.getPresentationHint())) {
                return false;
            }
            if (this.getVariablesReference() != other.getVariablesReference()) {
                return false;
            }
            if (!Objects.equals(this.getNamedVariables(), other.getNamedVariables())) {
                return false;
            }
            if (!Objects.equals(this.getIndexedVariables(), other.getIndexedVariables())) {
                return false;
            }
            return Objects.equals(this.getMemoryReference(), other.getMemoryReference());
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + Objects.hashCode(this.getResult());
            if (this.getType() != null) {
                hash = 79 * hash + Objects.hashCode(this.getType());
            }
            if (this.getPresentationHint() != null) {
                hash = 79 * hash + Objects.hashCode(this.getPresentationHint());
            }
            hash = 79 * hash + Integer.hashCode(this.getVariablesReference());
            if (this.getNamedVariables() != null) {
                hash = 79 * hash + Integer.hashCode(this.getNamedVariables());
            }
            if (this.getIndexedVariables() != null) {
                hash = 79 * hash + Integer.hashCode(this.getIndexedVariables());
            }
            if (this.getMemoryReference() != null) {
                hash = 79 * hash + Objects.hashCode(this.getMemoryReference());
            }
            return hash;
        }

        public static ResponseBody create(String result, Integer variablesReference) {
            JSONObject json = new JSONObject();
            json.put("result", (Object)result);
            json.put("variablesReference", (Object)variablesReference);
            return new ResponseBody(json);
        }
    }
}

