/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.ExceptionDetails;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class ExceptionInfoResponse
extends Response {
    ExceptionInfoResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public ExceptionInfoResponse setBody(ResponseBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionInfoResponse other = (ExceptionInfoResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.getBody());
        hash = 59 * hash + Objects.hashCode(this.getType());
        hash = 59 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 59 * hash + Boolean.hashCode(this.isSuccess());
        hash = 59 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 59 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 59 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ExceptionInfoResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new ExceptionInfoResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getExceptionId() {
            return this.jsonData.getString("exceptionId");
        }

        public ResponseBody setExceptionId(String exceptionId) {
            this.jsonData.put("exceptionId", (Object)exceptionId);
            return this;
        }

        public String getDescription() {
            return this.jsonData.optString("description", null);
        }

        public ResponseBody setDescription(String description) {
            this.jsonData.putOpt("description", (Object)description);
            return this;
        }

        public String getBreakMode() {
            return this.jsonData.getString("breakMode");
        }

        public ResponseBody setBreakMode(String breakMode) {
            this.jsonData.put("breakMode", (Object)breakMode);
            return this;
        }

        public ExceptionDetails getDetails() {
            return this.jsonData.has("details") ? new ExceptionDetails(this.jsonData.optJSONObject("details")) : null;
        }

        public ResponseBody setDetails(ExceptionDetails details) {
            this.jsonData.putOpt("details", (Object)(details != null ? details.jsonData : null));
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            if (!Objects.equals(this.getExceptionId(), other.getExceptionId())) {
                return false;
            }
            if (!Objects.equals(this.getDescription(), other.getDescription())) {
                return false;
            }
            if (!Objects.equals(this.getBreakMode(), other.getBreakMode())) {
                return false;
            }
            return Objects.equals(this.getDetails(), other.getDetails());
        }

        public int hashCode() {
            int hash = 5;
            hash = 47 * hash + Objects.hashCode(this.getExceptionId());
            if (this.getDescription() != null) {
                hash = 47 * hash + Objects.hashCode(this.getDescription());
            }
            hash = 47 * hash + Objects.hashCode(this.getBreakMode());
            if (this.getDetails() != null) {
                hash = 47 * hash + Objects.hashCode(this.getDetails());
            }
            return hash;
        }

        public static ResponseBody create(String exceptionId, String breakMode) {
            JSONObject json = new JSONObject();
            json.put("exceptionId", (Object)exceptionId);
            json.put("breakMode", (Object)breakMode);
            return new ResponseBody(json);
        }
    }
}

