/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class FunctionBreakpoint
extends JSONBase {
    FunctionBreakpoint(JSONObject jsonData) {
        super(jsonData);
    }

    public String getName() {
        return this.jsonData.getString("name");
    }

    public FunctionBreakpoint setName(String name) {
        this.jsonData.put("name", (Object)name);
        return this;
    }

    public String getCondition() {
        return this.jsonData.optString("condition", null);
    }

    public FunctionBreakpoint setCondition(String condition) {
        this.jsonData.putOpt("condition", (Object)condition);
        return this;
    }

    public String getHitCondition() {
        return this.jsonData.optString("hitCondition", null);
    }

    public FunctionBreakpoint setHitCondition(String hitCondition) {
        this.jsonData.putOpt("hitCondition", (Object)hitCondition);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionBreakpoint other = (FunctionBreakpoint)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getCondition(), other.getCondition())) {
            return false;
        }
        return Objects.equals(this.getHitCondition(), other.getHitCondition());
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + Objects.hashCode(this.getName());
        if (this.getCondition() != null) {
            hash = 31 * hash + Objects.hashCode(this.getCondition());
        }
        if (this.getHitCondition() != null) {
            hash = 31 * hash + Objects.hashCode(this.getHitCondition());
        }
        return hash;
    }

    public static FunctionBreakpoint create(String name) {
        JSONObject json = new JSONObject();
        json.put("name", (Object)name);
        return new FunctionBreakpoint(json);
    }
}

