/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.dap.types.Source;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class LoadedSourcesResponse
extends Response {
    LoadedSourcesResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public LoadedSourcesResponse setBody(ResponseBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadedSourcesResponse other = (LoadedSourcesResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.getBody());
        hash = 67 * hash + Objects.hashCode(this.getType());
        hash = 67 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 67 * hash + Boolean.hashCode(this.isSuccess());
        hash = 67 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 67 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 67 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static LoadedSourcesResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new LoadedSourcesResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public List<Source> getSources() {
            JSONArray json = this.jsonData.getJSONArray("sources");
            ArrayList<Source> list = new ArrayList<Source>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(new Source(json.getJSONObject(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public ResponseBody setSources(List<Source> sources) {
            JSONArray json = new JSONArray();
            for (Source source : sources) {
                json.put((Object)source.jsonData);
            }
            this.jsonData.put("sources", (Object)json);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            return Objects.equals(this.getSources(), other.getSources());
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + Objects.hashCode(this.getSources());
            return hash;
        }

        public static ResponseBody create(List<Source> sources) {
            JSONObject json = new JSONObject();
            JSONArray sourcesJsonArr = new JSONArray();
            for (Source source : sources) {
                sourcesJsonArr.put((Object)source.jsonData);
            }
            json.put("sources", (Object)sourcesJsonArr);
            return new ResponseBody(json);
        }
    }
}

