/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class Message
extends JSONBase {
    Message(JSONObject jsonData) {
        super(jsonData);
    }

    public int getId() {
        return this.jsonData.getInt("id");
    }

    public Message setId(int id) {
        this.jsonData.put("id", id);
        return this;
    }

    public String getFormat() {
        return this.jsonData.getString("format");
    }

    public Message setFormat(String format) {
        this.jsonData.put("format", (Object)format);
        return this;
    }

    public Map<String, String> getVariables() {
        JSONObject json = this.jsonData.optJSONObject("variables");
        if (json == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(json.length());
        for (String key : json.keySet()) {
            map.put(key, json.getString(key));
        }
        return map;
    }

    public Message setVariables(Map<String, String> variables) {
        if (variables != null) {
            JSONObject json = new JSONObject();
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                json.put(entry.getKey(), (Object)entry.getValue());
            }
            this.jsonData.put("variables", (Object)json);
        }
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getSendTelemetry() {
        return this.jsonData.has("sendTelemetry") ? Boolean.valueOf(this.jsonData.getBoolean("sendTelemetry")) : null;
    }

    public Message setSendTelemetry(Boolean sendTelemetry) {
        this.jsonData.putOpt("sendTelemetry", (Object)sendTelemetry);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getShowUser() {
        return this.jsonData.has("showUser") ? Boolean.valueOf(this.jsonData.getBoolean("showUser")) : null;
    }

    public Message setShowUser(Boolean showUser) {
        this.jsonData.putOpt("showUser", (Object)showUser);
        return this;
    }

    public String getUrl() {
        return this.jsonData.optString("url", null);
    }

    public Message setUrl(String url) {
        this.jsonData.putOpt("url", (Object)url);
        return this;
    }

    public String getUrlLabel() {
        return this.jsonData.optString("urlLabel", null);
    }

    public Message setUrlLabel(String urlLabel) {
        this.jsonData.putOpt("urlLabel", (Object)urlLabel);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (!Objects.equals(this.getFormat(), other.getFormat())) {
            return false;
        }
        if (!Objects.equals(this.getVariables(), other.getVariables())) {
            return false;
        }
        if (!Objects.equals(this.getSendTelemetry(), other.getSendTelemetry())) {
            return false;
        }
        if (!Objects.equals(this.getShowUser(), other.getShowUser())) {
            return false;
        }
        if (!Objects.equals(this.getUrl(), other.getUrl())) {
            return false;
        }
        return Objects.equals(this.getUrlLabel(), other.getUrlLabel());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Integer.hashCode(this.getId());
        hash = 97 * hash + Objects.hashCode(this.getFormat());
        if (this.getVariables() != null) {
            hash = 97 * hash + Objects.hashCode(this.getVariables());
        }
        if (this.getSendTelemetry() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getSendTelemetry());
        }
        if (this.getShowUser() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getShowUser());
        }
        if (this.getUrl() != null) {
            hash = 97 * hash + Objects.hashCode(this.getUrl());
        }
        if (this.getUrlLabel() != null) {
            hash = 97 * hash + Objects.hashCode(this.getUrlLabel());
        }
        return hash;
    }

    public static Message create(Integer id, String format) {
        JSONObject json = new JSONObject();
        json.put("id", (Object)id);
        json.put("format", (Object)format);
        return new Message(json);
    }
}

