/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class ReadMemoryResponse
extends Response {
    ReadMemoryResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return this.jsonData.has("body") ? new ResponseBody(this.jsonData.optJSONObject("body")) : null;
    }

    public ReadMemoryResponse setBody(ResponseBody body) {
        this.jsonData.putOpt("body", (Object)(body != null ? body.jsonData : null));
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReadMemoryResponse other = (ReadMemoryResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        if (this.getBody() != null) {
            hash = 53 * hash + Objects.hashCode(this.getBody());
        }
        hash = 53 * hash + Objects.hashCode(this.getType());
        hash = 53 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 53 * hash + Boolean.hashCode(this.isSuccess());
        hash = 53 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 53 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 53 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ReadMemoryResponse create(Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new ReadMemoryResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getAddress() {
            return this.jsonData.getString("address");
        }

        public ResponseBody setAddress(String address) {
            this.jsonData.put("address", (Object)address);
            return this;
        }

        public Integer getUnreadableBytes() {
            return this.jsonData.has("unreadableBytes") ? Integer.valueOf(this.jsonData.getInt("unreadableBytes")) : null;
        }

        public ResponseBody setUnreadableBytes(Integer unreadableBytes) {
            this.jsonData.putOpt("unreadableBytes", (Object)unreadableBytes);
            return this;
        }

        public String getData() {
            return this.jsonData.optString("data", null);
        }

        public ResponseBody setData(String data) {
            this.jsonData.putOpt("data", (Object)data);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            if (!Objects.equals(this.getAddress(), other.getAddress())) {
                return false;
            }
            if (!Objects.equals(this.getUnreadableBytes(), other.getUnreadableBytes())) {
                return false;
            }
            return Objects.equals(this.getData(), other.getData());
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Objects.hashCode(this.getAddress());
            if (this.getUnreadableBytes() != null) {
                hash = 37 * hash + Integer.hashCode(this.getUnreadableBytes());
            }
            if (this.getData() != null) {
                hash = 37 * hash + Objects.hashCode(this.getData());
            }
            return hash;
        }

        public static ResponseBody create(String address) {
            JSONObject json = new JSONObject();
            json.put("address", (Object)address);
            return new ResponseBody(json);
        }
    }
}

