/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.DataBreakpoint;
import com.oracle.truffle.tools.dap.types.JSONBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class SetDataBreakpointsArguments
extends JSONBase {
    SetDataBreakpointsArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public List<DataBreakpoint> getBreakpoints() {
        JSONArray json = this.jsonData.getJSONArray("breakpoints");
        ArrayList<DataBreakpoint> list = new ArrayList<DataBreakpoint>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new DataBreakpoint(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public SetDataBreakpointsArguments setBreakpoints(List<DataBreakpoint> breakpoints) {
        JSONArray json = new JSONArray();
        for (DataBreakpoint dataBreakpoint : breakpoints) {
            json.put((Object)dataBreakpoint.jsonData);
        }
        this.jsonData.put("breakpoints", (Object)json);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetDataBreakpointsArguments other = (SetDataBreakpointsArguments)obj;
        return Objects.equals(this.getBreakpoints(), other.getBreakpoints());
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Objects.hashCode(this.getBreakpoints());
        return hash;
    }

    public static SetDataBreakpointsArguments create(List<DataBreakpoint> breakpoints) {
        JSONObject json = new JSONObject();
        JSONArray breakpointsJsonArr = new JSONArray();
        for (DataBreakpoint dataBreakpoint : breakpoints) {
            breakpointsJsonArr.put((Object)dataBreakpoint.jsonData);
        }
        json.put("breakpoints", (Object)breakpointsJsonArr);
        return new SetDataBreakpointsArguments(json);
    }
}

