/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.tools.agentscript.impl.InsightException;

final class FilterExec {
    FilterExec() {
    }

    static boolean checkFilter(InteropLibrary iop, Object function, Object ... args) {
        boolean is;
        Object res;
        try {
            res = iop.execute(function, args);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException ex) {
            throw InsightException.raise((Exception)ex);
        }
        if (iop.isBoolean(res)) {
            try {
                is = iop.asBoolean(res);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        } else {
            is = false;
        }
        return is;
    }
}

