/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.LoadSourceEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.instrumentation.NearestSectionFilter;
import com.oracle.truffle.api.instrumentation.SourceFilter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.impl.AgentObject;
import com.oracle.truffle.tools.agentscript.impl.AgentType;
import com.oracle.truffle.tools.agentscript.impl.IgnoreSources;
import com.oracle.truffle.tools.agentscript.impl.InsightException;
import com.oracle.truffle.tools.agentscript.impl.InsightFilter;
import com.oracle.truffle.tools.agentscript.impl.InsightInstrument;
import com.oracle.truffle.tools.agentscript.impl.InsightSourceFilter;
import com.oracle.truffle.tools.agentscript.impl.RegexNameFilter;
import com.oracle.truffle.tools.agentscript.impl.RegexSourceFilter;
import com.oracle.truffle.tools.agentscript.impl.RootNameFilter;
import com.oracle.truffle.tools.agentscript.impl.SourceEventObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.graalvm.collections.EconomicMap;

final class InsightPerSource
implements ContextsListener,
AutoCloseable,
LoadSourceListener {
    private final InsightInstrument instrument;
    private final Supplier<Source> src;
    private final AgentObject insight;
    private final IgnoreSources ignoredSources;
    private final EconomicMap<TruffleContext, EventBinding<?>> initializeBindings = EconomicMap.create();
    private InsightInstrument.Key sourceBinding;
    private InsightInstrument.Key closeBinding;
    private Map<Object, InsightInstrument.Key> bindings = new HashMap<Object, InsightInstrument.Key>();
    private final Map<TruffleContext, Source> registeredSource = new WeakHashMap<TruffleContext, Source>();
    private final EventBinding<InsightPerSource> onInit;

    InsightPerSource(Instrumenter instrumenter, InsightInstrument instrument, Supplier<Source> src, IgnoreSources ignoredSources) {
        this.instrument = instrument;
        this.ignoredSources = ignoredSources;
        this.src = src;
        this.insight = instrument.createInsightObject(this);
        this.onInit = instrumenter.attachContextsListener((ContextsListener)this, true);
    }

    void collectSymbols(List<String> argNames, List<Object> args) {
        argNames.add("insight");
        args.add(this.insight);
        this.instrument.collectGlobalSymbolsImpl(this, argNames, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    void initializeAgent(TruffleContext ctx) {
        CallTarget target;
        Source script;
        InsightPerSource insightPerSource = this;
        synchronized (insightPerSource) {
            if (this.registeredSource.get(ctx) != null) {
                return;
            }
            script = this.src.get();
            this.registeredSource.put(ctx, script);
        }
        this.instrument.ignoreSources.ignoreSource(script);
        ArrayList<String> argNames = new ArrayList<String>();
        ArrayList<Object> args = new ArrayList<Object>();
        this.collectSymbols(argNames, args);
        try {
            target = this.instrument.env().parse(script, argNames.toArray(new String[0]));
        }
        catch (Exception ex) {
            throw InsightException.raise(ex);
        }
        target.call(args.toArray());
    }

    public void onContextCreated(TruffleContext context) {
    }

    public void onLanguageContextCreated(TruffleContext context, LanguageInfo language) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLanguageContextInitialized(TruffleContext context, LanguageInfo language) {
        if (language.isInternal()) {
            return;
        }
        if (context.isEntered()) {
            EventBinding agentBinding;
            InsightPerSource insightPerSource = this;
            synchronized (insightPerSource) {
                agentBinding = (EventBinding)this.initializeBindings.removeKey((Object)context);
            }
            if (agentBinding != null) {
                agentBinding.dispose();
            }
            this.initializeAgent(context);
        } else {
            InsightPerSource insightPerSource = this;
            synchronized (insightPerSource) {
                if (this.initializeBindings.containsKey((Object)context) || this.registeredSource.containsKey(context)) {
                    return;
                }
            }
            SourceSectionFilter anyRoot = SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).build();
            Instrumenter instrumenter = this.instrument.env().getInstrumenter();
            EventBinding agentBinding = instrumenter.attachExecutionEventListener(anyRoot, (ExecutionEventListener)new InitializeLater(context));
            InsightPerSource insightPerSource2 = this;
            synchronized (insightPerSource2) {
                this.initializeBindings.put((Object)context, (Object)agentBinding);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLanguageContextFinalized(TruffleContext context, LanguageInfo language) {
        InsightInstrument.Key closingKey;
        InsightPerSource insightPerSource = this;
        synchronized (insightPerSource) {
            closingKey = this.closeBinding;
        }
        if (closingKey != null) {
            this.instrument.find(context).onClosed(closingKey);
        }
    }

    public void onLanguageContextDisposed(TruffleContext context, LanguageInfo language) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContextClosed(TruffleContext context) {
        EventBinding binding;
        InsightPerSource insightPerSource = this;
        synchronized (insightPerSource) {
            binding = (EventBinding)this.initializeBindings.removeKey((Object)context);
        }
        if (binding != null) {
            binding.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        EventBinding[] eventBindingArray = this;
        synchronized (this) {
            if (this.bindings == null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            InsightInstrument.Key[] keys = this.bindings.values().toArray(new InsightInstrument.Key[0]);
            this.bindings = null;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.onInit.dispose();
            EventBinding[] eventBindingArray2 = this;
            synchronized (this) {
                EventBinding[] binds;
                if (!this.initializeBindings.isEmpty()) {
                    int n = this.initializeBindings.size();
                    binds = (EventBinding[])Array.newInstance(EventBinding.class, n);
                    int i = 0;
                    for (EventBinding agentInitBinding : this.initializeBindings.getValues()) {
                        binds[i++] = agentInitBinding;
                    }
                    this.initializeBindings.clear();
                } else {
                    binds = null;
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
                if (binds != null) {
                    for (EventBinding agentInitBinding : binds) {
                        agentInitBinding.dispose();
                    }
                }
                this.instrument.closeKeys(keys);
                return;
            }
        }
    }

    private void checkClosed() throws IllegalStateException {
        assert (Thread.holdsLock(this));
        if (this.bindings == null) {
            CompilerDirectives.transferToInterpreter();
            throw InsightException.alreadyClosed();
        }
    }

    synchronized void binding(InsightFilter.Data data, final Function<InsightInstrument.Key, ExecutionEventNodeFactory> needFactory, Consumer<InsightInstrument.Key> hasFactory) {
        this.checkClosed();
        final InsightFilter filter = data.filter;
        InsightInstrument.Key key = this.bindings.get(filter);
        if (key == null) {
            key = this.instrument.newKey(null);
            SourceFilter.Builder sfb = SourceFilter.newBuilder().sourceIs((Predicate)((Object)this.ignoredSources)).includeInternal(false);
            if (data.sourceFilterFn != null) {
                InsightSourceFilter predicate = new InsightSourceFilter(this.instrument, key);
                sfb.sourceIs((Predicate)predicate);
            }
            if (filter.getSourcePathRegExp() != null) {
                sfb.sourceIs((Predicate)((Object)new RegexSourceFilter(filter.getSourcePathRegExp())));
            }
            if (filter.getSourceURI() != null) {
                sfb.sourceIs((Predicate)new SourceSectionFilter.SourcePredicate(){

                    public boolean test(Source source) {
                        return filter.getSourceURI().equals(source.getURI());
                    }
                });
            }
            SourceFilter sourceFilter = sfb.build();
            Instrumenter instrumenter = this.instrument.env().getInstrumenter();
            int line = filter.getLine();
            if (line == 0) {
                this.attachBinding(data, key, sourceFilter, needFactory);
            } else {
                final InsightInstrument.Key theKey = key;
                Supplier<ExecutionEventNodeFactory> factoryCreate = new Supplier<ExecutionEventNodeFactory>(){
                    ExecutionEventNodeFactory factory;

                    @Override
                    public synchronized ExecutionEventNodeFactory get() {
                        if (this.factory == null) {
                            this.factory = (ExecutionEventNodeFactory)needFactory.apply(theKey);
                        }
                        return this.factory;
                    }
                };
                SourceSectionFilter.Builder ssfb = SourceSectionFilter.newBuilder().sourceFilter(sourceFilter);
                if (filter.getRootNameRegExp() != null) {
                    ssfb.rootNameIs((Predicate)new RegexNameFilter(filter.getRootNameRegExp()));
                } else if (data.rootNameFn != null) {
                    ssfb.rootNameIs((Predicate)new RootNameFilter(this.instrument, theKey));
                }
                int column = filter.getColumn();
                NearestSectionFilter nearestFilter = NearestSectionFilter.newBuilder((int)line, (int)column).anchorStart(data.type == AgentType.ENTER).tagIs((Class[])filter.getTags()).build();
                EventBinding binding = instrumenter.attachExecutionEventFactory(nearestFilter, ssfb.build(), (ExecutionEventNodeFactory)factoryCreate.get());
                theKey.assign(binding);
            }
            this.bindings.put(filter, key);
        } else {
            hasFactory.accept(key);
        }
    }

    private void attachBinding(InsightFilter.Data data, InsightInstrument.Key key, SourceFilter sourceFilter, Function<InsightInstrument.Key, ExecutionEventNodeFactory> needFactory) {
        InsightFilter filter = data.filter;
        SourceSectionFilter.Builder ssfb = SourceSectionFilter.newBuilder().sourceFilter(sourceFilter).tagIs((Class[])filter.getTags());
        if (filter.getRootNameRegExp() != null) {
            ssfb.rootNameIs((Predicate)new RegexNameFilter(filter.getRootNameRegExp()));
        } else if (data.rootNameFn != null) {
            ssfb.rootNameIs((Predicate)new RootNameFilter(this.instrument, key));
        }
        if (filter.getColumn() != 0) {
            ssfb.columnIn(filter.getColumn(), 1);
        }
        Instrumenter instrumenter = this.instrument.env().getInstrumenter();
        EventBinding handle = instrumenter.attachExecutionEventFactory(ssfb.build(), needFactory.apply(key));
        key.assign(handle);
    }

    synchronized InsightInstrument.Key closeBinding() {
        this.checkClosed();
        if (this.closeBinding == null) {
            this.closeBinding = this.instrument.newKey(AgentType.CLOSE);
            this.bindings.put((Object)AgentType.CLOSE, this.closeBinding);
        }
        return this.closeBinding;
    }

    synchronized InsightInstrument.Key sourceBinding() {
        this.checkClosed();
        if (this.sourceBinding == null) {
            SourceFilter filter = SourceFilter.newBuilder().sourceIs((Predicate)((Object)this.ignoredSources)).includeInternal(false).build();
            Instrumenter instrumenter = this.instrument.env().getInstrumenter();
            this.sourceBinding = this.instrument.newKey(AgentType.SOURCE).assign(instrumenter.attachLoadSourceListener(filter, (LoadSourceListener)this, false));
            this.bindings.put((Object)AgentType.SOURCE, this.sourceBinding);
        }
        return this.sourceBinding;
    }

    public void onLoad(LoadSourceEvent event) {
        InteropLibrary interop = InteropLibrary.getUncached();
        Instrumenter instrumenter = this.instrument.env().getInstrumenter();
        int len = this.sourceBinding.functionsMaxCount();
        for (int i = 0; i < len; ++i) {
            Object fn = this.instrument.findCtx().functionFor(this.sourceBinding, i);
            if (fn == null) continue;
            Source source = event.getSource();
            try {
                interop.execute(fn, new Object[]{new SourceEventObject(source)});
                continue;
            }
            catch (RuntimeException ex) {
                if (interop.isException((Object)ex)) {
                    InsightException.throwWhenExecuted(instrumenter, source, ex);
                    continue;
                }
                throw ex;
            }
            catch (InteropException ex) {
                InsightException.throwWhenExecuted(instrumenter, source, (Exception)((Object)ex));
            }
        }
    }

    final class InitializeLater
    implements ExecutionEventListener {
        private final TruffleContext context;

        InitializeLater(TruffleContext context) {
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEnter(EventContext ctx, VirtualFrame frame) {
            if (InsightPerSource.this.instrument.env().getEnteredContext() == this.context) {
                EventBinding agentInitBinding;
                CompilerDirectives.transferToInterpreterAndInvalidate();
                InsightPerSource insightPerSource = InsightPerSource.this;
                synchronized (insightPerSource) {
                    agentInitBinding = (EventBinding)InsightPerSource.this.initializeBindings.removeKey((Object)this.context);
                }
                if (agentInitBinding != null) {
                    agentInitBinding.dispose();
                    InsightPerSource.this.initializeAgent(this.context);
                }
            }
        }

        public void onReturnValue(EventContext ctx, VirtualFrame frame, Object result) {
        }

        public void onReturnExceptional(EventContext ctx, VirtualFrame frame, Throwable exception) {
        }
    }
}

