/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.tools.agentscript.impl.FilterExec;
import com.oracle.truffle.tools.agentscript.impl.InsightFilter;
import com.oracle.truffle.tools.agentscript.impl.InsightInstrument;
import com.oracle.truffle.tools.agentscript.impl.InsightPerContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

final class RootNameFilter
implements Predicate<String> {
    private final InsightInstrument instrument;
    private final InsightInstrument.Key key;
    private final ThreadLocal<Boolean> querying;
    private final Map<String, Boolean> cache;

    RootNameFilter(InsightInstrument instrument, InsightInstrument.Key key) {
        this.instrument = instrument;
        this.key = key;
        this.querying = new ThreadLocal();
        this.cache = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean test(String rootName) {
        Boolean computed;
        block7: {
            if (rootName == null) {
                return false;
            }
            computed = this.cache.get(rootName);
            if (computed != null) {
                return computed;
            }
            Boolean prev = this.querying.get();
            try {
                if (Boolean.TRUE.equals(prev)) {
                    computed = false;
                    break block7;
                }
                this.querying.set(true);
                InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
                computed = false;
                TruffleContext c = this.instrument.env().getEnteredContext();
                if (c == null) break block7;
                InsightPerContext ctx = this.instrument.find(c);
                int len = this.key.functionsMaxCount();
                for (int i = 0; i < len; ++i) {
                    InsightFilter.Data data = (InsightFilter.Data)ctx.functionFor(this.key, i);
                    if (data == null || data.rootNameFn == null || !RootNameFilter.rootNameCheck(iop, data, rootName)) continue;
                    computed = true;
                    break;
                }
            }
            finally {
                this.querying.set(prev);
            }
        }
        this.cache.put(rootName, computed);
        return computed;
    }

    static boolean rootNameCheck(InteropLibrary iop, InsightFilter.Data data, String rootName) {
        return FilterExec.checkFilter(iop, data.rootNameFn, rootName);
    }
}

