// CheckStyle: start generated
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.api.dsl.GeneratedBy;
import java.util.Iterator;
import java.util.List;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionStability;
import org.graalvm.polyglot.SandboxPolicy;

@GeneratedBy(MemoryTracerCLI.class)
final class MemoryTracerCLIOptionDescriptors implements TruffleOptionDescriptors {

    @Override
    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "memtracer" :
                return OptionDescriptor.newBuilder(MemoryTracerCLI.ENABLED, "memtracer").deprecated(false).help("Enable the Memory Tracer (default: false).").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            case "memtracer.FilterFile" :
                return OptionDescriptor.newBuilder(MemoryTracerCLI.FILTER_FILE, "memtracer.FilterFile").deprecated(false).help("Wildcard filter for source file paths. (for example, *program*.sl) (default: no filter).").usageSyntax("<filter>").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            case "memtracer.FilterLanguage" :
                return OptionDescriptor.newBuilder(MemoryTracerCLI.FILTER_LANGUAGE, "memtracer.FilterLanguage").deprecated(false).help("Only profile languages with given ID. (for example js) (default: no filter).").usageSyntax("<languageId>").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            case "memtracer.FilterMimeType" :
                return OptionDescriptor.newBuilder(MemoryTracerCLI.FILTER_MIME_TYPE, "memtracer.FilterMimeType").deprecated(false).help("Only profile languages with mime-type. (for example, application/javascript). (default: no filter)").usageSyntax("<mime-type>").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            case "memtracer.FilterRootName" :
                return OptionDescriptor.newBuilder(MemoryTracerCLI.FILTER_ROOT, "memtracer.FilterRootName").deprecated(false).help("Wildcard filter for program roots. (for example, Math.*) (default: no filter).").usageSyntax("<filter>").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            case "memtracer.Output" :
                return OptionDescriptor.newBuilder(MemoryTracerCLI.OUTPUT, "memtracer.Output").deprecated(false).help("Print a 'typehistogram', 'histogram' or 'calltree' as output. (default: histogram)").usageSyntax("typehistogram|histogram|calltree").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            case "memtracer.StackLimit" :
                return OptionDescriptor.newBuilder(MemoryTracerCLI.STACK_LIMIT, "memtracer.StackLimit").deprecated(false).help("Maximum number of maximum stack elements. (default: 10000)").usageSyntax("[1, inf)").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            case "memtracer.TraceCalls" :
                return OptionDescriptor.newBuilder(MemoryTracerCLI.TRACE_CALLS, "memtracer.TraceCalls").deprecated(false).help("Capture calls when tracing. (default: false)").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            case "memtracer.TraceInternal" :
                return OptionDescriptor.newBuilder(MemoryTracerCLI.TRACE_INTERNAL, "memtracer.TraceInternal").deprecated(false).help("Capture internal elements. (default: false)").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "memtracer.TraceRoots" :
                return OptionDescriptor.newBuilder(MemoryTracerCLI.TRACE_ROOTS, "memtracer.TraceRoots").deprecated(false).help("Capture roots when tracing. (default: true)").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            case "memtracer.TraceStatements" :
                return OptionDescriptor.newBuilder(MemoryTracerCLI.TRACE_STATEMENTS, "memtracer.TraceStatements").deprecated(false).help("Capture statements when tracing (default: false).").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
        }
        return null;
    }

    @Override
    public SandboxPolicy getSandboxPolicy(String optionName) {
        assert get(optionName) != null : "Unknown option " + optionName;
        return SandboxPolicy.TRUSTED;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return List.of(
            OptionDescriptor.newBuilder(MemoryTracerCLI.ENABLED, "memtracer").deprecated(false).help("Enable the Memory Tracer (default: false).").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(MemoryTracerCLI.FILTER_FILE, "memtracer.FilterFile").deprecated(false).help("Wildcard filter for source file paths. (for example, *program*.sl) (default: no filter).").usageSyntax("<filter>").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(MemoryTracerCLI.FILTER_LANGUAGE, "memtracer.FilterLanguage").deprecated(false).help("Only profile languages with given ID. (for example js) (default: no filter).").usageSyntax("<languageId>").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(MemoryTracerCLI.FILTER_MIME_TYPE, "memtracer.FilterMimeType").deprecated(false).help("Only profile languages with mime-type. (for example, application/javascript). (default: no filter)").usageSyntax("<mime-type>").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(MemoryTracerCLI.FILTER_ROOT, "memtracer.FilterRootName").deprecated(false).help("Wildcard filter for program roots. (for example, Math.*) (default: no filter).").usageSyntax("<filter>").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(MemoryTracerCLI.OUTPUT, "memtracer.Output").deprecated(false).help("Print a 'typehistogram', 'histogram' or 'calltree' as output. (default: histogram)").usageSyntax("typehistogram|histogram|calltree").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(MemoryTracerCLI.STACK_LIMIT, "memtracer.StackLimit").deprecated(false).help("Maximum number of maximum stack elements. (default: 10000)").usageSyntax("[1, inf)").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(MemoryTracerCLI.TRACE_CALLS, "memtracer.TraceCalls").deprecated(false).help("Capture calls when tracing. (default: false)").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(MemoryTracerCLI.TRACE_INTERNAL, "memtracer.TraceInternal").deprecated(false).help("Capture internal elements. (default: false)").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(MemoryTracerCLI.TRACE_ROOTS, "memtracer.TraceRoots").deprecated(false).help("Capture roots when tracing. (default: true)").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(MemoryTracerCLI.TRACE_STATEMENTS, "memtracer.TraceStatements").deprecated(false).help("Capture statements when tracing (default: false).").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build())
        .iterator();
    }

}
