/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler;

import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.tools.profiler.CPUSamplerData;
import com.oracle.truffle.tools.profiler.ProfilerException;
import com.oracle.truffle.tools.profiler.ProfilerNode;
import com.oracle.truffle.tools.profiler.SafepointStackSampler;
import com.oracle.truffle.tools.profiler.StackTraceEntry;
import com.oracle.truffle.tools.profiler.impl.CPUSamplerInstrument;
import com.oracle.truffle.tools.profiler.impl.ProfilerToolFactory;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.polyglot.Engine;

public final class CPUSampler
implements Closeable {
    static final SourceSectionFilter DEFAULT_FILTER = SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).build();
    private static final Supplier<Payload> PAYLOAD_FACTORY = new Supplier<Payload>(){

        @Override
        public Payload get() {
            return new Payload();
        }
    };
    private static final BiConsumer<Payload, Payload> MERGE_PAYLOAD = new BiConsumer<Payload, Payload>(){

        @Override
        public void accept(Payload sourcePayload, Payload destinationPayload) {
            int i;
            if (destinationPayload.selfTierCount.length < sourcePayload.selfTierCount.length) {
                destinationPayload.selfTierCount = Arrays.copyOf(destinationPayload.selfTierCount, sourcePayload.selfTierCount.length);
            }
            for (i = 0; i < sourcePayload.selfTierCount.length; ++i) {
                int n = i;
                destinationPayload.selfTierCount[n] = destinationPayload.selfTierCount[n] + sourcePayload.selfTierCount[i];
            }
            if (destinationPayload.tierCount.length < sourcePayload.tierCount.length) {
                destinationPayload.tierCount = Arrays.copyOf(destinationPayload.tierCount, sourcePayload.tierCount.length);
            }
            for (i = 0; i < sourcePayload.tierCount.length; ++i) {
                int n = i;
                destinationPayload.tierCount[n] = destinationPayload.tierCount[n] + sourcePayload.tierCount[i];
            }
            for (Long timestamp : sourcePayload.getSelfHitTimes()) {
                destinationPayload.addSelfHitTime(timestamp);
            }
        }
    };
    private static final Function<Payload, Payload> COPY_PAYLOAD = new Function<Payload, Payload>(){

        @Override
        public Payload apply(Payload sourcePayload) {
            Payload destinationPayload = new Payload();
            destinationPayload.selfTierCount = Arrays.copyOf(sourcePayload.selfTierCount, sourcePayload.selfTierCount.length);
            destinationPayload.tierCount = Arrays.copyOf(sourcePayload.tierCount, sourcePayload.tierCount.length);
            for (Long timestamp : sourcePayload.getSelfHitTimes()) {
                destinationPayload.addSelfHitTime(timestamp);
            }
            return destinationPayload;
        }
    };
    private final TruffleInstrument.Env env;
    private final Map<TruffleContext, MutableSamplerData> activeContexts = Collections.synchronizedMap(new HashMap());
    private volatile boolean closed;
    private volatile boolean collecting;
    private long period = 10L;
    private long delay = 0L;
    private int stackLimit = 10000;
    private boolean sampleContextInitialization = false;
    private SourceSectionFilter filter = DEFAULT_FILTER;
    private Timer samplerThread;
    private SamplingTimerTask samplerTask;
    private Thread processingThread;
    private ResultProcessingRunnable processingThreadRunnable;
    private volatile SafepointStackSampler safepointStackSampler = new SafepointStackSampler(this.stackLimit, this.filter, this.period);
    private boolean gatherSelfHitTimes = false;
    private final ArrayBlockingQueue<SamplingResult> resultsToProcess = new ArrayBlockingQueue(256);

    CPUSampler(TruffleInstrument.Env env) {
        this.env = env;
        env.getInstrumenter().attachContextsListener(new ContextsListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onContextCreated(TruffleContext context) {
                CPUSampler cPUSampler = CPUSampler.this;
                synchronized (cPUSampler) {
                    CPUSampler.this.activeContexts.put(context, new MutableSamplerData());
                }
            }

            public void onLanguageContextCreate(TruffleContext context, LanguageInfo language) {
            }

            public void onLanguageContextCreated(TruffleContext context, LanguageInfo language) {
            }

            public void onLanguageContextCreateFailed(TruffleContext context, LanguageInfo language) {
            }

            public void onLanguageContextInitialize(TruffleContext context, LanguageInfo language) {
                CPUSampler.this.safepointStackSampler.pushSyntheticFrame(language, "initializeContext");
            }

            public void onLanguageContextInitialized(TruffleContext context, LanguageInfo language) {
                CPUSampler.this.safepointStackSampler.popSyntheticFrame();
            }

            public void onLanguageContextInitializeFailed(TruffleContext context, LanguageInfo language) {
                CPUSampler.this.safepointStackSampler.popSyntheticFrame();
            }

            public void onLanguageContextFinalized(TruffleContext context, LanguageInfo language) {
            }

            public void onLanguageContextDisposed(TruffleContext context, LanguageInfo language) {
            }

            public void onContextClosed(TruffleContext context) {
            }
        }, true);
    }

    public static CPUSampler find(Engine engine) {
        return CPUSamplerInstrument.getSampler(engine);
    }

    public synchronized boolean isCollecting() {
        return this.collecting;
    }

    public synchronized void setCollecting(boolean collecting) {
        if (this.collecting != collecting) {
            this.collecting = collecting;
            this.resetSampling();
        }
    }

    @Deprecated
    public synchronized void setMode(Mode mode) {
    }

    public synchronized long getPeriod() {
        return this.period;
    }

    public synchronized void setPeriod(long samplePeriod) {
        this.enterChangeConfig();
        if (samplePeriod < 1L) {
            throw new ProfilerException(String.format("Invalid sample period %s.", samplePeriod));
        }
        this.period = samplePeriod;
    }

    public synchronized void setDelay(long delay) {
        this.enterChangeConfig();
        if (delay < 0L) {
            throw new ProfilerException(String.format("Invalid delay %s.", delay));
        }
        this.delay = delay;
    }

    public synchronized int getStackLimit() {
        return this.stackLimit;
    }

    public synchronized void setStackLimit(int stackLimit) {
        this.enterChangeConfig();
        if (stackLimit < 1) {
            throw new ProfilerException(String.format("Invalid stack limit %s.", stackLimit));
        }
        this.stackLimit = stackLimit;
    }

    @Deprecated
    public synchronized void setDelaySamplingUntilNonInternalLangInit(boolean delaySamplingUntilNonInternalLangInit) {
    }

    public synchronized void setSampleContextInitialization(boolean enabled) {
        this.enterChangeConfig();
        this.sampleContextInitialization = enabled;
    }

    public synchronized SourceSectionFilter getFilter() {
        return this.filter;
    }

    public synchronized void setFilter(SourceSectionFilter filter) {
        this.enterChangeConfig();
        this.filter = filter;
    }

    @Deprecated
    public synchronized long getSampleCount() {
        long sum = 0L;
        for (MutableSamplerData value : this.activeContexts.values()) {
            sum += value.samplesTaken.get();
        }
        return sum;
    }

    public boolean hasStackOverflowed() {
        return this.safepointStackSampler.hasOverflowed();
    }

    @Deprecated
    public synchronized Collection<ProfilerNode<Payload>> getRootNodes() {
        ProfilerNode<Payload> mergedRoot = new ProfilerNode<Payload>();
        Map<Thread, Collection<ProfilerNode<Payload>>> threadToNodes = this.getThreadToNodesMap();
        for (Collection<ProfilerNode<Payload>> nodes : threadToNodes.values()) {
            for (ProfilerNode<Payload> node : nodes) {
                mergedRoot.deepMergeNodeToChildren(node, MERGE_PAYLOAD, PAYLOAD_FACTORY);
            }
        }
        return mergedRoot.getChildren();
    }

    @Deprecated
    public synchronized Map<Thread, Collection<ProfilerNode<Payload>>> getThreadToNodesMap() {
        if (this.activeContexts.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap returnValue = new HashMap();
        for (Map.Entry<Thread, ProfilerNode<Payload>> entry : this.activeContexts.values().iterator().next().threadData.entrySet()) {
            ProfilerNode<Payload> copy = new ProfilerNode<Payload>();
            copy.deepCopyChildrenFrom(entry.getValue(), COPY_PAYLOAD);
            returnValue.put(entry.getKey(), copy.getChildren());
        }
        return Collections.unmodifiableMap(returnValue);
    }

    public synchronized Map<TruffleContext, CPUSamplerData> getData() {
        if (this.activeContexts.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<TruffleContext, CPUSamplerData> contextToData = new HashMap<TruffleContext, CPUSamplerData>();
        for (Map.Entry<TruffleContext, MutableSamplerData> contextEntry : this.activeContexts.entrySet()) {
            HashMap<Thread, Collection<ProfilerNode<Payload>>> threads = new HashMap<Thread, Collection<ProfilerNode<Payload>>>();
            MutableSamplerData mutableSamplerData = contextEntry.getValue();
            for (Map.Entry<Thread, ProfilerNode<Payload>> threadEntry : mutableSamplerData.threadData.entrySet()) {
                ProfilerNode<Payload> copy = new ProfilerNode<Payload>();
                copy.deepCopyChildrenFrom(threadEntry.getValue(), COPY_PAYLOAD);
                threads.put(threadEntry.getKey(), copy.getChildren());
            }
            TruffleContext context = contextEntry.getKey();
            contextToData.put(context, new CPUSamplerData(context, threads, mutableSamplerData.biasStatistic, mutableSamplerData.durationStatistic, mutableSamplerData.samplesTaken.get(), this.period, mutableSamplerData.missedSamples.get()));
        }
        return Collections.unmodifiableMap(contextToData);
    }

    public synchronized void clearData() {
        for (TruffleContext context : this.activeContexts.keySet()) {
            this.activeContexts.put(context, new MutableSamplerData());
        }
    }

    public synchronized boolean hasData() {
        for (MutableSamplerData mutableSamplerData : this.activeContexts.values()) {
            if (mutableSamplerData.samplesTaken.get() <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.resetSampling();
        this.clearData();
    }

    public boolean isGatherSelfHitTimes() {
        return this.gatherSelfHitTimes;
    }

    public synchronized void setGatherSelfHitTimes(boolean gatherSelfHitTimes) {
        this.enterChangeConfig();
        this.gatherSelfHitTimes = gatherSelfHitTimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Thread, List<StackTraceEntry>> takeSample() {
        CPUSampler cPUSampler = this;
        synchronized (cPUSampler) {
            if (this.safepointStackSampler == null) {
                this.safepointStackSampler = new SafepointStackSampler(this.stackLimit, this.filter, this.period);
            }
            if (this.activeContexts.isEmpty()) {
                return Collections.emptyMap();
            }
            TruffleContext context = this.activeContexts.keySet().iterator().next();
            if (context.isActive()) {
                throw new IllegalArgumentException("Cannot sample a context that is currently active on the current thread.");
            }
            HashMap<Thread, List<StackTraceEntry>> stacks = new HashMap<Thread, List<StackTraceEntry>>();
            List<SafepointStackSampler.StackSample> sample = this.safepointStackSampler.sample(this.env, context, this.activeContexts.get(context), !this.sampleContextInitialization);
            for (SafepointStackSampler.StackSample stackSample : sample) {
                stacks.put(stackSample.thread, stackSample.stack);
            }
            return Collections.unmodifiableMap(stacks);
        }
    }

    private void resetSampling() {
        assert (Thread.holdsLock(this));
        this.cleanup();
        if (!this.collecting || this.closed) {
            return;
        }
        if (this.processingThread == null) {
            this.processingThreadRunnable = new ResultProcessingRunnable();
            this.processingThread = new Thread((Runnable)this.processingThreadRunnable, "Sampling Processing Thread");
            this.processingThread.setDaemon(true);
        }
        this.processingThread.start();
        if (this.samplerThread == null) {
            this.samplerThread = new Timer("Sampling thread", true);
        }
        this.safepointStackSampler = new SafepointStackSampler(this.stackLimit, this.filter, this.period);
        this.samplerTask = new SamplingTimerTask();
        this.samplerThread.scheduleAtFixedRate((TimerTask)this.samplerTask, this.delay, this.period);
    }

    private void cleanup() {
        assert (Thread.holdsLock(this));
        if (this.samplerTask != null) {
            this.samplerTask.cancel();
            this.samplerTask = null;
        }
        if (this.samplerThread != null) {
            this.samplerThread.cancel();
            this.samplerThread = null;
        }
        if (this.processingThread != null) {
            this.processingThreadRunnable.cancelled = true;
            this.processingThread.interrupt();
            this.processingThread = null;
        }
    }

    private void enterChangeConfig() {
        assert (Thread.holdsLock(this));
        if (this.closed) {
            throw new ProfilerException("CPUSampler is already closed.");
        }
        if (this.collecting) {
            throw new ProfilerException("Cannot change sampler configuration while collecting. Call setCollecting(false) to disable collection first.");
        }
    }

    private synchronized TruffleContext[] contexts() {
        return this.activeContexts.keySet().toArray(new TruffleContext[this.activeContexts.size()]);
    }

    static {
        CPUSamplerInstrument.setFactory(new ProfilerToolFactory<CPUSampler>(){

            @Override
            public CPUSampler create(TruffleInstrument.Env env) {
                return new CPUSampler(env);
            }
        });
    }

    static class MutableSamplerData {
        final Map<Thread, ProfilerNode<Payload>> threadData = new HashMap<Thread, ProfilerNode<Payload>>();
        final AtomicLong samplesTaken = new AtomicLong(0L);
        final LongSummaryStatistics biasStatistic = new LongSummaryStatistics();
        final LongSummaryStatistics durationStatistic = new LongSummaryStatistics();
        final AtomicLong missedSamples = new AtomicLong(0L);

        MutableSamplerData() {
        }
    }

    private class SamplingTimerTask
    extends TimerTask {
        private SamplingTimerTask() {
        }

        @Override
        public void run() {
            long taskStartTime = System.currentTimeMillis();
            for (TruffleContext context : CPUSampler.this.contexts()) {
                if (context.isClosed()) continue;
                List<SafepointStackSampler.StackSample> samples = CPUSampler.this.safepointStackSampler.sample(CPUSampler.this.env, context, (MutableSamplerData)CPUSampler.this.activeContexts.get(context), !CPUSampler.this.sampleContextInitialization);
                CPUSampler.this.resultsToProcess.add(new SamplingResult(samples, context, taskStartTime));
            }
        }
    }

    static class SamplingResult {
        final List<SafepointStackSampler.StackSample> samples;
        final TruffleContext context;
        final long startTime;

        SamplingResult(List<SafepointStackSampler.StackSample> samples, TruffleContext context, long startTime) {
            this.samples = samples;
            this.context = context;
            this.startTime = startTime;
        }
    }

    private class ResultProcessingRunnable
    implements Runnable {
        private volatile boolean cancelled;

        private ResultProcessingRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.cancelled) {
                SamplingResult result = null;
                try {
                    result = (SamplingResult)CPUSampler.this.resultsToProcess.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.cancelled) {
                    return;
                }
                if (result == null || result.context.isClosed()) continue;
                CPUSampler cPUSampler = CPUSampler.this;
                synchronized (cPUSampler) {
                    MutableSamplerData mutableSamplerData = (MutableSamplerData)CPUSampler.this.activeContexts.get(result.context);
                    for (SafepointStackSampler.StackSample sample : result.samples) {
                        mutableSamplerData.biasStatistic.accept(sample.biasNs);
                        mutableSamplerData.durationStatistic.accept(sample.durationNs);
                        ProfilerNode<Payload> threadNode = mutableSamplerData.threadData.computeIfAbsent(sample.thread, new Function<Thread, ProfilerNode<Payload>>(){

                            @Override
                            public ProfilerNode<Payload> apply(Thread thread) {
                                return new ProfilerNode<Payload>();
                            }
                        });
                        this.record(sample, threadNode, result.startTime, mutableSamplerData);
                    }
                }
            }
            return;
        }

        private void record(SafepointStackSampler.StackSample sample, ProfilerNode<Payload> threadNode, long timestamp, MutableSamplerData mutableSamplerData) {
            if (sample.stack.size() == 0) {
                return;
            }
            ProfilerNode<Payload> treeNode = threadNode;
            for (int i = sample.stack.size() - 1; i >= 0; --i) {
                StackTraceEntry location = sample.stack.get(i);
                treeNode = this.addOrUpdateChild(treeNode, location);
                Payload payload = treeNode.getPayload();
                this.recordCompilationInfo(location, payload, i == 0, timestamp);
            }
            mutableSamplerData.samplesTaken.incrementAndGet();
        }

        private void recordCompilationInfo(StackTraceEntry location, Payload payload, boolean topOfStack, long timestamp) {
            int tier = location.getTier();
            if (topOfStack) {
                if (payload.selfTierCount.length < tier + 1) {
                    payload.selfTierCount = Arrays.copyOf(payload.selfTierCount, tier + 1);
                }
                int n = tier;
                payload.selfTierCount[n] = payload.selfTierCount[n] + 1;
                if (CPUSampler.this.gatherSelfHitTimes) {
                    payload.selfHitTimes.add(timestamp);
                    assert (payload.selfHitTimes.size() == payload.getSelfHitCount());
                }
            }
            if (payload.tierCount.length < tier + 1) {
                payload.tierCount = Arrays.copyOf(payload.tierCount, tier + 1);
            }
            int n = tier;
            payload.tierCount[n] = payload.tierCount[n] + 1;
        }

        private ProfilerNode<Payload> addOrUpdateChild(ProfilerNode<Payload> treeNode, StackTraceEntry location) {
            ProfilerNode<Payload> child = treeNode.findChild(location);
            if (child == null) {
                Payload payload = new Payload();
                child = new ProfilerNode<Payload>(treeNode, location, payload);
                treeNode.addChild(location, child);
            }
            return child;
        }
    }

    public static final class Payload {
        final List<Long> selfHitTimes = new ArrayList<Long>();
        int[] tierCount = new int[0];
        int[] selfTierCount = new int[0];

        Payload() {
        }

        public int getNumberOfTiers() {
            return Math.max(this.selfTierCount.length, this.tierCount.length);
        }

        public int getTierSelfCount(int tier) {
            if (tier >= this.selfTierCount.length) {
                return 0;
            }
            return this.selfTierCount[tier];
        }

        public int getTierTotalCount(int tier) {
            if (tier >= this.tierCount.length) {
                return 0;
            }
            return this.tierCount[tier];
        }

        @Deprecated
        public int getCompiledHitCount() {
            return Payload.sumWithoutFirst(this.tierCount);
        }

        @Deprecated
        public int getInterpretedHitCount() {
            return Payload.firstOrZero(this.tierCount);
        }

        @Deprecated
        public int getSelfCompiledHitCount() {
            return Payload.sumWithoutFirst(this.selfTierCount);
        }

        private static int sumWithoutFirst(int[] tierCounts) {
            if (tierCounts.length <= 1) {
                return 0;
            }
            int sum = 0;
            for (int i = 1; i < tierCounts.length; ++i) {
                sum += tierCounts[i];
            }
            return sum;
        }

        @Deprecated
        public int getSelfInterpretedHitCount() {
            return Payload.firstOrZero(this.selfTierCount);
        }

        private static int firstOrZero(int[] selfTierCount) {
            return selfTierCount.length == 0 ? 0 : selfTierCount[0];
        }

        public int getSelfHitCount() {
            int sum = 0;
            for (int count : this.selfTierCount) {
                sum += count;
            }
            return sum;
        }

        public int getHitCount() {
            int sum = 0;
            for (int count : this.tierCount) {
                sum += count;
            }
            return sum;
        }

        public List<Long> getSelfHitTimes() {
            return Collections.unmodifiableList(this.selfHitTimes);
        }

        void addSelfHitTime(Long time) {
            this.selfHitTimes.add(time);
        }
    }

    @Deprecated
    public static enum Mode {
        EXCLUDE_INLINED_ROOTS,
        ROOTS,
        STATEMENTS;

    }
}

