/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.profiler.CPUSampler;
import com.oracle.truffle.tools.profiler.impl.CPUSamplerCLI;
import com.oracle.truffle.tools.profiler.impl.CPUSamplerCLIOptionDescriptors;
import com.oracle.truffle.tools.profiler.impl.ProfilerToolFactory;
import java.lang.reflect.Method;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;

@TruffleInstrument.Registration(id="cpusampler", name="CPU Sampler", version="0.5.0", services={CPUSampler.class})
public class CPUSamplerInstrument
extends TruffleInstrument {
    public static final String ID = "cpusampler";
    static final String VERSION = "0.5.0";
    private CPUSampler sampler;
    private static final ProfilerToolFactory<CPUSampler> factory = CPUSamplerInstrument.getDefaultFactory();

    private static ProfilerToolFactory<CPUSampler> getDefaultFactory() {
        try {
            Method createFactory = CPUSampler.class.getDeclaredMethod("createFactory", new Class[0]);
            createFactory.setAccessible(true);
            return (ProfilerToolFactory)createFactory.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static CPUSampler getSampler(Engine engine) {
        Instrument instrument = (Instrument)engine.getInstruments().get(ID);
        if (instrument == null) {
            throw new IllegalStateException("Sampler is not installed.");
        }
        return (CPUSampler)instrument.lookup(CPUSampler.class);
    }

    protected void onCreate(TruffleInstrument.Env env) {
        this.sampler = factory.create(env);
        if (((Boolean)env.getOptions().get(CPUSamplerCLI.ENABLED)).booleanValue()) {
            this.sampler.setPeriod((Long)env.getOptions().get(CPUSamplerCLI.SAMPLE_PERIOD));
            this.sampler.setDelay((Long)env.getOptions().get(CPUSamplerCLI.DELAY_PERIOD));
            this.sampler.setStackLimit((Integer)env.getOptions().get(CPUSamplerCLI.STACK_LIMIT));
            this.sampler.setFilter(CPUSamplerInstrument.getSourceSectionFilter(env));
            this.sampler.setGatherSelfHitTimes((Boolean)env.getOptions().get(CPUSamplerCLI.GATHER_HIT_TIMES));
            this.sampler.setSampleContextInitialization((Boolean)env.getOptions().get(CPUSamplerCLI.SAMPLE_CONTEXT_INITIALIZATION));
            this.sampler.setCollecting(true);
        }
        env.registerService((Object)this.sampler);
    }

    private static SourceSectionFilter getSourceSectionFilter(TruffleInstrument.Env env) {
        boolean internals = (Boolean)env.getOptions().get(CPUSamplerCLI.SAMPLE_INTERNAL);
        Object[] filterRootName = (Object[])env.getOptions().get(CPUSamplerCLI.FILTER_ROOT);
        Object[] filterFile = (Object[])env.getOptions().get(CPUSamplerCLI.FILTER_FILE);
        String filterMimeType = (String)env.getOptions().get(CPUSamplerCLI.FILTER_MIME_TYPE);
        String filterLanguage = (String)env.getOptions().get(CPUSamplerCLI.FILTER_LANGUAGE);
        return CPUSamplerCLI.buildFilter(true, false, false, internals, filterRootName, filterFile, filterMimeType, filterLanguage);
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new CPUSamplerCLIOptionDescriptors();
    }

    protected void onFinalize(TruffleInstrument.Env env) {
        if (((Boolean)env.getOptions().get(CPUSamplerCLI.ENABLED)).booleanValue()) {
            CPUSamplerCLI.handleOutput(env, this.sampler);
        }
    }

    protected void onDispose(TruffleInstrument.Env env) {
        this.sampler.close();
    }
}

