/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.profiler.MemoryTracer;
import com.oracle.truffle.tools.profiler.impl.MemoryTracerCLI;
import com.oracle.truffle.tools.profiler.impl.MemoryTracerCLIOptionDescriptors;
import com.oracle.truffle.tools.profiler.impl.ProfilerToolFactory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;

@TruffleInstrument.Registration(id="memtracer", name="Memory Tracer", version="0.2", services={MemoryTracer.class})
public class MemoryTracerInstrument
extends TruffleInstrument {
    public static final String ID = "memtracer";
    private MemoryTracer tracer;
    private static ProfilerToolFactory<MemoryTracer> factory;

    public static void setFactory(ProfilerToolFactory<MemoryTracer> factory) {
        if (factory == null || !factory.getClass().getName().startsWith("com.oracle.truffle.tools.profiler")) {
            throw new IllegalArgumentException("Wrong factory: " + factory);
        }
        MemoryTracerInstrument.factory = factory;
    }

    public static MemoryTracer getTracer(Engine engine) {
        Instrument instrument = (Instrument)engine.getInstruments().get(ID);
        if (instrument == null) {
            throw new IllegalStateException("Memory Tracer is not installed.");
        }
        return (MemoryTracer)instrument.lookup(MemoryTracer.class);
    }

    protected void onCreate(TruffleInstrument.Env env) {
        this.tracer = factory.create(env);
        if (((Boolean)env.getOptions().get(MemoryTracerCLI.ENABLED)).booleanValue()) {
            this.tracer.setFilter(MemoryTracerInstrument.getSourceSectionFilter(env));
            this.tracer.setStackLimit((Integer)env.getOptions().get(MemoryTracerCLI.STACK_LIMIT));
            this.tracer.setCollecting(true);
        }
        env.registerService((Object)this.tracer);
    }

    private static SourceSectionFilter getSourceSectionFilter(TruffleInstrument.Env env) {
        boolean roots = (Boolean)env.getOptions().get(MemoryTracerCLI.TRACE_ROOTS);
        boolean statements = (Boolean)env.getOptions().get(MemoryTracerCLI.TRACE_STATEMENTS);
        boolean calls = (Boolean)env.getOptions().get(MemoryTracerCLI.TRACE_CALLS);
        boolean internals = (Boolean)env.getOptions().get(MemoryTracerCLI.TRACE_INTERNAL);
        Object[] filterRootName = (Object[])env.getOptions().get(MemoryTracerCLI.FILTER_ROOT);
        Object[] filterFile = (Object[])env.getOptions().get(MemoryTracerCLI.FILTER_FILE);
        String filterMimeType = (String)env.getOptions().get(MemoryTracerCLI.FILTER_MIME_TYPE);
        String filterLanguage = (String)env.getOptions().get(MemoryTracerCLI.FILTER_LANGUAGE);
        return MemoryTracerCLI.buildFilter(roots, statements, calls, internals, filterRootName, filterFile, filterMimeType, filterLanguage);
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new MemoryTracerCLIOptionDescriptors();
    }

    protected void onFinalize(TruffleInstrument.Env env) {
        if (((Boolean)env.getOptions().get(MemoryTracerCLI.ENABLED)).booleanValue()) {
            MemoryTracerCLI.handleOutput(env, this.tracer);
        }
    }

    protected void onDispose(TruffleInstrument.Env env) {
        this.tracer.close();
    }

    static {
        try {
            Class.forName(MemoryTracer.class.getName(), true, MemoryTracer.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new AssertionError();
        }
    }
}

