/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.profiler.MemoryTracer;
import com.oracle.truffle.tools.profiler.ProfilerNode;
import com.oracle.truffle.tools.profiler.impl.ProfilerCLI;
import com.oracle.truffle.tools.profiler.impl.WildcardFilter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionType;

@Option.Group(value={"memtracer"})
class MemoryTracerCLI
extends ProfilerCLI {
    static final OptionType<Output> CLI_OUTPUT_TYPE = new OptionType("Format", (Function)new Function<String, Output>(){

        @Override
        public Output apply(String s) {
            switch (s) {
                case "typehistogram": {
                    return Output.TYPE_HISTOGRAM;
                }
                case "histogram": {
                    return Output.LOCATION_HISTOGRAM;
                }
                case "calltree": {
                    return Output.CALLTREE;
                }
            }
            return null;
        }
    }, (Consumer)new Consumer<Output>(){

        @Override
        public void accept(Output output) {
            if (output == null) {
                throw new IllegalArgumentException();
            }
        }
    });
    @Option(name="", help="Enable the Memory Tracer (default: false).", category=OptionCategory.USER)
    static final OptionKey<Boolean> ENABLED = new OptionKey((Object)false);
    @Option(name="Output", help="Print a 'typehistogram', 'histogram' or 'calltree' as output. (default: histogram)", usageSyntax="typehistogram|histogram|calltree", category=OptionCategory.USER)
    static final OptionKey<Output> OUTPUT = new OptionKey((Object)Output.LOCATION_HISTOGRAM, CLI_OUTPUT_TYPE);
    @Option(name="StackLimit", help="Maximum number of maximum stack elements. (default: 10000)", usageSyntax="[1, inf)", category=OptionCategory.USER)
    static final OptionKey<Integer> STACK_LIMIT = new OptionKey((Object)10000);
    @Option(name="TraceRoots", help="Capture roots when tracing. (default: true)", usageSyntax="true|false", category=OptionCategory.USER)
    static final OptionKey<Boolean> TRACE_ROOTS = new OptionKey((Object)true);
    @Option(name="TraceStatements", help="Capture statements when tracing (default: false).", category=OptionCategory.USER)
    static final OptionKey<Boolean> TRACE_STATEMENTS = new OptionKey((Object)false);
    @Option(name="TraceCalls", help="Capture calls when tracing. (default: false)", category=OptionCategory.USER)
    static final OptionKey<Boolean> TRACE_CALLS = new OptionKey((Object)false);
    @Option(name="TraceInternal", help="Capture internal elements. (default: false)", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TRACE_INTERNAL = new OptionKey((Object)false);
    @Option(name="FilterRootName", help="Wildcard filter for program roots. (eg. Math.*) (default: no filter).", usageSyntax="<filter>", category=OptionCategory.USER)
    static final OptionKey<WildcardFilter> FILTER_ROOT = new OptionKey((Object)WildcardFilter.DEFAULT, WildcardFilter.WILDCARD_FILTER_TYPE);
    @Option(name="FilterFile", help="Wildcard filter for source file paths. (eg. *program*.sl) (default: no filter).", usageSyntax="<filter>", category=OptionCategory.USER)
    static final OptionKey<WildcardFilter> FILTER_FILE = new OptionKey((Object)WildcardFilter.DEFAULT, WildcardFilter.WILDCARD_FILTER_TYPE);
    @Option(name="FilterMimeType", help="Only profile languages with mime-type. (eg. application/javascript). (default: no filter)", usageSyntax="<mime-type>", category=OptionCategory.USER)
    static final OptionKey<String> FILTER_MIME_TYPE = new OptionKey((Object)"");
    @Option(name="FilterLanguage", help="Only profile languages with given ID. (eg. js) (default: no filter).", usageSyntax="<languageId>", category=OptionCategory.USER)
    static final OptionKey<String> FILTER_LANGUAGE = new OptionKey((Object)"");

    MemoryTracerCLI() {
    }

    static void handleOutput(TruffleInstrument.Env env, MemoryTracer tracer) {
        PrintStream out = new PrintStream(env.out());
        if (tracer.hasStackOverflowed()) {
            out.println("-------------------------------------------------------------------------------- ");
            out.println("ERROR: Shadow stack has overflowed its capacity of " + env.getOptions().get(STACK_LIMIT) + " during execution!");
            out.println("The gathered data is incomplete and incorrect!");
            out.println("Use --memtracer.StackLimit=<" + STACK_LIMIT.getType().getName() + "> to set stack capacity.");
            out.println("-------------------------------------------------------------------------------- ");
            return;
        }
        switch ((Output)((Object)env.getOptions().get(OUTPUT))) {
            case TYPE_HISTOGRAM: {
                MemoryTracerCLI.printMetaObjectHistogram(out, tracer);
                break;
            }
            case LOCATION_HISTOGRAM: {
                MemoryTracerCLI.printLocationHistogram(out, tracer);
                break;
            }
            case CALLTREE: {
                MemoryTracerCLI.printCallTree(out, tracer);
            }
        }
    }

    private static Map<String, List<MemoryTracer.AllocationEventInfo>> computeMetaObjectHistogram(MemoryTracer tracer) {
        HashMap<String, List<MemoryTracer.AllocationEventInfo>> histogram = new HashMap<String, List<MemoryTracer.AllocationEventInfo>>();
        MemoryTracerCLI.computeMetaObjectHistogramImpl(tracer.getRootNodes(), histogram);
        return histogram;
    }

    private static void computeMetaObjectHistogramImpl(Collection<ProfilerNode<MemoryTracer.Payload>> children, Map<String, List<MemoryTracer.AllocationEventInfo>> histogram) {
        for (ProfilerNode<MemoryTracer.Payload> treeNode : children) {
            for (MemoryTracer.AllocationEventInfo info : treeNode.getPayload().getEvents()) {
                List<MemoryTracer.AllocationEventInfo> nodes = histogram.computeIfAbsent(info.getMetaObjectString(), new Function<String, List<MemoryTracer.AllocationEventInfo>>(){

                    @Override
                    public List<MemoryTracer.AllocationEventInfo> apply(String s) {
                        return new ArrayList<MemoryTracer.AllocationEventInfo>();
                    }
                });
                nodes.add(info);
            }
            MemoryTracerCLI.computeMetaObjectHistogramImpl(treeNode.getChildren(), histogram);
        }
    }

    private static void printMetaObjectHistogram(PrintStream out, MemoryTracer tracer) {
        final Map<String, List<MemoryTracer.AllocationEventInfo>> histogram = MemoryTracerCLI.computeMetaObjectHistogram(tracer);
        ArrayList<String> keys = new ArrayList<String>(histogram.keySet());
        keys.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.compare(((List)histogram.get(o2)).size(), ((List)histogram.get(o1)).size());
            }
        });
        int metaObjectMax = 1;
        Iterator<String> iterator = histogram.keySet().iterator();
        while (iterator.hasNext()) {
            metaObjectMax = Math.max(metaObjectMax, iterator.next().length());
        }
        long totalAllocations = MemoryTracerCLI.getTotalAllocationCount(tracer);
        String format = " %-" + metaObjectMax + "s | %15s ";
        String title = String.format(format, "Type", "Count");
        String sep = MemoryTracerCLI.repeat("-", title.length());
        out.println(sep);
        out.println(String.format(" Type Histogram with Allocation Counts. Recorded a total of %d allocations.", totalAllocations));
        out.println(sep);
        out.println(title);
        out.println(sep);
        for (String metaObjectString : keys) {
            int allocationCount = histogram.get(metaObjectString).size();
            String count = String.format("%d %5.1f%%", allocationCount, (double)allocationCount * 100.0 / (double)totalAllocations);
            out.println(String.format(format, metaObjectString, count));
        }
        out.println(sep);
    }

    private static Map<ProfilerCLI.SourceLocation, List<ProfilerNode<MemoryTracer.Payload>>> computeSourceLocationHistogram(MemoryTracer tracer) {
        HashMap<ProfilerCLI.SourceLocation, List<ProfilerNode<MemoryTracer.Payload>>> histogram = new HashMap<ProfilerCLI.SourceLocation, List<ProfilerNode<MemoryTracer.Payload>>>();
        MemoryTracerCLI.computeSourceLocationHistogramImpl(tracer.getRootNodes(), histogram);
        return histogram;
    }

    private static void computeSourceLocationHistogramImpl(Collection<ProfilerNode<MemoryTracer.Payload>> children, Map<ProfilerCLI.SourceLocation, List<ProfilerNode<MemoryTracer.Payload>>> histogram) {
        for (ProfilerNode<MemoryTracer.Payload> treeNode : children) {
            List<ProfilerNode<MemoryTracer.Payload>> nodes = histogram.computeIfAbsent(new ProfilerCLI.SourceLocation(treeNode.getSourceSection(), treeNode.getRootName()), new Function<ProfilerCLI.SourceLocation, List<ProfilerNode<MemoryTracer.Payload>>>(){

                @Override
                public List<ProfilerNode<MemoryTracer.Payload>> apply(ProfilerCLI.SourceLocation sourceLocation) {
                    return new ArrayList<ProfilerNode<MemoryTracer.Payload>>();
                }
            });
            nodes.add(treeNode);
            MemoryTracerCLI.computeSourceLocationHistogramImpl(treeNode.getChildren(), histogram);
        }
    }

    private static void printLocationHistogram(PrintStream out, MemoryTracer tracer) {
        Map<ProfilerCLI.SourceLocation, List<ProfilerNode<MemoryTracer.Payload>>> histogram = MemoryTracerCLI.computeSourceLocationHistogram(tracer);
        List<ProfilerCLI.SourceLocation> keys = MemoryTracerCLI.getSortedSourceLocations(histogram);
        int nameMax = 1;
        for (List<ProfilerNode<MemoryTracer.Payload>> profilerNodes : histogram.values()) {
            nameMax = Math.max(nameMax, profilerNodes.get(0).getRootName().length());
        }
        long totalAllocations = MemoryTracerCLI.getTotalAllocationCount(tracer);
        String format = " %-" + nameMax + "s | %15s | %15s | %8s";
        String title = String.format(format, "Name", "Self Count", "Total Count", "Location");
        String sep = MemoryTracerCLI.repeat("-", title.length());
        out.println(sep);
        out.println(String.format(" Location Histogram with Allocation Counts. Recorded a total of %d allocations.", totalAllocations));
        out.println("   Total Count: Number of allocations during the execution of this element.");
        out.println("   Self Count: Number of allocations in this element alone (excluding sub calls). ");
        out.println(sep);
        out.println(title);
        out.println(sep);
        for (ProfilerCLI.SourceLocation location : keys) {
            List<ProfilerNode<MemoryTracer.Payload>> profilerNodes = histogram.get(location);
            long self = 0L;
            long total = 0L;
            for (ProfilerNode<MemoryTracer.Payload> node : profilerNodes) {
                MemoryTracer.Payload payload = node.getPayload();
                self += (long)payload.getEvents().size();
                total += node.isRecursive() ? 0L : payload.getTotalAllocations();
            }
            String selfCount = String.format("%d %5.1f%%", self, (double)self * 100.0 / (double)totalAllocations);
            String totalCount = String.format("%d %5.1f%%", total, (double)total * 100.0 / (double)totalAllocations);
            String output = String.format(format, profilerNodes.get(0).getRootName(), selfCount, totalCount, MemoryTracerCLI.getShortDescription(location.getSourceSection()));
            out.println(output);
        }
        out.println(sep);
    }

    private static void printCallTree(PrintStream out, MemoryTracer tracer) {
        int titleMax = MemoryTracerCLI.getFirstFieldOfTitleMax(tracer);
        long totalAllocations = MemoryTracerCLI.getTotalAllocationCount(tracer);
        String format = " %-" + titleMax + "s | %15s | %15s | %s";
        String title = String.format(format, "Name", "Total Count", "Self Count", "Location     ");
        String sep = MemoryTracerCLI.repeat("-", title.length());
        out.println(sep);
        out.println(String.format(" Call Tree with Allocation Counts. Recorded a total of %d allocations.", totalAllocations));
        out.println("   Total Count: Number of allocations during the execution of this function.");
        out.println("   Self Count: Number of allocations in this function alone (excluding sub calls). ");
        out.println(sep);
        out.println(title);
        out.println(sep);
        for (ProfilerNode<MemoryTracer.Payload> node : tracer.getRootNodes()) {
            MemoryTracerCLI.printCallTree(node, format, 0, totalAllocations, out);
        }
        out.println(sep);
    }

    private static void printCallTree(ProfilerNode<MemoryTracer.Payload> node, String format, int depth, long totalAllocations, PrintStream out) {
        String padding = MemoryTracerCLI.repeat("  ", depth);
        MemoryTracer.Payload payload = node.getPayload();
        String selfCount = String.format("%d %5.1f%%", payload.getEvents().size(), (double)payload.getEvents().size() * 100.0 / (double)totalAllocations);
        String count = String.format("%d %5.1f%%", payload.getTotalAllocations(), (double)payload.getTotalAllocations() * 100.0 / (double)totalAllocations);
        String output = String.format(format, padding + node.getRootName(), count, selfCount, MemoryTracerCLI.getShortDescription(node.getSourceSection()));
        out.println(output);
        for (ProfilerNode<MemoryTracer.Payload> child : node.getChildren()) {
            MemoryTracerCLI.printCallTree(child, format, depth + 1, totalAllocations, out);
        }
    }

    private static List<ProfilerCLI.SourceLocation> getSortedSourceLocations(final Map<ProfilerCLI.SourceLocation, List<ProfilerNode<MemoryTracer.Payload>>> histogram) {
        ArrayList<ProfilerCLI.SourceLocation> keys = new ArrayList<ProfilerCLI.SourceLocation>(histogram.keySet());
        Collections.sort(keys, new Comparator<ProfilerCLI.SourceLocation>(){

            @Override
            public int compare(ProfilerCLI.SourceLocation sl1, ProfilerCLI.SourceLocation sl2) {
                int sl1Self = 0;
                int sl1Total = 0;
                for (ProfilerNode node : (List)histogram.get(sl1)) {
                    sl1Self += ((MemoryTracer.Payload)node.getPayload()).getEvents().size();
                    sl1Total = (int)((long)sl1Total + (node.isRecursive() ? 0L : ((MemoryTracer.Payload)node.getPayload()).getTotalAllocations()));
                }
                int sl2Self = 0;
                int sl2Total = 0;
                for (ProfilerNode node : (List)histogram.get(sl2)) {
                    sl2Self += ((MemoryTracer.Payload)node.getPayload()).getEvents().size();
                    sl2Total = (int)((long)sl2Total + (node.isRecursive() ? 0L : ((MemoryTracer.Payload)node.getPayload()).getTotalAllocations()));
                }
                int result = Integer.compare(sl2Self, sl1Self);
                if (result == 0) {
                    return Integer.compare(sl2Total, sl1Total);
                }
                return result;
            }
        });
        return keys;
    }

    private static int getFirstFieldOfTitleMax(MemoryTracer tracer) {
        int titleMax = 10;
        for (ProfilerNode<MemoryTracer.Payload> node : tracer.getRootNodes()) {
            titleMax = Math.max(titleMax, MemoryTracerCLI.getFirstFieldOfTitleMaxRec(node, 0, titleMax));
        }
        return titleMax;
    }

    private static int getFirstFieldOfTitleMaxRec(ProfilerNode<MemoryTracer.Payload> node, int depth, int max) {
        int newMax = Math.max(max, node.getRootName().length() + 2 * depth);
        for (ProfilerNode<MemoryTracer.Payload> child : node.getChildren()) {
            newMax = Math.max(newMax, MemoryTracerCLI.getFirstFieldOfTitleMaxRec(child, depth + 1, newMax));
        }
        return newMax;
    }

    private static long getTotalAllocationCount(MemoryTracer tracer) {
        long sum = 0L;
        for (ProfilerNode<MemoryTracer.Payload> node : tracer.getRootNodes()) {
            sum += node.getPayload().getTotalAllocations();
        }
        return sum;
    }

    static enum Output {
        TYPE_HISTOGRAM,
        LOCATION_HISTOGRAM,
        CALLTREE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

