// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.polyglot.HostExecuteNode;
import com.oracle.truffle.polyglot.HostExecuteNodeGen;
import com.oracle.truffle.polyglot.HostFunction;
import java.util.concurrent.locks.Lock;

@GeneratedBy(HostFunction.class)
final class HostFunctionGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(HostFunction.class, new InteropLibraryExports());
    }

    private HostFunctionGen() {
    }

    @GeneratedBy(HostFunction.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, HostFunction.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof HostFunction;
            return new Uncached();
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof HostFunction;
            return new Cached();
        }

        @GeneratedBy(HostFunction.class)
        private static final class Cached extends InteropLibrary {

            @CompilationFinal private int state_;
            @Child private HostExecuteNode execute_;

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof HostFunction) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.polyglot.HostFunction'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof HostFunction;
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostFunction) receiver).isExecutable();
            }

            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostFunction arg0Value = (HostFunction) arg0Value_;
                int state = state_;
                if (state != 0 /* is-active execute(HostFunction, Object[], HostExecuteNode) */) {
                    return arg0Value.execute(arg1Value, this.execute_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(HostFunction arg0Value, Object[] arg1Value) throws UnsupportedTypeException, ArityException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    this.execute_ = super.insert((HostExecuteNode.create()));
                    this.state_ = state = state | 0b1 /* add-active execute(HostFunction, Object[], HostExecuteNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.execute(arg1Value, this.execute_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
        @GeneratedBy(HostFunction.class)
        private static final class Uncached extends InteropLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof HostFunction) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.polyglot.HostFunction'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof HostFunction;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostFunction) receiver) .isExecutable();
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostFunction arg0Value = (HostFunction) arg0Value_;
                return arg0Value.execute(arg1Value, (HostExecuteNodeGen.getUncached()));
            }

        }
    }
}
