/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.DefaultTruffleObjectExports;
import com.oracle.truffle.api.interop.InteropAccessNode;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=DefaultTruffleObjectExports.class)
final class DefaultTruffleObjectExportsGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private DefaultTruffleObjectExportsGen() {
    }

    static {
        LibraryExport.register(DefaultTruffleObjectExports.class, new InteropLibraryExports());
    }

    @GeneratedBy(value=DefaultTruffleObjectExports.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, TruffleObject.class, true);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof TruffleObject);
            return new Uncached(receiver);
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof TruffleObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=DefaultTruffleObjectExports.class)
        private static final class Uncached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isBoolean(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isBoolean(arg0Value, InteropAccessNode.getUncached(Message.IS_BOXED), InteropAccessNode.getUncached(Message.UNBOX));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean asBoolean(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.asBoolean(arg0Value, InteropAccessNode.getUncached(Message.UNBOX));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isString(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isString(arg0Value, InteropAccessNode.getUncached(Message.IS_BOXED), InteropAccessNode.getUncached(Message.UNBOX));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public String asString(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.asString(arg0Value, InteropAccessNode.getUncached(Message.UNBOX));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isNull(arg0Value, InteropAccessNode.getUncached(Message.IS_NULL));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.hasMembers(arg0Value, InteropAccessNode.getUncached(Message.HAS_KEYS));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.readMember(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.READ));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isMemberReadable(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEY_INFO));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isMemberModifiable(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEY_INFO));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isMemberInsertable(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEY_INFO));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isMemberRemovable(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEY_INFO));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInternal(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isMemberInternal(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEY_INFO));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isMemberInvocable(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEY_INFO));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.hasMemberReadSideEffects(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEY_INFO));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.hasMemberWriteSideEffects(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEY_INFO));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                DefaultTruffleObjectExports.writeMember(arg0Value, arg1Value, arg2Value, InteropAccessNode.getUncached(Message.WRITE));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                DefaultTruffleObjectExports.removeMember(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.REMOVE));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.getMembers(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEYS));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.invokeMember(arg0Value, arg1Value, arg2Value, InteropAccessNode.getUncached(Message.INVOKE));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isInstantiable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isInstantiable(arg0Value, InteropAccessNode.getUncached(Message.IS_INSTANTIABLE));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.instantiate(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.NEW));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isExecutable(arg0Value, InteropAccessNode.getUncached(Message.IS_EXECUTABLE));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.execute(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.EXECUTE));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.hasArrayElements(arg0Value, InteropAccessNode.getUncached(Message.HAS_SIZE));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isArrayElementReadable(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEY_INFO));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isArrayElementModifiable(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEY_INFO));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isArrayElementInsertable(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEY_INFO));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isArrayElementRemovable(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.KEY_INFO));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.readArrayElement(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.READ));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                DefaultTruffleObjectExports.writeArrayElement(arg0Value, arg1Value, arg2Value, InteropAccessNode.getUncached(Message.WRITE));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                DefaultTruffleObjectExports.removeArrayElement(arg0Value, arg1Value, InteropAccessNode.getUncached(Message.REMOVE));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.getArraySize(arg0Value, InteropAccessNode.getUncached(Message.GET_SIZE));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isPointer(arg0Value, InteropAccessNode.getUncached(Message.IS_POINTER));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.asPointer(arg0Value, InteropAccessNode.getUncached(Message.AS_POINTER), InteropAccessNode.getUncached(Message.TO_NATIVE), BranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void toNative(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                DefaultTruffleObjectExports.toNative(arg0Value, InteropAccessNode.getUncached(Message.TO_NATIVE));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isNumber(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.isNumber(arg0Value, InteropAccessNode.getUncached(Message.IS_BOXED), InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInByte(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.fitsInByte(arg0Value, InteropAccessNode.getUncached(Message.IS_BOXED), InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInShort(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.fitsInShort(arg0Value, InteropAccessNode.getUncached(Message.IS_BOXED), InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInInt(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.fitsInInt(arg0Value, InteropAccessNode.getUncached(Message.IS_BOXED), InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInLong(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.fitsInLong(arg0Value, InteropAccessNode.getUncached(Message.IS_BOXED), InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInFloat(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.fitsInFloat(arg0Value, InteropAccessNode.getUncached(Message.IS_BOXED), InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean fitsInDouble(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.fitsInDouble(arg0Value, InteropAccessNode.getUncached(Message.IS_BOXED), InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.asByte(arg0Value, InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.asShort(arg0Value, InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.asInt(arg0Value, InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.asLong(arg0Value, InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.asFloat(arg0Value, InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return DefaultTruffleObjectExports.asDouble(arg0Value, InteropAccessNode.getUncached(Message.UNBOX), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }
        }

        @GeneratedBy(value=DefaultTruffleObjectExports.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            @CompilerDirectives.CompilationFinal
            private long state_;
            @Node.Child
            private InteropAccessNode isBoxed;
            @Node.Child
            private InteropAccessNode unbox;
            @Node.Child
            private InteropAccessNode read;
            @Node.Child
            private InteropAccessNode keyInfo;
            @Node.Child
            private InteropAccessNode write;
            @Node.Child
            private InteropAccessNode remove;
            @Node.Child
            private InteropAccessNode toNative;
            @Node.Child
            private InteropLibrary numbers;
            @Node.Child
            private InteropAccessNode isNullNode__isNull_;
            @Node.Child
            private InteropAccessNode hasMembersNode__hasKeys_;
            @Node.Child
            private InteropAccessNode getMembersNode__keys_;
            @Node.Child
            private InteropAccessNode invokeMemberNode__invoke_;
            @Node.Child
            private InteropAccessNode isInstantiableNode__isInstantiable_;
            @Node.Child
            private InteropAccessNode instantiateNode__newNode_;
            @Node.Child
            private InteropAccessNode isExecutableNode__isExecutable_;
            @Node.Child
            private InteropAccessNode executeNode__execute_;
            @Node.Child
            private InteropAccessNode hasArrayElementsNode__hasSize_;
            @Node.Child
            private InteropAccessNode getArraySizeNode__getSize_;
            @Node.Child
            private InteropAccessNode isPointerNode__isPointer_;
            @Node.Child
            private InteropAccessNode asPointerNode__asPointer_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile asPointerNode__exception_;

            Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isBoolean(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 1L) != 0L) {
                    return DefaultTruffleObjectExports.isBoolean(arg0Value, this.isBoxed, this.unbox);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isBooleanNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isBooleanNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert(InteropAccessNode.create(Message.IS_BOXED));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    this.state_ = state |= 1L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isBoolean(arg0Value, this.isBoxed, this.unbox);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                long state = this.state_;
                if ((state & 1L) == 0L) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public boolean asBoolean(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 2L) != 0L) {
                    return DefaultTruffleObjectExports.asBoolean(arg0Value, this.unbox);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asBooleanNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean asBooleanNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    this.state_ = state |= 2L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.asBoolean(arg0Value, this.unbox);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isString(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 4L) != 0L) {
                    return DefaultTruffleObjectExports.isString(arg0Value, this.isBoxed, this.unbox);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isStringNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isStringNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert(InteropAccessNode.create(Message.IS_BOXED));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    this.state_ = state |= 4L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isString(arg0Value, this.isBoxed, this.unbox);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public String asString(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 8L) != 0L) {
                    return DefaultTruffleObjectExports.asString(arg0Value, this.unbox);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asStringNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String asStringNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    this.state_ = state |= 8L;
                    lock.unlock();
                    hasLock = false;
                    String string = DefaultTruffleObjectExports.asString(arg0Value, this.unbox);
                    return string;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isNull(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x10L) != 0L) {
                    return DefaultTruffleObjectExports.isNull(arg0Value, this.isNullNode__isNull_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isNullNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isNullNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.isNullNode__isNull_ = super.insert(InteropAccessNode.create(Message.IS_NULL));
                    this.state_ = state |= 0x10L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isNull(arg0Value, this.isNullNode__isNull_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasMembers(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x20L) != 0L) {
                    return DefaultTruffleObjectExports.hasMembers(arg0Value, this.hasMembersNode__hasKeys_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasMembersNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasMembersNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.hasMembersNode__hasKeys_ = super.insert(InteropAccessNode.create(Message.HAS_KEYS));
                    this.state_ = state |= 0x20L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.hasMembers(arg0Value, this.hasMembersNode__hasKeys_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x40L) != 0L) {
                    return DefaultTruffleObjectExports.readMember(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.read == null) {
                        this.read = super.insert(InteropAccessNode.create(Message.READ));
                    }
                    this.state_ = state |= 0x40L;
                    lock.unlock();
                    hasLock = false;
                    Object object = DefaultTruffleObjectExports.readMember(arg0Value, arg1Value, this.read);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x80L) != 0L) {
                    return DefaultTruffleObjectExports.isMemberReadable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberReadableNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(InteropAccessNode.create(Message.KEY_INFO));
                    }
                    this.state_ = state |= 0x80L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isMemberReadable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x100L) != 0L) {
                    return DefaultTruffleObjectExports.isMemberModifiable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberModifiableNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(InteropAccessNode.create(Message.KEY_INFO));
                    }
                    this.state_ = state |= 0x100L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isMemberModifiable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x200L) != 0L) {
                    return DefaultTruffleObjectExports.isMemberInsertable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberInsertableNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(InteropAccessNode.create(Message.KEY_INFO));
                    }
                    this.state_ = state |= 0x200L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isMemberInsertable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x400L) != 0L) {
                    return DefaultTruffleObjectExports.isMemberRemovable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberRemovableNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(InteropAccessNode.create(Message.KEY_INFO));
                    }
                    this.state_ = state |= 0x400L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isMemberRemovable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInternal(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x800L) != 0L) {
                    return DefaultTruffleObjectExports.isMemberInternal(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInternalNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberInternalNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(InteropAccessNode.create(Message.KEY_INFO));
                    }
                    this.state_ = state |= 0x800L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isMemberInternal(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x1000L) != 0L) {
                    return DefaultTruffleObjectExports.isMemberInvocable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberInvocableNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(InteropAccessNode.create(Message.KEY_INFO));
                    }
                    this.state_ = state |= 0x1000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isMemberInvocable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x2000L) != 0L) {
                    return DefaultTruffleObjectExports.hasMemberReadSideEffects(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasMemberReadSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasMemberReadSideEffectsNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(InteropAccessNode.create(Message.KEY_INFO));
                    }
                    this.state_ = state |= 0x2000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.hasMemberReadSideEffects(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x4000L) != 0L) {
                    return DefaultTruffleObjectExports.hasMemberWriteSideEffects(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasMemberWriteSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasMemberWriteSideEffectsNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(InteropAccessNode.create(Message.KEY_INFO));
                    }
                    this.state_ = state |= 0x4000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.hasMemberWriteSideEffects(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x8000L) != 0L) {
                    DefaultTruffleObjectExports.writeMember(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeMemberNode_AndSpecialize(TruffleObject arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.write == null) {
                        this.write = super.insert(InteropAccessNode.create(Message.WRITE));
                    }
                    this.state_ = state |= 0x8000L;
                    lock.unlock();
                    hasLock = false;
                    DefaultTruffleObjectExports.writeMember(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x10000L) != 0L) {
                    DefaultTruffleObjectExports.removeMember(arg0Value, arg1Value, this.remove);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.removeMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void removeMemberNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.remove == null) {
                        this.remove = super.insert(InteropAccessNode.create(Message.REMOVE));
                    }
                    this.state_ = state |= 0x10000L;
                    lock.unlock();
                    hasLock = false;
                    DefaultTruffleObjectExports.removeMember(arg0Value, arg1Value, this.remove);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x20000L) != 0L) {
                    return DefaultTruffleObjectExports.getMembers(arg0Value, arg1Value, this.getMembersNode__keys_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getMembersNode_AndSpecialize(TruffleObject arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.getMembersNode__keys_ = super.insert(InteropAccessNode.create(Message.KEYS));
                    this.state_ = state |= 0x20000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = DefaultTruffleObjectExports.getMembers(arg0Value, arg1Value, this.getMembersNode__keys_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x40000L) != 0L) {
                    return DefaultTruffleObjectExports.invokeMember(arg0Value, arg1Value, arg2Value, this.invokeMemberNode__invoke_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invokeMemberNode_AndSpecialize(TruffleObject arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.invokeMemberNode__invoke_ = super.insert(InteropAccessNode.create(Message.INVOKE));
                    this.state_ = state |= 0x40000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = DefaultTruffleObjectExports.invokeMember(arg0Value, arg1Value, arg2Value, this.invokeMemberNode__invoke_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isInstantiable(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x80000L) != 0L) {
                    return DefaultTruffleObjectExports.isInstantiable(arg0Value, this.isInstantiableNode__isInstantiable_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isInstantiableNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isInstantiableNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.isInstantiableNode__isInstantiable_ = super.insert(InteropAccessNode.create(Message.IS_INSTANTIABLE));
                    this.state_ = state |= 0x80000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isInstantiable(arg0Value, this.isInstantiableNode__isInstantiable_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x100000L) != 0L) {
                    return DefaultTruffleObjectExports.instantiate(arg0Value, arg1Value, this.instantiateNode__newNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.instantiateNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object instantiateNode_AndSpecialize(TruffleObject arg0Value, Object[] arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.instantiateNode__newNode_ = super.insert(InteropAccessNode.create(Message.NEW));
                    this.state_ = state |= 0x100000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = DefaultTruffleObjectExports.instantiate(arg0Value, arg1Value, this.instantiateNode__newNode_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x200000L) != 0L) {
                    return DefaultTruffleObjectExports.isExecutable(arg0Value, this.isExecutableNode__isExecutable_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isExecutableNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isExecutableNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.isExecutableNode__isExecutable_ = super.insert(InteropAccessNode.create(Message.IS_EXECUTABLE));
                    this.state_ = state |= 0x200000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isExecutable(arg0Value, this.isExecutableNode__isExecutable_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x400000L) != 0L) {
                    return DefaultTruffleObjectExports.execute(arg0Value, arg1Value, this.executeNode__execute_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeNode_AndSpecialize(TruffleObject arg0Value, Object[] arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.executeNode__execute_ = super.insert(InteropAccessNode.create(Message.EXECUTE));
                    this.state_ = state |= 0x400000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = DefaultTruffleObjectExports.execute(arg0Value, arg1Value, this.executeNode__execute_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasArrayElements(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x800000L) != 0L) {
                    return DefaultTruffleObjectExports.hasArrayElements(arg0Value, this.hasArrayElementsNode__hasSize_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasArrayElementsNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasArrayElementsNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.hasArrayElementsNode__hasSize_ = super.insert(InteropAccessNode.create(Message.HAS_SIZE));
                    this.state_ = state |= 0x800000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.hasArrayElements(arg0Value, this.hasArrayElementsNode__hasSize_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x1000000L) != 0L) {
                    return DefaultTruffleObjectExports.isArrayElementReadable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementReadableNode_AndSpecialize(TruffleObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(InteropAccessNode.create(Message.KEY_INFO));
                    }
                    this.state_ = state |= 0x1000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isArrayElementReadable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x2000000L) != 0L) {
                    return DefaultTruffleObjectExports.isArrayElementModifiable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementModifiableNode_AndSpecialize(TruffleObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(InteropAccessNode.create(Message.KEY_INFO));
                    }
                    this.state_ = state |= 0x2000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isArrayElementModifiable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x4000000L) != 0L) {
                    return DefaultTruffleObjectExports.isArrayElementInsertable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementInsertableNode_AndSpecialize(TruffleObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(InteropAccessNode.create(Message.KEY_INFO));
                    }
                    this.state_ = state |= 0x4000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isArrayElementInsertable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x8000000L) != 0L) {
                    return DefaultTruffleObjectExports.isArrayElementRemovable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementRemovableNode_AndSpecialize(TruffleObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert(InteropAccessNode.create(Message.KEY_INFO));
                    }
                    this.state_ = state |= 0x8000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isArrayElementRemovable(arg0Value, arg1Value, this.keyInfo);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x10000000L) != 0L) {
                    return DefaultTruffleObjectExports.readArrayElement(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readArrayElementNode_AndSpecialize(TruffleObject arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.read == null) {
                        this.read = super.insert(InteropAccessNode.create(Message.READ));
                    }
                    this.state_ = state |= 0x10000000L;
                    lock.unlock();
                    hasLock = false;
                    Object object = DefaultTruffleObjectExports.readArrayElement(arg0Value, arg1Value, this.read);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x20000000L) != 0L) {
                    DefaultTruffleObjectExports.writeArrayElement(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeArrayElementNode_AndSpecialize(TruffleObject arg0Value, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.write == null) {
                        this.write = super.insert(InteropAccessNode.create(Message.WRITE));
                    }
                    this.state_ = state |= 0x20000000L;
                    lock.unlock();
                    hasLock = false;
                    DefaultTruffleObjectExports.writeArrayElement(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x40000000L) != 0L) {
                    DefaultTruffleObjectExports.removeArrayElement(arg0Value, arg1Value, this.remove);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.removeArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void removeArrayElementNode_AndSpecialize(TruffleObject arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.remove == null) {
                        this.remove = super.insert(InteropAccessNode.create(Message.REMOVE));
                    }
                    this.state_ = state |= 0x40000000L;
                    lock.unlock();
                    hasLock = false;
                    DefaultTruffleObjectExports.removeArrayElement(arg0Value, arg1Value, this.remove);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x80000000L) != 0L) {
                    return DefaultTruffleObjectExports.getArraySize(arg0Value, this.getArraySizeNode__getSize_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getArraySizeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getArraySizeNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.getArraySizeNode__getSize_ = super.insert(InteropAccessNode.create(Message.GET_SIZE));
                    this.state_ = state |= 0x80000000L;
                    lock.unlock();
                    hasLock = false;
                    long l = DefaultTruffleObjectExports.getArraySize(arg0Value, this.getArraySizeNode__getSize_);
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isPointer(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x100000000L) != 0L) {
                    return DefaultTruffleObjectExports.isPointer(arg0Value, this.isPointerNode__isPointer_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isPointerNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isPointerNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.isPointerNode__isPointer_ = super.insert(InteropAccessNode.create(Message.IS_POINTER));
                    this.state_ = state |= 0x100000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isPointer(arg0Value, this.isPointerNode__isPointer_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x200000000L) != 0L) {
                    return DefaultTruffleObjectExports.asPointer(arg0Value, this.asPointerNode__asPointer_, this.toNative, this.asPointerNode__exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asPointerNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long asPointerNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    this.asPointerNode__asPointer_ = super.insert(InteropAccessNode.create(Message.AS_POINTER));
                    if (this.toNative == null) {
                        this.toNative = super.insert(InteropAccessNode.create(Message.TO_NATIVE));
                    }
                    this.asPointerNode__exception_ = BranchProfile.create();
                    this.state_ = state |= 0x200000000L;
                    lock.unlock();
                    hasLock = false;
                    long l = DefaultTruffleObjectExports.asPointer(arg0Value, this.asPointerNode__asPointer_, this.toNative, this.asPointerNode__exception_);
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void toNative(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x400000000L) != 0L) {
                    DefaultTruffleObjectExports.toNative(arg0Value, this.toNative);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNativeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void toNativeNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.toNative == null) {
                        this.toNative = super.insert(InteropAccessNode.create(Message.TO_NATIVE));
                    }
                    this.state_ = state |= 0x400000000L;
                    lock.unlock();
                    hasLock = false;
                    DefaultTruffleObjectExports.toNative(arg0Value, this.toNative);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isNumber(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x800000000L) != 0L) {
                    return DefaultTruffleObjectExports.isNumber(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isNumberNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isNumberNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert(InteropAccessNode.create(Message.IS_BOXED));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x800000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.isNumber(arg0Value, this.isBoxed, this.unbox, this.numbers);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInByte(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x1000000000L) != 0L) {
                    return DefaultTruffleObjectExports.fitsInByte(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInByteNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInByteNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert(InteropAccessNode.create(Message.IS_BOXED));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x1000000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.fitsInByte(arg0Value, this.isBoxed, this.unbox, this.numbers);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInShort(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x2000000000L) != 0L) {
                    return DefaultTruffleObjectExports.fitsInShort(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInShortNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInShortNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert(InteropAccessNode.create(Message.IS_BOXED));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x2000000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.fitsInShort(arg0Value, this.isBoxed, this.unbox, this.numbers);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInInt(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x4000000000L) != 0L) {
                    return DefaultTruffleObjectExports.fitsInInt(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInIntNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInIntNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert(InteropAccessNode.create(Message.IS_BOXED));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x4000000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.fitsInInt(arg0Value, this.isBoxed, this.unbox, this.numbers);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInLong(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x8000000000L) != 0L) {
                    return DefaultTruffleObjectExports.fitsInLong(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInLongNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInLongNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert(InteropAccessNode.create(Message.IS_BOXED));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x8000000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.fitsInLong(arg0Value, this.isBoxed, this.unbox, this.numbers);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x10000000000L) != 0L) {
                    return DefaultTruffleObjectExports.fitsInFloat(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInFloatNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInFloatNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert(InteropAccessNode.create(Message.IS_BOXED));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x10000000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.fitsInFloat(arg0Value, this.isBoxed, this.unbox, this.numbers);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInDouble(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x20000000000L) != 0L) {
                    return DefaultTruffleObjectExports.fitsInDouble(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fitsInDoubleNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fitsInDoubleNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert(InteropAccessNode.create(Message.IS_BOXED));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x20000000000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DefaultTruffleObjectExports.fitsInDouble(arg0Value, this.isBoxed, this.unbox, this.numbers);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x40000000000L) != 0L) {
                    return DefaultTruffleObjectExports.asByte(arg0Value, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asByteNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte asByteNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x40000000000L;
                    lock.unlock();
                    hasLock = false;
                    byte by = DefaultTruffleObjectExports.asByte(arg0Value, this.unbox, this.numbers);
                    return by;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x80000000000L) != 0L) {
                    return DefaultTruffleObjectExports.asShort(arg0Value, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asShortNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private short asShortNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x80000000000L;
                    lock.unlock();
                    hasLock = false;
                    short s = DefaultTruffleObjectExports.asShort(arg0Value, this.unbox, this.numbers);
                    return s;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x100000000000L) != 0L) {
                    return DefaultTruffleObjectExports.asInt(arg0Value, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asIntNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int asIntNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x100000000000L;
                    lock.unlock();
                    hasLock = false;
                    int n = DefaultTruffleObjectExports.asInt(arg0Value, this.unbox, this.numbers);
                    return n;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x200000000000L) != 0L) {
                    return DefaultTruffleObjectExports.asLong(arg0Value, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asLongNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long asLongNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x200000000000L;
                    lock.unlock();
                    hasLock = false;
                    long l = DefaultTruffleObjectExports.asLong(arg0Value, this.unbox, this.numbers);
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x400000000000L) != 0L) {
                    return DefaultTruffleObjectExports.asFloat(arg0Value, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asFloatNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private float asFloatNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x400000000000L;
                    lock.unlock();
                    hasLock = false;
                    float f = DefaultTruffleObjectExports.asFloat(arg0Value, this.unbox, this.numbers);
                    return f;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                long state = this.state_;
                if ((state & 0x800000000000L) != 0L) {
                    return DefaultTruffleObjectExports.asDouble(arg0Value, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asDoubleNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private double asDoubleNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                long state = this.state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert(InteropAccessNode.create(Message.UNBOX));
                    }
                    if (this.numbers == null) {
                        this.numbers = (InteropLibrary)super.insert(INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 0x800000000000L;
                    lock.unlock();
                    hasLock = false;
                    double d = DefaultTruffleObjectExports.asDouble(arg0Value, this.unbox, this.numbers);
                    return d;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

