// CheckStyle: start generated
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.DefaultTruffleObjectExports;
import com.oracle.truffle.api.interop.InteropAccessNode;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.util.concurrent.locks.Lock;

@GeneratedBy(DefaultTruffleObjectExports.class)
@SuppressWarnings("deprecation")
final class DefaultTruffleObjectExportsGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(DefaultTruffleObjectExports.class, new InteropLibraryExports());
    }

    private DefaultTruffleObjectExportsGen() {
    }

    @GeneratedBy(DefaultTruffleObjectExports.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, TruffleObject.class, true);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof TruffleObject;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof TruffleObject;
            return new Cached(receiver);
        }

        @GeneratedBy(DefaultTruffleObjectExports.class)
        private static final class Cached extends InteropLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            @CompilationFinal private long state_;
            @Child private InteropAccessNode isBoxed;
            @Child private InteropAccessNode unbox;
            @Child private InteropAccessNode read;
            @Child private InteropAccessNode keyInfo;
            @Child private InteropAccessNode write;
            @Child private InteropAccessNode remove;
            @Child private InteropAccessNode toNative;
            @Child private InteropLibrary numbers;
            @Child private InteropAccessNode isNullNode__isNull_;
            @Child private InteropAccessNode hasMembersNode__hasKeys_;
            @Child private InteropAccessNode getMembersNode__keys_;
            @Child private InteropAccessNode invokeMemberNode__invoke_;
            @Child private InteropAccessNode isInstantiableNode__isInstantiable_;
            @Child private InteropAccessNode instantiateNode__newNode_;
            @Child private InteropAccessNode isExecutableNode__isExecutable_;
            @Child private InteropAccessNode executeNode__execute_;
            @Child private InteropAccessNode hasArrayElementsNode__hasSize_;
            @Child private InteropAccessNode getArraySizeNode__getSize_;
            @Child private InteropAccessNode isPointerNode__isPointer_;
            @Child private InteropAccessNode asPointerNode__asPointer_;
            @CompilationFinal private BranchProfile asPointerNode__exception_;

            Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isBoolean(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b1) != 0 /* is-active isBoolean(TruffleObject, InteropAccessNode, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isBoolean(arg0Value, this.isBoxed, this.unbox);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isBooleanNode_AndSpecialize(arg0Value);
            }

            private boolean isBooleanNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_BOXED)));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    this.state_ = state = state | 0b1 /* add-active isBoolean(TruffleObject, InteropAccessNode, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isBoolean(arg0Value, this.isBoxed, this.unbox);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                long state = state_;
                if ((state & 0b1) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public boolean asBoolean(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b10) != 0 /* is-active asBoolean(TruffleObject, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.asBoolean(arg0Value, this.unbox);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asBooleanNode_AndSpecialize(arg0Value);
            }

            private boolean asBooleanNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    this.state_ = state = state | 0b10 /* add-active asBoolean(TruffleObject, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.asBoolean(arg0Value, this.unbox);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isString(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b100) != 0 /* is-active isString(TruffleObject, InteropAccessNode, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isString(arg0Value, this.isBoxed, this.unbox);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isStringNode_AndSpecialize(arg0Value);
            }

            private boolean isStringNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_BOXED)));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    this.state_ = state = state | 0b100 /* add-active isString(TruffleObject, InteropAccessNode, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isString(arg0Value, this.isBoxed, this.unbox);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public String asString(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b1000) != 0 /* is-active asString(TruffleObject, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.asString(arg0Value, this.unbox);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asStringNode_AndSpecialize(arg0Value);
            }

            private String asStringNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    this.state_ = state = state | 0b1000 /* add-active asString(TruffleObject, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.asString(arg0Value, this.unbox);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isNull(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b10000) != 0 /* is-active isNull(TruffleObject, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isNull(arg0Value, this.isNullNode__isNull_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isNullNode_AndSpecialize(arg0Value);
            }

            private boolean isNullNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.isNullNode__isNull_ = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_NULL)));
                    this.state_ = state = state | 0b10000 /* add-active isNull(TruffleObject, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isNull(arg0Value, this.isNullNode__isNull_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasMembers(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b100000) != 0 /* is-active hasMembers(TruffleObject, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.hasMembers(arg0Value, this.hasMembersNode__hasKeys_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasMembersNode_AndSpecialize(arg0Value);
            }

            private boolean hasMembersNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.hasMembersNode__hasKeys_ = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.HAS_KEYS)));
                    this.state_ = state = state | 0b100000 /* add-active hasMembers(TruffleObject, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.hasMembers(arg0Value, this.hasMembersNode__hasKeys_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b1000000) != 0 /* is-active readMember(TruffleObject, String, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.readMember(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.read == null) {
                        this.read = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.READ)));
                    }
                    this.state_ = state = state | 0b1000000 /* add-active readMember(TruffleObject, String, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.readMember(arg0Value, arg1Value, this.read);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b10000000) != 0 /* is-active isMemberReadable(TruffleObject, String, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isMemberReadable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEY_INFO)));
                    }
                    this.state_ = state = state | 0b10000000 /* add-active isMemberReadable(TruffleObject, String, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isMemberReadable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b100000000) != 0 /* is-active isMemberModifiable(TruffleObject, String, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isMemberModifiable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEY_INFO)));
                    }
                    this.state_ = state = state | 0b100000000 /* add-active isMemberModifiable(TruffleObject, String, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isMemberModifiable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b1000000000) != 0 /* is-active isMemberInsertable(TruffleObject, String, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isMemberInsertable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInsertableNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEY_INFO)));
                    }
                    this.state_ = state = state | 0b1000000000 /* add-active isMemberInsertable(TruffleObject, String, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isMemberInsertable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b10000000000) != 0 /* is-active isMemberRemovable(TruffleObject, String, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isMemberRemovable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberRemovableNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEY_INFO)));
                    }
                    this.state_ = state = state | 0b10000000000 /* add-active isMemberRemovable(TruffleObject, String, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isMemberRemovable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInternal(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b100000000000) != 0 /* is-active isMemberInternal(TruffleObject, String, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isMemberInternal(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInternalNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInternalNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEY_INFO)));
                    }
                    this.state_ = state = state | 0b100000000000 /* add-active isMemberInternal(TruffleObject, String, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isMemberInternal(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b1000000000000) != 0 /* is-active isMemberInvocable(TruffleObject, String, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isMemberInvocable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEY_INFO)));
                    }
                    this.state_ = state = state | 0b1000000000000 /* add-active isMemberInvocable(TruffleObject, String, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isMemberInvocable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b10000000000000) != 0 /* is-active hasMemberReadSideEffects(TruffleObject, String, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.hasMemberReadSideEffects(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasMemberReadSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean hasMemberReadSideEffectsNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEY_INFO)));
                    }
                    this.state_ = state = state | 0b10000000000000 /* add-active hasMemberReadSideEffects(TruffleObject, String, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.hasMemberReadSideEffects(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b100000000000000) != 0 /* is-active hasMemberWriteSideEffects(TruffleObject, String, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.hasMemberWriteSideEffects(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasMemberWriteSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean hasMemberWriteSideEffectsNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEY_INFO)));
                    }
                    this.state_ = state = state | 0b100000000000000 /* add-active hasMemberWriteSideEffects(TruffleObject, String, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.hasMemberWriteSideEffects(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b1000000000000000) != 0 /* is-active writeMember(TruffleObject, String, Object, InteropAccessNode) */) {
                    DefaultTruffleObjectExports.writeMember(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeMemberNode_AndSpecialize(TruffleObject arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.write == null) {
                        this.write = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.WRITE)));
                    }
                    this.state_ = state = state | 0b1000000000000000 /* add-active writeMember(TruffleObject, String, Object, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultTruffleObjectExports.writeMember(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x10000L) != 0 /* is-active removeMember(TruffleObject, String, InteropAccessNode) */) {
                    DefaultTruffleObjectExports.removeMember(arg0Value, arg1Value, this.remove);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                removeMemberNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void removeMemberNode_AndSpecialize(TruffleObject arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.remove == null) {
                        this.remove = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.REMOVE)));
                    }
                    this.state_ = state = state | 0x10000L /* add-active removeMember(TruffleObject, String, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultTruffleObjectExports.removeMember(arg0Value, arg1Value, this.remove);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x20000L) != 0 /* is-active getMembers(TruffleObject, boolean, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.getMembers(arg0Value, arg1Value, this.getMembersNode__keys_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getMembersNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object getMembersNode_AndSpecialize(TruffleObject arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.getMembersNode__keys_ = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEYS)));
                    this.state_ = state = state | 0x20000L /* add-active getMembers(TruffleObject, boolean, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.getMembers(arg0Value, arg1Value, this.getMembersNode__keys_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x40000L) != 0 /* is-active invokeMember(TruffleObject, String, Object[], InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.invokeMember(arg0Value, arg1Value, arg2Value, this.invokeMemberNode__invoke_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(TruffleObject arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.invokeMemberNode__invoke_ = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.INVOKE)));
                    this.state_ = state = state | 0x40000L /* add-active invokeMember(TruffleObject, String, Object[], InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.invokeMember(arg0Value, arg1Value, arg2Value, this.invokeMemberNode__invoke_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isInstantiable(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x80000L) != 0 /* is-active isInstantiable(TruffleObject, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isInstantiable(arg0Value, this.isInstantiableNode__isInstantiable_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isInstantiableNode_AndSpecialize(arg0Value);
            }

            private boolean isInstantiableNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.isInstantiableNode__isInstantiable_ = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_INSTANTIABLE)));
                    this.state_ = state = state | 0x80000L /* add-active isInstantiable(TruffleObject, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isInstantiable(arg0Value, this.isInstantiableNode__isInstantiable_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x100000L) != 0 /* is-active instantiate(TruffleObject, Object[], InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.instantiate(arg0Value, arg1Value, this.instantiateNode__newNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return instantiateNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object instantiateNode_AndSpecialize(TruffleObject arg0Value, Object[] arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.instantiateNode__newNode_ = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.NEW)));
                    this.state_ = state = state | 0x100000L /* add-active instantiate(TruffleObject, Object[], InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.instantiate(arg0Value, arg1Value, this.instantiateNode__newNode_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x200000L) != 0 /* is-active isExecutable(TruffleObject, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isExecutable(arg0Value, this.isExecutableNode__isExecutable_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isExecutableNode_AndSpecialize(arg0Value);
            }

            private boolean isExecutableNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.isExecutableNode__isExecutable_ = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_EXECUTABLE)));
                    this.state_ = state = state | 0x200000L /* add-active isExecutable(TruffleObject, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isExecutable(arg0Value, this.isExecutableNode__isExecutable_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x400000L) != 0 /* is-active execute(TruffleObject, Object[], InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.execute(arg0Value, arg1Value, this.executeNode__execute_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object executeNode_AndSpecialize(TruffleObject arg0Value, Object[] arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.executeNode__execute_ = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.EXECUTE)));
                    this.state_ = state = state | 0x400000L /* add-active execute(TruffleObject, Object[], InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.execute(arg0Value, arg1Value, this.executeNode__execute_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasArrayElements(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x800000L) != 0 /* is-active hasArrayElements(TruffleObject, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.hasArrayElements(arg0Value, this.hasArrayElementsNode__hasSize_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasArrayElementsNode_AndSpecialize(arg0Value);
            }

            private boolean hasArrayElementsNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.hasArrayElementsNode__hasSize_ = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.HAS_SIZE)));
                    this.state_ = state = state | 0x800000L /* add-active hasArrayElements(TruffleObject, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.hasArrayElements(arg0Value, this.hasArrayElementsNode__hasSize_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x1000000L) != 0 /* is-active isArrayElementReadable(TruffleObject, long, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isArrayElementReadable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementReadableNode_AndSpecialize(TruffleObject arg0Value, long arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEY_INFO)));
                    }
                    this.state_ = state = state | 0x1000000L /* add-active isArrayElementReadable(TruffleObject, long, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isArrayElementReadable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x2000000L) != 0 /* is-active isArrayElementModifiable(TruffleObject, long, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isArrayElementModifiable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementModifiableNode_AndSpecialize(TruffleObject arg0Value, long arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEY_INFO)));
                    }
                    this.state_ = state = state | 0x2000000L /* add-active isArrayElementModifiable(TruffleObject, long, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isArrayElementModifiable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x4000000L) != 0 /* is-active isArrayElementInsertable(TruffleObject, long, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isArrayElementInsertable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementInsertableNode_AndSpecialize(TruffleObject arg0Value, long arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEY_INFO)));
                    }
                    this.state_ = state = state | 0x4000000L /* add-active isArrayElementInsertable(TruffleObject, long, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isArrayElementInsertable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x8000000L) != 0 /* is-active isArrayElementRemovable(TruffleObject, long, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isArrayElementRemovable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementRemovableNode_AndSpecialize(TruffleObject arg0Value, long arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.KEY_INFO)));
                    }
                    this.state_ = state = state | 0x8000000L /* add-active isArrayElementRemovable(TruffleObject, long, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isArrayElementRemovable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x10000000L) != 0 /* is-active readArrayElement(TruffleObject, long, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.readArrayElement(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readArrayElementNode_AndSpecialize(TruffleObject arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.read == null) {
                        this.read = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.READ)));
                    }
                    this.state_ = state = state | 0x10000000L /* add-active readArrayElement(TruffleObject, long, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.readArrayElement(arg0Value, arg1Value, this.read);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x20000000L) != 0 /* is-active writeArrayElement(TruffleObject, long, Object, InteropAccessNode) */) {
                    DefaultTruffleObjectExports.writeArrayElement(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeArrayElementNode_AndSpecialize(TruffleObject arg0Value, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.write == null) {
                        this.write = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.WRITE)));
                    }
                    this.state_ = state = state | 0x20000000L /* add-active writeArrayElement(TruffleObject, long, Object, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultTruffleObjectExports.writeArrayElement(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x40000000L) != 0 /* is-active removeArrayElement(TruffleObject, long, InteropAccessNode) */) {
                    DefaultTruffleObjectExports.removeArrayElement(arg0Value, arg1Value, this.remove);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                removeArrayElementNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void removeArrayElementNode_AndSpecialize(TruffleObject arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.remove == null) {
                        this.remove = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.REMOVE)));
                    }
                    this.state_ = state = state | 0x40000000L /* add-active removeArrayElement(TruffleObject, long, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultTruffleObjectExports.removeArrayElement(arg0Value, arg1Value, this.remove);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x80000000L) != 0 /* is-active getArraySize(TruffleObject, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.getArraySize(arg0Value, this.getArraySizeNode__getSize_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getArraySizeNode_AndSpecialize(arg0Value);
            }

            private long getArraySizeNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.getArraySizeNode__getSize_ = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.GET_SIZE)));
                    this.state_ = state = state | 0x80000000L /* add-active getArraySize(TruffleObject, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.getArraySize(arg0Value, this.getArraySizeNode__getSize_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isPointer(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x100000000L) != 0 /* is-active isPointer(TruffleObject, InteropAccessNode) */) {
                    return DefaultTruffleObjectExports.isPointer(arg0Value, this.isPointerNode__isPointer_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isPointerNode_AndSpecialize(arg0Value);
            }

            private boolean isPointerNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.isPointerNode__isPointer_ = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_POINTER)));
                    this.state_ = state = state | 0x100000000L /* add-active isPointer(TruffleObject, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isPointer(arg0Value, this.isPointerNode__isPointer_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x200000000L) != 0 /* is-active asPointer(TruffleObject, InteropAccessNode, InteropAccessNode, BranchProfile) */) {
                    return DefaultTruffleObjectExports.asPointer(arg0Value, this.asPointerNode__asPointer_, this.toNative, this.asPointerNode__exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asPointerNode_AndSpecialize(arg0Value);
            }

            private long asPointerNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.asPointerNode__asPointer_ = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.AS_POINTER)));
                    if (this.toNative == null) {
                        this.toNative = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.TO_NATIVE)));
                    }
                    this.asPointerNode__exception_ = (BranchProfile.create());
                    this.state_ = state = state | 0x200000000L /* add-active asPointer(TruffleObject, InteropAccessNode, InteropAccessNode, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.asPointer(arg0Value, this.asPointerNode__asPointer_, this.toNative, this.asPointerNode__exception_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void toNative(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x400000000L) != 0 /* is-active toNative(TruffleObject, InteropAccessNode) */) {
                    DefaultTruffleObjectExports.toNative(arg0Value, this.toNative);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                toNativeNode_AndSpecialize(arg0Value);
                return;
            }

            private void toNativeNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.toNative == null) {
                        this.toNative = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.TO_NATIVE)));
                    }
                    this.state_ = state = state | 0x400000000L /* add-active toNative(TruffleObject, InteropAccessNode) */;
                    lock.unlock();
                    hasLock = false;
                    DefaultTruffleObjectExports.toNative(arg0Value, this.toNative);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isNumber(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x800000000L) != 0 /* is-active isNumber(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.isNumber(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isNumberNode_AndSpecialize(arg0Value);
            }

            private boolean isNumberNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_BOXED)));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x800000000L /* add-active isNumber(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.isNumber(arg0Value, this.isBoxed, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInByte(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x1000000000L) != 0 /* is-active fitsInByte(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.fitsInByte(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInByteNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInByteNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_BOXED)));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x1000000000L /* add-active fitsInByte(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.fitsInByte(arg0Value, this.isBoxed, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInShort(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x2000000000L) != 0 /* is-active fitsInShort(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.fitsInShort(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInShortNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInShortNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_BOXED)));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x2000000000L /* add-active fitsInShort(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.fitsInShort(arg0Value, this.isBoxed, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInInt(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x4000000000L) != 0 /* is-active fitsInInt(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.fitsInInt(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInIntNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInIntNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_BOXED)));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x4000000000L /* add-active fitsInInt(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.fitsInInt(arg0Value, this.isBoxed, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInLong(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x8000000000L) != 0 /* is-active fitsInLong(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.fitsInLong(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInLongNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInLongNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_BOXED)));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x8000000000L /* add-active fitsInLong(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.fitsInLong(arg0Value, this.isBoxed, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x10000000000L) != 0 /* is-active fitsInFloat(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.fitsInFloat(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInFloatNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInFloatNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_BOXED)));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x10000000000L /* add-active fitsInFloat(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.fitsInFloat(arg0Value, this.isBoxed, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInDouble(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x20000000000L) != 0 /* is-active fitsInDouble(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.fitsInDouble(arg0Value, this.isBoxed, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInDoubleNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInDoubleNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.isBoxed == null) {
                        this.isBoxed = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.IS_BOXED)));
                    }
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x20000000000L /* add-active fitsInDouble(TruffleObject, InteropAccessNode, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.fitsInDouble(arg0Value, this.isBoxed, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x40000000000L) != 0 /* is-active asByte(TruffleObject, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.asByte(arg0Value, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asByteNode_AndSpecialize(arg0Value);
            }

            private byte asByteNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x40000000000L /* add-active asByte(TruffleObject, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.asByte(arg0Value, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x80000000000L) != 0 /* is-active asShort(TruffleObject, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.asShort(arg0Value, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asShortNode_AndSpecialize(arg0Value);
            }

            private short asShortNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x80000000000L /* add-active asShort(TruffleObject, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.asShort(arg0Value, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x100000000000L) != 0 /* is-active asInt(TruffleObject, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.asInt(arg0Value, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asIntNode_AndSpecialize(arg0Value);
            }

            private int asIntNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x100000000000L /* add-active asInt(TruffleObject, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.asInt(arg0Value, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x200000000000L) != 0 /* is-active asLong(TruffleObject, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.asLong(arg0Value, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asLongNode_AndSpecialize(arg0Value);
            }

            private long asLongNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x200000000000L /* add-active asLong(TruffleObject, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.asLong(arg0Value, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x400000000000L) != 0 /* is-active asFloat(TruffleObject, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.asFloat(arg0Value, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asFloatNode_AndSpecialize(arg0Value);
            }

            private float asFloatNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x400000000000L /* add-active asFloat(TruffleObject, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.asFloat(arg0Value, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x800000000000L) != 0 /* is-active asDouble(TruffleObject, InteropAccessNode, InteropLibrary) */) {
                    return DefaultTruffleObjectExports.asDouble(arg0Value, this.unbox, this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asDoubleNode_AndSpecialize(arg0Value);
            }

            private double asDoubleNode_AndSpecialize(TruffleObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.unbox == null) {
                        this.unbox = super.insert((InteropAccessNode.create(com.oracle.truffle.api.interop.Message.UNBOX)));
                    }
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    this.state_ = state = state | 0x800000000000L /* add-active asDouble(TruffleObject, InteropAccessNode, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return DefaultTruffleObjectExports.asDouble(arg0Value, this.unbox, this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(DefaultTruffleObjectExports.class)
        private static final class Uncached extends InteropLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isBoolean(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isBoolean(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_BOXED)), (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)));
            }

            @TruffleBoundary
            @Override
            public boolean asBoolean(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.asBoolean(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)));
            }

            @TruffleBoundary
            @Override
            public boolean isString(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isString(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_BOXED)), (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)));
            }

            @TruffleBoundary
            @Override
            public String asString(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.asString(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)));
            }

            @TruffleBoundary
            @Override
            public boolean isNull(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isNull(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_NULL)));
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.hasMembers(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.HAS_KEYS)));
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.readMember(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.READ)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isMemberReadable(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEY_INFO)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isMemberModifiable(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEY_INFO)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isMemberInsertable(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEY_INFO)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isMemberRemovable(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEY_INFO)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInternal(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isMemberInternal(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEY_INFO)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isMemberInvocable(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEY_INFO)));
            }

            @TruffleBoundary
            @Override
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.hasMemberReadSideEffects(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEY_INFO)));
            }

            @TruffleBoundary
            @Override
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.hasMemberWriteSideEffects(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEY_INFO)));
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                DefaultTruffleObjectExports.writeMember(arg0Value, arg1Value, arg2Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.WRITE)));
                return;
            }

            @TruffleBoundary
            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                DefaultTruffleObjectExports.removeMember(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.REMOVE)));
                return;
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.getMembers(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEYS)));
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.invokeMember(arg0Value, arg1Value, arg2Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.INVOKE)));
            }

            @TruffleBoundary
            @Override
            public boolean isInstantiable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isInstantiable(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_INSTANTIABLE)));
            }

            @TruffleBoundary
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.instantiate(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.NEW)));
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isExecutable(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_EXECUTABLE)));
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.execute(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.EXECUTE)));
            }

            @TruffleBoundary
            @Override
            public boolean hasArrayElements(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.hasArrayElements(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.HAS_SIZE)));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isArrayElementReadable(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEY_INFO)));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isArrayElementModifiable(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEY_INFO)));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isArrayElementInsertable(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEY_INFO)));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isArrayElementRemovable(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.KEY_INFO)));
            }

            @TruffleBoundary
            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.readArrayElement(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.READ)));
            }

            @TruffleBoundary
            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                DefaultTruffleObjectExports.writeArrayElement(arg0Value, arg1Value, arg2Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.WRITE)));
                return;
            }

            @TruffleBoundary
            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                DefaultTruffleObjectExports.removeArrayElement(arg0Value, arg1Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.REMOVE)));
                return;
            }

            @TruffleBoundary
            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.getArraySize(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.GET_SIZE)));
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isPointer(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_POINTER)));
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.asPointer(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.AS_POINTER)), (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.TO_NATIVE)), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void toNative(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                DefaultTruffleObjectExports.toNative(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.TO_NATIVE)));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isNumber(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.isNumber(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_BOXED)), (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInByte(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.fitsInByte(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_BOXED)), (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInShort(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.fitsInShort(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_BOXED)), (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInInt(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.fitsInInt(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_BOXED)), (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInLong(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.fitsInLong(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_BOXED)), (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.fitsInFloat(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_BOXED)), (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInDouble(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.fitsInDouble(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.IS_BOXED)), (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.asByte(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.asShort(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.asInt(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.asLong(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.asFloat(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject) arg0Value_;
                return DefaultTruffleObjectExports.asDouble(arg0Value, (InteropAccessNode.getUncached(com.oracle.truffle.api.interop.Message.UNBOX)), (INTEROP_LIBRARY_.getUncached()));
            }

        }
    }
}
