// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.IntValueProfile;
import com.oracle.truffle.polyglot.PolyglotLanguageBindings;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PolyglotLanguageBindings.class)
final class PolyglotLanguageBindingsGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(PolyglotLanguageBindings.class, new InteropLibraryExports());
    }

    private PolyglotLanguageBindingsGen() {
    }

    @GeneratedBy(PolyglotLanguageBindings.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, PolyglotLanguageBindings.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof PolyglotLanguageBindings;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof PolyglotLanguageBindings;
            return new Cached();
        }

        @GeneratedBy(PolyglotLanguageBindings.class)
        private static final class Cached extends InteropLibrary {

            @CompilationFinal private int state_;
            @Child private InteropLibrary interop;
            @CompilationFinal private IntValueProfile lenghtProfile;

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PolyglotLanguageBindings) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.polyglot.PolyglotLanguageBindings'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PolyglotLanguageBindings;
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotLanguageBindings) receiver).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotLanguageBindings) receiver).getMembers(includeInternal);
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                int state = state_;
                if ((state & 0b1) != 0 /* is-active isMemberReadable(PolyglotLanguageBindings, String, InteropLibrary, IntValueProfile) */) {
                    return arg0Value.isMemberReadable(arg1Value, this.interop, this.lenghtProfile);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableNode_AndSpecialize(PolyglotLanguageBindings arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.interop == null) {
                        this.interop = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    if (this.lenghtProfile == null) {
                        this.lenghtProfile = (IntValueProfile.createIdentityProfile());
                    }
                    this.state_ = state = state | 0b1 /* add-active isMemberReadable(PolyglotLanguageBindings, String, InteropLibrary, IntValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.isMemberReadable(arg1Value, this.interop, this.lenghtProfile);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b1) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                int state = state_;
                if ((state & 0b10) != 0 /* is-active readMember(PolyglotLanguageBindings, String, InteropLibrary, IntValueProfile) */) {
                    return arg0Value.readMember(arg1Value, this.interop, this.lenghtProfile);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(PolyglotLanguageBindings arg0Value, String arg1Value) throws UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.interop == null) {
                        this.interop = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    if (this.lenghtProfile == null) {
                        this.lenghtProfile = (IntValueProfile.createIdentityProfile());
                    }
                    this.state_ = state = state | 0b10 /* add-active readMember(PolyglotLanguageBindings, String, InteropLibrary, IntValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.readMember(arg1Value, this.interop, this.lenghtProfile);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                int state = state_;
                if ((state & 0b100) != 0 /* is-active isMemberModifiable(PolyglotLanguageBindings, String, InteropLibrary, IntValueProfile) */) {
                    return arg0Value.isMemberModifiable(arg1Value, this.interop, this.lenghtProfile);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableNode_AndSpecialize(PolyglotLanguageBindings arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.interop == null) {
                        this.interop = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    if (this.lenghtProfile == null) {
                        this.lenghtProfile = (IntValueProfile.createIdentityProfile());
                    }
                    this.state_ = state = state | 0b100 /* add-active isMemberModifiable(PolyglotLanguageBindings, String, InteropLibrary, IntValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.isMemberModifiable(arg1Value, this.interop, this.lenghtProfile);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                int state = state_;
                if ((state & 0b1000) != 0 /* is-active isMemberInsertable(PolyglotLanguageBindings, String, InteropLibrary, IntValueProfile) */) {
                    return arg0Value.isMemberInsertable(arg1Value, this.interop, this.lenghtProfile);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInsertableNode_AndSpecialize(PolyglotLanguageBindings arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.interop == null) {
                        this.interop = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    if (this.lenghtProfile == null) {
                        this.lenghtProfile = (IntValueProfile.createIdentityProfile());
                    }
                    this.state_ = state = state | 0b1000 /* add-active isMemberInsertable(PolyglotLanguageBindings, String, InteropLibrary, IntValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.isMemberInsertable(arg1Value, this.interop, this.lenghtProfile);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                int state = state_;
                if ((state & 0b10000) != 0 /* is-active writeMember(PolyglotLanguageBindings, String, Object, InteropLibrary, IntValueProfile) */) {
                    arg0Value.writeMember(arg1Value, arg2Value, this.interop, this.lenghtProfile);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeMemberNode_AndSpecialize(PolyglotLanguageBindings arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.interop == null) {
                        this.interop = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    if (this.lenghtProfile == null) {
                        this.lenghtProfile = (IntValueProfile.createIdentityProfile());
                    }
                    this.state_ = state = state | 0b10000 /* add-active writeMember(PolyglotLanguageBindings, String, Object, InteropLibrary, IntValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writeMember(arg1Value, arg2Value, this.interop, this.lenghtProfile);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                int state = state_;
                if ((state & 0b100000) != 0 /* is-active removeMember(PolyglotLanguageBindings, String, InteropLibrary, IntValueProfile) */) {
                    arg0Value.removeMember(arg1Value, this.interop, this.lenghtProfile);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                removeMemberNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void removeMemberNode_AndSpecialize(PolyglotLanguageBindings arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.interop == null) {
                        this.interop = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    if (this.lenghtProfile == null) {
                        this.lenghtProfile = (IntValueProfile.createIdentityProfile());
                    }
                    this.state_ = state = state | 0b100000 /* add-active removeMember(PolyglotLanguageBindings, String, InteropLibrary, IntValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.removeMember(arg1Value, this.interop, this.lenghtProfile);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                int state = state_;
                if ((state & 0b1000000) != 0 /* is-active isMemberRemovable(PolyglotLanguageBindings, String, InteropLibrary, IntValueProfile) */) {
                    return arg0Value.isMemberRemovable(arg1Value, this.interop, this.lenghtProfile);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberRemovableNode_AndSpecialize(PolyglotLanguageBindings arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.interop == null) {
                        this.interop = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    }
                    if (this.lenghtProfile == null) {
                        this.lenghtProfile = (IntValueProfile.createIdentityProfile());
                    }
                    this.state_ = state = state | 0b1000000 /* add-active isMemberRemovable(PolyglotLanguageBindings, String, InteropLibrary, IntValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.isMemberRemovable(arg1Value, this.interop, this.lenghtProfile);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(PolyglotLanguageBindings.class)
        private static final class Uncached extends InteropLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PolyglotLanguageBindings) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.polyglot.PolyglotLanguageBindings'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PolyglotLanguageBindings;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotLanguageBindings) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotLanguageBindings) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                return arg0Value.isMemberReadable(arg1Value, (INTEROP_LIBRARY_.getUncached()), (IntValueProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                return arg0Value.readMember(arg1Value, (INTEROP_LIBRARY_.getUncached()), (IntValueProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                return arg0Value.isMemberModifiable(arg1Value, (INTEROP_LIBRARY_.getUncached()), (IntValueProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                return arg0Value.isMemberInsertable(arg1Value, (INTEROP_LIBRARY_.getUncached()), (IntValueProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached()), (IntValueProfile.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                arg0Value.removeMember(arg1Value, (INTEROP_LIBRARY_.getUncached()), (IntValueProfile.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotLanguageBindings arg0Value = (PolyglotLanguageBindings) arg0Value_;
                return arg0Value.isMemberRemovable(arg1Value, (INTEROP_LIBRARY_.getUncached()), (IntValueProfile.getUncached()));
            }

        }
    }
}
