// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageContext.ToGuestValueNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PolyglotLanguageContext.class)
final class PolyglotLanguageContextFactory {

    @GeneratedBy(ToGuestValueNode.class)
    static final class ToGuestValueNodeGen extends ToGuestValueNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private CachedData cached_cache;

        private ToGuestValueNodeGen() {
        }

        @ExplodeLoop
        @Override
        Object execute(PolyglotLanguageContext arg0Value, Object arg1Value) {
            int state = state_;
            if (state != 0 /* is-active doNull(PolyglotLanguageContext, Object) || doCached(PolyglotLanguageContext, Object, Class<>) || doUncached(PolyglotLanguageContext, Object) */) {
                if ((state & 0b1) != 0 /* is-active doNull(PolyglotLanguageContext, Object) */) {
                    if ((arg1Value == null)) {
                        return ToGuestValueNode.doNull(arg0Value, arg1Value);
                    }
                }
                if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Class<>) */ && (arg1Value != null)) {
                    CachedData s2_ = this.cached_cache;
                    while (s2_ != null) {
                        if ((arg1Value.getClass() == s2_.cachedReceiver_)) {
                            return ToGuestValueNode.doCached(arg0Value, arg1Value, s2_.cachedReceiver_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active doUncached(PolyglotLanguageContext, Object) */) {
                    return ToGuestValueNode.doUncached(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(PolyglotLanguageContext arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((arg1Value == null)) {
                    this.state_ = state = state | 0b1 /* add-active doNull(PolyglotLanguageContext, Object) */;
                    lock.unlock();
                    hasLock = false;
                    return ToGuestValueNode.doNull(arg0Value, arg1Value);
                }
                if ((exclude) == 0 /* is-not-excluded doCached(PolyglotLanguageContext, Object, Class<>) */ && (arg1Value != null)) {
                    int count2_ = 0;
                    CachedData s2_ = this.cached_cache;
                    if ((state & 0b10) != 0 /* is-active doCached(PolyglotLanguageContext, Object, Class<>) */) {
                        while (s2_ != null) {
                            if ((arg1Value.getClass() == s2_.cachedReceiver_)) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            Class<?> cachedReceiver__ = (arg1Value.getClass());
                            if ((arg1Value.getClass() == cachedReceiver__) && count2_ < (3)) {
                                s2_ = new CachedData(cached_cache);
                                s2_.cachedReceiver_ = cachedReceiver__;
                                this.cached_cache = s2_;
                                this.state_ = state = state | 0b10 /* add-active doCached(PolyglotLanguageContext, Object, Class<>) */;
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return ToGuestValueNode.doCached(arg0Value, arg1Value, s2_.cachedReceiver_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(PolyglotLanguageContext, Object, Class<>) */;
                this.cached_cache = null;
                state = state & 0xfffffffd /* remove-active doCached(PolyglotLanguageContext, Object, Class<>) */;
                this.state_ = state = state | 0b100 /* add-active doUncached(PolyglotLanguageContext, Object) */;
                lock.unlock();
                hasLock = false;
                return ToGuestValueNode.doUncached(arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s2_ = this.cached_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ToGuestValueNode create() {
            return new ToGuestValueNodeGen();
        }

        public static ToGuestValueNode getUncached() {
            return ToGuestValueNodeGen.UNCACHED;
        }

        @GeneratedBy(ToGuestValueNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal Class<?> cachedReceiver_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ToGuestValueNode.class)
        private static final class Uncached extends ToGuestValueNode {

            @TruffleBoundary
            @Override
            Object execute(PolyglotLanguageContext arg0Value, Object arg1Value) {
                if ((arg1Value == null)) {
                    return ToGuestValueNode.doNull(arg0Value, arg1Value);
                }
                return ToGuestValueNode.doUncached(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
