// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.TargetMappingNode;
import com.oracle.truffle.polyglot.ToHostNode;
import java.lang.reflect.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ToHostNode.class)
@SuppressWarnings("unused")
final class ToHostNodeGen extends ToHostNode {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @Child private Cached0Data cached0_cache;
    @Child private Cached1Data cached1_cache;
    @Child private TargetMappingNode generic_targetMapping_;
    @Child private InteropLibrary generic_interop_;

    private ToHostNodeGen() {
    }

    @ExplodeLoop
    @Override
    public Object execute(Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
        int state = state_;
        if (state != 0 /* is-active doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) || doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) || doGeneric(Object, Class<>, Type, PolyglotLanguageContext, boolean, TargetMappingNode, InteropLibrary) */) {
            if ((state & 0b1) != 0 /* is-active doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) */) {
                Cached0Data s1_ = this.cached0_cache;
                while (s1_ != null) {
                    if ((s1_.interop_.accepts(arg0Value)) && (arg1Value == s1_.cachedTargetType_)) {
                        return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.interop_, s1_.cachedTargetType_, s1_.primitiveTarget_, s1_.allowsImplementation_, s1_.targetMapping_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 0b10) != 0 /* is-active doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) */) {
                Cached1Data s2_ = this.cached1_cache;
                while (s2_ != null) {
                    if ((arg1Value == s2_.cachedTargetType_)) {
                        return this.cached1Boundary(state, s2_, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 0b100) != 0 /* is-active doGeneric(Object, Class<>, Type, PolyglotLanguageContext, boolean, TargetMappingNode, InteropLibrary) */) {
                return ToHostNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.generic_targetMapping_, this.generic_interop_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    @TruffleBoundary
    private Object cached1Boundary(int state, Cached1Data s2_, Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
        try {
            return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (INTEROP_LIBRARY_.getUncached(arg0Value)), s2_.cachedTargetType_, s2_.primitiveTarget_, s2_.allowsImplementation_, s2_.targetMapping_);
        } finally {
            NodeUtil.popEncapsulatingNode(prev_);
        }
    }

    private Object executeAndSpecialize(Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if (((exclude & 0b1)) == 0 /* is-not-excluded doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) */) {
                int count1_ = 0;
                Cached0Data s1_ = this.cached0_cache;
                if ((state & 0b1) != 0 /* is-active doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) */) {
                    while (s1_ != null) {
                        if ((s1_.interop_.accepts(arg0Value)) && (arg1Value == s1_.cachedTargetType_)) {
                            break;
                        }
                        s1_ = s1_.next_;
                        count1_++;
                    }
                }
                if (s1_ == null) {
                    // assert (s1_.interop_.accepts(arg0Value));
                    // assert (arg1Value == s1_.cachedTargetType_);
                    if (count1_ < (ToHostNode.LIMIT)) {
                        s1_ = super.insert(new Cached0Data(cached0_cache));
                        s1_.interop_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg0Value)));
                        s1_.cachedTargetType_ = (arg1Value);
                        s1_.primitiveTarget_ = (ToHostNode.isPrimitiveTarget(s1_.cachedTargetType_));
                        s1_.allowsImplementation_ = (ToHostNode.allowsImplementation(arg3Value, arg1Value));
                        s1_.targetMapping_ = s1_.insertAccessor((TargetMappingNode.create()));
                        this.cached0_cache = s1_;
                        this.state_ = state = state | 0b1 /* add-active doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) */;
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.interop_, s1_.cachedTargetType_, s1_.primitiveTarget_, s1_.allowsImplementation_, s1_.targetMapping_);
                }
            }
            if (((exclude & 0b10)) == 0 /* is-not-excluded doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) */) {
                {
                    Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                    try {
                        int count2_ = 0;
                        Cached1Data s2_ = this.cached1_cache;
                        if ((state & 0b10) != 0 /* is-active doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) */) {
                            while (s2_ != null) {
                                if ((arg1Value == s2_.cachedTargetType_)) {
                                    break;
                                }
                                s2_ = s2_.next_;
                                count2_++;
                            }
                        }
                        if (s2_ == null) {
                            // assert (arg1Value == s2_.cachedTargetType_);
                            if (count2_ < (ToHostNode.LIMIT)) {
                                s2_ = super.insert(new Cached1Data(cached1_cache));
                                s2_.cachedTargetType_ = (arg1Value);
                                s2_.primitiveTarget_ = (ToHostNode.isPrimitiveTarget(s2_.cachedTargetType_));
                                s2_.allowsImplementation_ = (ToHostNode.allowsImplementation(arg3Value, arg1Value));
                                s2_.targetMapping_ = s2_.insertAccessor((TargetMappingNode.create()));
                                this.cached1_cache = s2_;
                                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) */;
                                this.cached0_cache = null;
                                state = state & 0xfffffffe /* remove-active doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) */;
                                this.state_ = state = state | 0b10 /* add-active doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) */;
                            }
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (INTEROP_LIBRARY_.getUncached(arg0Value)), s2_.cachedTargetType_, s2_.primitiveTarget_, s2_.allowsImplementation_, s2_.targetMapping_);
                        }
                    } finally {
                        NodeUtil.popEncapsulatingNode(prev_);
                    }
                }
            }
            this.generic_targetMapping_ = super.insert((TargetMappingNode.create()));
            this.generic_interop_ = super.insert((INTEROP_LIBRARY_.createDispatched(0)));
            this.exclude_ = exclude = exclude | 0b11 /* add-excluded doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode), doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) */;
            this.cached0_cache = null;
            this.cached1_cache = null;
            state = state & 0xfffffffc /* remove-active doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode), doCached(Object, Class<>, Type, PolyglotLanguageContext, boolean, InteropLibrary, Class<>, boolean, boolean, TargetMappingNode) */;
            this.state_ = state = state | 0b100 /* add-active doGeneric(Object, Class<>, Type, PolyglotLanguageContext, boolean, TargetMappingNode, InteropLibrary) */;
            lock.unlock();
            hasLock = false;
            return ToHostNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.generic_targetMapping_, this.generic_interop_);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            Cached0Data s1_ = this.cached0_cache;
            Cached1Data s2_ = this.cached1_cache;
            if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToHostNode create() {
        return new ToHostNodeGen();
    }

    public static ToHostNode getUncached() {
        return ToHostNodeGen.UNCACHED;
    }

    @GeneratedBy(ToHostNode.class)
    private static final class Cached0Data extends Node {

        @Child Cached0Data next_;
        @Child InteropLibrary interop_;
        @CompilationFinal Class<?> cachedTargetType_;
        @CompilationFinal boolean primitiveTarget_;
        @CompilationFinal boolean allowsImplementation_;
        @Child TargetMappingNode targetMapping_;

        Cached0Data(Cached0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(ToHostNode.class)
    private static final class Cached1Data extends Node {

        @Child Cached1Data next_;
        @CompilationFinal Class<?> cachedTargetType_;
        @CompilationFinal boolean primitiveTarget_;
        @CompilationFinal boolean allowsImplementation_;
        @Child TargetMappingNode targetMapping_;

        Cached1Data(Cached1Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(ToHostNode.class)
    private static final class Uncached extends ToHostNode {

        @TruffleBoundary
        @Override
        public Object execute(Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
            return ToHostNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (TargetMappingNode.getUncached()), (INTEROP_LIBRARY_.getUncached()));
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
