/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.debug.ValueInteropList;
import com.oracle.truffle.api.debug.ValuePropertiesCollection;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Iterator;

public final class DebugScope {
    private final Scope scope;
    private final Iterator<Scope> iterator;
    private final DebuggerSession session;
    private final SuspendedEvent event;
    private final MaterializedFrame frame;
    private final RootNode root;
    private final LanguageInfo language;
    private DebugScope parent;
    private ValuePropertiesCollection variables;

    DebugScope(Scope scope, Iterator<Scope> iterator, DebuggerSession session, SuspendedEvent event, MaterializedFrame frame, RootNode root) {
        this(scope, iterator, session, event, frame, root, null);
    }

    DebugScope(Scope scope, Iterator<Scope> iterator, DebuggerSession session, LanguageInfo language) {
        this(scope, iterator, session, null, null, null, language);
    }

    private DebugScope(Scope scope, Iterator<Scope> iterator, DebuggerSession session, SuspendedEvent event, MaterializedFrame frame, RootNode root, LanguageInfo language) {
        this.scope = scope;
        this.iterator = iterator;
        this.session = session;
        this.event = event;
        this.frame = frame;
        this.root = root;
        this.language = language;
    }

    public String getName() {
        return this.scope.getName();
    }

    public DebugScope getParent() throws DebugException {
        this.verifyValidState();
        try {
            if (this.parent == null && this.iterator.hasNext()) {
                this.parent = new DebugScope(this.iterator.next(), this.iterator, this.session, this.event, this.frame, this.root, this.language);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.session, ex, this.language, null, true, null);
        }
        return this.parent;
    }

    public boolean isFunctionScope() {
        return this.root != null && this.root.equals(this.scope.getNode());
    }

    public SourceSection getSourceSection() throws DebugException {
        try {
            Node node = this.scope.getNode();
            if (node != null) {
                return this.session.resolveSection(node);
            }
            return null;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.session, ex, this.language, null, true, null);
        }
    }

    public Iterable<DebugValue> getArguments() throws DebugException {
        this.verifyValidState();
        try {
            Object argumentsObj = this.scope.getArguments();
            if (argumentsObj != null) {
                ValuePropertiesCollection properties = DebugValue.getProperties(argumentsObj, this.session, this.getLanguage(), this);
                if (properties != null) {
                    return properties;
                }
                if (ValueInteropList.INTEROP.hasArrayElements(argumentsObj)) {
                    return new ValueInteropList(this.session, this.getLanguage(), argumentsObj);
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.session, ex, this.language, null, true, null);
        }
        return null;
    }

    public DebugValue getReceiver() {
        this.verifyValidState();
        DebugValue.HeapValue receiverValue = null;
        try {
            Object receiver = this.scope.getReceiver();
            if (receiver != null) {
                receiverValue = new DebugValue.HeapValue(this.session, this.getLanguage(), this.scope.getReceiverName(), receiver);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.session, ex, this.language, null, true, null);
        }
        return receiverValue;
    }

    public DebugValue getRootInstance() {
        this.verifyValidState();
        DebugValue.HeapValue functionValue = null;
        try {
            Object function = this.scope.getRootInstance();
            if (function != null) {
                functionValue = new DebugValue.HeapValue(this.session, this.getLanguage(), this.root.getName(), function);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.session, ex, this.language, null, true, null);
        }
        return functionValue;
    }

    public Iterable<DebugValue> getDeclaredValues() throws DebugException {
        return this.getVariables();
    }

    public DebugValue getDeclaredValue(String name) throws DebugException {
        return this.getVariables().get(name);
    }

    private ValuePropertiesCollection getVariables() {
        this.verifyValidState();
        try {
            if (this.variables == null) {
                Object variablesObj = this.scope.getVariables();
                this.variables = DebugValue.getProperties(variablesObj, this.session, this.getLanguage(), this);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.session, ex, this.language, null, true, null);
        }
        return this.variables;
    }

    LanguageInfo getLanguage() {
        if (this.root != null) {
            return this.root.getLanguageInfo();
        }
        return this.language;
    }

    void verifyValidState() {
        if (this.event != null) {
            this.event.verifyValidState(false);
        }
    }
}

