// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.polyglot.HostFieldDesc;
import com.oracle.truffle.polyglot.HostMethodDesc;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.ToHostNode;
import com.oracle.truffle.polyglot.ToHostNodeGen;
import com.oracle.truffle.polyglot.HostObject.ArrayGet;
import com.oracle.truffle.polyglot.HostObject.ArraySet;
import com.oracle.truffle.polyglot.HostObject.IsArrayNode;
import com.oracle.truffle.polyglot.HostObject.IsListNode;
import com.oracle.truffle.polyglot.HostObject.LookupConstructorNode;
import com.oracle.truffle.polyglot.HostObject.LookupFieldNode;
import com.oracle.truffle.polyglot.HostObject.LookupFunctionalMethodNode;
import com.oracle.truffle.polyglot.HostObject.LookupInnerClassNode;
import com.oracle.truffle.polyglot.HostObject.LookupMethodNode;
import com.oracle.truffle.polyglot.HostObject.ReadFieldNode;
import com.oracle.truffle.polyglot.HostObject.WriteFieldNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContext.ToGuestValueNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContextFactory.ToGuestValueNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(HostObject.class)
final class HostObjectFactory {

    @GeneratedBy(ArraySet.class)
    static final class ArraySetNodeGen extends ArraySet {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;

        private ArraySetNodeGen() {
        }

        @Override
        protected void execute(Object arg0Value, int arg1Value, Object arg2Value) {
            int state = state_;
            if (state != 0 /* is-active doBoolean(boolean[], int, boolean) || doByte(byte[], int, byte) || doShort(short[], int, short) || doChar(char[], int, char) || doInt(int[], int, int) || doLong(long[], int, long) || doFloat(float[], int, float) || doDouble(double[], int, double) || doObject(Object[], int, Object) */) {
                if ((state & 0b1) != 0 /* is-active doBoolean(boolean[], int, boolean) */ && arg0Value instanceof boolean[]) {
                    boolean[] arg0Value_ = (boolean[]) arg0Value;
                    if (arg2Value instanceof Boolean) {
                        boolean arg2Value_ = (boolean) arg2Value;
                        ArraySet.doBoolean(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0b10) != 0 /* is-active doByte(byte[], int, byte) */ && arg0Value instanceof byte[]) {
                    byte[] arg0Value_ = (byte[]) arg0Value;
                    if (arg2Value instanceof Byte) {
                        byte arg2Value_ = (byte) arg2Value;
                        ArraySet.doByte(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0b100) != 0 /* is-active doShort(short[], int, short) */ && arg0Value instanceof short[]) {
                    short[] arg0Value_ = (short[]) arg0Value;
                    if (arg2Value instanceof Short) {
                        short arg2Value_ = (short) arg2Value;
                        ArraySet.doShort(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0b1000) != 0 /* is-active doChar(char[], int, char) */ && arg0Value instanceof char[]) {
                    char[] arg0Value_ = (char[]) arg0Value;
                    if (arg2Value instanceof Character) {
                        char arg2Value_ = (char) arg2Value;
                        ArraySet.doChar(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0b10000) != 0 /* is-active doInt(int[], int, int) */ && arg0Value instanceof int[]) {
                    int[] arg0Value_ = (int[]) arg0Value;
                    if (arg2Value instanceof Integer) {
                        int arg2Value_ = (int) arg2Value;
                        ArraySet.doInt(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0b100000) != 0 /* is-active doLong(long[], int, long) */ && arg0Value instanceof long[]) {
                    long[] arg0Value_ = (long[]) arg0Value;
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (long) arg2Value;
                        ArraySet.doLong(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0b1000000) != 0 /* is-active doFloat(float[], int, float) */ && arg0Value instanceof float[]) {
                    float[] arg0Value_ = (float[]) arg0Value;
                    if (arg2Value instanceof Float) {
                        float arg2Value_ = (float) arg2Value;
                        ArraySet.doFloat(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0b10000000) != 0 /* is-active doDouble(double[], int, double) */ && arg0Value instanceof double[]) {
                    double[] arg0Value_ = (double[]) arg0Value;
                    if (arg2Value instanceof Double) {
                        double arg2Value_ = (double) arg2Value;
                        ArraySet.doDouble(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if ((state & 0b100000000) != 0 /* is-active doObject(Object[], int, Object) */ && arg0Value instanceof Object[]) {
                    Object[] arg0Value_ = (Object[]) arg0Value;
                    ArraySet.doObject(arg0Value_, arg1Value, arg2Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            return;
        }

        private void executeAndSpecialize(Object arg0Value, int arg1Value, Object arg2Value) {
            int state = state_;
            if (arg0Value instanceof boolean[]) {
                boolean[] arg0Value_ = (boolean[]) arg0Value;
                if (arg2Value instanceof Boolean) {
                    boolean arg2Value_ = (boolean) arg2Value;
                    this.state_ = state = state | 0b1 /* add-active doBoolean(boolean[], int, boolean) */;
                    ArraySet.doBoolean(arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof byte[]) {
                byte[] arg0Value_ = (byte[]) arg0Value;
                if (arg2Value instanceof Byte) {
                    byte arg2Value_ = (byte) arg2Value;
                    this.state_ = state = state | 0b10 /* add-active doByte(byte[], int, byte) */;
                    ArraySet.doByte(arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof short[]) {
                short[] arg0Value_ = (short[]) arg0Value;
                if (arg2Value instanceof Short) {
                    short arg2Value_ = (short) arg2Value;
                    this.state_ = state = state | 0b100 /* add-active doShort(short[], int, short) */;
                    ArraySet.doShort(arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof char[]) {
                char[] arg0Value_ = (char[]) arg0Value;
                if (arg2Value instanceof Character) {
                    char arg2Value_ = (char) arg2Value;
                    this.state_ = state = state | 0b1000 /* add-active doChar(char[], int, char) */;
                    ArraySet.doChar(arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof int[]) {
                int[] arg0Value_ = (int[]) arg0Value;
                if (arg2Value instanceof Integer) {
                    int arg2Value_ = (int) arg2Value;
                    this.state_ = state = state | 0b10000 /* add-active doInt(int[], int, int) */;
                    ArraySet.doInt(arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof long[]) {
                long[] arg0Value_ = (long[]) arg0Value;
                if (arg2Value instanceof Long) {
                    long arg2Value_ = (long) arg2Value;
                    this.state_ = state = state | 0b100000 /* add-active doLong(long[], int, long) */;
                    ArraySet.doLong(arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof float[]) {
                float[] arg0Value_ = (float[]) arg0Value;
                if (arg2Value instanceof Float) {
                    float arg2Value_ = (float) arg2Value;
                    this.state_ = state = state | 0b1000000 /* add-active doFloat(float[], int, float) */;
                    ArraySet.doFloat(arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof double[]) {
                double[] arg0Value_ = (double[]) arg0Value;
                if (arg2Value instanceof Double) {
                    double arg2Value_ = (double) arg2Value;
                    this.state_ = state = state | 0b10000000 /* add-active doDouble(double[], int, double) */;
                    ArraySet.doDouble(arg0Value_, arg1Value, arg2Value_);
                    return;
                }
            }
            if (arg0Value instanceof Object[]) {
                Object[] arg0Value_ = (Object[]) arg0Value;
                this.state_ = state = state | 0b100000000 /* add-active doObject(Object[], int, Object) */;
                ArraySet.doObject(arg0Value_, arg1Value, arg2Value);
                return;
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ArraySet create() {
            return new ArraySetNodeGen();
        }

        public static ArraySet getUncached() {
            return ArraySetNodeGen.UNCACHED;
        }

        @GeneratedBy(ArraySet.class)
        private static final class Uncached extends ArraySet {

            @TruffleBoundary
            @Override
            protected void execute(Object arg0Value, int arg1Value, Object arg2Value) {
                if (arg0Value instanceof boolean[]) {
                    boolean[] arg0Value_ = (boolean[]) arg0Value;
                    if (arg2Value instanceof Boolean) {
                        boolean arg2Value_ = (boolean) arg2Value;
                        ArraySet.doBoolean(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof byte[]) {
                    byte[] arg0Value_ = (byte[]) arg0Value;
                    if (arg2Value instanceof Byte) {
                        byte arg2Value_ = (byte) arg2Value;
                        ArraySet.doByte(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof short[]) {
                    short[] arg0Value_ = (short[]) arg0Value;
                    if (arg2Value instanceof Short) {
                        short arg2Value_ = (short) arg2Value;
                        ArraySet.doShort(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof char[]) {
                    char[] arg0Value_ = (char[]) arg0Value;
                    if (arg2Value instanceof Character) {
                        char arg2Value_ = (char) arg2Value;
                        ArraySet.doChar(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof int[]) {
                    int[] arg0Value_ = (int[]) arg0Value;
                    if (arg2Value instanceof Integer) {
                        int arg2Value_ = (int) arg2Value;
                        ArraySet.doInt(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof long[]) {
                    long[] arg0Value_ = (long[]) arg0Value;
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (long) arg2Value;
                        ArraySet.doLong(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof float[]) {
                    float[] arg0Value_ = (float[]) arg0Value;
                    if (arg2Value instanceof Float) {
                        float arg2Value_ = (float) arg2Value;
                        ArraySet.doFloat(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof double[]) {
                    double[] arg0Value_ = (double[]) arg0Value;
                    if (arg2Value instanceof Double) {
                        double arg2Value_ = (double) arg2Value;
                        ArraySet.doDouble(arg0Value_, arg1Value, arg2Value_);
                        return;
                    }
                }
                if (arg0Value instanceof Object[]) {
                    Object[] arg0Value_ = (Object[]) arg0Value;
                    ArraySet.doObject(arg0Value_, arg1Value, arg2Value);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ArrayGet.class)
    static final class ArrayGetNodeGen extends ArrayGet {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;

        private ArrayGetNodeGen() {
        }

        @Override
        protected Object execute(Object arg0Value, int arg1Value) {
            int state = state_;
            if (state != 0 /* is-active doBoolean(boolean[], int) || doByte(byte[], int) || doShort(short[], int) || doChar(char[], int) || doInt(int[], int) || doLong(long[], int) || doFloat(float[], int) || doDouble(double[], int) || doObject(Object[], int) */) {
                if ((state & 0b1) != 0 /* is-active doBoolean(boolean[], int) */ && arg0Value instanceof boolean[]) {
                    boolean[] arg0Value_ = (boolean[]) arg0Value;
                    return ArrayGet.doBoolean(arg0Value_, arg1Value);
                }
                if ((state & 0b10) != 0 /* is-active doByte(byte[], int) */ && arg0Value instanceof byte[]) {
                    byte[] arg0Value_ = (byte[]) arg0Value;
                    return ArrayGet.doByte(arg0Value_, arg1Value);
                }
                if ((state & 0b100) != 0 /* is-active doShort(short[], int) */ && arg0Value instanceof short[]) {
                    short[] arg0Value_ = (short[]) arg0Value;
                    return ArrayGet.doShort(arg0Value_, arg1Value);
                }
                if ((state & 0b1000) != 0 /* is-active doChar(char[], int) */ && arg0Value instanceof char[]) {
                    char[] arg0Value_ = (char[]) arg0Value;
                    return ArrayGet.doChar(arg0Value_, arg1Value);
                }
                if ((state & 0b10000) != 0 /* is-active doInt(int[], int) */ && arg0Value instanceof int[]) {
                    int[] arg0Value_ = (int[]) arg0Value;
                    return ArrayGet.doInt(arg0Value_, arg1Value);
                }
                if ((state & 0b100000) != 0 /* is-active doLong(long[], int) */ && arg0Value instanceof long[]) {
                    long[] arg0Value_ = (long[]) arg0Value;
                    return ArrayGet.doLong(arg0Value_, arg1Value);
                }
                if ((state & 0b1000000) != 0 /* is-active doFloat(float[], int) */ && arg0Value instanceof float[]) {
                    float[] arg0Value_ = (float[]) arg0Value;
                    return ArrayGet.doFloat(arg0Value_, arg1Value);
                }
                if ((state & 0b10000000) != 0 /* is-active doDouble(double[], int) */ && arg0Value instanceof double[]) {
                    double[] arg0Value_ = (double[]) arg0Value;
                    return ArrayGet.doDouble(arg0Value_, arg1Value);
                }
                if ((state & 0b100000000) != 0 /* is-active doObject(Object[], int) */ && arg0Value instanceof Object[]) {
                    Object[] arg0Value_ = (Object[]) arg0Value;
                    return ArrayGet.doObject(arg0Value_, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, int arg1Value) {
            int state = state_;
            if (arg0Value instanceof boolean[]) {
                boolean[] arg0Value_ = (boolean[]) arg0Value;
                this.state_ = state = state | 0b1 /* add-active doBoolean(boolean[], int) */;
                return ArrayGet.doBoolean(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof byte[]) {
                byte[] arg0Value_ = (byte[]) arg0Value;
                this.state_ = state = state | 0b10 /* add-active doByte(byte[], int) */;
                return ArrayGet.doByte(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof short[]) {
                short[] arg0Value_ = (short[]) arg0Value;
                this.state_ = state = state | 0b100 /* add-active doShort(short[], int) */;
                return ArrayGet.doShort(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof char[]) {
                char[] arg0Value_ = (char[]) arg0Value;
                this.state_ = state = state | 0b1000 /* add-active doChar(char[], int) */;
                return ArrayGet.doChar(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof int[]) {
                int[] arg0Value_ = (int[]) arg0Value;
                this.state_ = state = state | 0b10000 /* add-active doInt(int[], int) */;
                return ArrayGet.doInt(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof long[]) {
                long[] arg0Value_ = (long[]) arg0Value;
                this.state_ = state = state | 0b100000 /* add-active doLong(long[], int) */;
                return ArrayGet.doLong(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof float[]) {
                float[] arg0Value_ = (float[]) arg0Value;
                this.state_ = state = state | 0b1000000 /* add-active doFloat(float[], int) */;
                return ArrayGet.doFloat(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof double[]) {
                double[] arg0Value_ = (double[]) arg0Value;
                this.state_ = state = state | 0b10000000 /* add-active doDouble(double[], int) */;
                return ArrayGet.doDouble(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof Object[]) {
                Object[] arg0Value_ = (Object[]) arg0Value;
                this.state_ = state = state | 0b100000000 /* add-active doObject(Object[], int) */;
                return ArrayGet.doObject(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ArrayGet create() {
            return new ArrayGetNodeGen();
        }

        public static ArrayGet getUncached() {
            return ArrayGetNodeGen.UNCACHED;
        }

        @GeneratedBy(ArrayGet.class)
        private static final class Uncached extends ArrayGet {

            @TruffleBoundary
            @Override
            protected Object execute(Object arg0Value, int arg1Value) {
                if (arg0Value instanceof boolean[]) {
                    boolean[] arg0Value_ = (boolean[]) arg0Value;
                    return ArrayGet.doBoolean(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof byte[]) {
                    byte[] arg0Value_ = (byte[]) arg0Value;
                    return ArrayGet.doByte(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof short[]) {
                    short[] arg0Value_ = (short[]) arg0Value;
                    return ArrayGet.doShort(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof char[]) {
                    char[] arg0Value_ = (char[]) arg0Value;
                    return ArrayGet.doChar(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof int[]) {
                    int[] arg0Value_ = (int[]) arg0Value;
                    return ArrayGet.doInt(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof long[]) {
                    long[] arg0Value_ = (long[]) arg0Value;
                    return ArrayGet.doLong(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof float[]) {
                    float[] arg0Value_ = (float[]) arg0Value;
                    return ArrayGet.doFloat(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof double[]) {
                    double[] arg0Value_ = (double[]) arg0Value;
                    return ArrayGet.doDouble(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof Object[]) {
                    Object[] arg0Value_ = (Object[]) arg0Value;
                    return ArrayGet.doObject(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(LookupConstructorNode.class)
    static final class LookupConstructorNodeGen extends LookupConstructorNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private CachedData cached_cache;

        private LookupConstructorNodeGen() {
        }

        @ExplodeLoop
        @Override
        public HostMethodDesc execute(HostObject arg0Value, Class<?> arg1Value) {
            int state = state_;
            if (state != 0 /* is-active doCached(HostObject, Class<>, Class<>, HostMethodDesc) || doUncached(HostObject, Class<>) */) {
                if ((state & 0b1) != 0 /* is-active doCached(HostObject, Class<>, Class<>, HostMethodDesc) */) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((arg1Value == s1_.cachedClazz_)) {
                            return doCached(arg0Value, arg1Value, s1_.cachedClazz_, s1_.cachedMethod_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncached(HostObject, Class<>) */) {
                    return doUncached(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private HostMethodDesc executeAndSpecialize(HostObject arg0Value, Class<?> arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded doCached(HostObject, Class<>, Class<>, HostMethodDesc) */) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 0b1) != 0 /* is-active doCached(HostObject, Class<>, Class<>, HostMethodDesc) */) {
                        while (s1_ != null) {
                            if ((arg1Value == s1_.cachedClazz_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg1Value == s1_.cachedClazz_);
                        if (count1_ < (LookupConstructorNode.LIMIT)) {
                            s1_ = new CachedData(cached_cache);
                            s1_.cachedClazz_ = (arg1Value);
                            s1_.cachedMethod_ = (doUncached(arg0Value, arg1Value));
                            this.cached_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active doCached(HostObject, Class<>, Class<>, HostMethodDesc) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doCached(arg0Value, arg1Value, s1_.cachedClazz_, s1_.cachedMethod_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(HostObject, Class<>, Class<>, HostMethodDesc) */;
                this.cached_cache = null;
                state = state & 0xfffffffe /* remove-active doCached(HostObject, Class<>, Class<>, HostMethodDesc) */;
                this.state_ = state = state | 0b10 /* add-active doUncached(HostObject, Class<>) */;
                lock.unlock();
                hasLock = false;
                return doUncached(arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LookupConstructorNode create() {
            return new LookupConstructorNodeGen();
        }

        public static LookupConstructorNode getUncached() {
            return LookupConstructorNodeGen.UNCACHED;
        }

        @GeneratedBy(LookupConstructorNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal Class<?> cachedClazz_;
            @CompilationFinal HostMethodDesc cachedMethod_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(LookupConstructorNode.class)
        private static final class Uncached extends LookupConstructorNode {

            @TruffleBoundary
            @Override
            public HostMethodDesc execute(HostObject arg0Value, Class<?> arg1Value) {
                return doUncached(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(LookupFieldNode.class)
    static final class LookupFieldNodeGen extends LookupFieldNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private CachedData cached_cache;

        private LookupFieldNodeGen() {
        }

        @ExplodeLoop
        @Override
        public HostFieldDesc execute(HostObject arg0Value, Class<?> arg1Value, String arg2Value, boolean arg3Value) {
            int state = state_;
            if (state != 0 /* is-active doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostFieldDesc) || doUncached(HostObject, Class<>, String, boolean) */) {
                if ((state & 0b1) != 0 /* is-active doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostFieldDesc) */) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((arg3Value == s1_.cachedStatic_) && (arg1Value == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg2Value))) {
                            return doCached(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedField_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncached(HostObject, Class<>, String, boolean) */) {
                    return doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private HostFieldDesc executeAndSpecialize(HostObject arg0Value, Class<?> arg1Value, String arg2Value, boolean arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostFieldDesc) */) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 0b1) != 0 /* is-active doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostFieldDesc) */) {
                        while (s1_ != null) {
                            if ((arg3Value == s1_.cachedStatic_) && (arg1Value == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg2Value))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg3Value == s1_.cachedStatic_);
                        // assert (arg1Value == s1_.cachedClazz_);
                        // assert (s1_.cachedName_.equals(arg2Value));
                        if (count1_ < (LookupFieldNode.LIMIT)) {
                            s1_ = new CachedData(cached_cache);
                            s1_.cachedStatic_ = (arg3Value);
                            s1_.cachedClazz_ = (arg1Value);
                            s1_.cachedName_ = (arg2Value);
                            s1_.cachedField_ = (doUncached(arg0Value, arg1Value, arg2Value, arg3Value));
                            this.cached_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostFieldDesc) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doCached(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedField_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostFieldDesc) */;
                this.cached_cache = null;
                state = state & 0xfffffffe /* remove-active doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostFieldDesc) */;
                this.state_ = state = state | 0b10 /* add-active doUncached(HostObject, Class<>, String, boolean) */;
                lock.unlock();
                hasLock = false;
                return doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LookupFieldNode create() {
            return new LookupFieldNodeGen();
        }

        public static LookupFieldNode getUncached() {
            return LookupFieldNodeGen.UNCACHED;
        }

        @GeneratedBy(LookupFieldNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal boolean cachedStatic_;
            @CompilationFinal Class<?> cachedClazz_;
            @CompilationFinal String cachedName_;
            @CompilationFinal HostFieldDesc cachedField_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(LookupFieldNode.class)
        private static final class Uncached extends LookupFieldNode {

            @TruffleBoundary
            @Override
            public HostFieldDesc execute(HostObject arg0Value, Class<?> arg1Value, String arg2Value, boolean arg3Value) {
                return doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(LookupFunctionalMethodNode.class)
    static final class LookupFunctionalMethodNodeGen extends LookupFunctionalMethodNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private CachedData cached_cache;

        private LookupFunctionalMethodNodeGen() {
        }

        @ExplodeLoop
        @Override
        public HostMethodDesc execute(HostObject arg0Value, Class<?> arg1Value) {
            int state = state_;
            if (state != 0 /* is-active doCached(HostObject, Class<>, Class<>, HostMethodDesc) || doUncached(HostObject, Class<>) */) {
                if ((state & 0b1) != 0 /* is-active doCached(HostObject, Class<>, Class<>, HostMethodDesc) */) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((arg1Value == s1_.cachedClazz_)) {
                            return doCached(arg0Value, arg1Value, s1_.cachedClazz_, s1_.cachedMethod_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncached(HostObject, Class<>) */) {
                    return LookupFunctionalMethodNode.doUncached(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private HostMethodDesc executeAndSpecialize(HostObject arg0Value, Class<?> arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded doCached(HostObject, Class<>, Class<>, HostMethodDesc) */) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 0b1) != 0 /* is-active doCached(HostObject, Class<>, Class<>, HostMethodDesc) */) {
                        while (s1_ != null) {
                            if ((arg1Value == s1_.cachedClazz_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg1Value == s1_.cachedClazz_);
                        if (count1_ < (LookupFunctionalMethodNode.LIMIT)) {
                            s1_ = new CachedData(cached_cache);
                            s1_.cachedClazz_ = (arg1Value);
                            s1_.cachedMethod_ = (LookupFunctionalMethodNode.doUncached(arg0Value, arg1Value));
                            this.cached_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active doCached(HostObject, Class<>, Class<>, HostMethodDesc) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doCached(arg0Value, arg1Value, s1_.cachedClazz_, s1_.cachedMethod_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(HostObject, Class<>, Class<>, HostMethodDesc) */;
                this.cached_cache = null;
                state = state & 0xfffffffe /* remove-active doCached(HostObject, Class<>, Class<>, HostMethodDesc) */;
                this.state_ = state = state | 0b10 /* add-active doUncached(HostObject, Class<>) */;
                lock.unlock();
                hasLock = false;
                return LookupFunctionalMethodNode.doUncached(arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LookupFunctionalMethodNode create() {
            return new LookupFunctionalMethodNodeGen();
        }

        public static LookupFunctionalMethodNode getUncached() {
            return LookupFunctionalMethodNodeGen.UNCACHED;
        }

        @GeneratedBy(LookupFunctionalMethodNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal Class<?> cachedClazz_;
            @CompilationFinal HostMethodDesc cachedMethod_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(LookupFunctionalMethodNode.class)
        private static final class Uncached extends LookupFunctionalMethodNode {

            @TruffleBoundary
            @Override
            public HostMethodDesc execute(HostObject arg0Value, Class<?> arg1Value) {
                return LookupFunctionalMethodNode.doUncached(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(LookupInnerClassNode.class)
    static final class LookupInnerClassNodeGen extends LookupInnerClassNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private CachedData cached_cache;

        private LookupInnerClassNodeGen() {
        }

        @ExplodeLoop
        @Override
        public Class<?> execute(Class<?> arg0Value, String arg1Value) {
            int state = state_;
            if (state != 0 /* is-active doCached(Class<>, String, Class<>, String, Class<>) || doUncached(Class<>, String) */) {
                if ((state & 0b1) != 0 /* is-active doCached(Class<>, String, Class<>, String, Class<>) */) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg1Value))) {
                            return doCached(arg0Value, arg1Value, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedInnerClass_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncached(Class<>, String) */) {
                    return doUncached(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Class<?> executeAndSpecialize(Class<?> arg0Value, String arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded doCached(Class<>, String, Class<>, String, Class<>) */) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 0b1) != 0 /* is-active doCached(Class<>, String, Class<>, String, Class<>) */) {
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg1Value))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg0Value == s1_.cachedClazz_);
                        // assert (s1_.cachedName_.equals(arg1Value));
                        if (count1_ < (LookupInnerClassNode.LIMIT)) {
                            s1_ = new CachedData(cached_cache);
                            s1_.cachedClazz_ = (arg0Value);
                            s1_.cachedName_ = (arg1Value);
                            s1_.cachedInnerClass_ = (doUncached(arg0Value, arg1Value));
                            this.cached_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active doCached(Class<>, String, Class<>, String, Class<>) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doCached(arg0Value, arg1Value, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedInnerClass_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(Class<>, String, Class<>, String, Class<>) */;
                this.cached_cache = null;
                state = state & 0xfffffffe /* remove-active doCached(Class<>, String, Class<>, String, Class<>) */;
                this.state_ = state = state | 0b10 /* add-active doUncached(Class<>, String) */;
                lock.unlock();
                hasLock = false;
                return doUncached(arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LookupInnerClassNode create() {
            return new LookupInnerClassNodeGen();
        }

        public static LookupInnerClassNode getUncached() {
            return LookupInnerClassNodeGen.UNCACHED;
        }

        @GeneratedBy(LookupInnerClassNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal Class<?> cachedClazz_;
            @CompilationFinal String cachedName_;
            @CompilationFinal Class<?> cachedInnerClass_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(LookupInnerClassNode.class)
        private static final class Uncached extends LookupInnerClassNode {

            @TruffleBoundary
            @Override
            public Class<?> execute(Class<?> arg0Value, String arg1Value) {
                return doUncached(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(LookupMethodNode.class)
    static final class LookupMethodNodeGen extends LookupMethodNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private CachedData cached_cache;

        private LookupMethodNodeGen() {
        }

        @ExplodeLoop
        @Override
        public HostMethodDesc execute(HostObject arg0Value, Class<?> arg1Value, String arg2Value, boolean arg3Value) {
            int state = state_;
            if (state != 0 /* is-active doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostMethodDesc) || doUncached(HostObject, Class<>, String, boolean) */) {
                if ((state & 0b1) != 0 /* is-active doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostMethodDesc) */) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((arg3Value == s1_.cachedStatic_) && (arg1Value == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg2Value))) {
                            return doCached(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedMethod_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncached(HostObject, Class<>, String, boolean) */) {
                    return doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private HostMethodDesc executeAndSpecialize(HostObject arg0Value, Class<?> arg1Value, String arg2Value, boolean arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostMethodDesc) */) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 0b1) != 0 /* is-active doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostMethodDesc) */) {
                        while (s1_ != null) {
                            if ((arg3Value == s1_.cachedStatic_) && (arg1Value == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg2Value))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg3Value == s1_.cachedStatic_);
                        // assert (arg1Value == s1_.cachedClazz_);
                        // assert (s1_.cachedName_.equals(arg2Value));
                        if (count1_ < (LookupMethodNode.LIMIT)) {
                            s1_ = new CachedData(cached_cache);
                            s1_.cachedStatic_ = (arg3Value);
                            s1_.cachedClazz_ = (arg1Value);
                            s1_.cachedName_ = (arg2Value);
                            s1_.cachedMethod_ = (doUncached(arg0Value, arg1Value, arg2Value, arg3Value));
                            this.cached_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostMethodDesc) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doCached(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedMethod_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostMethodDesc) */;
                this.cached_cache = null;
                state = state & 0xfffffffe /* remove-active doCached(HostObject, Class<>, String, boolean, boolean, Class<>, String, HostMethodDesc) */;
                this.state_ = state = state | 0b10 /* add-active doUncached(HostObject, Class<>, String, boolean) */;
                lock.unlock();
                hasLock = false;
                return doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LookupMethodNode create() {
            return new LookupMethodNodeGen();
        }

        public static LookupMethodNode getUncached() {
            return LookupMethodNodeGen.UNCACHED;
        }

        @GeneratedBy(LookupMethodNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal boolean cachedStatic_;
            @CompilationFinal Class<?> cachedClazz_;
            @CompilationFinal String cachedName_;
            @CompilationFinal HostMethodDesc cachedMethod_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(LookupMethodNode.class)
        private static final class Uncached extends LookupMethodNode {

            @TruffleBoundary
            @Override
            public HostMethodDesc execute(HostObject arg0Value, Class<?> arg1Value, String arg2Value, boolean arg3Value) {
                return doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ReadFieldNode.class)
    static final class ReadFieldNodeGen extends ReadFieldNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @Child private CachedData cached_cache;
        @Child private ToGuestValueNode uncached_toGuest_;

        private ReadFieldNodeGen() {
        }

        @ExplodeLoop
        @Override
        public Object execute(HostFieldDesc arg0Value, HostObject arg1Value) {
            int state = state_;
            if (state != 0 /* is-active doCached(HostFieldDesc, HostObject, HostFieldDesc, ToGuestValueNode) || doUncached(HostFieldDesc, HostObject, ToGuestValueNode) */) {
                if ((state & 0b1) != 0 /* is-active doCached(HostFieldDesc, HostObject, HostFieldDesc, ToGuestValueNode) */) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedField_)) {
                            return ReadFieldNode.doCached(arg0Value, arg1Value, s1_.cachedField_, s1_.toGuest_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncached(HostFieldDesc, HostObject, ToGuestValueNode) */) {
                    return ReadFieldNode.doUncached(arg0Value, arg1Value, this.uncached_toGuest_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(HostFieldDesc arg0Value, HostObject arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded doCached(HostFieldDesc, HostObject, HostFieldDesc, ToGuestValueNode) */) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 0b1) != 0 /* is-active doCached(HostFieldDesc, HostObject, HostFieldDesc, ToGuestValueNode) */) {
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedField_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg0Value == s1_.cachedField_);
                        if (count1_ < (ReadFieldNode.LIMIT)) {
                            s1_ = super.insert(new CachedData(cached_cache));
                            s1_.cachedField_ = (arg0Value);
                            s1_.toGuest_ = s1_.insertAccessor((ToGuestValueNodeGen.create()));
                            this.cached_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active doCached(HostFieldDesc, HostObject, HostFieldDesc, ToGuestValueNode) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return ReadFieldNode.doCached(arg0Value, arg1Value, s1_.cachedField_, s1_.toGuest_);
                    }
                }
                this.uncached_toGuest_ = super.insert((ToGuestValueNodeGen.create()));
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(HostFieldDesc, HostObject, HostFieldDesc, ToGuestValueNode) */;
                this.cached_cache = null;
                state = state & 0xfffffffe /* remove-active doCached(HostFieldDesc, HostObject, HostFieldDesc, ToGuestValueNode) */;
                this.state_ = state = state | 0b10 /* add-active doUncached(HostFieldDesc, HostObject, ToGuestValueNode) */;
                lock.unlock();
                hasLock = false;
                return ReadFieldNode.doUncached(arg0Value, arg1Value, this.uncached_toGuest_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ReadFieldNode create() {
            return new ReadFieldNodeGen();
        }

        public static ReadFieldNode getUncached() {
            return ReadFieldNodeGen.UNCACHED;
        }

        @GeneratedBy(ReadFieldNode.class)
        private static final class CachedData extends Node {

            @Child CachedData next_;
            @CompilationFinal HostFieldDesc cachedField_;
            @Child ToGuestValueNode toGuest_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ReadFieldNode.class)
        private static final class Uncached extends ReadFieldNode {

            @TruffleBoundary
            @Override
            public Object execute(HostFieldDesc arg0Value, HostObject arg1Value) {
                return ReadFieldNode.doUncached(arg0Value, arg1Value, (ToGuestValueNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(WriteFieldNode.class)
    static final class WriteFieldNodeGen extends WriteFieldNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @Child private CachedData cached_cache;
        @Child private ToHostNode uncached_toHost_;

        private WriteFieldNodeGen() {
        }

        @ExplodeLoop
        @Override
        public void execute(HostFieldDesc arg0Value, HostObject arg1Value, Object arg2Value) throws UnsupportedTypeException, UnknownIdentifierException {
            int state = state_;
            if (state != 0 /* is-active doCached(HostFieldDesc, HostObject, Object, HostFieldDesc, ToHostNode, BranchProfile) || doUncached(HostFieldDesc, HostObject, Object, ToHostNode) */) {
                if ((state & 0b1) != 0 /* is-active doCached(HostFieldDesc, HostObject, Object, HostFieldDesc, ToHostNode, BranchProfile) */) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedField_)) {
                            WriteFieldNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedField_, s1_.toHost_, s1_.errorBranch_);
                            return;
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active doUncached(HostFieldDesc, HostObject, Object, ToHostNode) */) {
                    WriteFieldNode.doUncached(arg0Value, arg1Value, arg2Value, this.uncached_toHost_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            return;
        }

        private void executeAndSpecialize(HostFieldDesc arg0Value, HostObject arg1Value, Object arg2Value) throws UnsupportedTypeException, UnknownIdentifierException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded doCached(HostFieldDesc, HostObject, Object, HostFieldDesc, ToHostNode, BranchProfile) */) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 0b1) != 0 /* is-active doCached(HostFieldDesc, HostObject, Object, HostFieldDesc, ToHostNode, BranchProfile) */) {
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedField_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg0Value == s1_.cachedField_);
                        if (count1_ < (WriteFieldNode.LIMIT)) {
                            s1_ = super.insert(new CachedData(cached_cache));
                            s1_.cachedField_ = (arg0Value);
                            s1_.toHost_ = s1_.insertAccessor((ToHostNodeGen.create()));
                            s1_.errorBranch_ = (BranchProfile.create());
                            this.cached_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active doCached(HostFieldDesc, HostObject, Object, HostFieldDesc, ToHostNode, BranchProfile) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        WriteFieldNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedField_, s1_.toHost_, s1_.errorBranch_);
                        return;
                    }
                }
                this.uncached_toHost_ = super.insert((ToHostNodeGen.create()));
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(HostFieldDesc, HostObject, Object, HostFieldDesc, ToHostNode, BranchProfile) */;
                this.cached_cache = null;
                state = state & 0xfffffffe /* remove-active doCached(HostFieldDesc, HostObject, Object, HostFieldDesc, ToHostNode, BranchProfile) */;
                this.state_ = state = state | 0b10 /* add-active doUncached(HostFieldDesc, HostObject, Object, ToHostNode) */;
                lock.unlock();
                hasLock = false;
                WriteFieldNode.doUncached(arg0Value, arg1Value, arg2Value, this.uncached_toHost_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static WriteFieldNode create() {
            return new WriteFieldNodeGen();
        }

        public static WriteFieldNode getUncached() {
            return WriteFieldNodeGen.UNCACHED;
        }

        @GeneratedBy(WriteFieldNode.class)
        private static final class CachedData extends Node {

            @Child CachedData next_;
            @CompilationFinal HostFieldDesc cachedField_;
            @Child ToHostNode toHost_;
            @CompilationFinal BranchProfile errorBranch_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(WriteFieldNode.class)
        private static final class Uncached extends WriteFieldNode {

            @TruffleBoundary
            @Override
            public void execute(HostFieldDesc arg0Value, HostObject arg1Value, Object arg2Value) throws UnsupportedTypeException, UnknownIdentifierException {
                WriteFieldNode.doUncached(arg0Value, arg1Value, arg2Value, (ToHostNodeGen.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(IsListNode.class)
    static final class IsListNodeGen extends IsListNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private boolean isListAccess_;

        private IsListNodeGen() {
        }

        @Override
        public boolean execute(HostObject arg0Value) {
            int state = state_;
            if (state != 0 /* is-active doDefault(HostObject, boolean) */) {
                return doDefault(arg0Value, this.isListAccess_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private boolean executeAndSpecialize(HostObject arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                this.isListAccess_ = (arg0Value.getHostClassCache().isListAccess());
                this.state_ = state = state | 0b1 /* add-active doDefault(HostObject, boolean) */;
                lock.unlock();
                hasLock = false;
                return doDefault(arg0Value, this.isListAccess_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static IsListNode create() {
            return new IsListNodeGen();
        }

        public static IsListNode getUncached() {
            return IsListNodeGen.UNCACHED;
        }

        @GeneratedBy(IsListNode.class)
        private static final class Uncached extends IsListNode {

            @TruffleBoundary
            @Override
            public boolean execute(HostObject arg0Value) {
                return doDefault(arg0Value, (arg0Value.getHostClassCache().isListAccess()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(IsArrayNode.class)
    static final class IsArrayNodeGen extends IsArrayNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private boolean isArrayAccess_;

        private IsArrayNodeGen() {
        }

        @Override
        public boolean execute(HostObject arg0Value) {
            int state = state_;
            if (state != 0 /* is-active doDefault(HostObject, boolean) */) {
                return doDefault(arg0Value, this.isArrayAccess_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private boolean executeAndSpecialize(HostObject arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                this.isArrayAccess_ = (arg0Value.getHostClassCache().isArrayAccess());
                this.state_ = state = state | 0b1 /* add-active doDefault(HostObject, boolean) */;
                lock.unlock();
                hasLock = false;
                return doDefault(arg0Value, this.isArrayAccess_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static IsArrayNode create() {
            return new IsArrayNodeGen();
        }

        public static IsArrayNode getUncached() {
            return IsArrayNodeGen.UNCACHED;
        }

        @GeneratedBy(IsArrayNode.class)
        private static final class Uncached extends IsArrayNode {

            @TruffleBoundary
            @Override
            public boolean execute(HostObject arg0Value) {
                return doDefault(arg0Value, (arg0Value.getHostClassCache().isArrayAccess()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
