/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.ShapeImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class DynamicObjectSupport {
    private DynamicObjectSupport() {
    }

    static void ensureCapacity(DynamicObject object, Shape otherShape) {
        DynamicObjectSupport.growObjectStore(object, object.getShape(), otherShape);
        DynamicObjectSupport.growPrimitiveStore(object, object.getShape(), otherShape);
    }

    static void grow(DynamicObject object, Shape thisShape, Shape otherShape) {
        DynamicObjectSupport.growObjectStore(object, thisShape, otherShape);
        DynamicObjectSupport.growPrimitiveStore(object, thisShape, otherShape);
    }

    static void resize(DynamicObject object, Shape thisShape, Shape otherShape) {
        DynamicObjectSupport.resizeObjectStore(object, thisShape, otherShape);
        DynamicObjectSupport.resizePrimitiveStore(object, thisShape, otherShape);
    }

    static void trimToSize(DynamicObject object, Shape thisShape, Shape otherShape) {
        DynamicObjectSupport.trimObjectStore(object, thisShape, otherShape);
        DynamicObjectSupport.trimPrimitiveStore(object, thisShape, otherShape);
    }

    static void growAndSetShape(DynamicObject object, Shape thisShape, Shape otherShape) {
        DynamicObjectSupport.grow(object, thisShape, otherShape);
        LayoutImpl.ACCESS.setShape(object, otherShape);
    }

    static void resizeAndSetShape(DynamicObject object, Shape thisShape, Shape otherShape) {
        DynamicObjectSupport.resize(object, thisShape, otherShape);
        LayoutImpl.ACCESS.setShape(object, otherShape);
    }

    private static void growObjectStore(DynamicObject object, Shape oldShape, Shape newShape) {
        int destinationCapacity;
        int sourceCapacity = DynamicObjectSupport.getObjectArrayCapacity(oldShape);
        if (sourceCapacity < (destinationCapacity = DynamicObjectSupport.getObjectArrayCapacity(newShape))) {
            Object[] newObjectStore = new Object[destinationCapacity];
            if (sourceCapacity != 0) {
                int sourceSize = DynamicObjectSupport.getObjectArraySize(oldShape);
                Object[] oldObjectStore = LayoutImpl.ACCESS.getObjectArray(object);
                LayoutImpl.ACCESS.arrayCopy(oldObjectStore, newObjectStore, sourceSize);
            }
            LayoutImpl.ACCESS.setObjectArray(object, newObjectStore);
        }
    }

    private static void resizeObjectStore(DynamicObject object, Shape oldShape, Shape newShape) {
        int destinationCapacity = DynamicObjectSupport.getObjectArrayCapacity(newShape);
        if (destinationCapacity == 0) {
            LayoutImpl.ACCESS.setObjectArray(object, null);
        } else {
            int sourceCapacity = DynamicObjectSupport.getObjectArrayCapacity(oldShape);
            if (sourceCapacity != destinationCapacity) {
                int sourceSize = DynamicObjectSupport.getObjectArraySize(oldShape);
                Object[] newObjectStore = new Object[destinationCapacity];
                if (sourceSize != 0) {
                    Object[] oldObjectStore = LayoutImpl.ACCESS.getObjectArray(object);
                    int destinationSize = DynamicObjectSupport.getObjectArraySize(newShape);
                    int length = Math.min(sourceSize, destinationSize);
                    LayoutImpl.ACCESS.arrayCopy(oldObjectStore, newObjectStore, length);
                }
                LayoutImpl.ACCESS.setObjectArray(object, newObjectStore);
            }
        }
    }

    private static void growPrimitiveStore(DynamicObject object, Shape oldShape, Shape newShape) {
        int destinationCapacity;
        int sourceCapacity = DynamicObjectSupport.getPrimitiveArrayCapacity(oldShape);
        if (sourceCapacity < (destinationCapacity = DynamicObjectSupport.getPrimitiveArrayCapacity(newShape))) {
            int[] newPrimitiveArray = new int[destinationCapacity];
            if (sourceCapacity != 0) {
                int sourceSize = DynamicObjectSupport.getPrimitiveArraySize(oldShape);
                int[] oldPrimitiveArray = LayoutImpl.ACCESS.getPrimitiveArray(object);
                LayoutImpl.ACCESS.arrayCopy(oldPrimitiveArray, newPrimitiveArray, sourceSize);
            }
            LayoutImpl.ACCESS.setPrimitiveArray(object, newPrimitiveArray);
        }
    }

    private static void resizePrimitiveStore(DynamicObject object, Shape oldShape, Shape newShape) {
        assert (DynamicObjectSupport.hasPrimitiveArray(newShape));
        int destinationCapacity = DynamicObjectSupport.getPrimitiveArrayCapacity(newShape);
        if (destinationCapacity == 0) {
            LayoutImpl.ACCESS.setPrimitiveArray(object, null);
        } else {
            int sourceCapacity = DynamicObjectSupport.getPrimitiveArrayCapacity(oldShape);
            if (sourceCapacity != destinationCapacity) {
                int sourceSize = DynamicObjectSupport.getPrimitiveArraySize(oldShape);
                int[] newPrimitiveArray = new int[destinationCapacity];
                if (sourceSize != 0) {
                    int[] oldPrimitiveArray = LayoutImpl.ACCESS.getPrimitiveArray(object);
                    int destinationSize = DynamicObjectSupport.getPrimitiveArraySize(newShape);
                    int length = Math.min(sourceSize, destinationSize);
                    LayoutImpl.ACCESS.arrayCopy(oldPrimitiveArray, newPrimitiveArray, length);
                }
                LayoutImpl.ACCESS.setPrimitiveArray(object, newPrimitiveArray);
            }
        }
    }

    private static void trimObjectStore(DynamicObject object, Shape thisShape, Shape newShape) {
        Object[] oldObjectStore = LayoutImpl.ACCESS.getObjectArray(object);
        int destinationCapacity = DynamicObjectSupport.getObjectArrayCapacity(newShape);
        if (destinationCapacity == 0) {
            if (oldObjectStore != null) {
                LayoutImpl.ACCESS.setObjectArray(object, null);
            }
        } else {
            int sourceCapacity = DynamicObjectSupport.getObjectArrayCapacity(thisShape);
            if (sourceCapacity > destinationCapacity) {
                Object[] newObjectStore = new Object[destinationCapacity];
                int destinationSize = DynamicObjectSupport.getObjectArraySize(newShape);
                LayoutImpl.ACCESS.arrayCopy(oldObjectStore, newObjectStore, destinationSize);
                LayoutImpl.ACCESS.setObjectArray(object, newObjectStore);
            }
        }
    }

    private static void trimPrimitiveStore(DynamicObject object, Shape thisShape, Shape newShape) {
        int[] oldPrimitiveStore = LayoutImpl.ACCESS.getPrimitiveArray(object);
        int destinationCapacity = DynamicObjectSupport.getPrimitiveArrayCapacity(newShape);
        if (destinationCapacity == 0) {
            if (oldPrimitiveStore != null) {
                LayoutImpl.ACCESS.setPrimitiveArray(object, null);
            }
        } else {
            int sourceCapacity = DynamicObjectSupport.getPrimitiveArrayCapacity(thisShape);
            if (sourceCapacity > destinationCapacity) {
                int[] newPrimitiveStore = new int[destinationCapacity];
                int destinationSize = DynamicObjectSupport.getPrimitiveArraySize(newShape);
                LayoutImpl.ACCESS.arrayCopy(oldPrimitiveStore, newPrimitiveStore, destinationSize);
                LayoutImpl.ACCESS.setPrimitiveArray(object, newPrimitiveStore);
            }
        }
    }

    private static int getObjectArrayCapacity(Shape shape) {
        return ((ShapeImpl)shape).getObjectArrayCapacity();
    }

    private static int getObjectArraySize(Shape shape) {
        return ((ShapeImpl)shape).getObjectArraySize();
    }

    private static int getPrimitiveArrayCapacity(Shape shape) {
        return ((ShapeImpl)shape).getPrimitiveArrayCapacity();
    }

    private static int getPrimitiveArraySize(Shape shape) {
        return ((ShapeImpl)shape).getPrimitiveArraySize();
    }

    private static boolean hasPrimitiveArray(Shape shape) {
        return ((ShapeImpl)shape).hasPrimitiveArray();
    }

    static Map<Object, Object> archive(DynamicObject object) {
        Property[] properties;
        HashMap<Object, Object> archive = new HashMap<Object, Object>();
        for (Property property : properties = ((ShapeImpl)object.getShape()).getPropertyArray()) {
            archive.put(property.getKey(), DynamicObjectLibrary.getUncached().getOrDefault(object, property.getKey(), null));
        }
        return archive;
    }

    static boolean verifyValues(DynamicObject object, Map<Object, Object> archive) {
        Property[] properties;
        for (Property property : properties = ((ShapeImpl)object.getShape()).getPropertyArray()) {
            Object key = property.getKey();
            Object before = archive.get(key);
            Object after = DynamicObjectLibrary.getUncached().getOrDefault(object, key, null);
            assert (Objects.equals(after, before)) : "before != after for key: " + key;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    static void invalidateAllPropertyAssumptions(Shape shape) {
        ShapeImpl shapeImpl = (ShapeImpl)shape;
        if (shapeImpl.isLeaf()) {
            shapeImpl.invalidateLeafAssumption();
        }
        if (shapeImpl.allowPropertyAssumptions()) {
            shapeImpl.invalidateAllPropertyAssumptions();
        }
    }
}

