/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.HostException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.management.ExecutionEvent;

final class PolyglotManagement
extends AbstractPolyglotImpl.AbstractManagementImpl {
    static final Object[] EMPTY_ARRAY = new Object[0];
    private final PolyglotImpl engineImpl;

    PolyglotManagement(PolyglotImpl engineImpl) {
        super((AbstractPolyglotImpl)engineImpl);
        this.engineImpl = engineImpl;
    }

    public Object attachExecutionListener(Engine engineAPI, Consumer<ExecutionEvent> onEnter, Consumer<ExecutionEvent> onReturn, boolean expressions, boolean statements, boolean roots, final Predicate<org.graalvm.polyglot.Source> sourceFilter, final Predicate<String> rootFilter, boolean collectInputValues, boolean collectReturnValues, boolean collectExceptions) {
        EventBinding<ExecutionEventNodeFactory> binding;
        final PolyglotEngineImpl engine = this.getEngine(engineAPI);
        Instrumenter instrumenter = (Instrumenter)EngineAccessor.INSTRUMENT.getEngineInstrumenter(engine.instrumentationHandler);
        ArrayList<Class<StandardTags.RootTag>> tags = new ArrayList<Class<StandardTags.RootTag>>();
        if (expressions) {
            tags.add(StandardTags.ExpressionTag.class);
        }
        if (statements) {
            tags.add(StandardTags.StatementTag.class);
        }
        if (roots) {
            tags.add(StandardTags.RootTag.class);
        }
        if (tags.isEmpty()) {
            throw new IllegalArgumentException("No elements specified to listen to for execution listener. Need to specify at least one element kind: expressions, statements or roots.");
        }
        if (onReturn == null && onEnter == null) {
            throw new IllegalArgumentException("At least one event consumer must be provided for onEnter or onReturn.");
        }
        SourceSectionFilter.Builder filterBuilder = SourceSectionFilter.newBuilder().tagIs(tags.toArray(new Class[0]));
        filterBuilder.includeInternal(false);
        final ListenerImpl config = new ListenerImpl(engine, onEnter, onReturn, collectInputValues, collectReturnValues, collectExceptions);
        filterBuilder.sourceIs(new SourceSectionFilter.SourcePredicate(){

            @Override
            public boolean test(Source s) {
                String language = s.getLanguage();
                if (language == null) {
                    return false;
                }
                if (!engine.idToLanguage.containsKey(language)) {
                    return false;
                }
                if (sourceFilter != null) {
                    try {
                        return sourceFilter.test(PolyglotManagement.this.engineImpl.getOrCreatePolyglotSource(s));
                    }
                    catch (Throwable e) {
                        if (config.closing) {
                            return false;
                        }
                        throw new HostException(e);
                    }
                }
                return true;
            }
        });
        if (rootFilter != null) {
            filterBuilder.rootNameIs(new Predicate<String>(){

                @Override
                public boolean test(String s) {
                    try {
                        return rootFilter.test(s);
                    }
                    catch (Throwable e) {
                        if (config.closing) {
                            return false;
                        }
                        throw new HostException(e);
                    }
                }
            });
        }
        SourceSectionFilter filter = filterBuilder.build();
        try {
            boolean mayNeedInputValues = config.collectInputValues && config.onReturn != null;
            boolean mayNeedReturnValue = config.collectReturnValues && config.onReturn != null;
            boolean mayNeedExceptions = config.collectExceptions;
            binding = mayNeedInputValues || mayNeedReturnValue || mayNeedExceptions ? instrumenter.attachExecutionEventFactory(filter, mayNeedInputValues ? filter : null, new ExecutionEventNodeFactory(){

                @Override
                public ExecutionEventNode create(EventContext context) {
                    return new ProfilingNode(config, context);
                }
            }) : instrumenter.attachExecutionEventFactory(filter, null, new ExecutionEventNodeFactory(){

                @Override
                public ExecutionEventNode create(EventContext context) {
                    return new DefaultNode(config, context);
                }
            });
        }
        catch (Throwable t) {
            throw PolyglotManagement.wrapException(engine, t);
        }
        config.binding = binding;
        return config;
    }

    public void closeExecutionListener(Object impl) {
        try {
            ((ListenerImpl)impl).closing = true;
            ((ListenerImpl)impl).binding.dispose();
        }
        catch (Throwable t) {
            throw PolyglotManagement.wrapException(((ListenerImpl)impl).engine, t);
        }
    }

    public List<Value> getExecutionEventInputValues(Object impl) {
        try {
            return ((Event)impl).getInputValues();
        }
        catch (Throwable t) {
            throw PolyglotManagement.wrapException(impl, t);
        }
    }

    public String getExecutionEventRootName(Object impl) {
        try {
            return ((Event)impl).getRootName();
        }
        catch (Throwable t) {
            throw PolyglotManagement.wrapException(impl, t);
        }
    }

    public Value getExecutionEventReturnValue(Object impl) {
        try {
            return ((Event)impl).getReturnValue();
        }
        catch (Throwable t) {
            throw PolyglotManagement.wrapException(impl, t);
        }
    }

    public org.graalvm.polyglot.SourceSection getExecutionEventLocation(Object impl) {
        return ((Event)impl).getLocation();
    }

    public PolyglotException getExecutionEventException(Object impl) {
        return ((Event)impl).getException();
    }

    public boolean isExecutionEventExpression(Object impl) {
        return PolyglotManagement.hasTag(impl, StandardTags.ExpressionTag.class);
    }

    public boolean isExecutionEventStatement(Object impl) {
        return PolyglotManagement.hasTag(impl, StandardTags.StatementTag.class);
    }

    public boolean isExecutionEventRoot(Object impl) {
        return PolyglotManagement.hasTag(impl, StandardTags.RootTag.class);
    }

    private static boolean hasTag(Object impl, Class<? extends Tag> tag) {
        try {
            return ((Event)impl).getContext().hasTag(tag);
        }
        catch (Throwable t) {
            throw PolyglotManagement.wrapException(impl, t);
        }
    }

    private static RuntimeException wrapException(PolyglotEngineImpl engine, Throwable t) {
        return PolyglotImpl.guestToHostException(engine, t);
    }

    private static RuntimeException wrapException(Object impl, Throwable t) {
        return PolyglotManagement.wrapException(((DefaultNode)impl).config.engine, t);
    }

    private PolyglotEngineImpl getEngine(Engine engineAPI) {
        return (PolyglotEngineImpl)this.engineImpl.getAPIAccess().getImpl(engineAPI);
    }

    static class ReadOnlyValueList
    extends AbstractList<Value> {
        static final ReadOnlyValueList EMPTY = new ReadOnlyValueList(new Value[0]);
        private final Value[] valueArray;

        ReadOnlyValueList(Value[] valueArray) {
            this.valueArray = valueArray;
        }

        @Override
        public Value get(int index) {
            return this.valueArray[index];
        }

        @Override
        public int size() {
            return this.valueArray.length;
        }
    }

    static abstract class AbstractNode
    extends ExecutionEventNode
    implements Event {
        final ListenerImpl config;
        final EventContext context;
        final ExecutionEvent cachedEvent;

        AbstractNode(ListenerImpl config, EventContext context) {
            this.config = config;
            this.context = context;
            this.cachedEvent = config.engine.impl.getManagement().newExecutionEvent((Object)this);
        }

        @Override
        public String getRootName() {
            RootNode rootNode = this.context.getInstrumentedNode().getRootNode();
            if (rootNode == null) {
                return null;
            }
            try {
                return rootNode.getName();
            }
            catch (Throwable t) {
                throw this.wrapHostError(t);
            }
        }

        @Override
        protected final void onEnter(VirtualFrame frame) {
            if (this.config.onEnter != null) {
                try {
                    this.invokeOnEnter();
                }
                catch (Throwable t) {
                    throw this.wrapHostError(t);
                }
            }
        }

        protected RuntimeException wrapHostError(Throwable t) {
            assert (!(t instanceof HostException));
            throw new HostException(t);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected final void invokeOnEnter() {
            this.config.onEnter.accept(this.cachedEvent);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected final void invokeReturn() {
            this.config.onReturn.accept(this.cachedEvent);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected final void invokeException() {
            this.config.onReturn.accept(this.cachedEvent);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected final void invokeReturnAllocate(List<Value> inputValues, Value returnValue) {
            this.config.onReturn.accept(this.config.management.newExecutionEvent((Object)new DynamicEvent(this, inputValues, returnValue, null)));
        }

        @Override
        public final org.graalvm.polyglot.SourceSection getLocation() {
            return this.config.engine.impl.getPolyglotSourceSection(this.context.getInstrumentedSourceSection());
        }

        @Override
        public final List<Value> getInputValues() {
            if (this.config.collectInputValues) {
                return ReadOnlyValueList.EMPTY;
            }
            return null;
        }

        @Override
        public final PolyglotException getException() {
            return null;
        }

        @Override
        public final Value getReturnValue() {
            return null;
        }

        @Override
        public final EventContext getContext() {
            return this.context;
        }
    }

    static class DefaultNode
    extends AbstractNode
    implements Event {
        DefaultNode(ListenerImpl config, EventContext context) {
            super(config, context);
        }

        @Override
        protected void onReturnValue(VirtualFrame frame, Object result) {
            if (this.config.onReturn != null) {
                try {
                    this.invokeReturn();
                }
                catch (Throwable t) {
                    throw this.wrapHostError(t);
                }
            }
        }

        @Override
        protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
            if (this.config.onReturn != null) {
                try {
                    this.invokeException();
                }
                catch (Throwable t) {
                    throw this.wrapHostError(t);
                }
            }
        }
    }

    static class ProfilingNode
    extends AbstractNode
    implements Event {
        @CompilerDirectives.CompilationFinal
        boolean seenInputValues;
        @CompilerDirectives.CompilationFinal
        boolean seenReturnValue;
        final PolyglotLanguage language;

        ProfilingNode(ListenerImpl config, EventContext context) {
            super(config, context);
            PolyglotLanguage languageToUse = null;
            SourceSection location = context.getInstrumentedSourceSection();
            if (location != null) {
                languageToUse = config.engine.idToLanguage.get(location.getSource().getLanguage());
            }
            if (languageToUse == null) {
                assert (false);
                languageToUse = config.engine.hostLanguage;
            }
            this.language = languageToUse;
        }

        @Override
        protected void onInputValue(VirtualFrame frame, EventContext inputContext, int inputIndex, Object inputValue) {
            assert (this.config.onReturn != null && this.config.collectInputValues);
            if (!this.seenInputValues) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenInputValues = true;
            }
            this.saveInputValue(frame, inputIndex, inputValue);
        }

        @Override
        protected void onReturnValue(VirtualFrame frame, Object result) {
            if (this.config.onReturn != null) {
                try {
                    if (this.config.collectReturnValues && !this.seenReturnValue && result != null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.seenReturnValue = true;
                    }
                    if (this.seenReturnValue || this.seenInputValues) {
                        Object[] inputValues = this.seenInputValues ? this.getSavedInputValues(frame) : EMPTY_ARRAY;
                        this.invokeReturnAllocate(inputValues, result);
                    } else {
                        this.invokeReturn();
                    }
                }
                catch (Throwable t) {
                    throw this.wrapHostError(t);
                }
            }
        }

        @Override
        protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
            if (this.config.onReturn != null) {
                try {
                    if (this.seenReturnValue || this.seenInputValues) {
                        Object[] inputValues = this.seenInputValues ? this.getSavedInputValues(frame) : EMPTY_ARRAY;
                        this.invokeExceptionAllocate(inputValues, exception);
                    } else if (this.config.collectExceptions) {
                        this.invokeExceptionAllocate(this.config.collectInputValues ? ReadOnlyValueList.EMPTY : (List)null, exception);
                    } else {
                        this.invokeException();
                    }
                }
                catch (Throwable t) {
                    throw this.wrapHostError(t);
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void invokeExceptionAllocate(Object[] inputValues, Throwable result) {
            ReadOnlyValueList convertedInputValues;
            boolean reportInputValues;
            boolean reportException = this.config.collectExceptions;
            boolean bl = reportInputValues = this.config.collectInputValues && inputValues.length > 0;
            if (!reportException && !reportInputValues) {
                this.invokeException();
                return;
            }
            PolyglotLanguageContext languageContext = this.language.getCurrentLanguageContext();
            if (reportInputValues) {
                Value[] hostValues = new Value[inputValues.length];
                for (int i = 0; i < inputValues.length; ++i) {
                    Object guestValue = inputValues[i];
                    hostValues[i] = guestValue != null ? languageContext.asValue(inputValues[i]) : null;
                }
                convertedInputValues = new ReadOnlyValueList(hostValues);
            } else {
                convertedInputValues = ReadOnlyValueList.EMPTY;
            }
            this.invokeExceptionAllocate(convertedInputValues, result);
        }

        @CompilerDirectives.TruffleBoundary
        private void invokeReturnAllocate(Object[] inputValues, Object result) {
            boolean reportInputValues;
            boolean reportResult = this.config.collectReturnValues && result != null;
            boolean bl = reportInputValues = this.config.collectInputValues && inputValues.length > 0;
            if (!reportResult && !reportInputValues) {
                this.invokeReturn();
                return;
            }
            PolyglotLanguageContext languageContext = this.language.getCurrentLanguageContext();
            Value returnValue = reportResult ? languageContext.asValue(result) : null;
            ReadOnlyValueList convertedInputValues = reportInputValues ? new ReadOnlyValueList(languageContext.toHostValues(inputValues)) : ReadOnlyValueList.EMPTY;
            this.invokeReturnAllocate(convertedInputValues, returnValue);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected final void invokeExceptionAllocate(List<Value> inputValues, Throwable e) {
            PolyglotException ex = e != null ? PolyglotImpl.guestToHostException(this.language.getCurrentLanguageContext(), e) : null;
            this.config.onReturn.accept(this.config.management.newExecutionEvent((Object)new DynamicEvent(this, inputValues, null, ex)));
        }
    }

    static final class DynamicEvent
    implements Event {
        final AbstractNode node;
        final List<Value> inputValues;
        final Value returnValue;
        final PolyglotException exception;

        DynamicEvent(AbstractNode node, List<Value> inputValues, Value returnValue, PolyglotException ex) {
            this.node = node;
            this.inputValues = inputValues;
            this.returnValue = returnValue;
            this.exception = ex;
        }

        @Override
        public String getRootName() {
            return this.node.getRootName();
        }

        @Override
        public PolyglotException getException() {
            return this.exception;
        }

        @Override
        public org.graalvm.polyglot.SourceSection getLocation() {
            return this.node.getLocation();
        }

        @Override
        public List<Value> getInputValues() {
            return this.inputValues;
        }

        @Override
        public Value getReturnValue() {
            return this.returnValue;
        }

        @Override
        public EventContext getContext() {
            return this.node.context;
        }
    }

    static interface Event {
        public String getRootName();

        public org.graalvm.polyglot.SourceSection getLocation();

        public List<Value> getInputValues();

        public Value getReturnValue();

        public EventContext getContext();

        public PolyglotException getException();
    }

    static class ListenerImpl {
        final PolyglotEngineImpl engine;
        final Consumer<ExecutionEvent> onEnter;
        final Consumer<ExecutionEvent> onReturn;
        final AbstractPolyglotImpl.ManagementAccess management;
        final boolean collectInputValues;
        final boolean collectReturnValues;
        final boolean collectExceptions;
        volatile EventBinding<?> binding;
        volatile boolean closing;

        ListenerImpl(PolyglotEngineImpl engine, Consumer<ExecutionEvent> onEnter, Consumer<ExecutionEvent> onReturn, boolean collectInputValues, boolean collectReturnValues, boolean collectExceptions) {
            this.engine = engine;
            this.onEnter = onEnter;
            this.onReturn = onReturn;
            this.management = engine.impl.getManagement();
            this.collectInputValues = collectInputValues;
            this.collectReturnValues = collectReturnValues;
            this.collectExceptions = collectExceptions;
        }
    }
}

