/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.DynamicObjectImpl;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=DynamicObjectImpl.class)
public final class DynamicObjectImplGen {
    private DynamicObjectImplGen() {
    }

    static {
        LibraryExport.register(DynamicObjectImpl.class, new DynamicDispatchLibraryExports());
    }

    @GeneratedBy(value=DynamicObjectImpl.class)
    public static class DynamicDispatchLibraryExports
    extends LibraryExport<DynamicDispatchLibrary> {
        private DynamicDispatchLibraryExports() {
            super(DynamicDispatchLibrary.class, DynamicObjectImpl.class, false, false, 0);
        }

        @Override
        protected DynamicDispatchLibrary createUncached(Object receiver) {
            assert (receiver instanceof DynamicObjectImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected DynamicDispatchLibrary createCached(Object receiver) {
            assert (receiver instanceof DynamicObjectImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=DynamicObjectImpl.class)
        public static class Uncached
        extends DynamicDispatchLibrary {
            protected Uncached(Object receiver) {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return receiver instanceof DynamicObjectImpl && Uncached.accepts_(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object cast(Object receiver) {
                return (DynamicObjectImpl)receiver;
            }

            @Override
            public final boolean isAdoptable() {
                return false;
            }

            @Override
            public final NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Class<?> dispatch(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObjectImpl arg0Value = (DynamicObjectImpl)arg0Value_;
                return DynamicObjectImpl.Dispatch.doCachedTypeClass(arg0Value, DynamicObjectImpl.getObjectType(arg0Value.getShape()).getClass());
            }

            @CompilerDirectives.TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                DynamicObjectImpl arg0Value = (DynamicObjectImpl)arg0Value_;
                return DynamicObjectImpl.Accepts.doCachedTypeClass(arg0Value, DynamicObjectImpl.getObjectType(arg0Value.getShape()).getClass());
            }
        }

        @GeneratedBy(value=DynamicObjectImpl.class)
        public static class Cached
        extends DynamicDispatchLibrary {
            private final Class<? extends DynamicObjectImpl> receiverClass_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @CompilerDirectives.CompilationFinal
            private Shape cachedShape;
            @CompilerDirectives.CompilationFinal
            private Class<? extends ObjectType> cachedTypeClass;

            protected Cached(Object receiver) {
                DynamicObjectImpl castReceiver = (DynamicObjectImpl)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public Object cast(Object receiver) {
                return CompilerDirectives.castExact(receiver, this.receiverClass_);
            }

            @Override
            public boolean accepts(Object receiver) {
                return CompilerDirectives.isExact(receiver, this.receiverClass_) && this.accepts_(receiver);
            }

            private boolean accepts_(Object arg0Value_) {
                DynamicObjectImpl arg0Value = CompilerDirectives.castExact(arg0Value_, this.receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && this.cachedShape == arg0Value.getShape()) {
                        return DynamicObjectImpl.Accepts.doCachedShape(arg0Value, this.cachedShape, this.cachedTypeClass);
                    }
                    if ((state_0 & 2) != 0) {
                        return DynamicObjectImpl.Accepts.doCachedTypeClass(arg0Value, this.cachedTypeClass);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.acceptsAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean acceptsAndSpecialize(DynamicObjectImpl arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                try {
                    int state_0 = this.state_0_;
                    int exclude = this.exclude_;
                    if ((exclude & 1) == 0) {
                        boolean CachedShape_duplicateFound_ = false;
                        if ((state_0 & 1) != 0 && this.cachedShape == arg0Value.getShape()) {
                            CachedShape_duplicateFound_ = true;
                        }
                        if (!CachedShape_duplicateFound_) {
                            Shape accepts_cachedShape_cachedShape__;
                            Shape shape = accepts_cachedShape_cachedShape__ = this.cachedShape == null ? arg0Value.getShape() : this.cachedShape;
                            if (accepts_cachedShape_cachedShape__ == arg0Value.getShape() && (state_0 & 1) == 0) {
                                if (this.cachedShape == null) {
                                    Shape accepts_cachedShape_cachedShape___check = accepts_cachedShape_cachedShape__;
                                    if (accepts_cachedShape_cachedShape___check == null) {
                                        throw new AssertionError((Object)"Specialization 'doCachedShape(DynamicObjectImpl, Shape, Class<? extends ObjectType>)' contains a shared cache with name 'cachedShape' that returned a null value for the cached initializer. Null values are not supported for shared cached initializers because null is reserved for the uninitialized state.");
                                    }
                                    this.cachedShape = accepts_cachedShape_cachedShape___check;
                                }
                                this.cachedTypeClass = this.cachedTypeClass == null ? DynamicObjectImpl.getObjectType(arg0Value.getShape()).getClass() : this.cachedTypeClass;
                                this.state_0_ = state_0 |= 1;
                                CachedShape_duplicateFound_ = true;
                            }
                        }
                        if (CachedShape_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            boolean bl = DynamicObjectImpl.Accepts.doCachedShape(arg0Value, this.cachedShape, this.cachedTypeClass);
                            return bl;
                        }
                    }
                    this.cachedTypeClass = this.cachedTypeClass == null ? DynamicObjectImpl.getObjectType(arg0Value.getShape()).getClass() : this.cachedTypeClass;
                    this.exclude_ = exclude |= 1;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = DynamicObjectImpl.Accepts.doCachedTypeClass(arg0Value, this.cachedTypeClass);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public Class<?> dispatch(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                DynamicObjectImpl arg0Value = CompilerDirectives.castExact(arg0Value_, this.receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0 && this.cachedShape == arg0Value.getShape()) {
                        return DynamicObjectImpl.Dispatch.doCachedShape(arg0Value, this.cachedShape, this.cachedTypeClass);
                    }
                    if ((state_0 & 8) != 0) {
                        return DynamicObjectImpl.Dispatch.doCachedTypeClass(arg0Value, this.cachedTypeClass);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.dispatchAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Class<?> dispatchAndSpecialize(DynamicObjectImpl arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                try {
                    int state_0 = this.state_0_;
                    int exclude = this.exclude_;
                    if ((exclude & 2) == 0) {
                        boolean CachedShape_duplicateFound_ = false;
                        if ((state_0 & 4) != 0 && this.cachedShape == arg0Value.getShape()) {
                            CachedShape_duplicateFound_ = true;
                        }
                        if (!CachedShape_duplicateFound_) {
                            Shape dispatch_cachedShape_cachedShape__;
                            Shape shape = dispatch_cachedShape_cachedShape__ = this.cachedShape == null ? arg0Value.getShape() : this.cachedShape;
                            if (dispatch_cachedShape_cachedShape__ == arg0Value.getShape() && (state_0 & 4) == 0) {
                                if (this.cachedShape == null) {
                                    Shape dispatch_cachedShape_cachedShape___check = dispatch_cachedShape_cachedShape__;
                                    if (dispatch_cachedShape_cachedShape___check == null) {
                                        throw new AssertionError((Object)"Specialization 'doCachedShape(DynamicObjectImpl, Shape, Class<? extends ObjectType>)' contains a shared cache with name 'cachedShape' that returned a null value for the cached initializer. Null values are not supported for shared cached initializers because null is reserved for the uninitialized state.");
                                    }
                                    this.cachedShape = dispatch_cachedShape_cachedShape___check;
                                }
                                this.cachedTypeClass = this.cachedTypeClass == null ? DynamicObjectImpl.getObjectType(arg0Value.getShape()).getClass() : this.cachedTypeClass;
                                this.state_0_ = state_0 |= 4;
                                CachedShape_duplicateFound_ = true;
                            }
                        }
                        if (CachedShape_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            Class<?> clazz = DynamicObjectImpl.Dispatch.doCachedShape(arg0Value, this.cachedShape, this.cachedTypeClass);
                            return clazz;
                        }
                    }
                    this.cachedTypeClass = this.cachedTypeClass == null ? DynamicObjectImpl.getObjectType(arg0Value.getShape()).getClass() : this.cachedTypeClass;
                    this.exclude_ = exclude |= 2;
                    state_0 &= 0xFFFFFFFB;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    Class<?> clazz = DynamicObjectImpl.Dispatch.doCachedTypeClass(arg0Value, this.cachedTypeClass);
                    return clazz;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

