/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.ImplAccessor;
import java.lang.reflect.Field;
import java.util.Arrays;
import sun.misc.Unsafe;

public final class FrameWithoutBoxing
implements VirtualFrame,
MaterializedFrame {
    private final FrameDescriptor descriptor;
    private final Object[] arguments;
    private Object[] locals;
    private long[] primitiveLocals;
    private byte[] tags;
    private final Object[] indexedLocals;
    private final long[] indexedPrimitiveLocals;
    private final byte[] indexedTags;
    private Object[] auxiliarySlots;
    private static final Object OBJECT_LOCATION = new Object();
    private static final Object PRIMITIVE_LOCATION = new Object();
    public static final byte OBJECT_TAG = 0;
    public static final byte LONG_TAG = 1;
    public static final byte INT_TAG = 2;
    public static final byte DOUBLE_TAG = 3;
    public static final byte FLOAT_TAG = 4;
    public static final byte BOOLEAN_TAG = 5;
    public static final byte BYTE_TAG = 6;
    public static final byte ILLEGAL_TAG = 7;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Unsafe UNSAFE = FrameWithoutBoxing.initUnsafe();

    private static Unsafe initUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                return (Unsafe)theUnsafe.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe", e);
            }
        }
    }

    public FrameWithoutBoxing(FrameDescriptor descriptor, Object[] arguments) {
        byte[] indexedTagsArray;
        long[] indexedPrimitiveLocalsArray;
        Object[] indexedLocalsArray;
        byte[] tagsArray;
        long[] primitiveLocalsArray;
        Object[] localsArray;
        int size = descriptor.getSize();
        int indexedSize = descriptor.getNumberOfSlots();
        int auxiliarySize = descriptor.getNumberOfAuxiliarySlots();
        Object defaultValue = descriptor.getDefaultValue();
        if (size == 0) {
            localsArray = EMPTY_OBJECT_ARRAY;
            primitiveLocalsArray = EMPTY_LONG_ARRAY;
            tagsArray = EMPTY_BYTE_ARRAY;
        } else {
            localsArray = new Object[size];
            if (defaultValue != null) {
                Arrays.fill(localsArray, defaultValue);
            }
            primitiveLocalsArray = new long[size];
            tagsArray = new byte[size];
        }
        if (indexedSize == 0) {
            indexedLocalsArray = EMPTY_OBJECT_ARRAY;
            indexedPrimitiveLocalsArray = EMPTY_LONG_ARRAY;
            indexedTagsArray = EMPTY_BYTE_ARRAY;
        } else {
            indexedLocalsArray = new Object[indexedSize];
            if (defaultValue != null) {
                Arrays.fill(indexedLocalsArray, defaultValue);
            }
            indexedPrimitiveLocalsArray = new long[indexedSize];
            indexedTagsArray = new byte[indexedSize];
        }
        Object[] auxiliarySlotsArray = auxiliarySize == 0 ? EMPTY_OBJECT_ARRAY : new Object[auxiliarySize];
        this.descriptor = descriptor;
        this.arguments = arguments;
        this.locals = localsArray;
        this.primitiveLocals = primitiveLocalsArray;
        this.tags = tagsArray;
        this.indexedLocals = indexedLocalsArray;
        this.indexedPrimitiveLocals = indexedPrimitiveLocalsArray;
        this.indexedTags = indexedTagsArray;
        this.auxiliarySlots = auxiliarySlotsArray;
    }

    @Override
    public Object[] getArguments() {
        return FrameWithoutBoxing.unsafeCast(this.arguments, Object[].class, true, true, true);
    }

    @Override
    public MaterializedFrame materialize() {
        ImplAccessor.frameSupportAccessor().markMaterializeCalled(this.descriptor);
        return this;
    }

    @Override
    public Object getObject(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)0);
        return this.getObjectUnsafe(slotIndex, slot, condition);
    }

    private Object[] getLocals() {
        return FrameWithoutBoxing.unsafeCast(this.locals, Object[].class, true, true, true);
    }

    private long[] getPrimitiveLocals() {
        return FrameWithoutBoxing.unsafeCast(this.primitiveLocals, long[].class, true, true, true);
    }

    public byte[] getTags() {
        return FrameWithoutBoxing.unsafeCast(this.tags, byte[].class, true, true, true);
    }

    Object getObjectUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        return FrameWithoutBoxing.unsafeGetObject(this.getLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)slotIndex * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, condition, slot);
    }

    @Override
    public void setObject(FrameSlot slot, Object value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)0);
        this.setObjectUnsafe(slotIndex, slot, value);
    }

    private void setObjectUnsafe(int slotIndex, FrameSlot slot, Object value) {
        FrameWithoutBoxing.unsafePutObject(this.getLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)slotIndex * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, value, slot);
    }

    @Override
    public byte getByte(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)6);
        return this.getByteUnsafe(slotIndex, slot, condition);
    }

    byte getByteUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        return (byte)FrameWithoutBoxing.unsafeGetInt(this.getPrimitiveLocals(), offset, condition, slot);
    }

    @Override
    public void setByte(FrameSlot slot, byte value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)6);
        this.setByteUnsafe(slotIndex, slot, value);
    }

    private void setByteUnsafe(int slotIndex, FrameSlot slot, byte value) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        FrameWithoutBoxing.unsafePutInt(this.getPrimitiveLocals(), offset, value, slot);
    }

    @Override
    public boolean getBoolean(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)5);
        return this.getBooleanUnsafe(slotIndex, slot, condition);
    }

    boolean getBooleanUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        return FrameWithoutBoxing.unsafeGetInt(this.getPrimitiveLocals(), offset, condition, slot) != 0;
    }

    @Override
    public void setBoolean(FrameSlot slot, boolean value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)5);
        this.setBooleanUnsafe(slotIndex, slot, value);
    }

    private void setBooleanUnsafe(int slotIndex, FrameSlot slot, boolean value) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        FrameWithoutBoxing.unsafePutInt(this.getPrimitiveLocals(), offset, value ? 1 : 0, slot);
    }

    @Override
    public float getFloat(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)4);
        return this.getFloatUnsafe(slotIndex, slot, condition);
    }

    float getFloatUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        return FrameWithoutBoxing.unsafeGetFloat(this.getPrimitiveLocals(), offset, condition, slot);
    }

    @Override
    public void setFloat(FrameSlot slot, float value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)4);
        this.setFloatUnsafe(slotIndex, slot, value);
    }

    private void setFloatUnsafe(int slotIndex, FrameSlot slot, float value) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        FrameWithoutBoxing.unsafePutFloat(this.getPrimitiveLocals(), offset, value, slot);
    }

    @Override
    public long getLong(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)1);
        return this.getLongUnsafe(slotIndex, slot, condition);
    }

    long getLongUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        return FrameWithoutBoxing.unsafeGetLong(this.getPrimitiveLocals(), offset, condition, slot);
    }

    @Override
    public void setLong(FrameSlot slot, long value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)1);
        this.setLongUnsafe(slotIndex, slot, value);
    }

    private void setLongUnsafe(int slotIndex, FrameSlot slot, long value) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        FrameWithoutBoxing.unsafePutLong(this.getPrimitiveLocals(), offset, value, slot);
    }

    @Override
    public int getInt(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)2);
        return this.getIntUnsafe(slotIndex, slot, condition);
    }

    int getIntUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        return FrameWithoutBoxing.unsafeGetInt(this.getPrimitiveLocals(), offset, condition, slot);
    }

    @Override
    public void setInt(FrameSlot slot, int value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)2);
        this.setIntUnsafe(slotIndex, slot, value);
    }

    private void setIntUnsafe(int slotIndex, FrameSlot slot, int value) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        FrameWithoutBoxing.unsafePutInt(this.getPrimitiveLocals(), offset, value, slot);
    }

    @Override
    public double getDouble(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)3);
        return this.getDoubleUnsafe(slotIndex, slot, condition);
    }

    double getDoubleUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        return FrameWithoutBoxing.unsafeGetDouble(this.getPrimitiveLocals(), offset, condition, slot);
    }

    @Override
    public void setDouble(FrameSlot slot, double value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)3);
        this.setDoubleUnsafe(slotIndex, slot, value);
    }

    private void setDoubleUnsafe(int slotIndex, FrameSlot slot, double value) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        FrameWithoutBoxing.unsafePutDouble(this.getPrimitiveLocals(), offset, value, slot);
    }

    @Override
    public FrameDescriptor getFrameDescriptor() {
        return FrameWithoutBoxing.unsafeCast(this.descriptor, FrameDescriptor.class, true, true, false);
    }

    private void verifySet(int slotIndex, byte tag) {
        try {
            this.getTags()[slotIndex] = tag;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.resizeAndGetTagsOrThrow((int)slotIndex)[slotIndex] = tag;
        }
    }

    private boolean verifyGet(int slotIndex, byte expectedTag) throws FrameSlotTypeException {
        boolean condition;
        byte actualTag = this.getTagChecked(slotIndex);
        boolean bl = condition = actualTag == expectedTag;
        if (!condition) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw FrameWithoutBoxing.frameSlotTypeException();
        }
        return condition;
    }

    private byte getTagChecked(int slotIndex) {
        try {
            return this.getTags()[slotIndex];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.resizeAndGetTagsOrThrow(slotIndex)[slotIndex];
        }
    }

    private static FrameSlotTypeException frameSlotTypeException() throws FrameSlotTypeException {
        CompilerAsserts.neverPartOfCompilation();
        throw new FrameSlotTypeException();
    }

    private byte[] resizeAndGetTagsOrThrow(int slotIndex) {
        byte[] newTags;
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (this.resize() && Integer.compareUnsigned(slotIndex, (newTags = this.getTags()).length) < 0) {
            return newTags;
        }
        throw FrameWithoutBoxing.outOfBoundsException(slotIndex);
    }

    private static IllegalArgumentException outOfBoundsException(int slotIndex) {
        CompilerAsserts.neverPartOfCompilation();
        throw new IllegalArgumentException("The frame slot '" + slotIndex + "' is not known by the frame descriptor.");
    }

    private static long getPrimitiveOffset(int slotIndex) {
        return (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (long)slotIndex * (long)Unsafe.ARRAY_LONG_INDEX_SCALE;
    }

    @Override
    public Object getValue(FrameSlot slot) {
        boolean condition;
        byte tag = this.getTag(slot);
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean bl = condition = tag == 5;
        if (condition) {
            return this.getBooleanUnsafe(slotIndex, slot, condition);
        }
        boolean bl2 = condition = tag == 6;
        if (condition) {
            return this.getByteUnsafe(slotIndex, slot, condition);
        }
        boolean bl3 = condition = tag == 2;
        if (condition) {
            return this.getIntUnsafe(slotIndex, slot, condition);
        }
        boolean bl4 = condition = tag == 3;
        if (condition) {
            return this.getDoubleUnsafe(slotIndex, slot, condition);
        }
        boolean bl5 = condition = tag == 1;
        if (condition) {
            return this.getLongUnsafe(slotIndex, slot, condition);
        }
        boolean bl6 = condition = tag == 4;
        if (condition) {
            return Float.valueOf(this.getFloatUnsafe(slotIndex, slot, condition));
        }
        boolean bl7 = condition = tag == 0;
        assert (condition);
        return this.getObjectUnsafe(slotIndex, slot, condition);
    }

    boolean resize() {
        CompilerAsserts.neverPartOfCompilation();
        int oldSize = this.tags.length;
        int newSize = this.descriptor.getSize();
        if (newSize > oldSize) {
            this.locals = Arrays.copyOf(this.locals, newSize);
            Arrays.fill(this.locals, oldSize, newSize, this.descriptor.getDefaultValue());
            this.primitiveLocals = Arrays.copyOf(this.primitiveLocals, newSize);
            this.tags = Arrays.copyOf(this.tags, newSize);
            return true;
        }
        return false;
    }

    @Override
    public byte getTag(int slotIndex) {
        try {
            return this.getIndexedTags()[slotIndex];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw CompilerDirectives.shouldNotReachHere("invalid indexed slot", e);
        }
    }

    private byte getTag(FrameSlot slot) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        try {
            return this.getTags()[slotIndex];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.resizeAndGetTags()[slotIndex];
        }
    }

    private byte[] resizeAndGetTags() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.resize();
        return this.getTags();
    }

    @Override
    public boolean isObject(FrameSlot slot) {
        return this.getTag(slot) == 0;
    }

    @Override
    public boolean isByte(FrameSlot slot) {
        return this.getTag(slot) == 6;
    }

    @Override
    public boolean isBoolean(FrameSlot slot) {
        return this.getTag(slot) == 5;
    }

    @Override
    public boolean isInt(FrameSlot slot) {
        return this.getTag(slot) == 2;
    }

    @Override
    public boolean isLong(FrameSlot slot) {
        return this.getTag(slot) == 1;
    }

    @Override
    public boolean isFloat(FrameSlot slot) {
        return this.getTag(slot) == 4;
    }

    @Override
    public boolean isDouble(FrameSlot slot) {
        return this.getTag(slot) == 3;
    }

    @Override
    public void clear(FrameSlot slot) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)7);
        this.setObjectUnsafe(slotIndex, slot, null);
        if (CompilerDirectives.inCompiledCode()) {
            this.setLongUnsafe(slotIndex, slot, 0L);
        }
    }

    private static <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
        return (T)value;
    }

    private static int unsafeGetInt(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UNSAFE.getInt(receiver, offset);
    }

    private static long unsafeGetLong(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UNSAFE.getLong(receiver, offset);
    }

    private static float unsafeGetFloat(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UNSAFE.getFloat(receiver, offset);
    }

    private static double unsafeGetDouble(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UNSAFE.getDouble(receiver, offset);
    }

    private static Object unsafeGetObject(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UNSAFE.getObject(receiver, offset);
    }

    private static void unsafePutInt(Object receiver, long offset, int value, Object locationIdentity) {
        UNSAFE.putInt(receiver, offset, value);
    }

    private static void unsafePutLong(Object receiver, long offset, long value, Object locationIdentity) {
        UNSAFE.putLong(receiver, offset, value);
    }

    private static void unsafePutFloat(Object receiver, long offset, float value, Object locationIdentity) {
        UNSAFE.putFloat(receiver, offset, value);
    }

    private static void unsafePutDouble(Object receiver, long offset, double value, Object locationIdentity) {
        UNSAFE.putDouble(receiver, offset, value);
    }

    private static void unsafePutObject(Object receiver, long offset, Object value, Object locationIdentity) {
        UNSAFE.putObject(receiver, offset, value);
    }

    @Override
    public Object getValue(int slot) {
        boolean condition;
        byte tag = this.getTag(slot);
        boolean bl = condition = tag == 5;
        if (condition) {
            return FrameWithoutBoxing.unsafeGetInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION) != 0;
        }
        boolean bl2 = condition = tag == 6;
        if (condition) {
            return (byte)FrameWithoutBoxing.unsafeGetInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
        }
        boolean bl3 = condition = tag == 2;
        if (condition) {
            return FrameWithoutBoxing.unsafeGetInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
        }
        boolean bl4 = condition = tag == 3;
        if (condition) {
            return FrameWithoutBoxing.unsafeGetDouble(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
        }
        boolean bl5 = condition = tag == 1;
        if (condition) {
            return FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
        }
        boolean bl6 = condition = tag == 4;
        if (condition) {
            return Float.valueOf(FrameWithoutBoxing.unsafeGetFloat(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION));
        }
        boolean bl7 = condition = tag == 0;
        assert (condition);
        return FrameWithoutBoxing.unsafeGetObject(this.getIndexedLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)slot * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, condition, OBJECT_LOCATION);
    }

    private static int getFrameSlotIndex(FrameSlot slot) {
        return slot.getIndex();
    }

    private Object[] getIndexedLocals() {
        return FrameWithoutBoxing.unsafeCast(this.indexedLocals, Object[].class, true, true, true);
    }

    private long[] getIndexedPrimitiveLocals() {
        return FrameWithoutBoxing.unsafeCast(this.indexedPrimitiveLocals, long[].class, true, true, true);
    }

    private byte[] getIndexedTags() {
        return FrameWithoutBoxing.unsafeCast(this.indexedTags, byte[].class, true, true, true);
    }

    @Override
    public Object getObject(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)0);
        return FrameWithoutBoxing.unsafeGetObject(this.getIndexedLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)slot * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, condition, OBJECT_LOCATION);
    }

    @Override
    public void setObject(int slot, Object value) {
        this.verifyIndexedSet(slot, (byte)0);
        FrameWithoutBoxing.unsafePutObject(this.getIndexedLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)slot * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, value, OBJECT_LOCATION);
    }

    @Override
    public byte getByte(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)6);
        return (byte)FrameWithoutBoxing.unsafeGetInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    @Override
    public void setByte(int slot, byte value) {
        this.verifyIndexedSet(slot, (byte)6);
        FrameWithoutBoxing.unsafePutInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value, PRIMITIVE_LOCATION);
    }

    @Override
    public boolean getBoolean(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)5);
        return FrameWithoutBoxing.unsafeGetInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION) != 0;
    }

    @Override
    public void setBoolean(int slot, boolean value) {
        this.verifyIndexedSet(slot, (byte)5);
        FrameWithoutBoxing.unsafePutInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value ? 1 : 0, PRIMITIVE_LOCATION);
    }

    @Override
    public float getFloat(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)4);
        return FrameWithoutBoxing.unsafeGetFloat(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    @Override
    public void setFloat(int slot, float value) {
        this.verifyIndexedSet(slot, (byte)4);
        FrameWithoutBoxing.unsafePutFloat(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value, PRIMITIVE_LOCATION);
    }

    @Override
    public long getLong(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)1);
        return FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    @Override
    public void setLong(int slot, long value) {
        this.verifyIndexedSet(slot, (byte)1);
        FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value, PRIMITIVE_LOCATION);
    }

    @Override
    public int getInt(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)2);
        return FrameWithoutBoxing.unsafeGetInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    @Override
    public void setInt(int slot, int value) {
        this.verifyIndexedSet(slot, (byte)2);
        FrameWithoutBoxing.unsafePutInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value, PRIMITIVE_LOCATION);
    }

    @Override
    public double getDouble(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)3);
        return FrameWithoutBoxing.unsafeGetDouble(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    @Override
    public void setDouble(int slot, double value) {
        this.verifyIndexedSet(slot, (byte)3);
        FrameWithoutBoxing.unsafePutDouble(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value, PRIMITIVE_LOCATION);
    }

    @Override
    public void copy(int srcSlot, int destSlot) {
        byte tag = this.getIndexedTagChecked(srcSlot);
        Object value = FrameWithoutBoxing.unsafeGetObject(this.getIndexedLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)srcSlot * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, true, OBJECT_LOCATION);
        this.verifyIndexedSet(destSlot, tag);
        FrameWithoutBoxing.unsafePutObject(this.getIndexedLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)destSlot * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, value, OBJECT_LOCATION);
        long primitiveValue = FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(srcSlot), true, PRIMITIVE_LOCATION);
        FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(destSlot), primitiveValue, PRIMITIVE_LOCATION);
    }

    @Override
    public void swap(int first, int second) {
        byte firstTag = this.getIndexedTagChecked(first);
        Object firstValue = FrameWithoutBoxing.unsafeGetObject(this.getIndexedLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)first * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, true, OBJECT_LOCATION);
        long firstPrimitiveValue = FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(first), true, PRIMITIVE_LOCATION);
        byte secondTag = this.getIndexedTagChecked(second);
        Object secondValue = FrameWithoutBoxing.unsafeGetObject(this.getIndexedLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)second * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, true, OBJECT_LOCATION);
        long secondPrimitiveValue = FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(second), true, PRIMITIVE_LOCATION);
        this.verifyIndexedSet(first, secondTag);
        this.verifyIndexedSet(second, firstTag);
        FrameWithoutBoxing.unsafePutObject(this.getIndexedLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)first * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, secondValue, OBJECT_LOCATION);
        FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(first), secondPrimitiveValue, PRIMITIVE_LOCATION);
        FrameWithoutBoxing.unsafePutObject(this.getIndexedLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)second * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, firstValue, OBJECT_LOCATION);
        FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(second), firstPrimitiveValue, PRIMITIVE_LOCATION);
    }

    private void verifyIndexedSet(int slot, byte tag) {
        this.getIndexedTags()[slot] = tag;
    }

    private boolean verifyIndexedGet(int slot, byte expectedTag) throws FrameSlotTypeException {
        boolean condition;
        byte actualTag = this.getIndexedTagChecked(slot);
        boolean bl = condition = actualTag == expectedTag;
        if (!condition) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw FrameWithoutBoxing.frameSlotTypeException();
        }
        return condition;
    }

    private byte getIndexedTagChecked(int slot) {
        return this.getIndexedTags()[slot];
    }

    @Override
    public boolean isObject(int slot) {
        return this.getTag(slot) == 0;
    }

    @Override
    public boolean isByte(int slot) {
        return this.getTag(slot) == 6;
    }

    @Override
    public boolean isBoolean(int slot) {
        return this.getTag(slot) == 5;
    }

    @Override
    public boolean isInt(int slot) {
        return this.getTag(slot) == 2;
    }

    @Override
    public boolean isLong(int slot) {
        return this.getTag(slot) == 1;
    }

    @Override
    public boolean isFloat(int slot) {
        return this.getTag(slot) == 4;
    }

    @Override
    public boolean isDouble(int slot) {
        return this.getTag(slot) == 3;
    }

    @Override
    public void clear(int slot) {
        this.verifyIndexedSet(slot, (byte)7);
        FrameWithoutBoxing.unsafePutObject(this.getIndexedLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)slot * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, null, OBJECT_LOCATION);
        if (CompilerDirectives.inCompiledCode()) {
            FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), 0L, PRIMITIVE_LOCATION);
        }
    }

    @Override
    public void setAuxiliarySlot(int slot, Object value) {
        if (this.auxiliarySlots.length <= slot) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.auxiliarySlots = Arrays.copyOf(this.auxiliarySlots, this.descriptor.getNumberOfAuxiliarySlots());
        }
        this.auxiliarySlots[slot] = value;
    }

    @Override
    public Object getAuxiliarySlot(int slot) {
        return slot < this.auxiliarySlots.length ? this.auxiliarySlots[slot] : null;
    }

    static {
        assert (0 == FrameSlotKind.Object.tag);
        assert (7 == FrameSlotKind.Illegal.tag);
        assert (1 == FrameSlotKind.Long.tag);
        assert (2 == FrameSlotKind.Int.tag);
        assert (3 == FrameSlotKind.Double.tag);
        assert (4 == FrameSlotKind.Float.tag);
        assert (5 == FrameSlotKind.Boolean.tag);
        assert (6 == FrameSlotKind.Byte.tag);
    }
}

