// CheckStyle: start generated
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TStringOpsNodes.CalculateHashCodeNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.IndexOfAnyCharNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.IndexOfAnyIntNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawArrayCopyBytesNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawArrayCopyNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawEqualsNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawLastIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawLastIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawMemCmpBytesNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawMemCmpNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawReadValueNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawRegionEqualsNode;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.Lock;

@GeneratedBy(TStringOpsNodes.class)
final class TStringOpsNodesFactory {

    @GeneratedBy(RawReadValueNode.class)
    static final class RawReadValueNodeGen extends RawReadValueNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CachedData cached_cache;

        private RawReadValueNodeGen() {
        }

        @ExplodeLoop
        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, int, int) */) {
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_)) {
                        return RawReadValueNode.cached(arg0Value, arg1Value, arg2Value, s0_.cachedStrideA_);
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                CachedData s0_ = this.cached_cache;
                if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, int, int) */) {
                    while (s0_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_)) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    {
                        int cachedStrideA__ = (TStringGuards.stride(arg0Value));
                        if ((TStringGuards.stride(arg0Value) == cachedStrideA__) && count0_ < (9)) {
                            s0_ = new CachedData(cached_cache);
                            s0_.cachedStrideA_ = cachedStrideA__;
                            VarHandle.storeStoreFence();
                            this.cached_cache = s0_;
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 cached(AbstractTruffleString, Object, int, int) */;
                        }
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return RawReadValueNode.cached(arg0Value, arg1Value, arg2Value, s0_.cachedStrideA_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RawReadValueNode create() {
            return new RawReadValueNodeGen();
        }

        public static RawReadValueNode getUncached() {
            return RawReadValueNodeGen.UNCACHED;
        }

        @GeneratedBy(RawReadValueNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideA_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawReadValueNode.class)
        private static final class Uncached extends RawReadValueNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value) {
                if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value)))) {
                    return RawReadValueNode.cached(arg0Value, arg1Value, arg2Value, (TStringGuards.stride(arg0Value)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(IndexOfAnyCharNode.class)
    static final class IndexOfAnyCharNodeGen extends IndexOfAnyCharNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_0_;

        private IndexOfAnyCharNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, char[] arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 stride0(AbstractTruffleString, Object, int, int, char[]) || stride0MultiValue(AbstractTruffleString, Object, int, int, char[]) || stride1(AbstractTruffleString, Object, int, int, char[]) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 stride0(AbstractTruffleString, Object, int, int, char[]) */) {
                    if ((TStringGuards.isStride0(arg0Value)) && (arg4Value.length == 1)) {
                        return stride0(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 stride0MultiValue(AbstractTruffleString, Object, int, int, char[]) */) {
                    if ((TStringGuards.isStride0(arg0Value)) && (arg4Value.length > 1)) {
                        return stride0MultiValue(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 stride1(AbstractTruffleString, Object, int, int, char[]) */) {
                    if ((TStringGuards.isStride1(arg0Value))) {
                        return stride1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, char[] arg4Value) {
            int state_0 = this.state_0_;
            if ((TStringGuards.isStride0(arg0Value)) && (arg4Value.length == 1)) {
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 stride0(AbstractTruffleString, Object, int, int, char[]) */;
                return stride0(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
            if ((TStringGuards.isStride0(arg0Value)) && (arg4Value.length > 1)) {
                this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 stride0MultiValue(AbstractTruffleString, Object, int, int, char[]) */;
                return stride0MultiValue(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
            if ((TStringGuards.isStride1(arg0Value))) {
                this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 stride1(AbstractTruffleString, Object, int, int, char[]) */;
                return stride1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static IndexOfAnyCharNode create() {
            return new IndexOfAnyCharNodeGen();
        }

        public static IndexOfAnyCharNode getUncached() {
            return IndexOfAnyCharNodeGen.UNCACHED;
        }

        @GeneratedBy(IndexOfAnyCharNode.class)
        private static final class Uncached extends IndexOfAnyCharNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, char[] arg4Value) {
                if ((TStringGuards.isStride0(arg0Value)) && (arg4Value.length == 1)) {
                    return stride0(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if ((TStringGuards.isStride0(arg0Value)) && (arg4Value.length > 1)) {
                    return stride0MultiValue(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if ((TStringGuards.isStride1(arg0Value))) {
                    return stride1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(IndexOfAnyIntNode.class)
    static final class IndexOfAnyIntNodeGen extends IndexOfAnyIntNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_0_;

        private IndexOfAnyIntNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int[] arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 stride0(AbstractTruffleString, Object, int, int, int[]) || stride0MultiValue(AbstractTruffleString, Object, int, int, int[]) || stride1(AbstractTruffleString, Object, int, int, int[]) || stride1MultiValue(AbstractTruffleString, Object, int, int, int[]) || stride2(AbstractTruffleString, Object, int, int, int[]) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 stride0(AbstractTruffleString, Object, int, int, int[]) */) {
                    if ((TStringGuards.isStride0(arg0Value)) && (arg4Value.length == 1)) {
                        return stride0(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 stride0MultiValue(AbstractTruffleString, Object, int, int, int[]) */) {
                    if ((TStringGuards.isStride0(arg0Value)) && (arg4Value.length > 1)) {
                        return stride0MultiValue(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 stride1(AbstractTruffleString, Object, int, int, int[]) */) {
                    if ((TStringGuards.isStride1(arg0Value)) && (arg4Value.length == 1)) {
                        return stride1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 stride1MultiValue(AbstractTruffleString, Object, int, int, int[]) */) {
                    if ((TStringGuards.isStride1(arg0Value)) && (arg4Value.length > 1)) {
                        return stride1MultiValue(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is-state_0 stride2(AbstractTruffleString, Object, int, int, int[]) */) {
                    if ((TStringGuards.isStride2(arg0Value))) {
                        return stride2(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int[] arg4Value) {
            int state_0 = this.state_0_;
            if ((TStringGuards.isStride0(arg0Value)) && (arg4Value.length == 1)) {
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 stride0(AbstractTruffleString, Object, int, int, int[]) */;
                return stride0(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
            if ((TStringGuards.isStride0(arg0Value)) && (arg4Value.length > 1)) {
                this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 stride0MultiValue(AbstractTruffleString, Object, int, int, int[]) */;
                return stride0MultiValue(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
            if ((TStringGuards.isStride1(arg0Value)) && (arg4Value.length == 1)) {
                this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 stride1(AbstractTruffleString, Object, int, int, int[]) */;
                return stride1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
            if ((TStringGuards.isStride1(arg0Value)) && (arg4Value.length > 1)) {
                this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 stride1MultiValue(AbstractTruffleString, Object, int, int, int[]) */;
                return stride1MultiValue(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
            if ((TStringGuards.isStride2(arg0Value))) {
                this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 stride2(AbstractTruffleString, Object, int, int, int[]) */;
                return stride2(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static IndexOfAnyIntNode create() {
            return new IndexOfAnyIntNodeGen();
        }

        public static IndexOfAnyIntNode getUncached() {
            return IndexOfAnyIntNodeGen.UNCACHED;
        }

        @GeneratedBy(IndexOfAnyIntNode.class)
        private static final class Uncached extends IndexOfAnyIntNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int[] arg4Value) {
                if ((TStringGuards.isStride0(arg0Value)) && (arg4Value.length == 1)) {
                    return stride0(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if ((TStringGuards.isStride0(arg0Value)) && (arg4Value.length > 1)) {
                    return stride0MultiValue(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if ((TStringGuards.isStride1(arg0Value)) && (arg4Value.length == 1)) {
                    return stride1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if ((TStringGuards.isStride1(arg0Value)) && (arg4Value.length > 1)) {
                    return stride1MultiValue(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if ((TStringGuards.isStride2(arg0Value))) {
                    return stride2(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RawIndexOfCodePointNode.class)
    static final class RawIndexOfCodePointNodeGen extends RawIndexOfCodePointNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CachedData cached_cache;

        private RawIndexOfCodePointNodeGen() {
        }

        @ExplodeLoop
        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, int, int, int, int) */) {
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_)) {
                        return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedStrideA_);
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                CachedData s0_ = this.cached_cache;
                if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, int, int, int, int) */) {
                    while (s0_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_)) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    {
                        int cachedStrideA__ = (TStringGuards.stride(arg0Value));
                        if ((TStringGuards.stride(arg0Value) == cachedStrideA__) && count0_ < (9)) {
                            s0_ = new CachedData(cached_cache);
                            s0_.cachedStrideA_ = cachedStrideA__;
                            VarHandle.storeStoreFence();
                            this.cached_cache = s0_;
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 cached(AbstractTruffleString, Object, int, int, int, int) */;
                        }
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedStrideA_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RawIndexOfCodePointNode create() {
            return new RawIndexOfCodePointNodeGen();
        }

        public static RawIndexOfCodePointNode getUncached() {
            return RawIndexOfCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(RawIndexOfCodePointNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideA_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawIndexOfCodePointNode.class)
        private static final class Uncached extends RawIndexOfCodePointNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value) {
                if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value)))) {
                    return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (TStringGuards.stride(arg0Value)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RawLastIndexOfCodePointNode.class)
    static final class RawLastIndexOfCodePointNodeGen extends RawLastIndexOfCodePointNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CachedData cached_cache;

        private RawLastIndexOfCodePointNodeGen() {
        }

        @ExplodeLoop
        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, int, int, int, int) */) {
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_)) {
                        return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedStrideA_);
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                CachedData s0_ = this.cached_cache;
                if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, int, int, int, int) */) {
                    while (s0_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_)) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    {
                        int cachedStrideA__ = (TStringGuards.stride(arg0Value));
                        if ((TStringGuards.stride(arg0Value) == cachedStrideA__) && count0_ < (9)) {
                            s0_ = new CachedData(cached_cache);
                            s0_.cachedStrideA_ = cachedStrideA__;
                            VarHandle.storeStoreFence();
                            this.cached_cache = s0_;
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 cached(AbstractTruffleString, Object, int, int, int, int) */;
                        }
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.cachedStrideA_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RawLastIndexOfCodePointNode create() {
            return new RawLastIndexOfCodePointNodeGen();
        }

        public static RawLastIndexOfCodePointNode getUncached() {
            return RawLastIndexOfCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(RawLastIndexOfCodePointNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideA_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawLastIndexOfCodePointNode.class)
        private static final class Uncached extends RawLastIndexOfCodePointNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value) {
                if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value)))) {
                    return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (TStringGuards.stride(arg0Value)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RawIndexOfStringNode.class)
    static final class RawIndexOfStringNodeGen extends RawIndexOfStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CachedLen1Data cachedLen1_cache;
        @CompilationFinal private CachedData cached_cache;

        private RawIndexOfStringNodeGen() {
        }

        @ExplodeLoop
        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value, int arg4Value, int arg5Value, byte[] arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 cachedLen1(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) || cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 cachedLen1(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */ && (TStringGuards.length(arg2Value) == 1)) {
                    CachedLen1Data s0_ = this.cachedLen1_cache;
                    while (s0_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s0_.cachedStrideB_)) {
                            return cachedLen1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedStrideA_, s0_.cachedStrideB_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */ && (TStringGuards.length(arg2Value) > 1)) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s1_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s1_.cachedStrideB_)) {
                            return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.cachedStrideA_, s1_.cachedStrideB_);
                        }
                        s1_ = s1_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value, int arg4Value, int arg5Value, byte[] arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.length(arg2Value) == 1)) {
                    int count0_ = 0;
                    CachedLen1Data s0_ = this.cachedLen1_cache;
                    if ((state_0 & 0b1) != 0 /* is-state_0 cachedLen1(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */) {
                        while (s0_ != null) {
                            if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s0_.cachedStrideB_)) {
                                break;
                            }
                            s0_ = s0_.next_;
                            count0_++;
                        }
                    }
                    if (s0_ == null) {
                        {
                            int cachedStrideA__ = (TStringGuards.stride(arg0Value));
                            if ((TStringGuards.stride(arg0Value) == cachedStrideA__)) {
                                int cachedStrideB__ = (TStringGuards.stride(arg2Value));
                                if ((TStringGuards.stride(arg2Value) == cachedStrideB__) && count0_ < (9)) {
                                    s0_ = new CachedLen1Data(cachedLen1_cache);
                                    s0_.cachedStrideA_ = cachedStrideA__;
                                    s0_.cachedStrideB_ = cachedStrideB__;
                                    VarHandle.storeStoreFence();
                                    this.cachedLen1_cache = s0_;
                                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 cachedLen1(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */;
                                }
                            }
                        }
                    }
                    if (s0_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return cachedLen1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedStrideA_, s0_.cachedStrideB_);
                    }
                }
                if ((TStringGuards.length(arg2Value) > 1)) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state_0 & 0b10) != 0 /* is-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */) {
                        while (s1_ != null) {
                            if ((TStringGuards.stride(arg0Value) == s1_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s1_.cachedStrideB_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        {
                            int cachedStrideA__1 = (TStringGuards.stride(arg0Value));
                            if ((TStringGuards.stride(arg0Value) == cachedStrideA__1)) {
                                int cachedStrideB__1 = (TStringGuards.stride(arg2Value));
                                if ((TStringGuards.stride(arg2Value) == cachedStrideB__1) && count1_ < (9)) {
                                    s1_ = new CachedData(cached_cache);
                                    s1_.cachedStrideA_ = cachedStrideA__1;
                                    s1_.cachedStrideB_ = cachedStrideB__1;
                                    VarHandle.storeStoreFence();
                                    this.cached_cache = s1_;
                                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */;
                                }
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.cachedStrideA_, s1_.cachedStrideB_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedLen1Data s0_ = this.cachedLen1_cache;
                    CachedData s1_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null) && (s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RawIndexOfStringNode create() {
            return new RawIndexOfStringNodeGen();
        }

        public static RawIndexOfStringNode getUncached() {
            return RawIndexOfStringNodeGen.UNCACHED;
        }

        @GeneratedBy(RawIndexOfStringNode.class)
        private static final class CachedLen1Data {

            @CompilationFinal CachedLen1Data next_;
            @CompilationFinal int cachedStrideA_;
            @CompilationFinal int cachedStrideB_;

            CachedLen1Data(CachedLen1Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawIndexOfStringNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideA_;
            @CompilationFinal int cachedStrideB_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawIndexOfStringNode.class)
        private static final class Uncached extends RawIndexOfStringNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value, int arg4Value, int arg5Value, byte[] arg6Value) {
                if ((TStringGuards.length(arg2Value) == 1)) {
                    if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value))) && (TStringGuards.stride(arg2Value) == (TStringGuards.stride(arg2Value)))) {
                        return cachedLen1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (TStringGuards.stride(arg0Value)), (TStringGuards.stride(arg2Value)));
                    }
                }
                if ((TStringGuards.length(arg2Value) > 1)) {
                    if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value))) && (TStringGuards.stride(arg2Value) == (TStringGuards.stride(arg2Value)))) {
                        return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (TStringGuards.stride(arg0Value)), (TStringGuards.stride(arg2Value)));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RawLastIndexOfStringNode.class)
    static final class RawLastIndexOfStringNodeGen extends RawLastIndexOfStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CachedLen1Data cachedLen1_cache;
        @CompilationFinal private CachedData cached_cache;

        private RawLastIndexOfStringNodeGen() {
        }

        @ExplodeLoop
        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value, int arg4Value, int arg5Value, byte[] arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 cachedLen1(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) || cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 cachedLen1(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */ && (TStringGuards.length(arg2Value) == 1)) {
                    CachedLen1Data s0_ = this.cachedLen1_cache;
                    while (s0_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s0_.cachedStrideB_)) {
                            return cachedLen1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedStrideA_, s0_.cachedStrideB_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */ && (TStringGuards.length(arg2Value) > 1)) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s1_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s1_.cachedStrideB_)) {
                            return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.cachedStrideA_, s1_.cachedStrideB_);
                        }
                        s1_ = s1_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value, int arg4Value, int arg5Value, byte[] arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.length(arg2Value) == 1)) {
                    int count0_ = 0;
                    CachedLen1Data s0_ = this.cachedLen1_cache;
                    if ((state_0 & 0b1) != 0 /* is-state_0 cachedLen1(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */) {
                        while (s0_ != null) {
                            if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s0_.cachedStrideB_)) {
                                break;
                            }
                            s0_ = s0_.next_;
                            count0_++;
                        }
                    }
                    if (s0_ == null) {
                        {
                            int cachedStrideA__ = (TStringGuards.stride(arg0Value));
                            if ((TStringGuards.stride(arg0Value) == cachedStrideA__)) {
                                int cachedStrideB__ = (TStringGuards.stride(arg2Value));
                                if ((TStringGuards.stride(arg2Value) == cachedStrideB__) && count0_ < (9)) {
                                    s0_ = new CachedLen1Data(cachedLen1_cache);
                                    s0_.cachedStrideA_ = cachedStrideA__;
                                    s0_.cachedStrideB_ = cachedStrideB__;
                                    VarHandle.storeStoreFence();
                                    this.cachedLen1_cache = s0_;
                                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 cachedLen1(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */;
                                }
                            }
                        }
                    }
                    if (s0_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return cachedLen1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedStrideA_, s0_.cachedStrideB_);
                    }
                }
                if ((TStringGuards.length(arg2Value) > 1)) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state_0 & 0b10) != 0 /* is-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */) {
                        while (s1_ != null) {
                            if ((TStringGuards.stride(arg0Value) == s1_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s1_.cachedStrideB_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        {
                            int cachedStrideA__1 = (TStringGuards.stride(arg0Value));
                            if ((TStringGuards.stride(arg0Value) == cachedStrideA__1)) {
                                int cachedStrideB__1 = (TStringGuards.stride(arg2Value));
                                if ((TStringGuards.stride(arg2Value) == cachedStrideB__1) && count1_ < (9)) {
                                    s1_ = new CachedData(cached_cache);
                                    s1_.cachedStrideA_ = cachedStrideA__1;
                                    s1_.cachedStrideB_ = cachedStrideB__1;
                                    VarHandle.storeStoreFence();
                                    this.cached_cache = s1_;
                                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, byte[], int, int) */;
                                }
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.cachedStrideA_, s1_.cachedStrideB_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedLen1Data s0_ = this.cachedLen1_cache;
                    CachedData s1_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null) && (s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RawLastIndexOfStringNode create() {
            return new RawLastIndexOfStringNodeGen();
        }

        public static RawLastIndexOfStringNode getUncached() {
            return RawLastIndexOfStringNodeGen.UNCACHED;
        }

        @GeneratedBy(RawLastIndexOfStringNode.class)
        private static final class CachedLen1Data {

            @CompilationFinal CachedLen1Data next_;
            @CompilationFinal int cachedStrideA_;
            @CompilationFinal int cachedStrideB_;

            CachedLen1Data(CachedLen1Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawLastIndexOfStringNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideA_;
            @CompilationFinal int cachedStrideB_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawLastIndexOfStringNode.class)
        private static final class Uncached extends RawLastIndexOfStringNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value, int arg4Value, int arg5Value, byte[] arg6Value) {
                if ((TStringGuards.length(arg2Value) == 1)) {
                    if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value))) && (TStringGuards.stride(arg2Value) == (TStringGuards.stride(arg2Value)))) {
                        return cachedLen1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (TStringGuards.stride(arg0Value)), (TStringGuards.stride(arg2Value)));
                    }
                }
                if ((TStringGuards.length(arg2Value) > 1)) {
                    if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value))) && (TStringGuards.stride(arg2Value) == (TStringGuards.stride(arg2Value)))) {
                        return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (TStringGuards.stride(arg0Value)), (TStringGuards.stride(arg2Value)));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RawRegionEqualsNode.class)
    static final class RawRegionEqualsNodeGen extends RawRegionEqualsNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CachedData cached_cache;

        private RawRegionEqualsNodeGen() {
        }

        @ExplodeLoop
        @Override
        boolean execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value, int arg4Value, int arg5Value, int arg6Value, byte[] arg7Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, int, byte[], int, int) */) {
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s0_.cachedStrideB_)) {
                        return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, s0_.cachedStrideA_, s0_.cachedStrideB_);
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
        }

        private boolean executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value, int arg4Value, int arg5Value, int arg6Value, byte[] arg7Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                CachedData s0_ = this.cached_cache;
                if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, int, byte[], int, int) */) {
                    while (s0_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s0_.cachedStrideB_)) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    {
                        int cachedStrideA__ = (TStringGuards.stride(arg0Value));
                        if ((TStringGuards.stride(arg0Value) == cachedStrideA__)) {
                            int cachedStrideB__ = (TStringGuards.stride(arg2Value));
                            if ((TStringGuards.stride(arg2Value) == cachedStrideB__) && count0_ < (9)) {
                                s0_ = new CachedData(cached_cache);
                                s0_.cachedStrideA_ = cachedStrideA__;
                                s0_.cachedStrideB_ = cachedStrideB__;
                                VarHandle.storeStoreFence();
                                this.cached_cache = s0_;
                                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int, int, byte[], int, int) */;
                            }
                        }
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, s0_.cachedStrideA_, s0_.cachedStrideB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RawRegionEqualsNode create() {
            return new RawRegionEqualsNodeGen();
        }

        public static RawRegionEqualsNode getUncached() {
            return RawRegionEqualsNodeGen.UNCACHED;
        }

        @GeneratedBy(RawRegionEqualsNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideA_;
            @CompilationFinal int cachedStrideB_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawRegionEqualsNode.class)
        private static final class Uncached extends RawRegionEqualsNode {

            @TruffleBoundary
            @Override
            boolean execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value, int arg4Value, int arg5Value, int arg6Value, byte[] arg7Value) {
                if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value))) && (TStringGuards.stride(arg2Value) == (TStringGuards.stride(arg2Value)))) {
                    return cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (TStringGuards.stride(arg0Value)), (TStringGuards.stride(arg2Value)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RawEqualsNode.class)
    static final class RawEqualsNodeGen extends RawEqualsNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CachedData cached_cache;

        private RawEqualsNodeGen() {
        }

        @ExplodeLoop
        @Override
        boolean execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int) */) {
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s0_.cachedStrideB_)) {
                        return cached(arg0Value, arg1Value, arg2Value, arg3Value, s0_.cachedStrideA_, s0_.cachedStrideB_);
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private boolean executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                CachedData s0_ = this.cached_cache;
                if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int) */) {
                    while (s0_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s0_.cachedStrideB_)) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    {
                        int cachedStrideA__ = (TStringGuards.stride(arg0Value));
                        if ((TStringGuards.stride(arg0Value) == cachedStrideA__)) {
                            int cachedStrideB__ = (TStringGuards.stride(arg2Value));
                            if ((TStringGuards.stride(arg2Value) == cachedStrideB__) && count0_ < (9)) {
                                s0_ = new CachedData(cached_cache);
                                s0_.cachedStrideA_ = cachedStrideA__;
                                s0_.cachedStrideB_ = cachedStrideB__;
                                VarHandle.storeStoreFence();
                                this.cached_cache = s0_;
                                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int) */;
                            }
                        }
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return cached(arg0Value, arg1Value, arg2Value, arg3Value, s0_.cachedStrideA_, s0_.cachedStrideB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RawEqualsNode create() {
            return new RawEqualsNodeGen();
        }

        public static RawEqualsNode getUncached() {
            return RawEqualsNodeGen.UNCACHED;
        }

        @GeneratedBy(RawEqualsNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideA_;
            @CompilationFinal int cachedStrideB_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawEqualsNode.class)
        private static final class Uncached extends RawEqualsNode {

            @TruffleBoundary
            @Override
            boolean execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value) {
                if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value))) && (TStringGuards.stride(arg2Value) == (TStringGuards.stride(arg2Value)))) {
                    return cached(arg0Value, arg1Value, arg2Value, arg3Value, (TStringGuards.stride(arg0Value)), (TStringGuards.stride(arg2Value)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RawMemCmpNode.class)
    static final class RawMemCmpNodeGen extends RawMemCmpNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CachedData cached_cache;

        private RawMemCmpNodeGen() {
        }

        @ExplodeLoop
        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int) */) {
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s0_.cachedStrideB_)) {
                        return cached(arg0Value, arg1Value, arg2Value, arg3Value, s0_.cachedStrideA_, s0_.cachedStrideB_);
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                CachedData s0_ = this.cached_cache;
                if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int) */) {
                    while (s0_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s0_.cachedStrideB_)) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    {
                        int cachedStrideA__ = (TStringGuards.stride(arg0Value));
                        if ((TStringGuards.stride(arg0Value) == cachedStrideA__)) {
                            int cachedStrideB__ = (TStringGuards.stride(arg2Value));
                            if ((TStringGuards.stride(arg2Value) == cachedStrideB__) && count0_ < (9)) {
                                s0_ = new CachedData(cached_cache);
                                s0_.cachedStrideA_ = cachedStrideA__;
                                s0_.cachedStrideB_ = cachedStrideB__;
                                VarHandle.storeStoreFence();
                                this.cached_cache = s0_;
                                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int) */;
                            }
                        }
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return cached(arg0Value, arg1Value, arg2Value, arg3Value, s0_.cachedStrideA_, s0_.cachedStrideB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RawMemCmpNode create() {
            return new RawMemCmpNodeGen();
        }

        public static RawMemCmpNode getUncached() {
            return RawMemCmpNodeGen.UNCACHED;
        }

        @GeneratedBy(RawMemCmpNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideA_;
            @CompilationFinal int cachedStrideB_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawMemCmpNode.class)
        private static final class Uncached extends RawMemCmpNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value) {
                if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value))) && (TStringGuards.stride(arg2Value) == (TStringGuards.stride(arg2Value)))) {
                    return cached(arg0Value, arg1Value, arg2Value, arg3Value, (TStringGuards.stride(arg0Value)), (TStringGuards.stride(arg2Value)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RawMemCmpBytesNode.class)
    static final class RawMemCmpBytesNodeGen extends RawMemCmpBytesNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CachedData cached_cache;

        private RawMemCmpBytesNodeGen() {
        }

        @ExplodeLoop
        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int) */) {
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s0_.cachedStrideB_)) {
                        return cached(arg0Value, arg1Value, arg2Value, arg3Value, s0_.cachedStrideA_, s0_.cachedStrideB_);
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                CachedData s0_ = this.cached_cache;
                if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int) */) {
                    while (s0_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (TStringGuards.stride(arg2Value) == s0_.cachedStrideB_)) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    {
                        int cachedStrideA__ = (TStringGuards.stride(arg0Value));
                        if ((TStringGuards.stride(arg0Value) == cachedStrideA__)) {
                            int cachedStrideB__ = (TStringGuards.stride(arg2Value));
                            if ((TStringGuards.stride(arg2Value) == cachedStrideB__) && count0_ < (9)) {
                                s0_ = new CachedData(cached_cache);
                                s0_.cachedStrideA_ = cachedStrideA__;
                                s0_.cachedStrideB_ = cachedStrideB__;
                                VarHandle.storeStoreFence();
                                this.cached_cache = s0_;
                                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 cached(AbstractTruffleString, Object, AbstractTruffleString, Object, int, int) */;
                            }
                        }
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return cached(arg0Value, arg1Value, arg2Value, arg3Value, s0_.cachedStrideA_, s0_.cachedStrideB_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RawMemCmpBytesNode create() {
            return new RawMemCmpBytesNodeGen();
        }

        public static RawMemCmpBytesNode getUncached() {
            return RawMemCmpBytesNodeGen.UNCACHED;
        }

        @GeneratedBy(RawMemCmpBytesNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideA_;
            @CompilationFinal int cachedStrideB_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawMemCmpBytesNode.class)
        private static final class Uncached extends RawMemCmpBytesNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value, AbstractTruffleString arg2Value, Object arg3Value) {
                if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value))) && (TStringGuards.stride(arg2Value) == (TStringGuards.stride(arg2Value)))) {
                    return cached(arg0Value, arg1Value, arg2Value, arg3Value, (TStringGuards.stride(arg0Value)), (TStringGuards.stride(arg2Value)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RawArrayCopyNode.class)
    static final class RawArrayCopyNodeGen extends RawArrayCopyNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CachedData cached_cache;

        private RawArrayCopyNodeGen() {
        }

        @ExplodeLoop
        @Override
        void execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, byte[] arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, int, byte[], int, int, int, int, int) */) {
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (arg5Value == s0_.cachedStrideDst_)) {
                        cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedStrideA_, s0_.cachedStrideDst_);
                        return;
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            return;
        }

        private void executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, byte[] arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                CachedData s0_ = this.cached_cache;
                if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, int, byte[], int, int, int, int, int) */) {
                    while (s0_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_) && (arg5Value == s0_.cachedStrideDst_)) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    {
                        int cachedStrideA__ = (TStringGuards.stride(arg0Value));
                        if ((TStringGuards.stride(arg0Value) == cachedStrideA__)) {
                            // assert (arg5Value == s0_.cachedStrideDst_);
                            if (count0_ < (9)) {
                                s0_ = new CachedData(cached_cache);
                                s0_.cachedStrideA_ = cachedStrideA__;
                                s0_.cachedStrideDst_ = (arg5Value);
                                VarHandle.storeStoreFence();
                                this.cached_cache = s0_;
                                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 cached(AbstractTruffleString, Object, int, byte[], int, int, int, int, int) */;
                            }
                        }
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedStrideA_, s0_.cachedStrideDst_);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RawArrayCopyNode create() {
            return new RawArrayCopyNodeGen();
        }

        public static RawArrayCopyNode getUncached() {
            return RawArrayCopyNodeGen.UNCACHED;
        }

        @GeneratedBy(RawArrayCopyNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideA_;
            @CompilationFinal int cachedStrideDst_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawArrayCopyNode.class)
        private static final class Uncached extends RawArrayCopyNode {

            @TruffleBoundary
            @Override
            void execute(AbstractTruffleString arg0Value, Object arg1Value, int arg2Value, byte[] arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value)))) {
                    // assert (arg5Value == (arg5Value));
                    cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (TStringGuards.stride(arg0Value)), (arg5Value));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RawArrayCopyBytesNode.class)
    static final class RawArrayCopyBytesNodeGen extends RawArrayCopyBytesNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CachedData cached_cache;

        private RawArrayCopyBytesNodeGen() {
        }

        @ExplodeLoop
        @Override
        void execute(Object arg0Value, int arg1Value, int arg2Value, byte[] arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 cached(Object, int, int, byte[], int, int, int, int, int) */) {
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if ((arg2Value == s0_.cachedStrideSrc_) && (arg5Value == s0_.cachedStrideDst_)) {
                        cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedStrideSrc_, s0_.cachedStrideDst_);
                        return;
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            return;
        }

        private void executeAndSpecialize(Object arg0Value, int arg1Value, int arg2Value, byte[] arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                CachedData s0_ = this.cached_cache;
                if (state_0 != 0 /* is-state_0 cached(Object, int, int, byte[], int, int, int, int, int) */) {
                    while (s0_ != null) {
                        if ((arg2Value == s0_.cachedStrideSrc_) && (arg5Value == s0_.cachedStrideDst_)) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    // assert (arg2Value == s0_.cachedStrideSrc_);
                    // assert (arg5Value == s0_.cachedStrideDst_);
                    if (count0_ < (9)) {
                        s0_ = new CachedData(cached_cache);
                        s0_.cachedStrideSrc_ = (arg2Value);
                        s0_.cachedStrideDst_ = (arg5Value);
                        VarHandle.storeStoreFence();
                        this.cached_cache = s0_;
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 cached(Object, int, int, byte[], int, int, int, int, int) */;
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.cachedStrideSrc_, s0_.cachedStrideDst_);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static RawArrayCopyBytesNode create() {
            return new RawArrayCopyBytesNodeGen();
        }

        public static RawArrayCopyBytesNode getUncached() {
            return RawArrayCopyBytesNodeGen.UNCACHED;
        }

        @GeneratedBy(RawArrayCopyBytesNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideSrc_;
            @CompilationFinal int cachedStrideDst_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(RawArrayCopyBytesNode.class)
        private static final class Uncached extends RawArrayCopyBytesNode {

            @TruffleBoundary
            @Override
            void execute(Object arg0Value, int arg1Value, int arg2Value, byte[] arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                // assert (arg2Value == (arg2Value));
                // assert (arg5Value == (arg5Value));
                cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (arg2Value), (arg5Value));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CalculateHashCodeNode.class)
    static final class CalculateHashCodeNodeGen extends CalculateHashCodeNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CachedData cached_cache;

        private CalculateHashCodeNodeGen() {
        }

        @ExplodeLoop
        @Override
        int execute(AbstractTruffleString arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, int) */) {
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_)) {
                        return cached(arg0Value, arg1Value, s0_.cachedStrideA_);
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                CachedData s0_ = this.cached_cache;
                if (state_0 != 0 /* is-state_0 cached(AbstractTruffleString, Object, int) */) {
                    while (s0_ != null) {
                        if ((TStringGuards.stride(arg0Value) == s0_.cachedStrideA_)) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    {
                        int cachedStrideA__ = (TStringGuards.stride(arg0Value));
                        if ((TStringGuards.stride(arg0Value) == cachedStrideA__) && count0_ < (9)) {
                            s0_ = new CachedData(cached_cache);
                            s0_.cachedStrideA_ = cachedStrideA__;
                            VarHandle.storeStoreFence();
                            this.cached_cache = s0_;
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 cached(AbstractTruffleString, Object, int) */;
                        }
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return cached(arg0Value, arg1Value, s0_.cachedStrideA_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CalculateHashCodeNode create() {
            return new CalculateHashCodeNodeGen();
        }

        public static CalculateHashCodeNode getUncached() {
            return CalculateHashCodeNodeGen.UNCACHED;
        }

        @GeneratedBy(CalculateHashCodeNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideA_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(CalculateHashCodeNode.class)
        private static final class Uncached extends CalculateHashCodeNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, Object arg1Value) {
                if ((TStringGuards.stride(arg0Value) == (TStringGuards.stride(arg0Value)))) {
                    return cached(arg0Value, arg1Value, (TStringGuards.stride(arg0Value)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
