// CheckStyle: start generated
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.strings.MutableTruffleString.AsManagedNode;
import com.oracle.truffle.api.strings.MutableTruffleString.AsMutableTruffleStringNode;
import com.oracle.truffle.api.strings.MutableTruffleString.CalcLazyAttributesNode;
import com.oracle.truffle.api.strings.MutableTruffleString.ConcatNode;
import com.oracle.truffle.api.strings.MutableTruffleString.ForceEncodingNode;
import com.oracle.truffle.api.strings.MutableTruffleString.FromByteArrayNode;
import com.oracle.truffle.api.strings.MutableTruffleString.FromNativePointerNode;
import com.oracle.truffle.api.strings.MutableTruffleString.SubstringByteIndexNode;
import com.oracle.truffle.api.strings.MutableTruffleString.SubstringNode;
import com.oracle.truffle.api.strings.MutableTruffleString.WriteByteNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointIndexToRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ConcatMaterializeBytesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodePointLengthNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.CodePointIndexToRawNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.ConcatMaterializeBytesNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodePointLengthNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen;
import com.oracle.truffle.api.strings.TruffleString.CopyToByteArrayNode;
import com.oracle.truffle.api.strings.TruffleString.Encoding;
import com.oracle.truffle.api.strings.TruffleString.ToIndexableNode;
import com.oracle.truffle.api.strings.TruffleStringFactory.ToIndexableNodeGen;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.Lock;

@GeneratedBy(MutableTruffleString.class)
public final class MutableTruffleStringFactory {

    @GeneratedBy(FromByteArrayNode.class)
    static final class FromByteArrayNodeGen extends FromByteArrayNode {

        private static final Uncached UNCACHED = new Uncached();

        private FromByteArrayNodeGen() {
        }

        @Override
        public MutableTruffleString execute(byte[] arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            return FromByteArrayNode.fromByteArray(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public static FromByteArrayNode create() {
            return new FromByteArrayNodeGen();
        }

        public static FromByteArrayNode getUncached() {
            return FromByteArrayNodeGen.UNCACHED;
        }

        @GeneratedBy(FromByteArrayNode.class)
        @DenyReplace
        private static final class Uncached extends FromByteArrayNode {

            @TruffleBoundary
            @Override
            public MutableTruffleString execute(byte[] arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
                return FromByteArrayNode.fromByteArray(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(FromNativePointerNode.class)
    static final class FromNativePointerNodeGen extends FromNativePointerNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private Node interopLibrary_;

        private FromNativePointerNodeGen() {
        }

        @Override
        public MutableTruffleString execute(Object arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 fromNativePointer(Object, int, int, Encoding, boolean, Node) */) {
                return fromNativePointer(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.interopLibrary_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private MutableTruffleString executeAndSpecialize(Object arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.interopLibrary_ = super.insert((TStringAccessor.createInteropLibrary()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 fromNativePointer(Object, int, int, Encoding, boolean, Node) */;
                lock.unlock();
                hasLock = false;
                return fromNativePointer(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.interopLibrary_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static FromNativePointerNode create() {
            return new FromNativePointerNodeGen();
        }

        public static FromNativePointerNode getUncached() {
            return FromNativePointerNodeGen.UNCACHED;
        }

        @GeneratedBy(FromNativePointerNode.class)
        @DenyReplace
        private static final class Uncached extends FromNativePointerNode {

            @TruffleBoundary
            @Override
            public MutableTruffleString execute(Object arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
                return fromNativePointer(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (TStringAccessor.getUncachedInteropLibrary()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AsMutableTruffleStringNode.class)
    static final class AsMutableTruffleStringNodeGen extends AsMutableTruffleStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CopyToByteArrayNode fromTruffleString_copyToByteArrayNode_;

        private AsMutableTruffleStringNodeGen() {
        }

        @Override
        public MutableTruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 mutable(MutableTruffleString, Encoding) || fromTruffleString(TruffleString, Encoding, CopyToByteArrayNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 mutable(MutableTruffleString, Encoding) */ && arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    return AsMutableTruffleStringNode.mutable(arg0Value_, arg1Value);
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 fromTruffleString(TruffleString, Encoding, CopyToByteArrayNode) */ && arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    return AsMutableTruffleStringNode.fromTruffleString(arg0Value_, arg1Value, this.fromTruffleString_copyToByteArrayNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private MutableTruffleString executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 mutable(MutableTruffleString, Encoding) */;
                    lock.unlock();
                    hasLock = false;
                    return AsMutableTruffleStringNode.mutable(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    this.fromTruffleString_copyToByteArrayNode_ = super.insert((CopyToByteArrayNode.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 fromTruffleString(TruffleString, Encoding, CopyToByteArrayNode) */;
                    lock.unlock();
                    hasLock = false;
                    return AsMutableTruffleStringNode.fromTruffleString(arg0Value_, arg1Value, this.fromTruffleString_copyToByteArrayNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AsMutableTruffleStringNode create() {
            return new AsMutableTruffleStringNodeGen();
        }

        public static AsMutableTruffleStringNode getUncached() {
            return AsMutableTruffleStringNodeGen.UNCACHED;
        }

        @GeneratedBy(AsMutableTruffleStringNode.class)
        @DenyReplace
        private static final class Uncached extends AsMutableTruffleStringNode {

            @TruffleBoundary
            @Override
            public MutableTruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    return AsMutableTruffleStringNode.mutable(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    return AsMutableTruffleStringNode.fromTruffleString(arg0Value_, arg1Value, (CopyToByteArrayNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AsManagedNode.class)
    static final class AsManagedNodeGen extends AsManagedNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CopyToByteArrayNode fromTruffleString_copyToByteArrayNode_;

        private AsManagedNodeGen() {
        }

        @Override
        public MutableTruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 mutable(MutableTruffleString, Encoding) || fromTruffleString(AbstractTruffleString, Encoding, CopyToByteArrayNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 mutable(MutableTruffleString, Encoding) */ && arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((!(arg0Value_.isNative()))) {
                        return AsManagedNode.mutable(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 fromTruffleString(AbstractTruffleString, Encoding, CopyToByteArrayNode) */) {
                    if ((arg0Value.isNative() || arg0Value.isImmutable())) {
                        return AsManagedNode.fromTruffleString(arg0Value, arg1Value, this.fromTruffleString_copyToByteArrayNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private MutableTruffleString executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((!(arg0Value_.isNative()))) {
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 mutable(MutableTruffleString, Encoding) */;
                        lock.unlock();
                        hasLock = false;
                        return AsManagedNode.mutable(arg0Value_, arg1Value);
                    }
                }
                if ((arg0Value.isNative() || arg0Value.isImmutable())) {
                    this.fromTruffleString_copyToByteArrayNode_ = super.insert((CopyToByteArrayNode.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 fromTruffleString(AbstractTruffleString, Encoding, CopyToByteArrayNode) */;
                    lock.unlock();
                    hasLock = false;
                    return AsManagedNode.fromTruffleString(arg0Value, arg1Value, this.fromTruffleString_copyToByteArrayNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AsManagedNode create() {
            return new AsManagedNodeGen();
        }

        public static AsManagedNode getUncached() {
            return AsManagedNodeGen.UNCACHED;
        }

        @GeneratedBy(AsManagedNode.class)
        @DenyReplace
        private static final class Uncached extends AsManagedNode {

            @TruffleBoundary
            @Override
            public MutableTruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((!(arg0Value_.isNative()))) {
                        return AsManagedNode.mutable(arg0Value_, arg1Value);
                    }
                }
                if ((arg0Value.isNative() || arg0Value.isImmutable())) {
                    return AsManagedNode.fromTruffleString(arg0Value, arg1Value, (CopyToByteArrayNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(WriteByteNode.class)
    static final class WriteByteNodeGen extends WriteByteNode {

        private static final Uncached UNCACHED = new Uncached();

        private WriteByteNodeGen() {
        }

        @Override
        public void execute(MutableTruffleString arg0Value, int arg1Value, byte arg2Value, Encoding arg3Value) {
            WriteByteNode.writeByte(arg0Value, arg1Value, arg2Value, arg3Value);
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public static WriteByteNode create() {
            return new WriteByteNodeGen();
        }

        public static WriteByteNode getUncached() {
            return WriteByteNodeGen.UNCACHED;
        }

        @GeneratedBy(WriteByteNode.class)
        @DenyReplace
        private static final class Uncached extends WriteByteNode {

            @TruffleBoundary
            @Override
            public void execute(MutableTruffleString arg0Value, int arg1Value, byte arg2Value, Encoding arg3Value) {
                WriteByteNode.writeByte(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ConcatNode.class)
    static final class ConcatNodeGen extends ConcatNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private ConcatData concat_cache;

        private ConcatNodeGen() {
        }

        @Override
        public MutableTruffleString execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 concat(AbstractTruffleString, AbstractTruffleString, Encoding, ToIndexableNode, ToIndexableNode, ConcatMaterializeBytesNode) */) {
                ConcatData s0_ = this.concat_cache;
                if (s0_ != null) {
                    return ConcatNode.concat(arg0Value, arg1Value, arg2Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.materializeBytesNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private MutableTruffleString executeAndSpecialize(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                ConcatData s0_ = super.insert(new ConcatData());
                s0_.toIndexableNodeA_ = s0_.insertAccessor((ToIndexableNodeGen.create()));
                s0_.toIndexableNodeB_ = s0_.insertAccessor((ToIndexableNodeGen.create()));
                s0_.materializeBytesNode_ = s0_.insertAccessor((ConcatMaterializeBytesNodeGen.create()));
                VarHandle.storeStoreFence();
                this.concat_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 concat(AbstractTruffleString, AbstractTruffleString, Encoding, ToIndexableNode, ToIndexableNode, ConcatMaterializeBytesNode) */;
                lock.unlock();
                hasLock = false;
                return ConcatNode.concat(arg0Value, arg1Value, arg2Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.materializeBytesNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static ConcatNode create() {
            return new ConcatNodeGen();
        }

        public static ConcatNode getUncached() {
            return ConcatNodeGen.UNCACHED;
        }

        @GeneratedBy(ConcatNode.class)
        private static final class ConcatData extends Node {

            @Child ToIndexableNode toIndexableNodeA_;
            @Child ToIndexableNode toIndexableNodeB_;
            @Child ConcatMaterializeBytesNode materializeBytesNode_;

            ConcatData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ConcatNode.class)
        @DenyReplace
        private static final class Uncached extends ConcatNode {

            @TruffleBoundary
            @Override
            public MutableTruffleString execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                return ConcatNode.concat(arg0Value, arg1Value, arg2Value, (ToIndexableNode.getUncached()), (ToIndexableNode.getUncached()), (ConcatMaterializeBytesNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(SubstringNode.class)
    static final class SubstringNodeGen extends SubstringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private SubstringData substring_cache;

        private SubstringNodeGen() {
        }

        @Override
        public MutableTruffleString execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 substring(AbstractTruffleString, int, int, Encoding, ToIndexableNode, GetCodeRangeNode, GetCodePointLengthNode, CodePointIndexToRawNode, CopyToByteArrayNode) */) {
                SubstringData s0_ = this.substring_cache;
                if (s0_ != null) {
                    return SubstringNode.substring(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodeRangeANode_, s0_.getCodePointLengthNode_, s0_.translateIndexNode_, s0_.copyToByteArrayNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private MutableTruffleString executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                SubstringData s0_ = super.insert(new SubstringData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNodeGen.create()));
                s0_.getCodeRangeANode_ = s0_.insertAccessor((GetCodeRangeNodeGen.create()));
                s0_.getCodePointLengthNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.translateIndexNode_ = s0_.insertAccessor((CodePointIndexToRawNodeGen.create()));
                s0_.copyToByteArrayNode_ = s0_.insertAccessor((CopyToByteArrayNode.create()));
                VarHandle.storeStoreFence();
                this.substring_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 substring(AbstractTruffleString, int, int, Encoding, ToIndexableNode, GetCodeRangeNode, GetCodePointLengthNode, CodePointIndexToRawNode, CopyToByteArrayNode) */;
                lock.unlock();
                hasLock = false;
                return SubstringNode.substring(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodeRangeANode_, s0_.getCodePointLengthNode_, s0_.translateIndexNode_, s0_.copyToByteArrayNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static SubstringNode create() {
            return new SubstringNodeGen();
        }

        public static SubstringNode getUncached() {
            return SubstringNodeGen.UNCACHED;
        }

        @GeneratedBy(SubstringNode.class)
        private static final class SubstringData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child GetCodeRangeNode getCodeRangeANode_;
            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child CodePointIndexToRawNode translateIndexNode_;
            @Child CopyToByteArrayNode copyToByteArrayNode_;

            SubstringData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(SubstringNode.class)
        @DenyReplace
        private static final class Uncached extends SubstringNode {

            @TruffleBoundary
            @Override
            public MutableTruffleString execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value) {
                return SubstringNode.substring(arg0Value, arg1Value, arg2Value, arg3Value, (ToIndexableNode.getUncached()), (GetCodeRangeNode.getUncached()), (GetCodePointLengthNode.getUncached()), (CodePointIndexToRawNodeGen.getUncached()), (CopyToByteArrayNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(SubstringByteIndexNode.class)
    static final class SubstringByteIndexNodeGen extends SubstringByteIndexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CopyToByteArrayNode copyToByteArrayNode_;

        private SubstringByteIndexNodeGen() {
        }

        @Override
        public MutableTruffleString execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 substringByteIndex(AbstractTruffleString, int, int, Encoding, CopyToByteArrayNode) */) {
                return SubstringByteIndexNode.substringByteIndex(arg0Value, arg1Value, arg2Value, arg3Value, this.copyToByteArrayNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private MutableTruffleString executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.copyToByteArrayNode_ = super.insert((CopyToByteArrayNode.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 substringByteIndex(AbstractTruffleString, int, int, Encoding, CopyToByteArrayNode) */;
                lock.unlock();
                hasLock = false;
                return SubstringByteIndexNode.substringByteIndex(arg0Value, arg1Value, arg2Value, arg3Value, this.copyToByteArrayNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static SubstringByteIndexNode create() {
            return new SubstringByteIndexNodeGen();
        }

        public static SubstringByteIndexNode getUncached() {
            return SubstringByteIndexNodeGen.UNCACHED;
        }

        @GeneratedBy(SubstringByteIndexNode.class)
        @DenyReplace
        private static final class Uncached extends SubstringByteIndexNode {

            @TruffleBoundary
            @Override
            public MutableTruffleString execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value) {
                return SubstringByteIndexNode.substringByteIndex(arg0Value, arg1Value, arg2Value, arg3Value, (CopyToByteArrayNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.MutableTruffleString.SwitchEncodingNode.class)
    static final class SwitchEncodingNodeGen extends com.oracle.truffle.api.strings.MutableTruffleString.SwitchEncodingNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private com.oracle.truffle.api.strings.TruffleString.SwitchEncodingNode transcodeAndCopy_switchEncodingNode_;
        @Child private AsMutableTruffleStringNode transcodeAndCopy_asMutableTruffleStringNode_;

        private SwitchEncodingNodeGen() {
        }

        @Override
        public MutableTruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 compatibleMutable(MutableTruffleString, Encoding) || transcodeAndCopy(AbstractTruffleString, Encoding, SwitchEncodingNode, AsMutableTruffleStringNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 compatibleMutable(MutableTruffleString, Encoding) */ && arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((arg0Value_.isCompatibleTo(arg1Value))) {
                        return com.oracle.truffle.api.strings.MutableTruffleString.SwitchEncodingNode.compatibleMutable(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 transcodeAndCopy(AbstractTruffleString, Encoding, SwitchEncodingNode, AsMutableTruffleStringNode) */) {
                    if ((!(arg0Value.isCompatibleTo(arg1Value)) || arg0Value.isImmutable())) {
                        return com.oracle.truffle.api.strings.MutableTruffleString.SwitchEncodingNode.transcodeAndCopy(arg0Value, arg1Value, this.transcodeAndCopy_switchEncodingNode_, this.transcodeAndCopy_asMutableTruffleStringNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private MutableTruffleString executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((arg0Value_.isCompatibleTo(arg1Value))) {
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 compatibleMutable(MutableTruffleString, Encoding) */;
                        lock.unlock();
                        hasLock = false;
                        return com.oracle.truffle.api.strings.MutableTruffleString.SwitchEncodingNode.compatibleMutable(arg0Value_, arg1Value);
                    }
                }
                if ((!(arg0Value.isCompatibleTo(arg1Value)) || arg0Value.isImmutable())) {
                    this.transcodeAndCopy_switchEncodingNode_ = super.insert((com.oracle.truffle.api.strings.TruffleString.SwitchEncodingNode.create()));
                    this.transcodeAndCopy_asMutableTruffleStringNode_ = super.insert((AsMutableTruffleStringNode.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 transcodeAndCopy(AbstractTruffleString, Encoding, SwitchEncodingNode, AsMutableTruffleStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return com.oracle.truffle.api.strings.MutableTruffleString.SwitchEncodingNode.transcodeAndCopy(arg0Value, arg1Value, this.transcodeAndCopy_switchEncodingNode_, this.transcodeAndCopy_asMutableTruffleStringNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static com.oracle.truffle.api.strings.MutableTruffleString.SwitchEncodingNode create() {
            return new SwitchEncodingNodeGen();
        }

        public static com.oracle.truffle.api.strings.MutableTruffleString.SwitchEncodingNode getUncached() {
            return SwitchEncodingNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.MutableTruffleString.SwitchEncodingNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.MutableTruffleString.SwitchEncodingNode {

            @TruffleBoundary
            @Override
            public MutableTruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((arg0Value_.isCompatibleTo(arg1Value))) {
                        return com.oracle.truffle.api.strings.MutableTruffleString.SwitchEncodingNode.compatibleMutable(arg0Value_, arg1Value);
                    }
                }
                if ((!(arg0Value.isCompatibleTo(arg1Value)) || arg0Value.isImmutable())) {
                    return com.oracle.truffle.api.strings.MutableTruffleString.SwitchEncodingNode.transcodeAndCopy(arg0Value, arg1Value, (com.oracle.truffle.api.strings.TruffleString.SwitchEncodingNode.getUncached()), (AsMutableTruffleStringNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ForceEncodingNode.class)
    static final class ForceEncodingNodeGen extends ForceEncodingNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CopyToByteArrayNode reinterpret_copyToByteArrayNode_;

        private ForceEncodingNodeGen() {
        }

        @Override
        public MutableTruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value, Encoding arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 compatible(MutableTruffleString, Encoding, Encoding) || reinterpret(AbstractTruffleString, Encoding, Encoding, CopyToByteArrayNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 compatible(MutableTruffleString, Encoding, Encoding) */ && arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((arg0Value_.isCompatibleTo(arg2Value))) {
                        return ForceEncodingNode.compatible(arg0Value_, arg1Value, arg2Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 reinterpret(AbstractTruffleString, Encoding, Encoding, CopyToByteArrayNode) */) {
                    if ((!(arg0Value.isCompatibleTo(arg2Value)) || arg0Value.isImmutable())) {
                        return ForceEncodingNode.reinterpret(arg0Value, arg1Value, arg2Value, this.reinterpret_copyToByteArrayNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private MutableTruffleString executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value, Encoding arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((arg0Value_.isCompatibleTo(arg2Value))) {
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 compatible(MutableTruffleString, Encoding, Encoding) */;
                        lock.unlock();
                        hasLock = false;
                        return ForceEncodingNode.compatible(arg0Value_, arg1Value, arg2Value);
                    }
                }
                if ((!(arg0Value.isCompatibleTo(arg2Value)) || arg0Value.isImmutable())) {
                    this.reinterpret_copyToByteArrayNode_ = super.insert((CopyToByteArrayNode.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 reinterpret(AbstractTruffleString, Encoding, Encoding, CopyToByteArrayNode) */;
                    lock.unlock();
                    hasLock = false;
                    return ForceEncodingNode.reinterpret(arg0Value, arg1Value, arg2Value, this.reinterpret_copyToByteArrayNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ForceEncodingNode create() {
            return new ForceEncodingNodeGen();
        }

        public static ForceEncodingNode getUncached() {
            return ForceEncodingNodeGen.UNCACHED;
        }

        @GeneratedBy(ForceEncodingNode.class)
        @DenyReplace
        private static final class Uncached extends ForceEncodingNode {

            @TruffleBoundary
            @Override
            public MutableTruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value, Encoding arg2Value) {
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((arg0Value_.isCompatibleTo(arg2Value))) {
                        return ForceEncodingNode.compatible(arg0Value_, arg1Value, arg2Value);
                    }
                }
                if ((!(arg0Value.isCompatibleTo(arg2Value)) || arg0Value.isImmutable())) {
                    return ForceEncodingNode.reinterpret(arg0Value, arg1Value, arg2Value, (CopyToByteArrayNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CalcLazyAttributesNode.class)
    static final class CalcLazyAttributesNodeGen extends CalcLazyAttributesNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private CalcData calc_cache;

        private CalcLazyAttributesNodeGen() {
        }

        @Override
        void execute(MutableTruffleString arg0Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 calc(MutableTruffleString, ValueProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */) {
                CalcData s0_ = this.calc_cache;
                if (s0_ != null) {
                    calc(arg0Value, s0_.dataClassProfile_, s0_.asciiBytesLatinProfile_, s0_.utf8Profile_, s0_.utf16Profile_, s0_.utf16S0Profile_, s0_.utf32Profile_, s0_.utf32S0Profile_, s0_.utf32S1Profile_, s0_.exoticMaterializeNativeProfile_, s0_.exoticValidProfile_, s0_.exoticFixedWidthProfile_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value);
            return;
        }

        private void executeAndSpecialize(MutableTruffleString arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                CalcData s0_ = new CalcData();
                s0_.dataClassProfile_ = (ValueProfile.createClassProfile());
                s0_.asciiBytesLatinProfile_ = (ConditionProfile.create());
                s0_.utf8Profile_ = (ConditionProfile.create());
                s0_.utf16Profile_ = (ConditionProfile.create());
                s0_.utf16S0Profile_ = (ConditionProfile.create());
                s0_.utf32Profile_ = (ConditionProfile.create());
                s0_.utf32S0Profile_ = (ConditionProfile.create());
                s0_.utf32S1Profile_ = (ConditionProfile.create());
                s0_.exoticMaterializeNativeProfile_ = (ConditionProfile.create());
                s0_.exoticValidProfile_ = (ConditionProfile.create());
                s0_.exoticFixedWidthProfile_ = (ConditionProfile.create());
                VarHandle.storeStoreFence();
                this.calc_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 calc(MutableTruffleString, ValueProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                calc(arg0Value, s0_.dataClassProfile_, s0_.asciiBytesLatinProfile_, s0_.utf8Profile_, s0_.utf16Profile_, s0_.utf16S0Profile_, s0_.utf32Profile_, s0_.utf32S0Profile_, s0_.utf32S1Profile_, s0_.exoticMaterializeNativeProfile_, s0_.exoticValidProfile_, s0_.exoticFixedWidthProfile_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CalcLazyAttributesNode create() {
            return new CalcLazyAttributesNodeGen();
        }

        public static CalcLazyAttributesNode getUncached() {
            return CalcLazyAttributesNodeGen.UNCACHED;
        }

        @GeneratedBy(CalcLazyAttributesNode.class)
        private static final class CalcData {

            @CompilationFinal ValueProfile dataClassProfile_;
            @CompilationFinal ConditionProfile asciiBytesLatinProfile_;
            @CompilationFinal ConditionProfile utf8Profile_;
            @CompilationFinal ConditionProfile utf16Profile_;
            @CompilationFinal ConditionProfile utf16S0Profile_;
            @CompilationFinal ConditionProfile utf32Profile_;
            @CompilationFinal ConditionProfile utf32S0Profile_;
            @CompilationFinal ConditionProfile utf32S1Profile_;
            @CompilationFinal ConditionProfile exoticMaterializeNativeProfile_;
            @CompilationFinal ConditionProfile exoticValidProfile_;
            @CompilationFinal ConditionProfile exoticFixedWidthProfile_;

            CalcData() {
            }

        }
        @GeneratedBy(CalcLazyAttributesNode.class)
        @DenyReplace
        private static final class Uncached extends CalcLazyAttributesNode {

            @TruffleBoundary
            @Override
            void execute(MutableTruffleString arg0Value) {
                calc(arg0Value, (ValueProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
