/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.provider.InternalResourceProvider;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.InstrumentCache;
import com.oracle.truffle.polyglot.InternalResourceCacheSymbol;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.ModuleUtils;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.polyglot.io.FileSystem;

final class InternalResourceCache {
    private static final char[] FILE_SYSTEM_SPECIAL_CHARACTERS = new char[]{'/', '\\', ':'};
    private static final String OVERRIDDEN_CACHE_ROOT = "polyglot.engine.resourcePath";
    private static final String OVERRIDDEN_COMPONENT_ROOT = "polyglot.engine.resourcePath.%s";
    private static final String OVERRIDDEN_RESOURCE_ROOT = "polyglot.engine.resourcePath.%s.%s";
    private static final Lock unpackLock = new ReentrantLock();
    private static final Map<Collection<EngineAccessor.AbstractClassLoaderSupplier>, Map<String, Map<String, Supplier<InternalResourceCache>>>> optionalInternalResourcesCaches = new HashMap<Collection<EngineAccessor.AbstractClassLoaderSupplier>, Map<String, Map<String, Supplier<InternalResourceCache>>>>();
    private static final Map<String, Map<String, Supplier<InternalResourceCache>>> nativeImageCache = TruffleOptions.AOT ? new HashMap() : null;
    private static volatile Pair<Path, Boolean> cacheRoot;
    private final String id;
    private final String resourceId;
    private final Supplier<InternalResource> resourceFactory;
    private volatile FileSystem resourceFileSystem;
    private static boolean useInternalResources;

    InternalResourceCache(String languageId, String resourceId, Supplier<InternalResource> resourceFactory) {
        this.id = Objects.requireNonNull(languageId);
        this.resourceId = Objects.requireNonNull(resourceId);
        this.resourceFactory = Objects.requireNonNull(resourceFactory);
    }

    FileSystem getResourceFileSystem(PolyglotEngineImpl polyglotEngine) throws IOException {
        return this.getResourceFileSystemImpl(resource -> EngineAccessor.LANGUAGE.createInternalResourceEnv((InternalResource)resource, () -> polyglotEngine.inEnginePreInitialization));
    }

    static Path installRuntimeResource(InternalResource resource) throws IOException {
        InternalResourceCache cache = InternalResourceCache.createRuntimeResourceCache(resource);
        return cache.getResourceFileSystemImpl(InternalResourceCache::createInternalResourceEnvReflectively).parsePath("").toAbsolutePath();
    }

    private static InternalResourceCache createRuntimeResourceCache(InternalResource resource) {
        InternalResource.Id id = resource.getClass().getAnnotation(InternalResource.Id.class);
        assert (id != null) : resource.getClass() + " must be annotated by @InternalResource.Id";
        return new InternalResourceCache("engine", id.value(), () -> resource);
    }

    private static InternalResource.Env createInternalResourceEnvReflectively(InternalResource resource) {
        try {
            Constructor newEnv = InternalResource.Env.class.getDeclaredConstructor(InternalResource.class, BooleanSupplier.class);
            newEnv.setAccessible(true);
            return (InternalResource.Env)newEnv.newInstance(resource, () -> TruffleOptions.AOT);
        }
        catch (ReflectiveOperationException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getResourceFileSystemImpl(Function<InternalResource, InternalResource.Env> createEnv) throws IOException {
        FileSystem result = this.resourceFileSystem;
        if (result == null) {
            InternalResourceCache internalResourceCache = this;
            synchronized (internalResourceCache) {
                result = this.resourceFileSystem;
                if (result == null) {
                    Path root = this.findOverriddenResourceRoot();
                    if (root == null) {
                        if (InternalResourceCache.hasExplicitCacheRoot()) {
                            root = this.findStandaloneResourceRoot(InternalResourceCache.getExplicitCacheRoot());
                        } else if (ImageInfo.inImageRuntimeCode()) {
                            root = this.findStandaloneResourceRoot(InternalResourceCache.findCacheRootOnNativeImage());
                        } else {
                            InternalResource.Env env;
                            InternalResource resource = this.resourceFactory.get();
                            String versionHash = resource.versionHash(env = createEnv.apply(resource));
                            if (versionHash.getBytes().length > 128) {
                                throw new IOException("The version hash length is restricted to a maximum of 128 bytes.");
                            }
                            root = InternalResourceCache.findCacheRootOnHotSpot().resolve(Path.of(InternalResourceCache.sanitize(this.id), InternalResourceCache.sanitize(this.resourceId), InternalResourceCache.sanitize(versionHash)));
                            InternalResourceCache.unpackResourceFiles(root, resource, env);
                        }
                    }
                    ResettableCachedRoot rootSupplier = new ResettableCachedRoot(root);
                    this.resourceFileSystem = result = FileSystems.newInternalResourceFileSystem(rootSupplier);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unpackResourceFiles(Path target, InternalResource resource, InternalResource.Env env) throws IOException {
        unpackLock.lock();
        try {
            if (!Files.exists(target, new LinkOption[0])) {
                Path parent = target.getParent();
                if (parent == null) {
                    throw CompilerDirectives.shouldNotReachHere("Target must have a parent directory but was " + target);
                }
                Path owner = Files.createDirectories(Objects.requireNonNull(parent), new FileAttribute[0]);
                Path tmpDir = Files.createTempDirectory(owner, null, new FileAttribute[0]);
                resource.unpackFiles(env, tmpDir);
                try {
                    Files.move(tmpDir, target, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (FileAlreadyExistsException existsException) {
                    InternalResourceCache.unlink(tmpDir);
                }
            } else {
                InternalResourceCache.verifyResourceRoot(target);
            }
        }
        finally {
            unpackLock.unlock();
        }
    }

    private static void verifyResourceRoot(Path resourceRoot) throws IOException {
        if (!Files.isDirectory(resourceRoot, new LinkOption[0])) {
            throw new IOException("Resource cache root " + resourceRoot + " must be a directory.");
        }
        if (!Files.isReadable(resourceRoot)) {
            throw new IOException("Resource cache root " + resourceRoot + " must be readable.");
        }
    }

    private Path findStandaloneResourceRoot(Path root) {
        return root.resolve(Path.of(InternalResourceCache.sanitize(this.id), InternalResourceCache.sanitize(this.resourceId)));
    }

    private Path findOverriddenResourceRoot() throws IOException {
        String value = System.getProperty(String.format(OVERRIDDEN_RESOURCE_ROOT, this.id, this.resourceId));
        if (value != null) {
            return Paths.get(value, new String[0]).toRealPath(new LinkOption[0]);
        }
        value = System.getProperty(String.format(OVERRIDDEN_COMPONENT_ROOT, this.id));
        if (value != null) {
            return Paths.get(value, new String[0]).resolve(InternalResourceCache.sanitize(this.resourceId)).toRealPath(new LinkOption[0]);
        }
        return null;
    }

    private static String sanitize(String pathElement) {
        String result = pathElement;
        for (char fileSystemsSpecialChar : FILE_SYSTEM_SPECIAL_CHARACTERS) {
            result = result.replace(fileSystemsSpecialChar, '_');
        }
        return result;
    }

    private static boolean hasExplicitCacheRoot() throws IOException {
        String resourcesFolder;
        Pair res = cacheRoot;
        if (res == null && (resourcesFolder = System.getProperty(OVERRIDDEN_CACHE_ROOT)) != null) {
            Path cache = Paths.get(resourcesFolder, new String[0]).toRealPath(new LinkOption[0]);
            cacheRoot = res = Pair.create((Object)cache, (Object)true);
        }
        return res != null && (Boolean)res.getRight() != false;
    }

    private static Path getExplicitCacheRoot() {
        Pair<Path, Boolean> res = cacheRoot;
        if (res == null || !((Boolean)res.getRight()).booleanValue()) {
            throw CompilerDirectives.shouldNotReachHere("Can be only called when hasExplicitCacheRoot() returned true");
        }
        return (Path)res.getLeft();
    }

    private static Path findCacheRootOnHotSpot() throws IOException {
        Pair res = cacheRoot;
        if (res == null) {
            String userHomeValue = System.getProperty("user.home");
            if (userHomeValue == null) {
                throw CompilerDirectives.shouldNotReachHere("The 'user.home' system property is not set.");
            }
            Path userHome = Paths.get(userHomeValue, new String[0]);
            Path container = switch (InternalResource.OS.getCurrent()) {
                default -> throw new IncompatibleClassChangeError();
                case InternalResource.OS.DARWIN -> {
                    Path var4_3;
                    yield var4_3 = userHome.resolve(Path.of("Library", "Caches"));
                }
                case InternalResource.OS.LINUX -> {
                    Path var4_3;
                    Path userCacheDir = null;
                    String xdgCacheValue = System.getenv("XDG_CACHE_HOME");
                    if (xdgCacheValue != null) {
                        try {
                            Path xdgCacheDir = Path.of(xdgCacheValue, new String[0]);
                            if (xdgCacheDir.isAbsolute()) {
                                userCacheDir = xdgCacheDir;
                            } else {
                                InternalResourceCache.emitWarning("The value of the environment variable 'XDG_CACHE_HOME' is not an absolute path. Using the default cache folder '%s'.", userHome.resolve(".cache"));
                            }
                        }
                        catch (InvalidPathException notPath) {
                            InternalResourceCache.emitWarning("The value of the environment variable 'XDG_CACHE_HOME' is not a valid path. Using the default cache folder '%s'.", userHome.resolve(".cache"));
                        }
                    }
                    if (userCacheDir == null) {
                        userCacheDir = userHome.resolve(".cache");
                    }
                    yield var4_3 = userCacheDir;
                }
                case InternalResource.OS.WINDOWS -> {
                    Path var4_3;
                    yield var4_3 = userHome.resolve(Path.of("AppData", "Local"));
                }
            };
            Path cache = container.resolve("org.graalvm.polyglot");
            cache = Files.createDirectories(cache, new FileAttribute[0]).toRealPath(new LinkOption[0]);
            cacheRoot = res = Pair.create((Object)cache, (Object)false);
        }
        return (Path)res.getLeft();
    }

    private static void emitWarning(String message, Object ... args) {
        PrintStream out = System.err;
        out.printf(message + "%n", args);
    }

    private static Path findCacheRootOnNativeImage() {
        Pair res = cacheRoot;
        if (res == null) {
            assert (ImageInfo.inImageRuntimeCode()) : "Can be called only in the native-image execution time.";
            Path executable = InternalResourceCache.getExecutablePath();
            Path cache = executable.resolveSibling("resources");
            cacheRoot = res = Pair.create((Object)cache, (Object)false);
        }
        return (Path)res.getLeft();
    }

    private static Path getExecutablePath() {
        assert (ImageInfo.inImageRuntimeCode());
        if (useInternalResources) {
            if (ImageInfo.isExecutable()) {
                return Path.of(ProcessProperties.getExecutableName(), new String[0]);
            }
            if (ImageInfo.isSharedLibrary()) {
                return Path.of(ProcessProperties.getObjectFile(InternalResourceCacheSymbol.SYMBOL), new String[0]);
            }
            throw CompilerDirectives.shouldNotReachHere("Should only be invoked within native image runtime code.");
        }
        throw new IllegalArgumentException("Lookup an executable name is restricted. To enable it, use '-H:+CopyLanguageResources' during the native image build.");
    }

    static void initializeNativeImageState(ClassLoader nativeImageClassLoader) {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageCache.putAll(InternalResourceCache.collectOptionalResources(List.of(new EngineAccessor.StrongClassLoaderSupplier(nativeImageClassLoader))));
    }

    static void resetNativeImageState() {
        nativeImageCache.clear();
    }

    private void resetFileSystemNativeImageState() {
        FileSystem fs = this.resourceFileSystem;
        if (fs != null) {
            ((ResettableCachedRoot)FileSystems.getInternalResourceFileSystemRoot((FileSystem)fs)).resourceCacheRoot = null;
        }
    }

    static boolean copyResourcesForNativeImage(Path target, String ... components) throws IOException {
        InternalResourceCache cache;
        Collection<InstrumentCache> instruments;
        Collection<LanguageCache> languages;
        boolean result = false;
        if (components.length == 0) {
            languages = LanguageCache.languages().values();
            instruments = InstrumentCache.load();
        } else {
            HashSet requiredComponentIds = new HashSet();
            Collections.addAll(requiredComponentIds, components);
            HashSet<String> requiredLanguageIds = new HashSet<String>(LanguageCache.languages().keySet());
            requiredLanguageIds.retainAll(requiredComponentIds);
            Set requiredInstrumentIds = InstrumentCache.load().stream().map(InstrumentCache::getId).collect(Collectors.toSet());
            requiredInstrumentIds.retainAll(requiredComponentIds);
            requiredComponentIds.removeAll(requiredLanguageIds);
            requiredComponentIds.removeAll(requiredInstrumentIds);
            if (!requiredComponentIds.isEmpty()) {
                TreeSet<String> installedComponents = new TreeSet<String>(LanguageCache.languages().keySet());
                InstrumentCache.load().stream().map(InstrumentCache::getId).forEach(installedComponents::add);
                throw new IllegalArgumentException(String.format("Components with ids %s are not installed. Installed components are: %s.", String.join((CharSequence)", ", requiredComponentIds), String.join((CharSequence)", ", installedComponents)));
            }
            HashSet<LanguageCache> requiredLanguages = new HashSet<LanguageCache>(LanguageCache.internalLanguages());
            for (String requiredLanguageId : requiredLanguageIds) {
                requiredLanguages.addAll(LanguageCache.computeTransitiveLanguageDependencies(requiredLanguageId));
            }
            languages = requiredLanguages;
            HashSet<InstrumentCache> requiredInstruments = new HashSet<InstrumentCache>(InstrumentCache.internalInstruments());
            InstrumentCache.load().stream().filter(ic -> requiredInstrumentIds.contains(ic.getId())).forEach(requiredInstruments::add);
            instruments = requiredInstruments;
        }
        for (LanguageCache language : languages) {
            for (String resourceId : language.getResourceIds()) {
                cache = language.getResourceCache(resourceId);
                result |= cache.copyResourcesForNativeImage(target);
            }
        }
        for (InstrumentCache instrument : instruments) {
            for (String resourceId : instrument.getResourceIds()) {
                cache = instrument.getResourceCache(resourceId);
                result |= cache.copyResourcesForNativeImage(target);
            }
        }
        for (String resourceId : InternalResourceCache.getEngineResourceIds()) {
            InternalResourceCache cache2 = InternalResourceCache.getEngineResource(resourceId);
            result |= cache2.copyResourcesForNativeImage(target);
        }
        return result;
    }

    private boolean copyResourcesForNativeImage(Path target) throws IOException {
        Path resourceRoot = this.findStandaloneResourceRoot(target);
        InternalResourceCache.unlink(resourceRoot);
        Files.createDirectories(resourceRoot, new FileAttribute[0]);
        InternalResource resource = this.resourceFactory.get();
        InternalResource.Env env = EngineAccessor.LANGUAGE.createInternalResourceEnv(resource, () -> false);
        resource.unpackFiles(env, resourceRoot);
        if (InternalResourceCache.isEmpty(resourceRoot)) {
            Files.deleteIfExists(resourceRoot);
            return false;
        }
        return true;
    }

    static Collection<String> getEngineResourceIds() {
        Map<String, Supplier<InternalResourceCache>> engineResources = InternalResourceCache.loadOptionalInternalResources(EngineAccessor.locatorOrDefaultLoaders()).get("engine");
        return engineResources != null ? engineResources.keySet() : List.of();
    }

    static InternalResourceCache getEngineResource(String resourceId) {
        Map<String, Supplier<InternalResourceCache>> engineResources = InternalResourceCache.loadOptionalInternalResources(EngineAccessor.locatorOrDefaultLoaders()).get("engine");
        Supplier<InternalResourceCache> resourceSupplier = engineResources != null ? engineResources.get(resourceId) : null;
        return resourceSupplier != null ? resourceSupplier.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Map<String, Supplier<InternalResourceCache>>> loadOptionalInternalResources(List<EngineAccessor.AbstractClassLoaderSupplier> suppliers) {
        if (TruffleOptions.AOT) {
            assert (nativeImageCache != null);
            return nativeImageCache;
        }
        Class<InternalResourceCache> clazz = InternalResourceCache.class;
        synchronized (InternalResourceCache.class) {
            Map<String, Map<String, Supplier<InternalResourceCache>>> cache = optionalInternalResourcesCaches.get(suppliers);
            if (cache == null) {
                cache = InternalResourceCache.collectOptionalResources(suppliers);
                optionalInternalResourcesCaches.put(suppliers, cache);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    private static Map<String, Map<String, Supplier<InternalResourceCache>>> collectOptionalResources(List<EngineAccessor.AbstractClassLoaderSupplier> suppliers) {
        HashMap<String, Map<String, Supplier<InternalResourceCache>>> cache = new HashMap<String, Map<String, Supplier<InternalResourceCache>>>();
        for (EngineAccessor.AbstractClassLoaderSupplier supplier : suppliers) {
            ClassLoader loader = (ClassLoader)supplier.get();
            if (loader == null || !InternalResourceCache.isValidLoader(loader)) continue;
            StreamSupport.stream(ServiceLoader.load(InternalResourceProvider.class, loader).spliterator(), false).filter(p -> supplier.accepts(p.getClass())).forEach(p -> {
                ModuleUtils.exportTransitivelyTo(p.getClass().getModule());
                String componentId = EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceComponentId((InternalResourceProvider)p);
                String resourceId = EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceId((InternalResourceProvider)p);
                Map componentOptionalResources = cache.computeIfAbsent(componentId, k -> new HashMap());
                OptionalResourceSupplier resourceSupplier = new OptionalResourceSupplier((InternalResourceProvider)p);
                OptionalResourceSupplier existing = componentOptionalResources.put(resourceId, resourceSupplier);
                if (existing != null && !InternalResourceCache.hasSameCodeSource(resourceSupplier, existing)) {
                    throw InternalResourceCache.throwDuplicateOptionalResourceException(existing.get(), resourceSupplier.get());
                }
            });
        }
        return cache;
    }

    private static boolean hasSameCodeSource(OptionalResourceSupplier first, OptionalResourceSupplier second) {
        return first.optionalResourceProvider.getClass() == second.optionalResourceProvider.getClass();
    }

    private static boolean isValidLoader(ClassLoader loader) {
        try {
            Class<?> truffleLanguageClassAsSeenByLoader = Class.forName(TruffleLanguage.class.getName(), true, loader);
            return truffleLanguageClassAsSeenByLoader == TruffleLanguage.class;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    static RuntimeException throwDuplicateOptionalResourceException(InternalResourceCache existing, InternalResourceCache duplicate) {
        String message = String.format("Duplicate optional resource id %s for component %s. First optional resource [%s]. Second optional resource [%s].", existing.resourceId, existing.id, InternalResourceCache.formatResourceLocation(existing.resourceFactory.get()), InternalResourceCache.formatResourceLocation(duplicate.resourceFactory.get()));
        throw new IllegalStateException(message);
    }

    private static String formatResourceLocation(InternalResource internalResource) {
        URL url;
        StringBuilder sb = new StringBuilder();
        sb.append("Internal resource class ").append(internalResource.getClass().getName());
        CodeSource source = internalResource.getClass().getProtectionDomain().getCodeSource();
        URL uRL = url = source != null ? source.getLocation() : null;
        if (url != null) {
            sb.append(", Loaded from ").append(url);
        }
        return sb.toString();
    }

    private static boolean isEmpty(Path folder) throws IOException {
        try (Stream<Path> children = Files.list(folder);){
            boolean bl = children.findAny().isEmpty();
            return bl;
        }
    }

    private static void unlink(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> children = Files.newDirectoryStream(path);){
                for (Path child : children) {
                    InternalResourceCache.unlink(child);
                }
            }
        }
        Files.deleteIfExists(path);
    }

    private static void setTestCacheRoot(Path root, boolean disposeResourceFileSystem) {
        InternalResourceCache cache;
        cacheRoot = root == null ? null : Pair.create((Object)root, (Object)false);
        for (LanguageCache language : LanguageCache.languages().values()) {
            for (String resourceId : language.getResourceIds()) {
                cache = language.getResourceCache(resourceId);
                if (disposeResourceFileSystem) {
                    cache.resourceFileSystem = null;
                    continue;
                }
                cache.resetFileSystemNativeImageState();
            }
        }
        for (InstrumentCache instrument : InstrumentCache.load()) {
            for (String resourceId : instrument.getResourceIds()) {
                cache = instrument.getResourceCache(resourceId);
                if (disposeResourceFileSystem) {
                    cache.resourceFileSystem = null;
                    continue;
                }
                cache.resetFileSystemNativeImageState();
            }
        }
    }

    static {
        useInternalResources = true;
    }

    private final class ResettableCachedRoot
    implements Supplier<Path> {
        private volatile Path resourceCacheRoot;

        ResettableCachedRoot(Path resourceCacheRoot) {
            Objects.requireNonNull(resourceCacheRoot, "ResourceCacheRoot must be non-null.");
            this.resourceCacheRoot = resourceCacheRoot;
        }

        @Override
        public Path get() {
            Path res = this.resourceCacheRoot;
            if (res == null) {
                if (ImageInfo.inImageBuildtimeCode()) {
                    throw CompilerDirectives.shouldNotReachHere("Reintroducing internal resource cache path into an image heap.");
                }
                try {
                    res = InternalResourceCache.this.findOverriddenResourceRoot();
                    if (res == null) {
                        Path cache = InternalResourceCache.hasExplicitCacheRoot() ? InternalResourceCache.getExplicitCacheRoot() : InternalResourceCache.findCacheRootOnNativeImage();
                        res = InternalResourceCache.this.findStandaloneResourceRoot(cache);
                    }
                    this.resourceCacheRoot = res;
                }
                catch (IOException ioe) {
                    throw new IOError(ioe);
                }
            }
            return res;
        }
    }

    private static final class OptionalResourceSupplier
    implements Supplier<InternalResourceCache> {
        private final InternalResourceProvider optionalResourceProvider;
        private volatile InternalResourceCache cachedResource;

        private OptionalResourceSupplier(InternalResourceProvider optionalResourceProvider) {
            Objects.requireNonNull(optionalResourceProvider, "OptionalResourceProvider must be non null");
            this.optionalResourceProvider = optionalResourceProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InternalResourceCache get() {
            InternalResourceCache res = this.cachedResource;
            if (res == null) {
                OptionalResourceSupplier optionalResourceSupplier = this;
                synchronized (optionalResourceSupplier) {
                    res = this.cachedResource;
                    if (res == null) {
                        this.cachedResource = res = new InternalResourceCache(EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceComponentId(this.optionalResourceProvider), EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceId(this.optionalResourceProvider), () -> EngineAccessor.LANGUAGE_PROVIDER.createInternalResource(this.optionalResourceProvider));
                    }
                }
            }
            return res;
        }
    }
}

