/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractInternalNode;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.DecodingErrorHandler;
import com.oracle.truffle.api.strings.Encodings;
import com.oracle.truffle.api.strings.FastDoubleParser;
import com.oracle.truffle.api.strings.IndexOfCodePointSet;
import com.oracle.truffle.api.strings.InternalErrors;
import com.oracle.truffle.api.strings.JCodings;
import com.oracle.truffle.api.strings.NumberConversion;
import com.oracle.truffle.api.strings.Stride;
import com.oracle.truffle.api.strings.StringAttributes;
import com.oracle.truffle.api.strings.TSCodeRange;
import com.oracle.truffle.api.strings.TStringConstants;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory;
import com.oracle.truffle.api.strings.TStringOps;
import com.oracle.truffle.api.strings.TStringOpsNodes;
import com.oracle.truffle.api.strings.TStringUnsafe;
import com.oracle.truffle.api.strings.TranscodingErrorHandler;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.Arrays;

final class TStringInternalNodes {
    TStringInternalNodes() {
    }

    private static long updateAttributes(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, int impreciseCodeRange, TruffleString.ToIndexableNode toIndexableNode, CalcStringAttributesNode calcStringAttributesNode) {
        assert (!TSCodeRange.isPrecise(impreciseCodeRange));
        long attrs = calcStringAttributesNode.execute(node, a, toIndexableNode.execute(node, a, a.data()), a.offset(), a.length(), a.stride(), encoding, 0, impreciseCodeRange);
        a.updateAttributes(StringAttributes.getCodePointLength(attrs), StringAttributes.getCodeRange(attrs));
        return attrs;
    }

    static int indexOfFixedWidth(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, int codepoint, int fromIndex, int toIndex, TStringOpsNodes.RawIndexOfCodePointNode indexOfNode) {
        if (fromIndex == toIndex || !TSCodeRange.isInCodeRange(codepoint, codeRangeA)) {
            return -1;
        }
        return indexOfNode.execute(node, a, arrayA, codepoint, fromIndex, toIndex);
    }

    static int lastIndexOfFixedWidth(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, int codepoint, int fromIndex, int toIndex, TStringOpsNodes.RawLastIndexOfCodePointNode indexOfNode) {
        if (fromIndex == toIndex || !TSCodeRange.isInCodeRange(codepoint, codeRangeA)) {
            return -1;
        }
        return indexOfNode.execute(node, a, arrayA, codepoint, fromIndex, toIndex);
    }

    static abstract class CalcStringAttributesNode
    extends AbstractInternalNode {
        CalcStringAttributesNode() {
        }

        abstract long execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, int var6, TruffleString.Encoding var7, int var8, int var9);

        @Specialization(guards={"length == 0"})
        long empty(AbstractTruffleString a, Object array, int offset, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            return StringAttributes.create(length, TSCodeRange.getAsciiCodeRange(encoding));
        }

        @Specialization(guards={"is7Bit(knownCodeRange)", "length > 0"})
        long ascii(AbstractTruffleString a, Object array, int offset, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            return StringAttributes.create(length, TSCodeRange.get7Bit());
        }

        @Specialization(guards={"!is7Bit(knownCodeRange)", "length > 0"})
        static long notAscii(Node node, AbstractTruffleString a, Object array, int offset, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange, @Cached CalcStringAttributesInnerNode calcNode) {
            return calcNode.execute(node, a, array, offset, length, stride, encoding, fromIndex, knownCodeRange);
        }
    }

    static abstract class TransCodeIntlNode
    extends AbstractInternalNode {
        TransCodeIntlNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, TruffleString.Encoding var6, TruffleString.Encoding var7, TranscodingErrorHandler var8);

        @Specialization(guards={"isSupportedOrUTFFE(sourceEncoding)", "isAscii(targetEncoding) || isBytes(targetEncoding)"})
        static TruffleString targetAscii(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            assert (!TStringGuards.is7Bit(codeRangeA));
            byte[] buffer = new byte[codePointLengthA];
            int length = 0;
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            boolean replacedChars = false;
            while (it.hasNext()) {
                int codepoint = iteratorNextNode.execute(node, it, DecodingErrorHandler.DEFAULT_UTF8_INCOMPLETE_SEQUENCES);
                if (codepoint > 127) {
                    buffer[length++] = 63;
                    replacedChars = true;
                } else {
                    buffer[length++] = (byte)codepoint;
                }
                TStringConstants.truffleSafePointPoll(node, length);
            }
            return TransCodeIntlNode.create(a, TransCodeIntlNode.trim(buffer, length), length, 0, targetEncoding, length, TSCodeRange.get7Bit(), replacedChars);
        }

        @Specialization(guards={"isSupportedOrUTFFE(sourceEncoding)", "isLatin1(targetEncoding)"})
        static TruffleString latin1Transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            assert (!TStringGuards.is7Or8Bit(codeRangeA));
            byte[] buffer = new byte[codePointLengthA];
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            int codeRange = TSCodeRange.get7Bit();
            boolean replacedChars = false;
            int length = 0;
            while (it.hasNext()) {
                int latin1;
                int codepoint = iteratorNextNode.execute(node, it, DecodingErrorHandler.DEFAULT_UTF8_INCOMPLETE_SEQUENCES);
                if (codepoint > 255) {
                    latin1 = 63;
                    replacedChars = true;
                } else {
                    latin1 = (byte)codepoint;
                }
                buffer[length++] = latin1;
                if (latin1 < 0) {
                    codeRange = TSCodeRange.get8Bit();
                }
                TStringConstants.truffleSafePointPoll(node, length);
            }
            return TransCodeIntlNode.create(a, TransCodeIntlNode.trim(buffer, length), length, 0, TruffleString.Encoding.ISO_8859_1, length, codeRange, replacedChars);
        }

        @Specialization(guards={"isSupportedOrUTFFE(sourceEncoding)", "!isLarge(codePointLengthA)", "isUTF8(targetEncoding)"})
        static TruffleString utf8Transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode, @Cached InlinedConditionProfile brokenProfile, @Cached @Cached.Shared(value="outOfMemoryProfile") InlinedBranchProfile outOfMemoryProfile, @Cached @Cached.Shared InlinedConditionProfile largeProfile) {
            return TransCodeIntlNode.utf8Transcode(node, a, arrayA, codePointLengthA, codeRangeA, sourceEncoding, errorHandler, iteratorNextNode, largeProfile.profile(node, TransCodeIntlNode.isLarge(codePointLengthA)), brokenProfile, outOfMemoryProfile);
        }

        static boolean isLarge(int codePointLengthA) {
            return codePointLengthA > 0x1FFFFFFD;
        }

        private static TruffleString utf8Transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TranscodingErrorHandler errorHandler, TruffleStringIterator.InternalNextNode iteratorNextNode, boolean isLarge, InlinedConditionProfile brokenProfile, InlinedBranchProfile outOfMemoryProfile) {
            int codePointLength;
            assert (!TStringGuards.is7Bit(codeRangeA));
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            boolean allowUTF16Surrogates = errorHandler == TranscodingErrorHandler.DEFAULT_KEEP_SURROGATES_IN_UTF8;
            DecodingErrorHandler decodingErrorHandler = TransCodeIntlNode.getDecodingErrorHandler(errorHandler);
            byte[] buffer = new byte[isLarge ? 0x7FFFFFF7 : codePointLengthA * 4];
            int codeRange = TSCodeRange.get7Bit();
            int length = 0;
            int loopCount = 0;
            while (it.hasNext()) {
                int codepoint = iteratorNextNode.execute(node, it, decodingErrorHandler);
                boolean isSurrogate = Encodings.isUTF16Surrogate(codepoint);
                boolean isGreaterMax = TransCodeIntlNode.isGreaterThanMaxUTFCodepoint(codepoint);
                if (isSurrogate || isGreaterMax) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                    codepoint = TransCodeIntlNode.utfReplaceInvalid(codepoint, isSurrogate, isGreaterMax, allowUTF16Surrogates);
                } else if (codepoint > 127 && TSCodeRange.is7Bit(codeRange)) {
                    codeRange = TSCodeRange.getValidMultiByte();
                }
                int n = Encodings.utf8EncodedSize(codepoint);
                assert (isLarge || length + n <= buffer.length);
                if (isLarge && length > 0x7FFFFFF7 - n) {
                    outOfMemoryProfile.enter(node);
                    throw InternalErrors.outOfMemory();
                }
                Encodings.utf8Encode(codepoint, buffer, length, n);
                length += n;
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            if (TStringGuards.isBrokenMultiByte(codeRange)) {
                long attrs = TStringOps.calcStringAttributesUTF8(node, buffer, 0, length, false, false, brokenProfile);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            } else {
                codePointLength = codePointLengthA;
            }
            return TransCodeIntlNode.create(a, Arrays.copyOf(buffer, length), length, 0, TruffleString.Encoding.UTF_8, codePointLength, codeRange);
        }

        @Specialization(guards={"isUTF32(sourceEncoding)", "isUTF16(targetEncoding)"})
        TruffleString utf16Fixed32Bit(AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            int codePointLength;
            assert (TStringGuards.isValidFixedWidth(codeRangeA) || TStringGuards.isBrokenFixedWidth(codeRangeA));
            assert (TStringGuards.isStride2(a));
            boolean allowUTF16Surrogates = TransCodeIntlNode.isAllowUTF16SurrogatesUTF16Or32(errorHandler);
            byte[] buffer = new byte[codePointLengthA * 4];
            int length = 0;
            int codeRange = TStringGuards.isValidFixedWidth(codeRangeA) ? TSCodeRange.getValidMultiByte() : TSCodeRange.getBrokenMultiByte();
            for (int i = 0; i < a.length(); ++i) {
                length += Encodings.utf16Encode(TransCodeIntlNode.utfReplaceInvalid(TStringOps.readS2(a, arrayA, i), allowUTF16Surrogates), buffer, length);
                TStringConstants.truffleSafePointPoll(this, i + 1);
            }
            if (TStringGuards.isBrokenMultiByte(codeRange)) {
                long attrs = TStringOps.calcStringAttributesUTF16(this, buffer, 0, length, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            } else {
                codePointLength = codePointLengthA;
            }
            return TransCodeIntlNode.create(a, Arrays.copyOf(buffer, length * 2), length, 1, TruffleString.Encoding.UTF_16, codePointLength, codeRange);
        }

        @Specialization(guards={"isUTF16(sourceEncoding)", "isUTF16FE(targetEncoding)"})
        static TruffleString utf16ByteSwapToFE(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            int inflatedOffset;
            Object inflatedBuffer;
            int length = a.length();
            if (TStringGuards.isStride0(a)) {
                inflatedBuffer = TStringOps.arraycopyOfWithStride(node, arrayA, a.offset(), a.length(), 0, length, 1);
                inflatedOffset = 0;
            } else {
                inflatedBuffer = arrayA;
                inflatedOffset = a.offset();
            }
            byte[] buffer = new byte[a.byteLength(TruffleString.Encoding.UTF_16)];
            TStringOps.byteSwapS1(node, inflatedBuffer, inflatedOffset, buffer, 0, length);
            int codeRange = TSCodeRange.isMoreRestrictiveOrEqual(codeRangeA, TSCodeRange.getValidMultiByte()) ? TSCodeRange.getValidMultiByte() : TSCodeRange.getBrokenMultiByte();
            return TransCodeIntlNode.create(a, buffer, buffer.length, 0, TruffleString.Encoding.UTF_16_FOREIGN_ENDIAN, codePointLengthA, codeRange);
        }

        @Specialization(guards={"isUTF16FE(sourceEncoding)", "isUTF16(targetEncoding)"})
        static TruffleString utf16ByteSwapFromFE(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            assert (TStringGuards.isValidMultiByte(codeRangeA) || TStringGuards.isBrokenMultiByte(codeRangeA));
            assert (TStringGuards.isStride0(a));
            byte[] buffer = new byte[a.length()];
            int length = buffer.length >> 1;
            TStringOps.byteSwapS1(node, arrayA, a.offset(), buffer, 0, length);
            long attrs = TStringOps.calcStringAttributesUTF16(node, buffer, 0, length, false);
            int codeRange = StringAttributes.getCodeRange(attrs);
            int codePointLength = StringAttributes.getCodePointLength(attrs);
            assert (codePointLength == codePointLengthA);
            int stride = Stride.fromCodeRangeUTF16(codeRange);
            if (stride == 0) {
                buffer = TStringOps.arraycopyOfWithStride(node, buffer, 0, length, 1, length, 0);
            }
            return TransCodeIntlNode.create(a, buffer, length, stride, TruffleString.Encoding.UTF_16, codePointLength, codeRange);
        }

        @Specialization(guards={"isUTF32FE(sourceEncoding)", "isUTF32(targetEncoding)"})
        static TruffleString utf32ByteSwap(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            assert (TStringGuards.isValidMultiByte(codeRangeA) || TStringGuards.isBrokenMultiByte(codeRangeA));
            assert (TStringGuards.isStride0(a));
            byte[] buffer = new byte[a.length()];
            int length = buffer.length >> 2;
            TStringOps.byteSwapS2(node, arrayA, a.offset(), buffer, 0, length);
            int codeRange = TStringOps.calcStringAttributesUTF32(node, buffer, 0, length);
            int stride = Stride.fromCodeRangeUTF32(codeRange);
            if (stride < 2) {
                buffer = TStringOps.arraycopyOfWithStride(node, buffer, 0, length, 2, length, stride);
            }
            return TransCodeIntlNode.create(a, buffer, length, stride, TruffleString.Encoding.UTF_32, length, codeRange);
        }

        @Specialization(guards={"isUTF32(sourceEncoding)", "isUTF32FE(targetEncoding)"})
        static TruffleString utf32ByteSwapToFE(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            int inflatedOffset;
            Object inflatedBuffer;
            int length = a.length();
            if (a.stride() < 2) {
                inflatedBuffer = TStringOps.arraycopyOfWithStride(node, arrayA, a.offset(), a.length(), a.stride(), length, 2);
                inflatedOffset = 0;
            } else {
                inflatedBuffer = arrayA;
                inflatedOffset = a.offset();
            }
            byte[] buffer = new byte[a.byteLength(TruffleString.Encoding.UTF_32)];
            TStringOps.byteSwapS2(node, inflatedBuffer, inflatedOffset, buffer, 0, length);
            int codeRange = TSCodeRange.isMoreRestrictiveOrEqual(codeRangeA, TSCodeRange.getValidFixedWidth()) ? TSCodeRange.getValidMultiByte() : TSCodeRange.getBrokenMultiByte();
            return TransCodeIntlNode.create(a, buffer, buffer.length, 0, TruffleString.Encoding.UTF_32_FOREIGN_ENDIAN, codePointLengthA, codeRange);
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding) || isUTF32FE(sourceEncoding)", "!isFixedWidth(codeRangeA)", "isUTF16(targetEncoding)"})
        static TruffleString utf16Transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode, @Cached @Cached.Shared(value="outOfMemoryProfile") InlinedBranchProfile outOfMemoryProfile, @Cached @Cached.Shared InlinedConditionProfile largeProfile) {
            return TransCodeIntlNode.utf16Transcode(node, a, arrayA, codePointLengthA, codeRangeA, sourceEncoding, errorHandler, iteratorNextNode, largeProfile.profile(node, TransCodeIntlNode.isLarge(codePointLengthA)), outOfMemoryProfile);
        }

        private static TruffleString utf16Transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TranscodingErrorHandler errorHandler, TruffleStringIterator.InternalNextNode iteratorNextNode, boolean isLarge, InlinedBranchProfile outOfMemoryProfile) {
            boolean isSurrogate;
            int codepoint;
            int curIndex;
            assert (TStringGuards.isValidOrBrokenMultiByte(codeRangeA));
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            boolean allowUTF16Surrogates = TransCodeIntlNode.isAllowUTF16SurrogatesUTF16Or32(errorHandler);
            byte[] buffer = new byte[codePointLengthA];
            int codePointLength = codePointLengthA;
            int length = 0;
            int codeRange = TSCodeRange.get7Bit();
            DecodingErrorHandler decodingErrorHandler = TransCodeIntlNode.getDecodingErrorHandler(errorHandler);
            while (it.hasNext()) {
                curIndex = it.getRawIndex();
                codepoint = iteratorNextNode.execute(node, it, decodingErrorHandler);
                if (codepoint > 255) {
                    buffer = TStringOps.arraycopyOfWithStride(node, buffer, 0, length, 0, codePointLengthA, 1);
                    codeRange = TSCodeRange.get16Bit();
                    it.setRawIndex(curIndex);
                    break;
                }
                if (codepoint > 127) {
                    codeRange = TSCodeRange.get8Bit();
                }
                buffer[length++] = (byte)codepoint;
                TStringConstants.truffleSafePointPoll(node, length);
            }
            if (!it.hasNext()) {
                assert (length == codePointLengthA);
                return TransCodeIntlNode.create(a, buffer, length, 0, TruffleString.Encoding.UTF_16, codePointLengthA, codeRange);
            }
            while (it.hasNext()) {
                curIndex = it.getRawIndex();
                codepoint = iteratorNextNode.execute(node, it, decodingErrorHandler);
                if (codepoint > 65535) {
                    buffer = Arrays.copyOf(buffer, isLarge ? 0x7FFFFFF7 : buffer.length * 2);
                    codeRange = TSCodeRange.commonCodeRange(codeRange, TSCodeRange.getValidMultiByte());
                    it.setRawIndex(curIndex);
                    break;
                }
                isSurrogate = Encodings.isUTF16Surrogate(codepoint);
                if (isSurrogate) {
                    codepoint = TransCodeIntlNode.utfReplaceInvalid(codepoint, true, false, allowUTF16Surrogates);
                    codeRange = TSCodeRange.getBrokenMultiByte();
                }
                TStringOps.writeToByteArray(buffer, 1, length++, codepoint);
                TStringConstants.truffleSafePointPoll(node, length);
            }
            codePointLength = length;
            if (!it.hasNext()) {
                if (TStringGuards.isBrokenMultiByte(codeRange)) {
                    long attrs = TStringOps.calcStringAttributesUTF16(node, buffer, 0, length, false);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                    codeRange = StringAttributes.getCodeRange(attrs);
                }
                return TransCodeIntlNode.create(a, TransCodeIntlNode.trim(buffer, length * 2), length, 1, TruffleString.Encoding.UTF_16, codePointLength, codeRange);
            }
            int loopCount = 0;
            while (it.hasNext()) {
                codepoint = iteratorNextNode.execute(node, it, decodingErrorHandler);
                isSurrogate = Encodings.isUTF16Surrogate(codepoint);
                boolean isGreaterMax = TransCodeIntlNode.isGreaterThanMaxUTFCodepoint(codepoint);
                if (isSurrogate || isGreaterMax) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                    codepoint = TransCodeIntlNode.utfReplaceInvalid(codepoint, isSurrogate, isGreaterMax, allowUTF16Surrogates);
                }
                if (isLarge && length + Encodings.utf16EncodedSize(codepoint) > 0x3FFFFFFB) {
                    outOfMemoryProfile.enter(node);
                    throw InternalErrors.outOfMemory();
                }
                length += Encodings.utf16Encode(codepoint, buffer, length);
                ++codePointLength;
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            if (TStringGuards.isBrokenMultiByte(codeRange)) {
                long attrs = TStringOps.calcStringAttributesUTF16(node, buffer, 0, length, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            }
            return TransCodeIntlNode.create(a, Arrays.copyOf(buffer, length * 2), length, 1, TruffleString.Encoding.UTF_16, codePointLength, codeRange);
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding) || isUTF32FE(sourceEncoding)", "!isUTF16(sourceEncoding)", "isUTF16FE(targetEncoding)"})
        static TruffleString utf16FETranscode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode, @Cached @Cached.Shared(value="outOfMemoryProfile") InlinedBranchProfile outOfMemoryProfile, @Cached @Cached.Shared InlinedConditionProfile largeProfile) {
            return TransCodeIntlNode.utf16FETranscode(node, a, arrayA, codePointLengthA, codeRangeA, sourceEncoding, errorHandler, iteratorNextNode, largeProfile.profile(node, TransCodeIntlNode.isLarge(codePointLengthA)), outOfMemoryProfile);
        }

        private static TruffleString utf16FETranscode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TranscodingErrorHandler errorHandler, TruffleStringIterator.InternalNextNode iteratorNextNode, boolean isLarge, InlinedBranchProfile outOfMemoryProfile) {
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            boolean allowUTF16Surrogates = TransCodeIntlNode.isAllowUTF16SurrogatesUTF16Or32(errorHandler);
            byte[] buffer = new byte[isLarge ? 0x7FFFFFF7 : codePointLengthA << 2];
            int codePointLength = 0;
            int length = 0;
            int codeRange = TSCodeRange.getValidMultiByte();
            DecodingErrorHandler decodingErrorHandler = TransCodeIntlNode.getDecodingErrorHandler(errorHandler);
            int loopCount = 0;
            while (it.hasNext()) {
                int codepoint = iteratorNextNode.execute(node, it, decodingErrorHandler);
                boolean isSurrogate = Encodings.isUTF16Surrogate(codepoint);
                boolean isGreaterMax = TransCodeIntlNode.isGreaterThanMaxUTFCodepoint(codepoint);
                if (isSurrogate || isGreaterMax) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                    codepoint = TransCodeIntlNode.utfReplaceInvalid(codepoint, isSurrogate, isGreaterMax, allowUTF16Surrogates);
                }
                if (isLarge && length + Encodings.utf16EncodedSize(codepoint) > 0x3FFFFFFB) {
                    outOfMemoryProfile.enter(node);
                    throw InternalErrors.outOfMemory();
                }
                length += Encodings.utf16FEEncode(codepoint, buffer, length);
                ++codePointLength;
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            if (TStringGuards.isBrokenMultiByte(codeRange)) {
                long attrs = TStringOps.calcStringAttributesUTF16FE(node, buffer, 0, length);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            }
            return TransCodeIntlNode.create(a, Arrays.copyOf(buffer, length * 2), length << 1, 0, TruffleString.Encoding.UTF_16_FOREIGN_ENDIAN, codePointLength, codeRange);
        }

        @Specialization(guards={"!isUTF16(sourceEncoding)", "isSupportedEncoding(sourceEncoding) || isUTF16FE(sourceEncoding)", "!isFixedWidth(codeRangeA)", "!isLarge(codePointLengthA)", "isUTF32(targetEncoding)"})
        static TruffleString utf32TranscodeRegular(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            return TransCodeIntlNode.utf32Transcode(node, a, arrayA, codePointLengthA, codeRangeA, sourceEncoding, errorHandler, iteratorNextNode);
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding) || isUTF16FE(sourceEncoding)", "!isFixedWidth(codeRangeA)", "isLarge(codePointLengthA)", "isUTF32(targetEncoding)"})
        static TruffleString utf32TranscodeLarge(AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            throw InternalErrors.outOfMemory();
        }

        @Specialization(guards={"isUTF16(sourceEncoding)", "!isFixedWidth(codeRangeA)", "!isLarge(codePointLengthA)", "isUTF32(targetEncoding)"})
        static TruffleString utf32TranscodeUTF16(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            int codeRange;
            assert (TransCodeIntlNode.containsSurrogates(a));
            boolean allowUTF16Surrogates = TransCodeIntlNode.isAllowUTF16SurrogatesUTF16Or32(errorHandler);
            DecodingErrorHandler decodingErrorHandler = TransCodeIntlNode.getDecodingErrorHandler(errorHandler);
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            byte[] buffer = new byte[codePointLengthA << 2];
            int length = 0;
            while (it.hasNext()) {
                TStringOps.writeToByteArray(buffer, 2, length++, TransCodeIntlNode.utfReplaceInvalid(iteratorNextNode.execute(node, it, decodingErrorHandler), allowUTF16Surrogates));
                TStringConstants.truffleSafePointPoll(node, length);
            }
            assert (length == codePointLengthA);
            boolean isBroken = TStringGuards.isBrokenMultiByte(codeRangeA);
            int codePointLength = codePointLengthA;
            int n = codeRange = isBroken ? TSCodeRange.getBrokenFixedWidth() : TSCodeRange.getValidFixedWidth();
            if (isBroken && !allowUTF16Surrogates) {
                long attrs = TStringOps.calcStringAttributesUTF16(node, buffer, 0, length, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            }
            return TransCodeIntlNode.create(a, buffer, length, 2, TruffleString.Encoding.UTF_32, codePointLength, codeRange);
        }

        private static TruffleString utf32Transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TranscodingErrorHandler errorHandler, TruffleStringIterator.InternalNextNode iteratorNextNode) {
            int curIndex;
            assert (TStringGuards.isValidOrBrokenMultiByte(codeRangeA));
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            DecodingErrorHandler decodingErrorHandler = TransCodeIntlNode.getDecodingErrorHandler(errorHandler);
            byte[] buffer = new byte[codePointLengthA];
            int length = 0;
            int codeRange = TSCodeRange.get7Bit();
            int codepoint = 0;
            while (it.hasNext()) {
                curIndex = it.getRawIndex();
                codepoint = iteratorNextNode.execute(node, it, decodingErrorHandler);
                if (codepoint > 255) {
                    if (Encodings.isUTF16Surrogate(codepoint)) {
                        buffer = TStringOps.arraycopyOfWithStride(node, buffer, 0, length, 0, codePointLengthA, 2);
                        codeRange = TSCodeRange.getBrokenFixedWidth();
                    } else {
                        buffer = TStringOps.arraycopyOfWithStride(node, buffer, 0, length, 0, codePointLengthA, 1);
                        codeRange = TSCodeRange.get16Bit();
                    }
                    it.setRawIndex(curIndex);
                    break;
                }
                if (codepoint > 127) {
                    codeRange = TSCodeRange.get8Bit();
                }
                buffer[length++] = (byte)codepoint;
                TStringConstants.truffleSafePointPoll(node, length);
            }
            if (!it.hasNext()) {
                assert (length == codePointLengthA);
                return TransCodeIntlNode.create(a, buffer, length, 0, TruffleString.Encoding.UTF_32, codePointLengthA, codeRange);
            }
            if (TStringGuards.is16Bit(codeRange)) {
                while (it.hasNext()) {
                    curIndex = it.getRawIndex();
                    codepoint = iteratorNextNode.execute(node, it, decodingErrorHandler);
                    if (codepoint > 65535 || Encodings.isUTF16Surrogate(codepoint)) {
                        buffer = TStringOps.arraycopyOfWithStride(node, buffer, 0, length, 1, codePointLengthA, 2);
                        codeRange = Encodings.isValidUnicodeCodepoint(codepoint) ? TSCodeRange.getValidFixedWidth() : TSCodeRange.getBrokenFixedWidth();
                        it.setRawIndex(curIndex);
                        break;
                    }
                    TStringOps.writeToByteArray(buffer, 1, length++, codepoint);
                    TStringConstants.truffleSafePointPoll(node, length);
                }
            }
            if (!it.hasNext()) {
                assert (length == codePointLengthA || sourceEncoding == TruffleString.Encoding.UTF_8 && TStringGuards.isBrokenMultiByte(codeRangeA));
                return TransCodeIntlNode.create(a, TransCodeIntlNode.trim(buffer, length * 2), length, 1, TruffleString.Encoding.UTF_32, length, codeRange);
            }
            while (it.hasNext()) {
                codepoint = iteratorNextNode.execute(node, it, decodingErrorHandler);
                boolean isSurrogate = Encodings.isUTF16Surrogate(codepoint);
                boolean isGreaterMax = TransCodeIntlNode.isGreaterThanMaxUTFCodepoint(codepoint);
                if (isSurrogate || isGreaterMax) {
                    codeRange = TSCodeRange.getBrokenFixedWidth();
                    codepoint = TransCodeIntlNode.utfReplaceInvalid(codepoint, isSurrogate, isGreaterMax, TransCodeIntlNode.isAllowUTF16SurrogatesUTF16Or32(errorHandler));
                }
                TStringOps.writeToByteArray(buffer, 2, length++, codepoint);
                TStringConstants.truffleSafePointPoll(node, length);
            }
            return TransCodeIntlNode.create(a, TransCodeIntlNode.trim(buffer, length * 4), length, 2, TruffleString.Encoding.UTF_32, length, codeRange);
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding) || isUTF16FE(sourceEncoding)", "!isUTF32(sourceEncoding)", "!isLarge(codePointLengthA)", "isUTF32FE(targetEncoding)"})
        static TruffleString utf32FETranscodeRegular(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared(value="iteratorNextNode") TruffleStringIterator.InternalNextNode iteratorNextNode) {
            return TransCodeIntlNode.utf32FETranscode(node, a, arrayA, codePointLengthA, codeRangeA, sourceEncoding, errorHandler, iteratorNextNode);
        }

        @Specialization(guards={"isSupportedEncoding(sourceEncoding) || isUTF16FE(sourceEncoding)", "!isUTF32(sourceEncoding)", "isLarge(codePointLengthA)", "isUTF32FE(targetEncoding)"})
        static TruffleString utf32FETranscodeLarge(AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            throw InternalErrors.outOfMemory();
        }

        private static TruffleString utf32FETranscode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TranscodingErrorHandler errorHandler, TruffleStringIterator.InternalNextNode iteratorNextNode) {
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            DecodingErrorHandler decodingErrorHandler = TransCodeIntlNode.getDecodingErrorHandler(errorHandler);
            byte[] buffer = new byte[codePointLengthA << 2];
            int length = 0;
            int codeRange = TSCodeRange.getValidMultiByte();
            while (it.hasNext()) {
                int codepoint = iteratorNextNode.execute(node, it, decodingErrorHandler);
                boolean isSurrogate = Encodings.isUTF16Surrogate(codepoint);
                boolean isGreaterMax = TransCodeIntlNode.isGreaterThanMaxUTFCodepoint(codepoint);
                if (isSurrogate || isGreaterMax) {
                    codeRange = TSCodeRange.getBrokenMultiByte();
                    codepoint = TransCodeIntlNode.utfReplaceInvalid(codepoint, isSurrogate, isGreaterMax, TransCodeIntlNode.isAllowUTF16SurrogatesUTF16Or32(errorHandler));
                }
                TStringOps.writeToByteArray(buffer, 2, length++, Integer.reverseBytes(codepoint));
                TStringConstants.truffleSafePointPoll(node, length);
            }
            return TransCodeIntlNode.create(a, TransCodeIntlNode.trim(buffer, length << 2), length << 2, 0, TruffleString.Encoding.UTF_32_FOREIGN_ENDIAN, length, codeRange);
        }

        @Specialization(guards={"!isSupportedOrUTFFE(sourceEncoding) || !isSupportedOrUTFFE(targetEncoding)"})
        static TruffleString unsupported(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode) {
            return JCodings.getInstance().transcode(node, a, arrayA, codePointLengthA, targetEncoding, fromBufferWithStringCompactionNode, errorHandler);
        }

        static boolean isSupportedOrUTFFE(TruffleString.Encoding encoding) {
            return TStringGuards.isSupportedEncoding(encoding) || TStringGuards.isUTF16FE(encoding) || TStringGuards.isUTF32FE(encoding);
        }

        private static byte[] trim(byte[] array, int byteLength) {
            if (byteLength != array.length) {
                return Arrays.copyOf(array, byteLength);
            }
            return array;
        }

        private static DecodingErrorHandler getDecodingErrorHandler(TranscodingErrorHandler errorHandler) {
            assert (errorHandler == TranscodingErrorHandler.DEFAULT || errorHandler == TranscodingErrorHandler.DEFAULT_KEEP_SURROGATES_IN_UTF8);
            CompilerAsserts.partialEvaluationConstant(errorHandler);
            DecodingErrorHandler decodingErrorHandler = errorHandler == TranscodingErrorHandler.DEFAULT ? DecodingErrorHandler.DEFAULT_UTF8_INCOMPLETE_SEQUENCES : DecodingErrorHandler.DEFAULT_KEEP_SURROGATES_IN_UTF8;
            CompilerAsserts.partialEvaluationConstant(decodingErrorHandler);
            return decodingErrorHandler;
        }

        static boolean isAllowUTF16SurrogatesUTF16Or32(TranscodingErrorHandler errorHandler) {
            return TStringGuards.isBuiltin(errorHandler);
        }

        private static boolean isGreaterThanMaxUTFCodepoint(int codepoint) {
            return Integer.toUnsignedLong(codepoint) > 0x10FFFFL;
        }

        private static int utfReplaceInvalid(int codepoint, boolean allowUTF16Surrogates) {
            return TransCodeIntlNode.utfReplaceInvalid(codepoint, Encodings.isUTF16Surrogate(codepoint), TransCodeIntlNode.isGreaterThanMaxUTFCodepoint(codepoint), allowUTF16Surrogates);
        }

        private static int utfReplaceInvalid(int codepoint, boolean isSurrogate, boolean isGreaterThanMaxCodepoint, boolean allowUTF16Surrogates) {
            if (isGreaterThanMaxCodepoint || isSurrogate && !allowUTF16Surrogates) {
                return Encodings.invalidCodepoint();
            }
            return codepoint;
        }

        private static TruffleString create(AbstractTruffleString a, byte[] buffer, int length, int stride, TruffleString.Encoding encoding, int codePointLength, int codeRange) {
            return TransCodeIntlNode.create(a, buffer, length, stride, encoding, codePointLength, codeRange, false);
        }

        private static TruffleString create(AbstractTruffleString a, byte[] buffer, int length, int stride, TruffleString.Encoding encoding, int codePointLength, int codeRange, boolean replacedChars) {
            return TruffleString.createFromByteArray(buffer, length, stride, encoding, codePointLength, codeRange, TSCodeRange.isBroken(a.codeRange()) || TSCodeRange.isBroken(codeRange) || a.isMutable() || replacedChars);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean containsSurrogates(AbstractTruffleString a) {
            CompilerAsserts.neverPartOfCompilation();
            for (int i = 0; i < a.length(); ++i) {
                if (!Encodings.isUTF16Surrogate(a.readCharUTF16Uncached(i))) continue;
                return true;
            }
            return false;
        }
    }

    static abstract class TransCodeIntlWithErrorHandlerNode
    extends AbstractInternalNode {
        TransCodeIntlWithErrorHandlerNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, TruffleString.Encoding var6, TruffleString.Encoding var7, TranscodingErrorHandler var8);

        @Specialization(guards={"isBroken(codeRangeA) || isAsciiBytesOrLatin1(targetEncoding)", "isSupportedEncoding(sourceEncoding)", "isSupportedEncoding(targetEncoding)", "!isBuiltin(errorHandler)"})
        static TruffleString supportedWithCustomErrorHandler(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached TruffleStringIterator.InternalNextNode iteratorNextNode, @Cached TruffleStringBuilder.AppendCodePointIntlNode appendCodePointNode, @Cached TruffleStringBuilder.AppendStringIntlNode appendStringNode, @Cached TruffleStringBuilder.ToStringIntlNode toStringNode) {
            TruffleStringBuilder sb = TruffleStringBuilder.create(targetEncoding);
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, sourceEncoding);
            int maxCodePoint = Encodings.maxCodePoint(targetEncoding);
            int i = 1;
            while (it.hasNext()) {
                int pos = it.getRawIndex();
                int bytePos = it.getByteIndex();
                int codepoint = iteratorNextNode.execute(node, it, DecodingErrorHandler.RETURN_NEGATIVE_UTF8_INCOMPLETE_SEQUENCES);
                if (Integer.compareUnsigned(codepoint, maxCodePoint) <= 0) {
                    appendCodePointNode.execute(node, sb, codepoint, 1, false);
                } else {
                    TranscodingErrorHandler.ReplacementString replacementString = errorHandler.apply(a, bytePos, it.getByteIndex() - bytePos, sourceEncoding, targetEncoding);
                    if (replacementString.byteLength() >= 0) {
                        it.setRawIndex(pos);
                        it.errorHandlerSkipBytes(replacementString.byteLength(), true);
                    }
                    appendStringNode.execute(node, sb, replacementString.replacement());
                }
                TStringConstants.truffleSafePointPoll(node, i++);
            }
            return toStringNode.execute(node, sb, false);
        }

        @Fallback
        static TruffleString transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding sourceEncoding, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached TransCodeIntlNode transCodeIntlNode) {
            return transCodeIntlNode.execute(node, a, arrayA, codePointLengthA, codeRangeA, sourceEncoding, targetEncoding, errorHandler);
        }
    }

    static abstract class TransCodeNode
    extends AbstractInternalNode {
        TransCodeNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, TruffleString.Encoding var6, TranscodingErrorHandler var7);

        @Specialization
        static TruffleString transcode(Node node, AbstractTruffleString a, Object arrayA, int codePointLengthA, int codeRangeA, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached InlinedConditionProfile asciiBytesInvalidProfile, @Cached TransCodeIntlWithErrorHandlerNode transCodeIntlNode) {
            CompilerAsserts.partialEvaluationConstant(errorHandler);
            if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS && a.isImmutable() && TSCodeRange.isMoreRestrictiveThan(codeRangeA, targetEncoding.maxCompatibleCodeRange)) {
                if (a.stride() == 0) {
                    return TruffleString.createFromArray(arrayA, a.offset(), a.length(), 0, targetEncoding, codePointLengthA, codeRangeA, false);
                }
                int targetStride = Stride.fromCodeRange(codeRangeA, targetEncoding);
                byte[] array = TStringOps.arraycopyOfWithStride(node, arrayA, a.offset(), a.length(), a.stride(), a.length(), targetStride);
                return TruffleString.createFromArray(array, 0, a.length(), targetStride, targetEncoding, codePointLengthA, codeRangeA, false);
            }
            assert (a.length() > 0);
            if (asciiBytesInvalidProfile.profile(node, (TStringGuards.isAscii(a.encoding()) || TStringGuards.isBytes(a.encoding())) && TStringGuards.isSupportedEncoding(targetEncoding) && TStringGuards.isBuiltin(errorHandler))) {
                assert ((TStringGuards.isBrokenFixedWidth(codeRangeA) || TStringGuards.isValidFixedWidth(codeRangeA)) && TStringGuards.isStride0(a) && codePointLengthA == a.length());
                boolean replacedChars = false;
                byte[] buffer = new byte[codePointLengthA];
                for (int i = 0; i < buffer.length; ++i) {
                    int c = TStringOps.readS0(a, arrayA, i);
                    if (c > 127) {
                        buffer[i] = 63;
                        replacedChars = true;
                    } else {
                        buffer[i] = (byte)c;
                    }
                    TStringConstants.truffleSafePointPoll(node, i + 1);
                }
                return TransCodeIntlNode.create(a, buffer, buffer.length, 0, targetEncoding, codePointLengthA, TSCodeRange.get7Bit(), replacedChars);
            }
            return transCodeIntlNode.execute(node, a, arrayA, codePointLengthA, codeRangeA, TruffleString.Encoding.get(a.encoding()), targetEncoding, errorHandler);
        }
    }

    static abstract class ToValidStringNode
    extends AbstractInternalNode {
        private static final int[] UTF_32_ASTRAL_RANGE = new int[]{65536, 0x10FFFF};
        private static final int[] UTF_32_INVALID_RANGES = new int[]{55296, 57343, 0x110000, -1};

        ToValidStringNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, Object var3, TruffleString.Encoding var4);

        @Specialization(guards={"isAscii(encoding)"})
        static TruffleString ascii(Node node, AbstractTruffleString a, Object arrayA, TruffleString.Encoding encoding) {
            assert (TStringGuards.isStride0(a));
            int length = a.length();
            byte[] array = TStringOps.arraycopyOfWithStride(node, arrayA, a.offset(), length, 0, length, 0);
            int pos = 0;
            int loopCount = 0;
            while (pos < length && (pos = TStringOps.indexOfCodePointWithMaskWithStrideIntl(node, array, 0, length, 0, pos, 255, 127)) >= 0) {
                TStringOps.writeToByteArray(array, 0, pos++, 63);
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            return TruffleString.createFromByteArray(array, length, 0, TruffleString.Encoding.US_ASCII, length, TSCodeRange.get7Bit());
        }

        @Specialization(guards={"isUTF8(encoding)"})
        static TruffleString utf8(Node node, AbstractTruffleString a, Object arrayA, TruffleString.Encoding encoding, @Cached InlinedBranchProfile outOfMemoryProfile) {
            assert (TStringGuards.isStride0(a));
            assert (TSCodeRange.isPrecise(a.codeRange()));
            assert (a.isCodePointLengthKnown());
            boolean isLarge = TransCodeIntlNode.isLarge(a.codePointLength());
            byte[] buffer = new byte[isLarge ? 0x7FFFFFF7 : a.codePointLength() * 4];
            int length = 0;
            int state = 0;
            int lastCodePointPos = 0;
            int lastErrorPos = 0;
            int codePointLength = a.codePointLength();
            byte[] stateMachine = Encodings.UTF_8_STATE_MACHINE;
            int i = 0;
            while (i < a.length()) {
                int b;
                byte type;
                if ((state = stateMachine[256 + state + (type = stateMachine[b = TStringOps.readS0(a, arrayA, i++)])]) == 0) {
                    lastCodePointPos = i;
                } else if (state == 12) {
                    int curCPLength = i - (lastCodePointPos + 1);
                    length = ToValidStringNode.utf8CopyValidRegion(node, a, arrayA, outOfMemoryProfile, isLarge, buffer, length, lastCodePointPos, lastErrorPos);
                    System.arraycopy(Encodings.CONVERSION_REPLACEMENT_UTF_8, 0, buffer, length, Encodings.CONVERSION_REPLACEMENT_UTF_8.length);
                    length += Encodings.CONVERSION_REPLACEMENT_UTF_8.length;
                    state = 0;
                    if (curCPLength > 1) {
                        codePointLength -= curCPLength - 1;
                    }
                    lastErrorPos = --i;
                    lastCodePointPos = i;
                }
                TStringConstants.truffleSafePointPoll(node, i);
            }
            length = ToValidStringNode.utf8CopyValidRegion(node, a, arrayA, outOfMemoryProfile, isLarge, buffer, length, lastCodePointPos, lastErrorPos);
            if (lastCodePointPos != a.length() && lastErrorPos != lastCodePointPos) {
                System.arraycopy(Encodings.CONVERSION_REPLACEMENT_UTF_8, 0, buffer, length, Encodings.CONVERSION_REPLACEMENT_UTF_8.length);
                length += Encodings.CONVERSION_REPLACEMENT_UTF_8.length;
                int curCPLength = a.length() - lastCodePointPos;
                if (curCPLength > 1) {
                    codePointLength -= curCPLength - 1;
                }
            }
            return TruffleString.createFromByteArray(Arrays.copyOf(buffer, length), length, 0, TruffleString.Encoding.UTF_8, codePointLength, TSCodeRange.getValidMultiByte());
        }

        private static int utf8CopyValidRegion(Node node, AbstractTruffleString a, Object arrayA, InlinedBranchProfile outOfMemoryProfile, boolean isLarge, byte[] buffer, int length, int lastCodePointPos, int lastErrorPos) {
            int lengthCPY = lastCodePointPos - lastErrorPos;
            if (isLarge && Integer.compareUnsigned(length + lengthCPY + Encodings.CONVERSION_REPLACEMENT_UTF_8.length, buffer.length) > 0) {
                outOfMemoryProfile.enter(node);
                throw InternalErrors.outOfMemory();
            }
            TStringOps.arraycopyWithStride(node, arrayA, a.offset(), 0, lastErrorPos, buffer, 0, 0, length, lengthCPY);
            return length + lengthCPY;
        }

        @Specialization(guards={"isUTF16(encoding)"})
        static TruffleString utf16(Node node, AbstractTruffleString a, Object arrayA, TruffleString.Encoding encoding) {
            assert (TStringGuards.isStride1(a));
            int length = a.length();
            byte[] array = TStringOps.arraycopyOfWithStride(node, arrayA, a.offset(), length, 1, length, 1);
            int pos = 0;
            int codeRange = TSCodeRange.get16Bit();
            int loopCount = 0;
            while ((pos = TStringOps.indexOfCodePointWithMaskWithStrideIntl(node, array, 0, length, 1, pos, 57343, 2047)) >= 0) {
                boolean invalid = true;
                if (pos != length - 1) {
                    char c = (char)TStringOps.readFromByteArray(array, 1, pos);
                    assert (Encodings.isUTF16Surrogate(c));
                    if (!Encodings.isUTF16LowSurrogate(c)) {
                        assert (Encodings.isUTF16HighSurrogate(c));
                        if (Encodings.isUTF16LowSurrogate((char)TStringOps.readFromByteArray(array, 1, pos + 1))) {
                            invalid = false;
                            codeRange = TSCodeRange.getValidMultiByte();
                            ++pos;
                        }
                    }
                }
                if (invalid) {
                    TStringOps.writeToByteArray(array, 1, pos, 65533);
                }
                if (++pos == length) break;
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            return TruffleString.createFromByteArray(array, length, 1, TruffleString.Encoding.UTF_16, a.codePointLength(), codeRange);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static TruffleString utf32(Node node, AbstractTruffleString a, Object arrayA, TruffleString.Encoding encoding, @Cached InlinedConditionProfile strideProfile) {
            int codeRange;
            int stride;
            byte[] array;
            assert (TStringGuards.isStride2(a));
            int length = a.length();
            if (strideProfile.profile(node, TStringOps.indexOfAnyIntRange(node, arrayA, 0, 2, 0, a.length(), UTF_32_ASTRAL_RANGE) < 0)) {
                array = TStringOps.arraycopyOfWithStride(node, arrayA, a.offset(), length, 2, length, 1);
                stride = 1;
                codeRange = TSCodeRange.get16Bit();
                ToValidStringNode.utf32ReplaceInvalid(node, arrayA, length, array, 1);
            } else {
                array = TStringOps.arraycopyOfWithStride(node, arrayA, a.offset(), length, 2, length, 2);
                stride = 2;
                codeRange = TSCodeRange.getValidFixedWidth();
                ToValidStringNode.utf32ReplaceInvalid(node, arrayA, length, array, 2);
            }
            return TruffleString.createFromByteArray(array, length, stride, TruffleString.Encoding.UTF_32, a.codePointLength(), codeRange);
        }

        private static void utf32ReplaceInvalid(Node node, Object arrayA, int length, byte[] array, int stride) {
            int pos = 0;
            int loopCount = 0;
            while (pos < length && (pos = TStringOps.indexOfAnyIntRange(node, arrayA, 0, 2, pos, length, UTF_32_INVALID_RANGES)) >= 0) {
                TStringOps.writeToByteArray(array, stride, pos++, 65533);
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)"})
        static TruffleString unsupported(Node node, AbstractTruffleString a, Object arrayA, TruffleString.Encoding encoding) {
            throw InternalErrors.unsupportedOperation();
        }
    }

    static abstract class CreateJavaStringNode
    extends AbstractInternalNode {
        CreateJavaStringNode() {
        }

        abstract String execute(Node var1, AbstractTruffleString var2, Object var3);

        @Specialization
        static String createJavaString(Node node, AbstractTruffleString a, Object arrayA, @Cached InlinedConditionProfile reuseProfile) {
            byte[] bytes;
            assert (TSCodeRange.is7Or8Bit(a.codeRange()) || TSCodeRange.isPrecise(a.codeRange()));
            assert (a.isLooselyCompatibleTo(TruffleString.Encoding.UTF_16));
            int stride = TStringUnsafe.COMPACT_STRINGS_ENABLED ? Stride.fromCodeRangeUTF16(a.codeRange()) : 1;
            if (reuseProfile.profile(node, a instanceof TruffleString && arrayA instanceof byte[] && a.length() << a.stride() == ((byte[])arrayA).length && a.stride() == stride)) {
                assert (a.offset() == 0);
                bytes = (byte[])arrayA;
            } else {
                bytes = new byte[a.length() << stride];
                TStringOps.arraycopyWithStride(node, arrayA, a.offset(), a.stride(), 0, bytes, 0, stride, 0, a.length());
            }
            return TStringUnsafe.createJavaString(bytes, stride);
        }
    }

    static abstract class FromJavaStringUTF16Node
    extends AbstractInternalNode {
        FromJavaStringUTF16Node() {
        }

        abstract TruffleString execute(Node var1, String var2, int var3, int var4, boolean var5);

        @Specialization
        static TruffleString doNonEmpty(Node node, String javaString, int charOffset, int length, boolean copy, @Cached InlinedConditionProfile utf16CompactProfile) {
            byte[] array;
            int offset;
            int stride;
            int codePointLength;
            int codeRange;
            AbstractTruffleString.checkArrayRange(javaString.length(), charOffset, length);
            CompilerAsserts.partialEvaluationConstant(copy);
            if (length == 0) {
                return TruffleString.Encoding.UTF_16.getEmpty();
            }
            int strideJS = TStringUnsafe.getJavaStringStride(javaString);
            int offsetJS = charOffset << 1;
            byte[] arrayJS = TStringUnsafe.getJavaStringArray(javaString);
            if (utf16CompactProfile.profile(node, strideJS == 0)) {
                if (length == 1) {
                    return TStringConstants.getSingleByte(TruffleString.Encoding.UTF_16, Byte.toUnsignedInt(arrayJS[charOffset]));
                }
                codeRange = TSCodeRange.markImprecise(TSCodeRange.get8Bit());
                codePointLength = length;
            } else {
                assert (strideJS == 1);
                if (length == 1 && TStringOps.readFromByteArray(arrayJS, 1, charOffset) <= 255) {
                    return TStringConstants.getSingleByte(TruffleString.Encoding.UTF_16, TStringOps.readFromByteArray(arrayJS, 1, charOffset));
                }
                if (TStringUnsafe.COMPACT_STRINGS_ENABLED && length == javaString.length()) {
                    codePointLength = -1;
                    codeRange = TSCodeRange.markImprecise(TSCodeRange.getBrokenMultiByte());
                } else {
                    long attrs = TStringOps.calcStringAttributesUTF16(node, arrayJS, offsetJS, length, false);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                    codeRange = StringAttributes.getCodeRange(attrs);
                }
            }
            if (TStringUnsafe.COMPACT_STRINGS_ENABLED && (!copy || length == javaString.length())) {
                stride = strideJS;
                offset = offsetJS;
                array = arrayJS;
            } else {
                stride = Stride.fromCodeRangeUTF16AllowImprecise(codeRange);
                array = new byte[length << stride];
                offset = 0;
                if (strideJS == 1 && stride == 0) {
                    TStringOps.arraycopyWithStride(node, arrayJS, offsetJS, 1, 0, array, offset, 0, 0, length);
                } else {
                    assert (strideJS == stride);
                    TStringOps.arraycopyWithStride(node, arrayJS, offsetJS, 0, 0, array, offset, 0, 0, length << stride);
                }
            }
            TruffleString ret = TruffleString.createFromArray(array, offset, length, stride, TruffleString.Encoding.UTF_16, codePointLength, codeRange);
            if (length == javaString.length()) {
                assert (charOffset == 0);
                TruffleString wrapped = TruffleString.createWrapJavaString(javaString, codePointLength, codeRange);
                ret.cacheInsertFirstBeforePublished(wrapped);
            }
            return ret;
        }
    }

    static abstract class ParseDoubleNode
    extends AbstractInternalNode {
        ParseDoubleNode() {
        }

        abstract double execute(Node var1, AbstractTruffleString var2, Object var3) throws TruffleString.NumberFormatException;

        @Specialization(guards={"compaction == cachedCompaction"}, limit="3", unroll=3)
        static double doParse(Node node, AbstractTruffleString a, Object arrayA, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return FastDoubleParser.parseDouble(node, a, arrayA, cachedCompaction.getStride(), 0, a.length(), errorProfile);
        }
    }

    static abstract class ParseLongNode
    extends AbstractInternalNode {
        ParseLongNode() {
        }

        abstract long execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6) throws TruffleString.NumberFormatException;

        @Specialization(guards={"is7Bit(codeRangeA)", "compaction == cachedCompaction"}, limit="3", unroll=3)
        static long do7Bit(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int radix, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return NumberConversion.parseLong7Bit(node, a, arrayA, cachedCompaction.getStride(), radix, errorProfile);
        }

        @Specialization(guards={"!is7Bit(codeRangeA)"})
        static long parseLong(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int radix, @Cached TruffleStringIterator.InternalNextNode nextNode, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return NumberConversion.parseLong(node, AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding), radix, errorProfile, nextNode);
        }
    }

    static abstract class ParseIntNode
    extends AbstractInternalNode {
        ParseIntNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6) throws TruffleString.NumberFormatException;

        @Specialization(guards={"is7Bit(codeRangeA)", "compaction == cachedCompaction"}, limit="3", unroll=3)
        static int do7Bit(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int radix, @Bind(value="fromStride(a.stride())") TruffleString.CompactionLevel compaction, @Cached(value="compaction") TruffleString.CompactionLevel cachedCompaction, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return NumberConversion.parseInt7Bit(node, a, arrayA, cachedCompaction.getStride(), radix, errorProfile);
        }

        @Specialization(guards={"!is7Bit(codeRangeA)"})
        static int doGeneric(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int radix, @Cached TruffleStringIterator.InternalNextNode nextNode, @Cached InlinedBranchProfile errorProfile) throws TruffleString.NumberFormatException {
            return NumberConversion.parseInt(node, AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding), radix, errorProfile, nextNode);
        }
    }

    static abstract class CalcStringAttributesInnerNode
    extends AbstractInternalNode {
        CalcStringAttributesInnerNode() {
        }

        abstract long execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, int var6, TruffleString.Encoding var7, int var8, int var9);

        @Specialization(guards={"is8Bit(knownCodeRange) || isAsciiBytesOrLatin1(encoding)", "stride == 0"})
        long doLatin1(AbstractTruffleString a, Object array, int offset, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            int codeRange = TStringOps.calcStringAttributesLatin1(this, array, offset + fromIndex, length);
            return StringAttributes.create(length, TStringGuards.is8Bit(codeRange) && TStringGuards.isAsciiBytesOrLatin1(encoding) ? TSCodeRange.asciiLatinBytesNonAsciiCodeRange(encoding) : codeRange);
        }

        @Specialization(guards={"isUpTo16Bit(knownCodeRange)", "stride == 1"})
        long doBMP(AbstractTruffleString a, Object array, int offset, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            return StringAttributes.create(length, TStringOps.calcStringAttributesBMP(this, array, offset + (fromIndex << 1), length));
        }

        @Specialization(guards={"isUTF8(encoding)", "!isFixedWidth(knownCodeRange)"})
        static long doUTF8(Node node, AbstractTruffleString a, Object array, int offset, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange, @Cached.Exclusive @Cached InlinedConditionProfile brokenProfile) {
            assert (stride == 0);
            int off = offset + fromIndex;
            if (TStringGuards.isValid(knownCodeRange) && a != null) {
                return TStringOps.calcStringAttributesUTF8(node, array, off, length, true, off + length == a.offset() + a.length(), brokenProfile);
            }
            return TStringOps.calcStringAttributesUTF8(node, array, off, length, false, false, brokenProfile);
        }

        @Specialization(guards={"isUTF16(encoding)", "isValid(knownCodeRange)"})
        long doUTF16Valid(AbstractTruffleString a, Object array, int offset, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            assert (stride == 1);
            return TStringOps.calcStringAttributesUTF16(this, array, offset + (fromIndex << 1), length, true);
        }

        @Specialization(guards={"isUTF16(encoding)", "isBroken(knownCodeRange)"})
        long doUTF16Unknown(AbstractTruffleString a, Object array, int offset, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            assert (stride == 1);
            return TStringOps.calcStringAttributesUTF16(this, array, offset + (fromIndex << 1), length, false);
        }

        @Specialization(guards={"stride == 2"})
        long doUTF32(AbstractTruffleString a, Object array, int offset, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            assert (TStringGuards.isUTF32(encoding));
            return StringAttributes.create(length, TStringOps.calcStringAttributesUTF32(this, array, offset + (fromIndex << 2), length));
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"isUTF16FE(encoding)"})
        long doUTF16FE(AbstractTruffleString a, Object array, int offset, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            assert (stride == 0);
            return TStringOps.calcStringAttributesUTF16FE(this, array, offset + fromIndex, length >> 1);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"isUTF32FE(encoding)"})
        long doUTF32FE(AbstractTruffleString a, Object array, int offset, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange) {
            assert (stride == 0);
            return StringAttributes.create(length >> 2, TStringOps.calcStringAttributesUTF32FE(this, array, offset + fromIndex, length >> 2));
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isUTF16FE(encoding)", "!isUTF32FE(encoding)"})
        static long doGeneric(Node node, AbstractTruffleString a, Object array, int offset, int length, int stride, TruffleString.Encoding encoding, int fromIndex, int knownCodeRange, @Cached.Exclusive @Cached InlinedConditionProfile validCharacterProfile, @Cached.Exclusive @Cached InlinedConditionProfile fixedWidthProfile) {
            assert (stride == 0);
            return JCodings.getInstance().calcStringAttributes(node, array, offset, length, encoding, fromIndex, validCharacterProfile, fixedWidthProfile);
        }
    }

    static abstract class StrideFromCodeRangeNode
    extends AbstractInternalNode {
        StrideFromCodeRangeNode() {
        }

        abstract int execute(Node var1, int var2, TruffleString.Encoding var3);

        @Specialization(guards={"isUTF16(encoding)"})
        int doUTF16(int codeRange, TruffleString.Encoding encoding) {
            return Stride.fromCodeRangeUTF16(codeRange);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        int doUTF32(int codeRange, TruffleString.Encoding encoding) {
            return Stride.fromCodeRangeUTF32(codeRange);
        }

        @Specialization(guards={"!isUTF16(encoding)", "!isUTF32(encoding)"})
        int doOther(int codeRange, TruffleString.Encoding encoding) {
            return 0;
        }
    }

    static abstract class LastIndexOfStringRawNode
    extends AbstractInternalNode {
        LastIndexOfStringRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, AbstractTruffleString var5, Object var6, int var7, int var8, int var9, byte[] var10, TruffleString.Encoding var11);

        @Specialization(guards={"isSupportedEncoding(encoding) || isFixedWidth(codeRangeA)"})
        static int lios8SameEncoding(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b, Object arrayB, int codeRangeB, int fromIndex, int toIndex, byte[] mask, TruffleString.Encoding encoding, @Cached TStringOpsNodes.RawLastIndexOfStringNode indexOfStringNode) {
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(codeRangeA, b, codeRangeB, mask, fromIndex - toIndex));
            return indexOfStringNode.execute(node, a, arrayA, b, arrayB, fromIndex, toIndex, mask);
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isFixedWidth(codeRangeA)"})
        static int unsupported(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b, Object arrayB, int codeRangeB, int fromIndex, int toIndex, byte[] mask, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalPreviousNode prevNodeA, @Cached TruffleStringIterator.InternalPreviousNode prevNodeB) {
            assert (mask == null);
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(codeRangeA, b, codeRangeB, mask, fromIndex - toIndex));
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.backwardIterator(b, arrayB, codeRangeB, encoding);
            return TruffleStringIterator.lastByteIndexOfString(node, aIt, bIt, fromIndex, toIndex, nextNodeA, prevNodeA, prevNodeB);
        }
    }

    static abstract class LastIndexOfStringNode
    extends AbstractInternalNode {
        LastIndexOfStringNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, AbstractTruffleString var5, Object var6, int var7, int var8, int var9, TruffleString.Encoding var10);

        @Specialization(guards={"isFixedWidth(codeRangeA, codeRangeB)"})
        static int direct(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b, Object arrayB, int codeRangeB, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached TStringOpsNodes.RawLastIndexOfStringNode indexOfStringNode) {
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(node, codeRangeA, b, codeRangeB, fromIndex - toIndex, encoding, GetCodePointLengthNode.getUncached()));
            return indexOfStringNode.execute(node, a, arrayA, b, arrayB, fromIndex, toIndex, null);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA, codeRangeB)"})
        static int decode(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b, Object arrayB, int codeRangeB, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalPreviousNode prevNodeA, @Cached TruffleStringIterator.InternalPreviousNode prevNodeB) {
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(node, codeRangeA, b, codeRangeB, fromIndex - toIndex, encoding, GetCodePointLengthNode.getUncached()));
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.backwardIterator(b, arrayB, codeRangeB, encoding);
            return TruffleStringIterator.lastIndexOfString(node, aIt, bIt, fromIndex, toIndex, nextNodeA, prevNodeA, prevNodeB);
        }
    }

    static abstract class IndexOfStringRawNode
    extends AbstractInternalNode {
        IndexOfStringRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, AbstractTruffleString var5, Object var6, int var7, int var8, int var9, byte[] var10, TruffleString.Encoding var11);

        @Specialization(guards={"isSupportedEncoding(encoding) || isFixedWidth(codeRangeA)"})
        static int supported(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b, Object arrayB, int codeRangeB, int fromIndex, int toIndex, byte[] mask, TruffleString.Encoding encoding, @Cached TStringOpsNodes.RawIndexOfStringNode indexOfStringNode) {
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(codeRangeA, b, codeRangeB, mask, toIndex - fromIndex));
            return indexOfStringNode.execute(node, a, arrayA, b, arrayB, fromIndex, toIndex, mask);
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isFixedWidth(codeRangeA)"})
        static int unsupported(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b, Object arrayB, int codeRangeB, int fromIndex, int toIndex, byte[] mask, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalNextNode nextNodeB) {
            assert (mask == null);
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(codeRangeA, b, codeRangeB, mask, toIndex - fromIndex));
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.forwardIterator(b, arrayB, codeRangeB, encoding);
            return TruffleStringIterator.byteIndexOfString(node, aIt, bIt, fromIndex, toIndex, nextNodeA, nextNodeB);
        }
    }

    static abstract class InternalIndexOfStringNode
    extends AbstractInternalNode {
        InternalIndexOfStringNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, AbstractTruffleString var5, Object var6, int var7, int var8, int var9, TruffleString.Encoding var10);

        @Specialization(guards={"isFixedWidth(codeRangeA, codeRangeB)"})
        static int direct(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b, Object arrayB, int codeRangeB, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached TStringOpsNodes.RawIndexOfStringNode indexOfStringNode) {
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(node, codeRangeA, b, codeRangeB, toIndex - fromIndex, encoding, GetCodePointLengthNode.getUncached()));
            return indexOfStringNode.execute(node, a, arrayA, b, arrayB, fromIndex, toIndex, null);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA, codeRangeB)"})
        static int decode(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, AbstractTruffleString b, Object arrayB, int codeRangeB, int fromIndex, int toIndex, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalNextNode nextNodeB) {
            assert (!b.isEmpty() && !TStringGuards.indexOfCannotMatch(node, codeRangeA, b, codeRangeB, toIndex - fromIndex, encoding, GetCodePointLengthNode.getUncached()));
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.forwardIterator(b, arrayB, codeRangeB, encoding);
            return TruffleStringIterator.indexOfString(node, aIt, bIt, fromIndex, toIndex, nextNodeA, nextNodeB);
        }
    }

    static abstract class RegionEqualsNode
    extends AbstractInternalNode {
        RegionEqualsNode() {
        }

        abstract boolean execute(Node var1, AbstractTruffleString var2, Object var3, int var4, int var5, AbstractTruffleString var6, Object var7, int var8, int var9, int var10, TruffleString.Encoding var11);

        @Specialization(guards={"isFixedWidth(codeRangeA, codeRangeB)"})
        boolean direct(AbstractTruffleString a, Object arrayA, int codeRangeA, int fromIndexA, AbstractTruffleString b, Object arrayB, int codeRangeB, int fromIndexB, int length, TruffleString.Encoding encoding) {
            return TStringOps.regionEqualsWithOrMaskWithStride(this, a, arrayA, a.stride(), fromIndexA, b, arrayB, b.stride(), fromIndexB, null, length);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA, codeRangeB)"})
        static boolean decode(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, int fromIndexA, AbstractTruffleString b, Object arrayB, int codeRangeB, int fromIndexB, int length, TruffleString.Encoding encoding, @Cached TruffleStringIterator.InternalNextNode nextNodeA, @Cached TruffleStringIterator.InternalNextNode nextNodeB) {
            int i;
            TruffleStringIterator aIt = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            TruffleStringIterator bIt = AbstractTruffleString.forwardIterator(b, arrayB, codeRangeB, encoding);
            for (i = 0; i < fromIndexA; ++i) {
                if (!aIt.hasNext()) {
                    return false;
                }
                nextNodeA.execute(node, aIt);
                TStringConstants.truffleSafePointPoll(node, i + 1);
            }
            for (i = 0; i < fromIndexB; ++i) {
                if (!bIt.hasNext()) {
                    return false;
                }
                nextNodeB.execute(node, bIt);
                TStringConstants.truffleSafePointPoll(node, i + 1);
            }
            for (i = 0; i < length; ++i) {
                if (!aIt.hasNext() || !bIt.hasNext() || nextNodeA.execute(node, aIt) != nextNodeB.execute(node, bIt)) {
                    return false;
                }
                TStringConstants.truffleSafePointPoll(node, i + 1);
            }
            return true;
        }
    }

    static abstract class ConcatMaterializeBytesNode
    extends AbstractInternalNode {
        ConcatMaterializeBytesNode() {
        }

        abstract byte[] execute(Node var1, AbstractTruffleString var2, Object var3, AbstractTruffleString var4, Object var5, TruffleString.Encoding var6, int var7, int var8);

        @Specialization(guards={"isUTF16(encoding) || isUTF32(encoding)"})
        byte[] doWithCompression(AbstractTruffleString a, Object arrayA, AbstractTruffleString b, Object arrayB, TruffleString.Encoding encoding, int concatLength, int concatStride) {
            byte[] bytes = new byte[concatLength << concatStride];
            TStringOps.arraycopyWithStride(this, arrayA, a.offset(), a.stride(), 0, bytes, 0, concatStride, 0, a.length());
            TStringOps.arraycopyWithStride(this, arrayB, b.offset(), b.stride(), 0, bytes, 0, concatStride, a.length(), b.length());
            return bytes;
        }

        @Specialization(guards={"!isUTF16(encoding)", "!isUTF32(encoding)"})
        byte[] doNoCompression(AbstractTruffleString a, Object arrayA, AbstractTruffleString b, Object arrayB, TruffleString.Encoding encoding, int concatLength, int concatStride) {
            assert (TStringGuards.isStride0(a));
            assert (TStringGuards.isStride0(b));
            assert (concatStride == 0);
            byte[] bytes = new byte[concatLength];
            TStringOps.arraycopyWithStride(this, arrayA, a.offset(), 0, 0, bytes, 0, 0, 0, a.length());
            TStringOps.arraycopyWithStride(this, arrayB, b.offset(), 0, 0, bytes, 0, 0, a.length(), b.length());
            return bytes;
        }
    }

    static abstract class ConcatEagerNode
    extends AbstractInternalNode {
        ConcatEagerNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, AbstractTruffleString var3, TruffleString.Encoding var4, int var5, int var6, int var7);

        @Specialization
        static TruffleString concat(Node node, AbstractTruffleString a, AbstractTruffleString b, TruffleString.Encoding encoding, int concatLength, int concatStride, int concatCodeRange, @Cached TruffleString.ToIndexableNode toIndexableNodeA, @Cached TruffleString.ToIndexableNode toIndexableNodeB, @Cached GetCodePointLengthNode getCodePointLengthANode, @Cached GetCodePointLengthNode getCodePointLengthBNode, @Cached ConcatMaterializeBytesNode materializeBytesNode, @Cached CalcStringAttributesNode calculateAttributesNode, @Cached InlinedConditionProfile brokenProfile) {
            int codeRange;
            int codePointLength;
            byte[] bytes = materializeBytesNode.execute(node, a, toIndexableNodeA.execute(node, a, a.data()), b, toIndexableNodeB.execute(node, b, b.data()), encoding, concatLength, concatStride);
            if (brokenProfile.profile(node, TStringGuards.isBrokenMultiByte(concatCodeRange))) {
                long attrs = calculateAttributesNode.execute(node, null, bytes, 0, concatLength, concatStride, encoding, 0, TSCodeRange.getBrokenMultiByte());
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
            } else {
                codePointLength = getCodePointLengthANode.execute(node, a, encoding) + getCodePointLengthBNode.execute(node, b, encoding);
                codeRange = concatCodeRange;
            }
            return TruffleString.createFromByteArray(bytes, concatLength, concatStride, encoding, codePointLength, codeRange);
        }
    }

    static abstract class SubstringNode
    extends AbstractInternalNode {
        SubstringNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7, boolean var8);

        @Specialization(guards={"length == 0"})
        static TruffleString lengthZero(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int fromIndex, int length, boolean lazy) {
            return encoding.getEmpty();
        }

        @Specialization(guards={"fromIndex == 0", "length == length(a)"})
        static TruffleString sameStr(TruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int fromIndex, int length, boolean lazy) {
            return a;
        }

        @Specialization(guards={"length > 0", "length != length(a) || a.isMutable()", "!lazy"})
        static TruffleString materializeSubstring(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int fromIndex, int length, boolean lazy, @Cached.Shared(value="attributes") @Cached CalcStringAttributesNode calcAttributesNode, @Cached.Exclusive @Cached InlinedConditionProfile utf16Profile, @Cached.Exclusive @Cached InlinedConditionProfile utf32Profile) {
            int newStride;
            int codeRange;
            long attrs;
            int stride;
            if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                stride = a.stride();
                attrs = calcAttributesNode.execute(node, a, arrayA, a.offset(), length, stride, TruffleString.Encoding.UTF_16, fromIndex, codeRangeA);
                codeRange = StringAttributes.getCodeRange(attrs);
                newStride = Stride.fromCodeRangeUTF16(codeRange);
            } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                stride = a.stride();
                attrs = calcAttributesNode.execute(node, a, arrayA, a.offset(), length, stride, TruffleString.Encoding.UTF_32, fromIndex, codeRangeA);
                codeRange = StringAttributes.getCodeRange(attrs);
                newStride = Stride.fromCodeRangeUTF32(codeRange);
            } else {
                stride = 0;
                attrs = calcAttributesNode.execute(node, a, arrayA, a.offset(), length, stride, encoding, fromIndex, codeRangeA);
                codeRange = StringAttributes.getCodeRange(attrs);
                newStride = 0;
            }
            byte[] newBytes = TStringOps.arraycopyOfWithStride(node, arrayA, a.offset() + (fromIndex << stride), length, stride, length, newStride);
            return TruffleString.createFromByteArray(newBytes, length, newStride, encoding, StringAttributes.getCodePointLength(attrs), codeRange);
        }

        @Specialization(guards={"length > 0", "length != length(a)", "lazy"})
        static TruffleString createLazySubstring(Node node, TruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int fromIndex, int length, boolean lazy, @Cached.Shared(value="attributes") @Cached CalcStringAttributesNode calcAttributesNode, @Cached.Exclusive @Cached InlinedConditionProfile stride1MustMaterializeProfile, @Cached.Exclusive @Cached InlinedConditionProfile stride2MustMaterializeProfile) {
            Object array;
            int offset;
            int stride;
            int lazyOffset = a.offset() + (fromIndex << a.stride());
            long attrs = calcAttributesNode.execute(node, a, arrayA, a.offset(), length, a.stride(), encoding, fromIndex, codeRangeA);
            int codeRange = StringAttributes.getCodeRange(attrs);
            int codePointLength = StringAttributes.getCodePointLength(attrs);
            if (stride1MustMaterializeProfile.profile(node, a.stride() == 1 && TSCodeRange.isMoreRestrictiveOrEqual(codeRange, TSCodeRange.get8Bit()))) {
                assert (TStringGuards.isUTF16Or32(encoding));
                stride = 0;
                offset = 0;
                byte[] newBytes = new byte[length];
                TStringOps.arraycopyWithStride(node, arrayA, lazyOffset, 1, 0, newBytes, offset, 0, 0, length);
                array = newBytes;
            } else if (stride2MustMaterializeProfile.profile(node, a.stride() == 2 && TSCodeRange.isMoreRestrictiveOrEqual(codeRange, TSCodeRange.get16Bit()))) {
                assert (TStringGuards.isUTF32(encoding));
                stride = Stride.fromCodeRangeUTF32(StringAttributes.getCodeRange(attrs));
                offset = 0;
                byte[] newBytes = new byte[length << stride];
                if (stride == 0) {
                    TStringOps.arraycopyWithStride(node, arrayA, lazyOffset, 2, 0, newBytes, offset, 0, 0, length);
                } else {
                    assert (stride == 1);
                    TStringOps.arraycopyWithStride(node, arrayA, lazyOffset, 2, 0, newBytes, offset, 1, 0, length);
                }
                array = newBytes;
            } else {
                array = TStringGuards.isUnsupportedEncoding(encoding) && arrayA instanceof AbstractTruffleString.NativePointer ? ((AbstractTruffleString.NativePointer)arrayA).copy() : arrayA;
                offset = lazyOffset;
                stride = a.stride();
            }
            return TruffleString.createFromArray(array, offset, length, stride, encoding, codePointLength, codeRange);
        }
    }

    @ImportStatic(value={TStringGuards.class, TruffleString.Encoding.class})
    static abstract class IndexOfCodePointSetNode
    extends Node {
        static final int POSSIBLE_STRIDE_VALUES = 3;
        @Node.Children
        IndexOfCodePointSet.IndexOfNode[] indexOfNodes;
        final TruffleString.Encoding encoding;
        final boolean isUTF16Or32;

        IndexOfCodePointSetNode(IndexOfCodePointSet.IndexOfNode[] indexOfNodes, TruffleString.Encoding encoding) {
            this.indexOfNodes = this.insert(indexOfNodes);
            this.encoding = encoding;
            this.isUTF16Or32 = TStringGuards.isUTF16Or32(encoding);
        }

        abstract int execute(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

        @Specialization(guards={"!isUTF16Or32"})
        int stride0(Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex) {
            return this.doIndexOf(arrayA, offsetA, lengthA, 0, codeRangeA, fromIndex, toIndex);
        }

        @Specialization(guards={"isUTF16Or32", "strideA == cachedStride"}, limit="POSSIBLE_STRIDE_VALUES")
        int dynamicStride(Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex, @Cached(value="strideA", allowUncached=true) int cachedStride) {
            return this.doIndexOf(arrayA, offsetA, lengthA, cachedStride, codeRangeA, fromIndex, toIndex);
        }

        @ExplodeLoop
        private int doIndexOf(Object arrayA, int offsetA, int lengthA, int strideA, int codeRangeA, int fromIndex, int toIndex) {
            CompilerAsserts.partialEvaluationConstant(this.indexOfNodes);
            for (int i = 0; i < this.indexOfNodes.length - 1; ++i) {
                CompilerAsserts.partialEvaluationConstant(i);
                IndexOfCodePointSet.IndexOfNode node = this.indexOfNodes[i];
                CompilerAsserts.partialEvaluationConstant(node);
                if (!TSCodeRange.isMoreRestrictiveOrEqual(codeRangeA, Byte.toUnsignedInt(node.maxCodeRange))) continue;
                return node.execute(this, arrayA, offsetA, lengthA, strideA, codeRangeA, fromIndex, toIndex, this.encoding);
            }
            return this.indexOfNodes[this.indexOfNodes.length - 1].execute(this, arrayA, offsetA, lengthA, strideA, codeRangeA, fromIndex, toIndex, this.encoding);
        }
    }

    static abstract class LastIndexOfCodePointRawNode
    extends AbstractInternalNode {
        LastIndexOfCodePointRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7, int var8);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int utf8Fixed(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached @Cached.Shared(value="lastIndexOfNode") TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode) {
            return TStringInternalNodes.lastIndexOfFixedWidth(node, a, arrayA, codeRangeA, codepoint, fromIndex, toIndex, lastIndexOfNode);
        }

        @Specialization(guards={"isUTF8(encoding)", "!isFixedWidth(codeRangeA)"})
        static int utf8Variable(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached @Cached.Shared(value="lastIndexOfNode") TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode) {
            int encodedSize = Encodings.utf8EncodedSize(codepoint);
            if (encodedSize > fromIndex - toIndex) {
                return -1;
            }
            if (encodedSize == 1) {
                return TStringInternalNodes.lastIndexOfFixedWidth(node, a, arrayA, codeRangeA, codepoint, fromIndex, toIndex, lastIndexOfNode);
            }
            byte[] encoded = Encodings.utf8EncodeNonAscii(codepoint, encodedSize);
            TruffleString b = TruffleString.createFromByteArray(encoded, encoded.length, 0, TruffleString.Encoding.UTF_8, 1, TSCodeRange.getValidMultiByte());
            return TStringOps.lastIndexOfStringWithOrMaskWithStride(node, a, arrayA, 0, b, encoded, 0, fromIndex, toIndex, null);
        }

        @Specialization(guards={"isUTF16(encoding)", "!isFixedWidth(codeRangeA)"})
        static int utf16Variable(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached @Cached.Shared(value="lastIndexOfNode") TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode) {
            assert (TStringGuards.isStride1(a));
            int encodedSize = Encodings.utf16EncodedSize(codepoint);
            if (encodedSize > fromIndex - toIndex) {
                return -1;
            }
            if (encodedSize == 1) {
                return TStringInternalNodes.lastIndexOfFixedWidth(node, a, arrayA, codeRangeA, codepoint, fromIndex, toIndex, lastIndexOfNode);
            }
            return TStringOps.lastIndexOf2ConsecutiveWithOrMaskWithStride(node, a, arrayA, 1, fromIndex, toIndex, Character.highSurrogate(codepoint), Character.lowSurrogate(codepoint), 0, 0);
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isFixedWidth(codeRangeA)"})
        static int unsupported(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TruffleStringIterator.InternalPreviousNode prevNode) {
            TruffleStringIterator it = TruffleString.backwardIterator(a, arrayA, codeRangeA, encoding);
            it.setRawIndex(fromIndex);
            int loopCount = 0;
            while (it.hasPrevious() && it.getRawIndex() >= toIndex) {
                if (prevNode.execute(node, it, DecodingErrorHandler.DEFAULT) == codepoint) {
                    return it.getRawIndex();
                }
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            return -1;
        }
    }

    static abstract class LastIndexOfCodePointNode
    extends AbstractInternalNode {
        LastIndexOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7, int var8);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int doFixedWidth(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode) {
            return TStringInternalNodes.lastIndexOfFixedWidth(node, a, arrayA, codeRangeA, codepoint, fromIndex, toIndex, lastIndexOfNode);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA)"})
        static int decode(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TruffleStringIterator.InternalNextNode nextNode) {
            return TruffleStringIterator.lastIndexOf(node, AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding), codepoint, fromIndex, toIndex, nextNode);
        }
    }

    static abstract class IndexOfCodePointRawNode
    extends AbstractInternalNode {
        IndexOfCodePointRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7, int var8);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int utf8Fixed(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TStringOpsNodes.RawIndexOfCodePointNode indexOfNode) {
            return TStringInternalNodes.indexOfFixedWidth(node, a, arrayA, codeRangeA, codepoint, fromIndex, toIndex, indexOfNode);
        }

        @Specialization(guards={"isUTF8(encoding)", "!isFixedWidth(codeRangeA)"})
        int utf8Variable(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex) {
            assert (TStringGuards.isStride0(a));
            int encodedSize = Encodings.utf8EncodedSize(codepoint);
            if (encodedSize > toIndex - fromIndex) {
                return -1;
            }
            if (encodedSize == 1) {
                return TStringOps.indexOfCodePointWithStride(this, a, arrayA, 0, fromIndex, toIndex, codepoint);
            }
            byte[] encoded = Encodings.utf8EncodeNonAscii(codepoint, encodedSize);
            TruffleString b = TruffleString.createFromByteArray(encoded, encoded.length, 0, TruffleString.Encoding.UTF_8, 1, TSCodeRange.getValidMultiByte());
            return TStringOps.indexOfStringWithOrMaskWithStride(this, a, arrayA, 0, b, encoded, 0, fromIndex, toIndex, null);
        }

        @Specialization(guards={"isUTF16(encoding)", "!isFixedWidth(codeRangeA)"})
        int utf16Variable(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex) {
            assert (TStringGuards.isStride1(a));
            int encodedSize = Encodings.utf16EncodedSize(codepoint);
            if (encodedSize > toIndex - fromIndex) {
                return -1;
            }
            if (encodedSize == 1) {
                return TStringOps.indexOfCodePointWithStride(this, a, arrayA, 1, fromIndex, toIndex, codepoint);
            }
            return TStringOps.indexOf2ConsecutiveWithStride(this, a, arrayA, 1, fromIndex, toIndex, Character.highSurrogate(codepoint), Character.lowSurrogate(codepoint));
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isFixedWidth(codeRangeA)"})
        static int unsupported(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TruffleStringIterator.InternalNextNode nextNode) {
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            it.setRawIndex(fromIndex);
            int loopCount = 0;
            while (it.hasNext() && it.getRawIndex() < toIndex) {
                int ret = it.getRawIndex();
                if (nextNode.execute(node, it) == codepoint) {
                    return ret;
                }
                TStringConstants.truffleSafePointPoll(node, ++loopCount);
            }
            return -1;
        }
    }

    static abstract class IndexOfCodePointNode
    extends AbstractInternalNode {
        IndexOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7, int var8);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        static int doFixedWidth(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TStringOpsNodes.RawIndexOfCodePointNode indexOfNode) {
            return TStringInternalNodes.indexOfFixedWidth(node, a, arrayA, codeRangeA, codepoint, fromIndex, toIndex, indexOfNode);
        }

        @Specialization(guards={"!isFixedWidth(codeRangeA)"})
        static int decode(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, @Cached TruffleStringIterator.InternalNextNode nextNode) {
            return TruffleStringIterator.indexOf(node, AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding), codepoint, fromIndex, toIndex, nextNode);
        }
    }

    static abstract class CodePointAtRawNode
    extends AbstractInternalNode {
        CodePointAtRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, TruffleString.ErrorHandling var7);

        @Specialization(guards={"isUTF16(encoding)"})
        static int utf16(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached InlinedConditionProfile fixedWidthProfile, @Cached @Cached.Shared InlinedConditionProfile validProfile, @Cached.Shared(value="stride0") @Cached InlinedConditionProfile stride0Profile) {
            if (fixedWidthProfile.profile(node, TStringGuards.isFixedWidth(codeRangeA))) {
                if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                    return TStringOps.readS0(a, arrayA, i);
                }
                assert (TStringGuards.isStride1(a));
                return TStringOps.readS1(a, arrayA, i);
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf16DecodeValid(a, arrayA, i);
            }
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf16DecodeBroken(a, arrayA, i, errorHandling);
        }

        @Specialization(guards={"isUTF16FE(encoding)"})
        static int utf16FE(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached @Cached.Shared InlinedConditionProfile validProfile) {
            assert (TStringGuards.isStride0(a));
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf16FEDecodeValid(arrayA, a.offset(), a.length() >> 1, i >> 1);
            }
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf16FEDecodeBroken(arrayA, a.offset(), a.length() >> 1, i >> 1, errorHandling);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static int utf32(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached.Shared(value="stride0") @Cached InlinedConditionProfile stride0Profile, @Cached.Exclusive @Cached InlinedConditionProfile stride1Profile) {
            if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                return TStringOps.readS0(a, arrayA, i);
            }
            if (stride1Profile.profile(node, TStringGuards.isStride1(a))) {
                char c = TStringOps.readS1(a, arrayA, i);
                if (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE && Encodings.isUTF16Surrogate(c)) {
                    return -1;
                }
                return c;
            }
            assert (TStringGuards.isStride2(a));
            int c = TStringOps.readS2(a, arrayA, i);
            if (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE && !Encodings.isValidUnicodeCodepoint(c)) {
                return -1;
            }
            return c;
        }

        @Specialization(guards={"isUTF32FE(encoding)"})
        static int utf32FE(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            int c = Integer.reverseBytes(TStringOps.readS2(arrayA, a.offset(), a.length() >> 2, i >> 2));
            if (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE && !Encodings.isValidUnicodeCodepoint(c)) {
                return -1;
            }
            return c;
        }

        @Specialization(guards={"isUTF8(encoding)"})
        static int utf8(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached.Exclusive @Cached InlinedConditionProfile fixedWidthProfile, @Cached.Exclusive @Cached InlinedConditionProfile validProfile) {
            if (fixedWidthProfile.profile(node, TStringGuards.is7Bit(codeRangeA))) {
                return TStringOps.readS0(a, arrayA, i);
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf8DecodeValid(a, arrayA, i);
            }
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf8DecodeBroken(a, arrayA, i, errorHandling);
        }

        @Specialization(guards={"!isUTF16Or32(encoding)", "!isUTF8(encoding)", "isBytes(encoding) || is7Or8Bit(codeRangeA)"})
        static int doFixed(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            return TStringOps.readS0(a, arrayA, i);
        }

        @Specialization(guards={"isAscii(encoding)", "!is7Or8Bit(codeRangeA)"})
        static int doAsciiBroken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            int c = TStringOps.readS0(a, arrayA, i);
            if (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE && c > 127) {
                return -1;
            }
            assert (errorHandling == TruffleString.ErrorHandling.BEST_EFFORT || !TSCodeRange.isPrecise(codeRangeA));
            return c;
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isUTF16FE(encoding)", "!isUTF32FE(encoding)", "!is7Or8Bit(codeRangeA)"})
        static int unsupported(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            return JCodings.getInstance().decode(a, JCodings.asByteArray(arrayA), i, encoding, errorHandling);
        }
    }

    static abstract class CodePointAtNode
    extends AbstractInternalNode {
        CodePointAtNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, TruffleString.ErrorHandling var7);

        @Specialization(guards={"isUTF16(encoding)"})
        static int utf16(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached InlinedConditionProfile fixedWidthProfile, @Cached.Shared(value="stride0") @Cached InlinedConditionProfile stride0Profile, @Cached.Shared(value="valid") @Cached InlinedConditionProfile validProfile) {
            if (fixedWidthProfile.profile(node, TStringGuards.isFixedWidth(codeRangeA))) {
                if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                    return TStringOps.readS0(a, arrayA, i);
                }
                assert (TStringGuards.isStride1(a));
                return TStringOps.readS1(a, arrayA, i);
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                assert (TStringGuards.isStride1(a));
                return Encodings.utf16DecodeValid(a, arrayA, Encodings.utf16ValidCodePointToCharIndex(node, a, arrayA, i));
            }
            assert (TStringGuards.isStride1(a));
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf16DecodeBroken(a, arrayA, Encodings.utf16BrokenCodePointToCharIndex(node, a, arrayA, i), errorHandling);
        }

        @Specialization(guards={"isUTF16FE(encoding)"})
        static int utf16FE(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached.Shared(value="valid") @Cached InlinedConditionProfile validProfile) {
            assert (TStringGuards.isStride0(a));
            int offsetA = a.offset();
            int lengthA = a.length() >> 1;
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf16FEDecodeValid(arrayA, offsetA, lengthA, Encodings.utf16FEValidCodePointToCharIndex(node, arrayA, offsetA, lengthA, i));
            }
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf16FEDecodeBroken(arrayA, offsetA, lengthA, Encodings.utf16FEBrokenCodePointToCharIndex(node, arrayA, offsetA, lengthA, i), errorHandling);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static int utf32(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached.Shared(value="stride0") @Cached InlinedConditionProfile stride0Profile, @Cached.Exclusive @Cached InlinedConditionProfile stride1Profile) {
            return CodePointAtRawNode.utf32(node, a, arrayA, codeRangeA, encoding, i, errorHandling, stride0Profile, stride1Profile);
        }

        @Specialization(guards={"isUTF32FE(encoding)"})
        static int utf32FE(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            return CodePointAtRawNode.utf32FE(a, arrayA, codeRangeA, encoding, i << 2, errorHandling);
        }

        @Specialization(guards={"isUTF8(encoding)"})
        static int utf8(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling, @Cached.Exclusive @Cached InlinedConditionProfile fixedWidthProfile, @Cached.Shared(value="valid") @Cached InlinedConditionProfile validProfile) {
            if (fixedWidthProfile.profile(node, TStringGuards.is7Bit(codeRangeA))) {
                return TStringOps.readS0(a, arrayA, i);
            }
            int byteIndex = Encodings.utf8CodePointToByteIndex(node, a, arrayA, i);
            if (validProfile.profile(node, TStringGuards.isValid(codeRangeA))) {
                return Encodings.utf8DecodeValid(a, arrayA, byteIndex);
            }
            assert (TStringGuards.isBroken(codeRangeA));
            return Encodings.utf8DecodeBroken(a, arrayA, byteIndex, errorHandling);
        }

        @Specialization(guards={"!isUTF16Or32(encoding)", "!isUTF8(encoding)", "isBytes(encoding) || is7Or8Bit(codeRangeA)"})
        static int doFixed(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            return CodePointAtRawNode.doFixed(a, arrayA, codeRangeA, encoding, i, errorHandling);
        }

        @Specialization(guards={"isAscii(encoding)", "!is7Or8Bit(codeRangeA)"})
        static int doAsciiBroken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            return CodePointAtRawNode.doAsciiBroken(a, arrayA, codeRangeA, encoding, i, errorHandling);
        }

        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isUTF16FE(encoding)", "!isUTF32FE(encoding)", "!is7Or8Bit(codeRangeA)"})
        int unsupported(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int i, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            JCodings jcodings = JCodings.getInstance();
            byte[] bytes = JCodings.asByteArray(arrayA);
            return jcodings.decode(a, bytes, jcodings.codePointIndexToRaw(this, a, bytes, 0, i, false, encoding), encoding, errorHandling);
        }
    }

    static abstract class ReadByteNode
    extends AbstractInternalNode {
        ReadByteNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5);

        @Specialization(guards={"isUTF16(encoding)"})
        static int doUTF16(Node node, AbstractTruffleString a, Object arrayA, int i, TruffleString.Encoding encoding, @Cached.Shared(value="stride0") @Cached InlinedConditionProfile stride0Profile) {
            int index;
            a.boundsCheckByteIndexUTF16(i);
            if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                if (TStringGuards.bigEndian() == ((i & 1) == 0)) {
                    return 0;
                }
                index = i >> 1;
            } else {
                assert (TStringGuards.isStride1(a));
                index = i;
            }
            return TStringOps.readS0(arrayA, a.offset(), a.length() << a.stride(), index);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static int doUTF32(Node node, AbstractTruffleString a, Object arrayA, int i, TruffleString.Encoding encoding, @Cached.Shared(value="stride0") @Cached InlinedConditionProfile stride0Profile, @Cached.Exclusive @Cached InlinedConditionProfile stride1Profile) {
            int index;
            a.boundsCheckByteIndexUTF32(i);
            if (stride0Profile.profile(node, TStringGuards.isStride0(a))) {
                if ((i & 3) != (TStringGuards.bigEndian() ? 3 : 0)) {
                    return 0;
                }
                index = i >> 2;
            } else if (stride1Profile.profile(node, TStringGuards.isStride1(a))) {
                if (TStringGuards.bigEndian() == ((i & 2) == 0)) {
                    return 0;
                }
                index = TStringGuards.bigEndian() ? i >> 1 | i & 1 : i >> 1 & 0xFFFFFFFE | i & 1;
            } else {
                assert (TStringGuards.isStride2(a));
                index = i;
            }
            return TStringOps.readS0(arrayA, a.offset(), a.length() << a.stride(), index);
        }

        @Specialization(guards={"!isUTF16Or32(encoding)"})
        static int doRest(AbstractTruffleString a, Object arrayA, int i, TruffleString.Encoding encoding) {
            a.boundsCheckByteIndexS0(i);
            return TStringOps.readS0(a, arrayA, i);
        }
    }

    static abstract class CodePointIndexToRawNode
    extends AbstractInternalNode {
        CodePointIndexToRawNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7, boolean var8);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        int doFixed(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            return index;
        }

        @Specialization(guards={"isUTF32FE(encoding)"})
        int utf32FE(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            return index << 2;
        }

        @Specialization(guards={"isUTF8(encoding)", "isValid(codeRangeA)"})
        int utf8Valid(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            int regionLength;
            assert (TStringGuards.isStride0(a));
            int regionOffset = a.offset() + extraOffsetRaw;
            int byteIndex = TStringOps.codePointIndexToByteIndexUTF8Valid(this, arrayA, regionOffset, regionLength = a.length() - extraOffsetRaw, index);
            if (byteIndex < 0 || !isLength && byteIndex == regionLength) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CodePointIndexToRawNode.debugException(a, regionOffset, regionLength, index, isLength, byteIndex);
            }
            return byteIndex;
        }

        @CompilerDirectives.TruffleBoundary
        private static RuntimeException debugException(AbstractTruffleString a, int regionOffset, int regionLength, int index, boolean isLength, int byteIndex) {
            String msg = String.format("string: %s, regionOffset: %d, regionLength: %d, index: %d, isLength: %b, byteIndex: %d", a.toStringDebug(), regionOffset, regionLength, index, isLength, byteIndex);
            return new IndexOutOfBoundsException(msg);
        }

        @Specialization(guards={"isUTF8(encoding)", "isBroken(codeRangeA)"})
        int utf8Broken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            assert (TStringGuards.isStride0(a));
            int cpi = 0;
            for (int i = extraOffsetRaw; i < a.length(); i += Encodings.utf8GetCodePointLength(a, arrayA, i, DecodingErrorHandler.DEFAULT)) {
                if (cpi == index) {
                    return i - extraOffsetRaw;
                }
                TStringConstants.truffleSafePointPoll(this, ++cpi);
            }
            return CodePointIndexToRawNode.atEnd(a, extraOffsetRaw, index, isLength, cpi);
        }

        @Specialization(guards={"isUTF16(encoding)", "isValid(codeRangeA)"})
        int utf16Valid(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            int regionLength;
            assert (TStringGuards.isStride1(a));
            int regionOffset = a.offset() + (extraOffsetRaw << 1);
            int result = TStringOps.codePointIndexToByteIndexUTF16Valid(this, arrayA, regionOffset, regionLength = a.length() - extraOffsetRaw, index);
            if (result < 0 || !isLength && result == regionLength) {
                throw InternalErrors.indexOutOfBounds(regionLength, result);
            }
            return result;
        }

        @Specialization(guards={"isUTF16(encoding)", "isBroken(codeRangeA)"})
        int utf16Broken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            assert (TStringGuards.isStride1(a));
            int cpi = 0;
            for (int i = extraOffsetRaw; i < a.length(); ++i) {
                if (i <= extraOffsetRaw || !Encodings.isUTF16LowSurrogate(TStringOps.readS1(a, arrayA, i)) || !Encodings.isUTF16HighSurrogate(TStringOps.readS1(a, arrayA, i - 1))) {
                    if (cpi == index) {
                        return i - extraOffsetRaw;
                    }
                    ++cpi;
                }
                TStringConstants.truffleSafePointPoll(this, i + 1);
            }
            return CodePointIndexToRawNode.atEnd(a, extraOffsetRaw, index, isLength, cpi);
        }

        @Specialization(guards={"isUTF16FE(encoding)"})
        int utf16FE(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            int extraOffsetScaled;
            assert (TStringGuards.isStride0(a));
            int cpi = 0;
            int lengthA = a.length() >> 1;
            for (int i = extraOffsetScaled = extraOffsetRaw >> 1; i < lengthA; ++i) {
                if (i <= extraOffsetScaled || !Encodings.isUTF16LowSurrogate(Character.reverseBytes(TStringOps.readS1(arrayA, a.offset(), lengthA, i))) || !Encodings.isUTF16HighSurrogate(Character.reverseBytes(TStringOps.readS1(arrayA, a.offset(), lengthA, i - 1)))) {
                    if (cpi == index) {
                        return i - extraOffsetScaled << 1;
                    }
                    ++cpi;
                }
                TStringConstants.truffleSafePointPoll(this, i + 1);
            }
            return CodePointIndexToRawNode.atEnd(a, extraOffsetRaw, index, isLength, cpi);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isUTF16FE(encoding)", "!isUTF32FE(encoding)"})
        int unsupported(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int extraOffsetRaw, int index, boolean isLength) {
            return JCodings.getInstance().codePointIndexToRaw(this, a, JCodings.asByteArray(arrayA), extraOffsetRaw, index, isLength, encoding);
        }

        static int atEnd(AbstractTruffleString a, int extraOffsetRaw, int index, boolean isLength, int cpi) {
            int regionLength = a.length() - extraOffsetRaw;
            if (isLength && cpi == index) {
                return regionLength;
            }
            throw InternalErrors.indexOutOfBounds(regionLength, index);
        }
    }

    static abstract class RawIndexToCodePointIndexNode
    extends AbstractInternalNode {
        RawIndexToCodePointIndexNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, int var7);

        @Specialization(guards={"isFixedWidth(codeRangeA)"})
        int doFixed(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index) {
            return index;
        }

        @Specialization(guards={"isUTF32FE(encoding)"})
        int utf32FE(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index) {
            return index >> 2;
        }

        @Specialization(guards={"isUTF8(encoding)", "isValid(codeRangeA)"})
        static int utf8Valid(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index, @Cached.Shared(value="broken") @Cached InlinedConditionProfile brokenProfile) {
            return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF8(node, arrayA, a.offset() + byteOffset, index, true, byteOffset + index == a.length(), brokenProfile));
        }

        @Specialization(guards={"isUTF8(encoding)", "isBroken(codeRangeA)"})
        static int utf8Broken(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index, @Cached.Shared(value="broken") @Cached InlinedConditionProfile brokenProfile) {
            return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF8(node, arrayA, a.offset() + byteOffset, index, false, false, brokenProfile));
        }

        @Specialization(guards={"isUTF16(encoding)", "isValid(codeRangeA)"})
        int utf16Valid(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index) {
            assert (TStringGuards.isStride1(a));
            return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF16(this, arrayA, a.offset() + byteOffset, index, true));
        }

        @Specialization(guards={"isUTF16(encoding)", "isBroken(codeRangeA)"})
        int utf16Broken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index) {
            assert (TStringGuards.isStride1(a));
            return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF16(this, arrayA, a.offset() + byteOffset, index, false));
        }

        @Specialization(guards={"isUTF16FE(encoding)"})
        int utf16FE(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index) {
            assert (TStringGuards.isStride0(a));
            return StringAttributes.getCodePointLength(TStringOps.calcStringAttributesUTF16FE(this, arrayA, a.offset() + byteOffset, index >> 1));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isUTF16FE(encoding)", "!isUTF32FE(encoding)"})
        static int unsupported(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int byteOffset, int index, @Cached.Exclusive @Cached InlinedConditionProfile validProfile, @Cached.Shared(value="broken") @Cached InlinedConditionProfile fixedWidthProfile) {
            return StringAttributes.getCodePointLength(JCodings.getInstance().calcStringAttributes(node, arrayA, a.offset(), index, encoding, byteOffset, validProfile, fixedWidthProfile));
        }
    }

    static abstract class ByteLengthOfCodePointNode
    extends AbstractInternalNode {
        ByteLengthOfCodePointNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, int var6, TruffleString.ErrorHandling var7);

        @Specialization(guards={"isFixedWidth(codeRangeA)", "isBestEffort(errorHandling)"})
        int doFixed(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            return 1 << encoding.naturalStride;
        }

        @Specialization(guards={"isUpToValidFixedWidth(codeRangeA)", "isReturnNegative(errorHandling)"})
        int doFixedValidReturnNegative(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            return 1 << encoding.naturalStride;
        }

        @Specialization(guards={"isAscii(encoding)", "isBroken(codeRangeA)", "isReturnNegative(errorHandling)"})
        int doASCIIBrokenReturnNegative(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            return TStringOps.readS0(a, arrayA, index) < 128 ? 1 : -1;
        }

        @Specialization(guards={"isUTF32FE(encoding)", "isValid(codeRangeA) || !isReturnNegative(errorHandling)"})
        static int doUTF32FE(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            return 4;
        }

        @Specialization(guards={"isUTF32(encoding) || isUTF32FE(encoding)", "isBroken(codeRangeA)", "isReturnNegative(errorHandling)"})
        static int doUTF32BrokenReturnNegative(Node node, AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling, @Cached CodePointAtRawNode codePointAtRawNode) {
            return codePointAtRawNode.execute(node, a, arrayA, codeRangeA, encoding, index, TruffleString.ErrorHandling.RETURN_NEGATIVE) < 0 ? -1 : 4;
        }

        @Specialization(guards={"isUTF8(encoding)", "isValid(codeRangeA)"})
        int utf8Valid(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            int firstByte = TStringOps.readS0(a, arrayA, index);
            return firstByte <= 127 ? 1 : Encodings.utf8CodePointLength(firstByte);
        }

        @Specialization(guards={"isUTF8(encoding)", "isBroken(codeRangeA)"})
        int utf8Broken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            return Encodings.utf8GetCodePointLength(a, arrayA, index, errorHandling.errorHandler);
        }

        @Specialization(guards={"isUTF16(encoding)", "isValid(codeRangeA)"})
        int utf16Valid(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride1(a));
            return Encodings.isUTF16HighSurrogate(TStringOps.readS1(a, arrayA, index)) ? 4 : 2;
        }

        @Specialization(guards={"isUTF16FE(encoding)", "isValid(codeRangeA)"})
        int utf16FEValid(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            return Encodings.isUTF16HighSurrogate(Character.reverseBytes(TStringOps.readS1(arrayA, a.offset(), a.length() >> 1, index >> 1))) ? 4 : 2;
        }

        @Specialization(guards={"isUTF16(encoding)", "isBroken(codeRangeA)"})
        int utf16Broken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride1(a));
            return Encodings.utf16BrokenGetCodePointByteLength(a, arrayA, index, errorHandling);
        }

        @Specialization(guards={"isUTF16FE(encoding)", "isBroken(codeRangeA)"})
        int utf16FEBroken(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            return Encodings.utf16FEBrokenGetCodePointByteLength(arrayA, a.offset(), a.length() >> 1, index >> 1, errorHandling);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isUnsupportedEncoding(encoding)", "!isUTF16FE(encoding)", "!isUTF32FE(encoding)"})
        int unsupported(AbstractTruffleString a, Object arrayA, int codeRangeA, TruffleString.Encoding encoding, int index, TruffleString.ErrorHandling errorHandling) {
            assert (TStringGuards.isStride0(a));
            JCodings jcodings = JCodings.getInstance();
            int cpLength = jcodings.getCodePointLength(encoding, JCodings.asByteArray(arrayA), a.byteArrayOffset() + index, a.byteArrayOffset() + a.length());
            int regionLength = a.length() - index;
            if (errorHandling == TruffleString.ErrorHandling.BEST_EFFORT) {
                if (cpLength > 0 && cpLength <= regionLength) {
                    return cpLength;
                }
                return Math.min(jcodings.minLength(encoding), regionLength);
            }
            assert (errorHandling == TruffleString.ErrorHandling.RETURN_NEGATIVE);
            if (cpLength <= regionLength) {
                return cpLength;
            }
            return -1 - (cpLength - regionLength);
        }
    }

    static abstract class FromNativePointerNode
    extends AbstractInternalNode {
        FromNativePointerNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString.NativePointer var2, int var3, int var4, TruffleString.Encoding var5, boolean var6);

        @Specialization
        static TruffleString fromNativePointerInternal(Node node, AbstractTruffleString.NativePointer pointer, int byteOffset, int byteLength, TruffleString.Encoding encoding, boolean isCacheHead, @Cached InlinedConditionProfile asciiLatinBytesProfile, @Cached InlinedConditionProfile utf8Profile, @Cached InlinedConditionProfile utf8BrokenProfile, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16FEProfile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32FEProfile, @Cached InlinedConditionProfile exoticValidProfile, @Cached InlinedConditionProfile exoticFixedWidthProfile) {
            int stride;
            int codeRange;
            int codePointLength;
            int length;
            if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                AbstractTruffleString.checkByteLengthUTF16(byteLength);
                length = byteLength >> 1;
                long attrs = TStringOps.calcStringAttributesUTF16(node, pointer, byteOffset, length, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
                stride = 1;
            } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                AbstractTruffleString.checkByteLengthUTF32(byteLength);
                length = byteLength >> 2;
                codeRange = TStringOps.calcStringAttributesUTF32(node, pointer, byteOffset, length);
                codePointLength = length;
                stride = 2;
            } else {
                length = byteLength;
                stride = 0;
                if (utf8Profile.profile(node, TStringGuards.isUTF8(encoding))) {
                    long attrs = TStringOps.calcStringAttributesUTF8(node, pointer, byteOffset, length, false, false, utf8BrokenProfile);
                    codeRange = StringAttributes.getCodeRange(attrs);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                } else if (asciiLatinBytesProfile.profile(node, TStringGuards.isAsciiBytesOrLatin1(encoding))) {
                    int cr = TStringOps.calcStringAttributesLatin1(node, pointer, byteOffset, length);
                    codeRange = TStringGuards.is8Bit(cr) ? TSCodeRange.asciiLatinBytesNonAsciiCodeRange(encoding) : cr;
                    codePointLength = length;
                } else if (utf16FEProfile.profile(node, TStringGuards.isUTF16FE(encoding))) {
                    AbstractTruffleString.checkByteLengthUTF16(byteLength);
                    long attrs = TStringOps.calcStringAttributesUTF16FE(node, pointer, byteOffset, length >> 1);
                    codeRange = StringAttributes.getCodeRange(attrs);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                } else if (utf32FEProfile.profile(node, TStringGuards.isUTF32FE(encoding))) {
                    AbstractTruffleString.checkByteLengthUTF32(byteLength);
                    codeRange = TStringOps.calcStringAttributesUTF32FE(node, pointer, byteOffset, length >> 2);
                    codePointLength = length >> 2;
                } else {
                    JCodings jcodings = JCodings.getInstance();
                    pointer.materializeByteArray(node, byteOffset, byteLength, InlinedConditionProfile.getUncached());
                    long attrs = jcodings.calcStringAttributes(node, pointer, byteOffset, length, encoding, 0, exoticValidProfile, exoticFixedWidthProfile);
                    codeRange = StringAttributes.getCodeRange(attrs);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                }
            }
            return TruffleString.createFromArray(pointer, byteOffset, length, stride, encoding, codePointLength, codeRange, isCacheHead);
        }
    }

    @GenerateInline(value=false)
    @GenerateCached(value=false)
    static abstract class FromNativePointerEmbedderNode
    extends AbstractInternalNode {
        FromNativePointerEmbedderNode() {
        }

        abstract TruffleString execute(long var1, int var3, int var4, TruffleString.Encoding var5, boolean var6);

        @Specialization
        final TruffleString fromNativePointer(long rawPointer, int byteOffset, int byteLength, TruffleString.Encoding enc, boolean copy, @Cached FromNativePointerNode fromNativePointerNode, @Cached FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode) {
            AbstractTruffleString.NativePointer pointer = new AbstractTruffleString.NativePointer(TruffleString.ETERNAL_POINTER, rawPointer);
            if (copy) {
                return fromBufferWithStringCompactionNode.execute(this, pointer, byteOffset, byteLength, enc, true, true);
            }
            return fromNativePointerNode.execute(this, pointer, byteOffset, byteLength, enc, true);
        }
    }

    static abstract class FromBufferWithStringCompactionKnownAttributesNode
    extends AbstractInternalNode {
        FromBufferWithStringCompactionKnownAttributesNode() {
        }

        final TruffleString execute(Node node, AbstractTruffleString a, TruffleString.Encoding encoding) {
            return this.execute(node, a, true, encoding);
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, boolean var3, TruffleString.Encoding var4);

        @Specialization
        static TruffleString fromBufferWithStringCompaction(Node node, AbstractTruffleString a, boolean isCacheHead, TruffleString.Encoding encoding, @Cached GetCodePointLengthNode getCodePointLengthNode, @Cached GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16CompactProfile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32Compact0Profile, @Cached InlinedConditionProfile utf32Compact1Profile) {
            byte[] array;
            int stride;
            int codeRange = getPreciseCodeRangeNode.execute(node, a, encoding);
            a.looseCheckEncoding(encoding, codeRange);
            int length = a.length();
            if (length == 0) {
                return encoding.getEmpty();
            }
            Object arrayA = a.data();
            assert (arrayA instanceof byte[] || arrayA instanceof AbstractTruffleString.NativePointer);
            int offsetA = a.offset();
            int strideA = a.stride();
            boolean offset = false;
            if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                stride = Stride.fromCodeRangeUTF16(codeRange);
                array = new byte[length << stride];
                if (utf16CompactProfile.profile(node, strideA == 1 && stride == 0)) {
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 1, 0, array, 0, 0, 0, length);
                } else {
                    assert (stride == strideA);
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, 0, array, 0, 0, 0, length << stride);
                }
            } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                stride = Stride.fromCodeRangeUTF32(codeRange);
                array = new byte[length << stride];
                if (utf32Compact0Profile.profile(node, strideA == 2 && stride == 0)) {
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, 0, 0, 0, length);
                } else if (utf32Compact1Profile.profile(node, strideA == 2 && stride == 1)) {
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, 0, 1, 0, length);
                } else {
                    assert (stride == strideA);
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, 0, array, 0, 0, 0, length << stride);
                }
            } else {
                stride = 0;
                array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, length, 0, length, 0);
            }
            int codePointLength = getCodePointLengthNode.execute(node, a, encoding);
            return TruffleString.createFromArray(array, 0, length, stride, encoding, codePointLength, codeRange, isCacheHead);
        }

        static FromBufferWithStringCompactionKnownAttributesNode getUncached() {
            return TStringInternalNodesFactory.FromBufferWithStringCompactionKnownAttributesNodeGen.getUncached();
        }
    }

    static abstract class FromBufferWithStringCompactionNode
    extends AbstractInternalNode {
        FromBufferWithStringCompactionNode() {
        }

        abstract TruffleString execute(Node var1, Object var2, int var3, int var4, TruffleString.Encoding var5, boolean var6, boolean var7);

        @Specialization
        static TruffleString fromBufferWithStringCompaction(Node node, Object arrayA, int offsetA, int byteLength, TruffleString.Encoding encoding, boolean copy, boolean isCacheHead, @Cached InlinedConditionProfile asciiLatinBytesProfile, @Cached InlinedConditionProfile utf8Profile, @Cached InlinedConditionProfile utf8BrokenProfile, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16CompactProfile, @Cached InlinedConditionProfile utf16FEProfile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32Compact0Profile, @Cached InlinedConditionProfile utf32Compact1Profile, @Cached InlinedConditionProfile utf32FEProfile, @Cached InlinedConditionProfile exoticValidProfile, @Cached InlinedConditionProfile exoticFixedWidthProfile) {
            Object array;
            int offset;
            int stride;
            int codeRange;
            int codePointLength;
            int length;
            if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                AbstractTruffleString.checkByteLengthUTF16(byteLength);
                length = byteLength >> 1;
                long attrs = TStringOps.calcStringAttributesUTF16(node, arrayA, offsetA, length, false);
                codePointLength = StringAttributes.getCodePointLength(attrs);
                codeRange = StringAttributes.getCodeRange(attrs);
                stride = Stride.fromCodeRangeUTF16(codeRange);
                if (copy || stride == 0) {
                    offset = 0;
                    array = new byte[length << stride];
                    if (utf16CompactProfile.profile(node, stride == 0)) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 1, 0, array, offset, 0, 0, length);
                    } else {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 1, 0, array, offset, 1, 0, length);
                    }
                } else {
                    offset = offsetA;
                    array = arrayA;
                }
            } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                AbstractTruffleString.checkByteLengthUTF32(byteLength);
                length = byteLength >> 2;
                codeRange = TStringOps.calcStringAttributesUTF32(node, arrayA, offsetA, length);
                codePointLength = length;
                stride = Stride.fromCodeRangeUTF32(codeRange);
                if (copy || stride < 2) {
                    offset = 0;
                    array = new byte[length << stride];
                    if (utf32Compact0Profile.profile(node, stride == 0)) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, offset, 0, 0, length);
                    } else if (utf32Compact1Profile.profile(node, stride == 1)) {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, offset, 1, 0, length);
                    } else {
                        TStringOps.arraycopyWithStride(node, arrayA, offsetA, 2, 0, array, offset, 2, 0, length);
                    }
                } else {
                    offset = offsetA;
                    array = arrayA;
                }
            } else {
                length = byteLength;
                stride = 0;
                if (utf8Profile.profile(node, TStringGuards.isUTF8(encoding))) {
                    long attrs = TStringOps.calcStringAttributesUTF8(node, arrayA, offsetA, length, false, false, utf8BrokenProfile);
                    codeRange = StringAttributes.getCodeRange(attrs);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                } else if (asciiLatinBytesProfile.profile(node, TStringGuards.isAsciiBytesOrLatin1(encoding))) {
                    int cr = TStringOps.calcStringAttributesLatin1(node, arrayA, offsetA, length);
                    codeRange = TStringGuards.is8Bit(cr) ? TSCodeRange.asciiLatinBytesNonAsciiCodeRange(encoding) : cr;
                    codePointLength = length;
                } else if (utf16FEProfile.profile(node, TStringGuards.isUTF16FE(encoding))) {
                    AbstractTruffleString.checkByteLengthUTF16(byteLength);
                    long attrs = TStringOps.calcStringAttributesUTF16FE(node, arrayA, offsetA, length >> 1);
                    codeRange = StringAttributes.getCodeRange(attrs);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                } else if (utf32FEProfile.profile(node, TStringGuards.isUTF32FE(encoding))) {
                    AbstractTruffleString.checkByteLengthUTF32(byteLength);
                    codeRange = TStringOps.calcStringAttributesUTF32FE(node, arrayA, offsetA, length >> 2);
                    codePointLength = length >> 2;
                } else {
                    JCodings jcodings = JCodings.getInstance();
                    if (arrayA instanceof AbstractTruffleString.NativePointer) {
                        ((AbstractTruffleString.NativePointer)arrayA).materializeByteArray(node, offsetA, length << stride, InlinedConditionProfile.getUncached());
                    }
                    long attrs = jcodings.calcStringAttributes(node, arrayA, offsetA, length, encoding, 0, exoticValidProfile, exoticFixedWidthProfile);
                    codeRange = StringAttributes.getCodeRange(attrs);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                }
                if (copy) {
                    offset = 0;
                    array = TStringOps.arraycopyOfWithStride(node, arrayA, offsetA, length, 0, length, 0);
                } else {
                    offset = offsetA;
                    array = arrayA;
                }
            }
            return TruffleString.createFromArray(array, offset, length, stride, encoding, codePointLength, codeRange, isCacheHead);
        }
    }

    static abstract class GetCodePointLengthNode
    extends AbstractInternalNode {
        GetCodePointLengthNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, TruffleString.Encoding var3);

        @Specialization
        static int get(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, @Cached InlinedConditionProfile cacheMissProfile, @Cached TruffleString.ToIndexableNode toIndexableNode, @Cached CalcStringAttributesNode calcStringAttributesNode) {
            int codePointLength = a.codePointLength();
            if (cacheMissProfile.profile(node, codePointLength < 0)) {
                return StringAttributes.getCodePointLength(TStringInternalNodes.updateAttributes(node, a, encoding, a.codeRange(), toIndexableNode, calcStringAttributesNode));
            }
            return codePointLength;
        }

        static GetCodePointLengthNode getUncached() {
            return TStringInternalNodesFactory.GetCodePointLengthNodeGen.getUncached();
        }
    }

    static abstract class GetPreciseCodeRangeNode
    extends AbstractInternalNode {
        GetPreciseCodeRangeNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, TruffleString.Encoding var3);

        @Specialization
        static int get(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, @Cached InlinedConditionProfile impreciseProfile, @Cached TruffleString.ToIndexableNode toIndexableNode, @Cached CalcStringAttributesNode calcStringAttributesNode) {
            int codeRange = a.codeRange();
            if (impreciseProfile.profile(node, !TSCodeRange.isPrecise(codeRange))) {
                return StringAttributes.getCodeRange(TStringInternalNodes.updateAttributes(node, a, encoding, codeRange, toIndexableNode, calcStringAttributesNode));
            }
            return codeRange;
        }
    }

    static abstract class GetValidOrBrokenCodeRangeNode
    extends AbstractInternalNode {
        GetValidOrBrokenCodeRangeNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, TruffleString.Encoding var3);

        @Specialization
        static int get(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, @Cached InlinedConditionProfile impreciseProfile, @Cached TruffleString.ToIndexableNode toIndexableNode, @Cached CalcStringAttributesNode calcStringAttributesNode) {
            int codeRange = a.codeRange();
            if (impreciseProfile.profile(node, !TSCodeRange.isPrecise(codeRange) && TSCodeRange.isBroken(codeRange))) {
                return StringAttributes.getCodeRange(TStringInternalNodes.updateAttributes(node, a, encoding, codeRange, toIndexableNode, calcStringAttributesNode));
            }
            return codeRange;
        }
    }

    static abstract class GetCodeRangeForIndexCalculationNode
    extends AbstractInternalNode {
        GetCodeRangeForIndexCalculationNode() {
        }

        abstract int execute(Node var1, AbstractTruffleString var2, TruffleString.Encoding var3);

        @Specialization
        static int get(Node node, AbstractTruffleString a, TruffleString.Encoding encoding, @Cached InlinedConditionProfile impreciseProfile, @Cached TruffleString.ToIndexableNode toIndexableNode, @Cached CalcStringAttributesNode calcStringAttributesNode) {
            int codeRange = a.codeRange();
            if (impreciseProfile.profile(node, !TSCodeRange.isPrecise(codeRange) && !TStringGuards.isFixedWidth(codeRange))) {
                return StringAttributes.getCodeRange(TStringInternalNodes.updateAttributes(node, a, encoding, codeRange, toIndexableNode, calcStringAttributesNode));
            }
            return codeRange;
        }
    }
}

