// CheckStyle: start generated
package com.oracle.truffle.api.bytecode;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.UnadoptableNode;

@GeneratedBy(TagTreeNodeExports.class)
final class TagTreeNodeExportsGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(TagTreeNodeExports.class, new NodeLibraryExports());
    }

    private TagTreeNodeExportsGen() {
    }

    @GeneratedBy(TagTreeNodeExports.class)
    private static final class NodeLibraryExports extends LibraryExport<NodeLibrary> {

        private NodeLibraryExports() {
            super(NodeLibrary.class, TagTreeNode.class, false, false, 0);
        }

        @Override
        protected NodeLibrary createUncached(Object receiver) {
            assert receiver instanceof TagTreeNode;
            NodeLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected NodeLibrary createCached(Object receiver) {
            assert receiver instanceof TagTreeNode;
            return new Cached(receiver);
        }

        @GeneratedBy(TagTreeNodeExports.class)
        private static final class Cached extends NodeLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == TagTreeNodeExports.class;
            }

            @Override
            public boolean hasScope(Object receiver, Frame frame) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return TagTreeNodeExports.hasScope(((TagTreeNode) dynamicDispatch_.cast(receiver)), frame);
            }

            @Override
            public Object getScope(Object receiver, Frame frame, boolean nodeEnter) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return TagTreeNodeExports.getScope(((TagTreeNode) dynamicDispatch_.cast(receiver)), frame, nodeEnter);
            }

        }
        @GeneratedBy(TagTreeNodeExports.class)
        @DenyReplace
        private static final class Uncached extends NodeLibrary implements UnadoptableNode {

            @Child private DynamicDispatchLibrary dynamicDispatch_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == TagTreeNodeExports.class;
            }

            @Override
            public boolean hasScope(Object receiver, Frame frame) {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return TagTreeNodeExports.hasScope(((TagTreeNode) receiver) , frame);
            }

            @Override
            public Object getScope(Object receiver, Frame frame, boolean nodeEnter) throws UnsupportedMessageException {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return TagTreeNodeExports.getScope(((TagTreeNode) receiver) , frame, nodeEnter);
            }

        }
    }
}
