// CheckStyle: start generated
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ByteField;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.IntField;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedByteValueProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString.NativePointer;
import com.oracle.truffle.api.strings.IndexOfCodePointSet.IndexOfNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ByteLengthOfCodePointNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CalcStringAttributesInnerNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CalcStringAttributesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointAtNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointAtRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointIndexToRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ConcatEagerNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ConcatMaterializeBytesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CreateJavaStringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromBufferWithStringCompactionNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromJavaStringUTF16Node;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromNativePointerEmbedderNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromNativePointerNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodePointLengthNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodePointLengthWithMaterializationNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeForIndexCalculationNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetPreciseCodeRangeNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetPreciseCodeRangeWithMaterializationNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetValidOrBrokenCodeRangeNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfCodePointRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfCodePointSetNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfStringRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.InternalIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfCodePointRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfStringRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ParseDoubleNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ParseIntNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ParseLongNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.RawIndexToCodePointIndexNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ReadByteNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.RegionEqualsNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.StrideFromCodeRangeNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.SubstringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ToIndexableNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ToValidStringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.TransCodeIntlNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.TransCodeIntlWithErrorHandlerNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.TransCodeNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawLastIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.RawLastIndexOfStringNode;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawIndexOfCodePointNodeGen;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawIndexOfStringNodeGen;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawLastIndexOfCodePointNodeGen;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.RawLastIndexOfStringNodeGen;
import com.oracle.truffle.api.strings.TruffleString.CompactionLevel;
import com.oracle.truffle.api.strings.TruffleString.Encoding;
import com.oracle.truffle.api.strings.TruffleString.ErrorHandling;
import com.oracle.truffle.api.strings.TruffleString.NumberFormatException;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendCodePointIntlNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendStringIntlNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.ToStringIntlNode;
import com.oracle.truffle.api.strings.TruffleStringBuilderFactory.AppendCodePointIntlNodeGen;
import com.oracle.truffle.api.strings.TruffleStringBuilderFactory.AppendStringIntlNodeGen;
import com.oracle.truffle.api.strings.TruffleStringBuilderFactory.ToStringIntlNodeGen;
import com.oracle.truffle.api.strings.TruffleStringIterator.InternalNextNode;
import com.oracle.truffle.api.strings.TruffleStringIterator.InternalPreviousNode;
import com.oracle.truffle.api.strings.TruffleStringIteratorFactory.InternalNextNodeGen;
import com.oracle.truffle.api.strings.TruffleStringIteratorFactory.InternalPreviousNodeGen;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;

@GeneratedBy(TStringInternalNodes.class)
@SuppressWarnings({"javadoc", "unused"})
final class TStringInternalNodesFactory {

    @CompilationFinal(dimensions = 1) private static final CompactionLevel[] COMPACTION_LEVEL_VALUES = DSLSupport.lookupEnumConstants(CompactionLevel.class);

    private static CompactionLevel decodeCompactionLevel(int state) {
        if (state >= 0) {
            return COMPACTION_LEVEL_VALUES[state];
        } else {
            return null;
        }
    }

    private static int encodeCompactionLevel(CompactionLevel e) {
        if (e != null) {
            return e.ordinal();
        } else {
            return -1;
        }
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link ToIndexableNode#doByteArray}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link ToIndexableNode#doNativePointer}
     *     Activation probability: 0.33333
     *     With/without class size: 8/0 bytes
     *   Specialization {@link ToIndexableNode#slowpath}
     *     Activation probability: 0.18333
     *     With/without class size: 6/0 bytes
     * </pre> */
    @GeneratedBy(ToIndexableNode.class)
    @SuppressWarnings("javadoc")
    static final class ToIndexableNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static ToIndexableNode getUncached() {
            return ToIndexableNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static ToIndexableNode inline(@RequiredField(bits = 3, value = StateField.class) InlineTarget target) {
            return new ToIndexableNodeGen.Inlined(target);
        }

        @GeneratedBy(ToIndexableNode.class)
        @DenyReplace
        private static final class Inlined extends ToIndexableNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ToIndexableNode#doByteArray}
             *   1: SpecializationActive {@link ToIndexableNode#doNativePointer}
             *   2: SpecializationActive {@link ToIndexableNode#slowpath}
             * </pre> */
            private final StateField state_0_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ToIndexableNode.class);
                this.state_0_ = target.getState(0, 3);
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ToIndexableNode.doByteArray(AbstractTruffleString, byte[])] */) && arg2Value instanceof byte[]) {
                    return false;
                }
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.ToIndexableNode.doNativePointer(AbstractTruffleString, NativePointer)] */) && arg2Value instanceof NativePointer) {
                    return false;
                }
                return true;
            }

            @Override
            Object execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0 /* is SpecializationActive[TStringInternalNodes.ToIndexableNode.doByteArray(AbstractTruffleString, byte[])] || SpecializationActive[TStringInternalNodes.ToIndexableNode.doNativePointer(AbstractTruffleString, NativePointer)] || SpecializationActive[TStringInternalNodes.ToIndexableNode.slowpath(Node, AbstractTruffleString, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ToIndexableNode.doByteArray(AbstractTruffleString, byte[])] */ && arg2Value instanceof byte[]) {
                        byte[] arg2Value_ = (byte[]) arg2Value;
                        return ToIndexableNode.doByteArray(arg1Value, arg2Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.ToIndexableNode.doNativePointer(AbstractTruffleString, NativePointer)] */ && arg2Value instanceof NativePointer) {
                        NativePointer arg2Value_ = (NativePointer) arg2Value;
                        return ToIndexableNode.doNativePointer(arg1Value, arg2Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.ToIndexableNode.slowpath(Node, AbstractTruffleString, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                            return ToIndexableNode.slowpath(arg0Value, arg1Value, arg2Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof byte[]) {
                    byte[] arg2Value_ = (byte[]) arg2Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ToIndexableNode.doByteArray(AbstractTruffleString, byte[])] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ToIndexableNode.doByteArray(arg1Value, arg2Value_);
                }
                if (arg2Value instanceof NativePointer) {
                    NativePointer arg2Value_ = (NativePointer) arg2Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.ToIndexableNode.doNativePointer(AbstractTruffleString, NativePointer)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ToIndexableNode.doNativePointer(arg1Value, arg2Value_);
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.ToIndexableNode.slowpath(Node, AbstractTruffleString, Object)] */;
                this.state_0_.set(arg0Value, state_0);
                return ToIndexableNode.slowpath(arg0Value, arg1Value, arg2Value);
            }

        }
        @GeneratedBy(ToIndexableNode.class)
        @DenyReplace
        private static final class Uncached extends ToIndexableNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            Object execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) {
                if (arg2Value instanceof byte[]) {
                    byte[] arg2Value_ = (byte[]) arg2Value;
                    return ToIndexableNode.doByteArray(arg1Value, arg2Value_);
                }
                if (arg2Value instanceof NativePointer) {
                    NativePointer arg2Value_ = (NativePointer) arg2Value;
                    return ToIndexableNode.doNativePointer(arg1Value, arg2Value_);
                }
                return ToIndexableNode.slowpath(arg0Value, arg1Value, arg2Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link GetCodeRangeForIndexCalculationNode#get}
     *     Activation probability: 1.00000
     *     With/without class size: 24/1 bytes
     * </pre> */
    @GeneratedBy(GetCodeRangeForIndexCalculationNode.class)
    @SuppressWarnings("javadoc")
    static final class GetCodeRangeForIndexCalculationNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static GetCodeRangeForIndexCalculationNode getUncached() {
            return GetCodeRangeForIndexCalculationNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static GetCodeRangeForIndexCalculationNode inline(@RequiredField(bits = 2, value = StateField.class) InlineTarget target) {
            return new GetCodeRangeForIndexCalculationNodeGen.Inlined(target);
        }

        @GeneratedBy(GetCodeRangeForIndexCalculationNode.class)
        @DenyReplace
        private static final class Inlined extends GetCodeRangeForIndexCalculationNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link GetCodeRangeForIndexCalculationNode#get}
             *        Parameter: {@link InlinedConditionProfile} impreciseProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetCodeRangeForIndexCalculationNode#get}
             *   Parameter: {@link InlinedConditionProfile} impreciseProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile impreciseProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(GetCodeRangeForIndexCalculationNode.class);
                this.state_0_ = target.getState(0, 2);
                this.impreciseProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, Encoding arg4Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_);
                return GetCodeRangeForIndexCalculationNode.get(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.impreciseProfile_);
            }

        }
        @GeneratedBy(GetCodeRangeForIndexCalculationNode.class)
        @DenyReplace
        private static final class Uncached extends GetCodeRangeForIndexCalculationNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, Encoding arg4Value) {
                return GetCodeRangeForIndexCalculationNode.get(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link GetValidOrBrokenCodeRangeNode#get}
     *     Activation probability: 1.00000
     *     With/without class size: 24/1 bytes
     * </pre> */
    @GeneratedBy(GetValidOrBrokenCodeRangeNode.class)
    @SuppressWarnings("javadoc")
    static final class GetValidOrBrokenCodeRangeNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static GetValidOrBrokenCodeRangeNode getUncached() {
            return GetValidOrBrokenCodeRangeNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static GetValidOrBrokenCodeRangeNode inline(@RequiredField(bits = 6, value = StateField.class) InlineTarget target) {
            return new GetValidOrBrokenCodeRangeNodeGen.Inlined(target);
        }

        @GeneratedBy(GetValidOrBrokenCodeRangeNode.class)
        @DenyReplace
        private static final class Inlined extends GetValidOrBrokenCodeRangeNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link GetValidOrBrokenCodeRangeNode#get}
             *        Parameter: {@link InlinedConditionProfile} impreciseProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-3: InlinedCache
             *        Specialization: {@link GetValidOrBrokenCodeRangeNode#get}
             *        Parameter: {@link InlinedConditionProfile} managedProfileA
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   4-5: InlinedCache
             *        Specialization: {@link GetValidOrBrokenCodeRangeNode#get}
             *        Parameter: {@link InlinedConditionProfile} nativeProfileA
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetValidOrBrokenCodeRangeNode#get}
             *   Parameter: {@link InlinedConditionProfile} impreciseProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile impreciseProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetValidOrBrokenCodeRangeNode#get}
             *   Parameter: {@link InlinedConditionProfile} managedProfileA
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile managedProfileA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetValidOrBrokenCodeRangeNode#get}
             *   Parameter: {@link InlinedConditionProfile} nativeProfileA
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile nativeProfileA_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(GetValidOrBrokenCodeRangeNode.class);
                this.state_0_ = target.getState(0, 6);
                this.impreciseProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.managedProfileA_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(2, 2)));
                this.nativeProfileA_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_);
                return GetValidOrBrokenCodeRangeNode.get(arg0Value, arg1Value, arg2Value, this.impreciseProfile_, this.managedProfileA_, this.nativeProfileA_);
            }

        }
        @GeneratedBy(GetValidOrBrokenCodeRangeNode.class)
        @DenyReplace
        private static final class Uncached extends GetValidOrBrokenCodeRangeNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                return GetValidOrBrokenCodeRangeNode.get(arg0Value, arg1Value, arg2Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link GetPreciseCodeRangeNode#get}
     *     Activation probability: 1.00000
     *     With/without class size: 24/1 bytes
     * </pre> */
    @GeneratedBy(GetPreciseCodeRangeNode.class)
    @SuppressWarnings("javadoc")
    static final class GetPreciseCodeRangeNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static GetPreciseCodeRangeNode getUncached() {
            return GetPreciseCodeRangeNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static GetPreciseCodeRangeNode inline(@RequiredField(bits = 2, value = StateField.class) InlineTarget target) {
            return new GetPreciseCodeRangeNodeGen.Inlined(target);
        }

        @GeneratedBy(GetPreciseCodeRangeNode.class)
        @DenyReplace
        private static final class Inlined extends GetPreciseCodeRangeNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link GetPreciseCodeRangeNode#get}
             *        Parameter: {@link InlinedConditionProfile} impreciseProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetPreciseCodeRangeNode#get}
             *   Parameter: {@link InlinedConditionProfile} impreciseProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile impreciseProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(GetPreciseCodeRangeNode.class);
                this.state_0_ = target.getState(0, 2);
                this.impreciseProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, Encoding arg4Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_);
                return GetPreciseCodeRangeNode.get(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.impreciseProfile_);
            }

        }
        @GeneratedBy(GetPreciseCodeRangeNode.class)
        @DenyReplace
        private static final class Uncached extends GetPreciseCodeRangeNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, Encoding arg4Value) {
                return GetPreciseCodeRangeNode.get(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link GetPreciseCodeRangeWithMaterializationNode#get}
     *     Activation probability: 1.00000
     *     With/without class size: 24/1 bytes
     * </pre> */
    @GeneratedBy(GetPreciseCodeRangeWithMaterializationNode.class)
    @SuppressWarnings("javadoc")
    static final class GetPreciseCodeRangeWithMaterializationNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static GetPreciseCodeRangeWithMaterializationNode getUncached() {
            return GetPreciseCodeRangeWithMaterializationNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static GetPreciseCodeRangeWithMaterializationNode inline(@RequiredField(bits = 6, value = StateField.class) InlineTarget target) {
            return new GetPreciseCodeRangeWithMaterializationNodeGen.Inlined(target);
        }

        @GeneratedBy(GetPreciseCodeRangeWithMaterializationNode.class)
        @DenyReplace
        private static final class Inlined extends GetPreciseCodeRangeWithMaterializationNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link GetPreciseCodeRangeWithMaterializationNode#get}
             *        Parameter: {@link InlinedConditionProfile} impreciseProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-3: InlinedCache
             *        Specialization: {@link GetPreciseCodeRangeWithMaterializationNode#get}
             *        Parameter: {@link InlinedConditionProfile} managedProfileA
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   4-5: InlinedCache
             *        Specialization: {@link GetPreciseCodeRangeWithMaterializationNode#get}
             *        Parameter: {@link InlinedConditionProfile} nativeProfileA
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetPreciseCodeRangeWithMaterializationNode#get}
             *   Parameter: {@link InlinedConditionProfile} impreciseProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile impreciseProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetPreciseCodeRangeWithMaterializationNode#get}
             *   Parameter: {@link InlinedConditionProfile} managedProfileA
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile managedProfileA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetPreciseCodeRangeWithMaterializationNode#get}
             *   Parameter: {@link InlinedConditionProfile} nativeProfileA
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile nativeProfileA_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(GetPreciseCodeRangeWithMaterializationNode.class);
                this.state_0_ = target.getState(0, 6);
                this.impreciseProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.managedProfileA_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(2, 2)));
                this.nativeProfileA_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_);
                return GetPreciseCodeRangeWithMaterializationNode.get(arg0Value, arg1Value, arg2Value, this.impreciseProfile_, this.managedProfileA_, this.nativeProfileA_);
            }

        }
        @GeneratedBy(GetPreciseCodeRangeWithMaterializationNode.class)
        @DenyReplace
        private static final class Uncached extends GetPreciseCodeRangeWithMaterializationNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                return GetPreciseCodeRangeWithMaterializationNode.get(arg0Value, arg1Value, arg2Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link GetCodePointLengthNode#get}
     *     Activation probability: 1.00000
     *     With/without class size: 24/1 bytes
     * </pre> */
    @GeneratedBy(GetCodePointLengthNode.class)
    @SuppressWarnings("javadoc")
    static final class GetCodePointLengthNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static GetCodePointLengthNode getUncached() {
            return GetCodePointLengthNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static GetCodePointLengthNode inline(@RequiredField(bits = 2, value = StateField.class) InlineTarget target) {
            return new GetCodePointLengthNodeGen.Inlined(target);
        }

        @GeneratedBy(GetCodePointLengthNode.class)
        @DenyReplace
        private static final class Inlined extends GetCodePointLengthNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link GetCodePointLengthNode#get}
             *        Parameter: {@link InlinedConditionProfile} cacheMissProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetCodePointLengthNode#get}
             *   Parameter: {@link InlinedConditionProfile} cacheMissProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile cacheMissProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(GetCodePointLengthNode.class);
                this.state_0_ = target.getState(0, 2);
                this.cacheMissProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, Encoding arg4Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_);
                return GetCodePointLengthNode.get(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.cacheMissProfile_);
            }

        }
        @GeneratedBy(GetCodePointLengthNode.class)
        @DenyReplace
        private static final class Uncached extends GetCodePointLengthNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, Encoding arg4Value) {
                return GetCodePointLengthNode.get(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link GetCodePointLengthWithMaterializationNode#get}
     *     Activation probability: 1.00000
     *     With/without class size: 24/1 bytes
     * </pre> */
    @GeneratedBy(GetCodePointLengthWithMaterializationNode.class)
    @SuppressWarnings("javadoc")
    static final class GetCodePointLengthWithMaterializationNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static GetCodePointLengthWithMaterializationNode getUncached() {
            return GetCodePointLengthWithMaterializationNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static GetCodePointLengthWithMaterializationNode inline(@RequiredField(bits = 6, value = StateField.class) InlineTarget target) {
            return new GetCodePointLengthWithMaterializationNodeGen.Inlined(target);
        }

        @GeneratedBy(GetCodePointLengthWithMaterializationNode.class)
        @DenyReplace
        private static final class Inlined extends GetCodePointLengthWithMaterializationNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link GetCodePointLengthWithMaterializationNode#get}
             *        Parameter: {@link InlinedConditionProfile} cacheMissProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-3: InlinedCache
             *        Specialization: {@link GetCodePointLengthWithMaterializationNode#get}
             *        Parameter: {@link InlinedConditionProfile} managedProfileA
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   4-5: InlinedCache
             *        Specialization: {@link GetCodePointLengthWithMaterializationNode#get}
             *        Parameter: {@link InlinedConditionProfile} nativeProfileA
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetCodePointLengthWithMaterializationNode#get}
             *   Parameter: {@link InlinedConditionProfile} cacheMissProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile cacheMissProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetCodePointLengthWithMaterializationNode#get}
             *   Parameter: {@link InlinedConditionProfile} managedProfileA
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile managedProfileA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetCodePointLengthWithMaterializationNode#get}
             *   Parameter: {@link InlinedConditionProfile} nativeProfileA
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile nativeProfileA_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(GetCodePointLengthWithMaterializationNode.class);
                this.state_0_ = target.getState(0, 6);
                this.cacheMissProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.managedProfileA_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(2, 2)));
                this.nativeProfileA_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_);
                return GetCodePointLengthWithMaterializationNode.get(arg0Value, arg1Value, arg2Value, this.cacheMissProfile_, this.managedProfileA_, this.nativeProfileA_);
            }

        }
        @GeneratedBy(GetCodePointLengthWithMaterializationNode.class)
        @DenyReplace
        private static final class Uncached extends GetCodePointLengthWithMaterializationNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                return GetCodePointLengthWithMaterializationNode.get(arg0Value, arg1Value, arg2Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
     *     Activation probability: 1.00000
     *     With/without class size: 25/3 bytes
     * </pre> */
    @GeneratedBy(FromBufferWithStringCompactionNode.class)
    @SuppressWarnings("javadoc")
    static final class FromBufferWithStringCompactionNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static FromBufferWithStringCompactionNode getUncached() {
            return FromBufferWithStringCompactionNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#unlikelyEncodingProfile__field1_}
         * </ul> */
        @NeverDefault
        public static FromBufferWithStringCompactionNode inline(@RequiredField(bits = 16, value = StateField.class)@RequiredField(ByteField.class) InlineTarget target) {
            return new FromBufferWithStringCompactionNodeGen.Inlined(target);
        }

        @GeneratedBy(FromBufferWithStringCompactionNode.class)
        @DenyReplace
        private static final class Inlined extends FromBufferWithStringCompactionNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf8Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-3: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf8BrokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   4-5: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf16Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   6-7: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf16CompactProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf32Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf32Compact0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   12-13: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf32Compact1Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   14-15: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedByteValueProfile} unlikelyEncodingProfile
             *        Inline method: {@link InlinedByteValueProfile#inline}
             * </pre> */
            private final StateField state_0_;
            private final ByteField unlikelyEncodingProfile__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf8Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf8BrokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8BrokenProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf16Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf16CompactProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16CompactProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf32Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf32Compact0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32Compact0Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf32Compact1Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32Compact1Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedByteValueProfile} unlikelyEncodingProfile
             *   Inline method: {@link InlinedByteValueProfile#inline}</pre> */
            private final InlinedByteValueProfile unlikelyEncodingProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(FromBufferWithStringCompactionNode.class);
                this.state_0_ = target.getState(0, 16);
                this.unlikelyEncodingProfile__field1_ = target.getPrimitive(1, ByteField.class);
                this.utf8Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.utf8BrokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(2, 2)));
                this.utf16Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
                this.utf16CompactProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.utf32Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(8, 2)));
                this.utf32Compact0Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(10, 2)));
                this.utf32Compact1Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(12, 2)));
                this.unlikelyEncodingProfile_ = InlinedByteValueProfile.inline(InlineTarget.create(InlinedByteValueProfile.class, state_0_.subUpdater(14, 2), unlikelyEncodingProfile__field1_));
            }

            @Override
            TruffleString execute(Node arg0Value, Object arg1Value, int arg2Value, int arg3Value, Encoding arg4Value, boolean arg5Value, boolean arg6Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.unlikelyEncodingProfile__field1_);
                return FromBufferWithStringCompactionNode.fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf8Profile_, this.utf8BrokenProfile_, this.utf16Profile_, this.utf16CompactProfile_, this.utf32Profile_, this.utf32Compact0Profile_, this.utf32Compact1Profile_, this.unlikelyEncodingProfile_);
            }

        }
        @GeneratedBy(FromBufferWithStringCompactionNode.class)
        @DenyReplace
        private static final class Uncached extends FromBufferWithStringCompactionNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, Object arg1Value, int arg2Value, int arg3Value, Encoding arg4Value, boolean arg5Value, boolean arg6Value) {
                return FromBufferWithStringCompactionNode.fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedByteValueProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
     *     Activation probability: 1.00000
     *     With/without class size: 24/3 bytes
     * </pre> */
    @GeneratedBy(FromBufferWithStringCompactionKnownAttributesNode.class)
    @SuppressWarnings("javadoc")
    static final class FromBufferWithStringCompactionKnownAttributesNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static FromBufferWithStringCompactionKnownAttributesNode getUncached() {
            return FromBufferWithStringCompactionKnownAttributesNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static FromBufferWithStringCompactionKnownAttributesNode inline(@RequiredField(bits = 18, value = StateField.class) InlineTarget target) {
            return new FromBufferWithStringCompactionKnownAttributesNodeGen.Inlined(target);
        }

        @GeneratedBy(FromBufferWithStringCompactionKnownAttributesNode.class)
        @DenyReplace
        private static final class Inlined extends FromBufferWithStringCompactionKnownAttributesNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} managedProfileA
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-3: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} nativeProfileA
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   4-5: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link GetCodePointLengthNode} getCodePointLengthNode
             *        Inline method: {@link GetCodePointLengthNodeGen#inline}
             *   6-7: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link GetPreciseCodeRangeNode} getPreciseCodeRangeNode
             *        Inline method: {@link GetPreciseCodeRangeNodeGen#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf16Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf16CompactProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   12-13: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf32Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   14-15: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf32Compact0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   16-17: InlinedCache
             *        Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *        Parameter: {@link InlinedConditionProfile} utf32Compact1Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} managedProfileA
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile managedProfileA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} nativeProfileA
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile nativeProfileA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link GetCodePointLengthNode} getCodePointLengthNode
             *   Inline method: {@link GetCodePointLengthNodeGen#inline}</pre> */
            private final GetCodePointLengthNode getCodePointLengthNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link GetPreciseCodeRangeNode} getPreciseCodeRangeNode
             *   Inline method: {@link GetPreciseCodeRangeNodeGen#inline}</pre> */
            private final GetPreciseCodeRangeNode getPreciseCodeRangeNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf16Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf16CompactProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16CompactProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf32Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf32Compact0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32Compact0Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBufferWithStringCompactionKnownAttributesNode#fromBufferWithStringCompaction}
             *   Parameter: {@link InlinedConditionProfile} utf32Compact1Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32Compact1Profile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(FromBufferWithStringCompactionKnownAttributesNode.class);
                this.state_0_ = target.getState(0, 18);
                this.managedProfileA_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.nativeProfileA_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(2, 2)));
                this.getCodePointLengthNode_ = GetCodePointLengthNodeGen.inline(InlineTarget.create(GetCodePointLengthNode.class, state_0_.subUpdater(4, 2)));
                this.getPreciseCodeRangeNode_ = GetPreciseCodeRangeNodeGen.inline(InlineTarget.create(GetPreciseCodeRangeNode.class, state_0_.subUpdater(6, 2)));
                this.utf16Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(8, 2)));
                this.utf16CompactProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(10, 2)));
                this.utf32Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(12, 2)));
                this.utf32Compact0Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(14, 2)));
                this.utf32Compact1Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(16, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, boolean arg2Value, Encoding arg3Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_);
                return FromBufferWithStringCompactionKnownAttributesNode.fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, this.managedProfileA_, this.nativeProfileA_, this.getCodePointLengthNode_, this.getPreciseCodeRangeNode_, this.utf16Profile_, this.utf16CompactProfile_, this.utf32Profile_, this.utf32Compact0Profile_, this.utf32Compact1Profile_);
            }

        }
        @GeneratedBy(FromBufferWithStringCompactionKnownAttributesNode.class)
        @DenyReplace
        private static final class Uncached extends FromBufferWithStringCompactionKnownAttributesNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, boolean arg2Value, Encoding arg3Value) {
                return FromBufferWithStringCompactionKnownAttributesNode.fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (GetCodePointLengthNode.getUncached()), (GetPreciseCodeRangeNodeGen.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link FromNativePointerEmbedderNode#fromNativePointer}
     *     Activation probability: 1.00000
     *     With/without class size: 26/6 bytes
     * </pre> */
    @GeneratedBy(FromNativePointerEmbedderNode.class)
    @SuppressWarnings("javadoc")
    static final class FromNativePointerEmbedderNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static FromNativePointerEmbedderNode getUncached() {
            return FromNativePointerEmbedderNodeGen.UNCACHED;
        }

        @GeneratedBy(FromNativePointerEmbedderNode.class)
        @DenyReplace
        private static final class Uncached extends FromNativePointerEmbedderNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            TruffleString execute(long arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
                return fromNativePointer(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (FromNativePointerNodeGen.getUncached()), (FromBufferWithStringCompactionNodeGen.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link FromNativePointerNode#fromNativePointerInternal}
     *     Activation probability: 1.00000
     *     With/without class size: 25/3 bytes
     * </pre> */
    @GeneratedBy(FromNativePointerNode.class)
    @SuppressWarnings("javadoc")
    static final class FromNativePointerNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static FromNativePointerNode getUncached() {
            return FromNativePointerNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#unlikelyEncodingProfile__field1_}
         * </ul> */
        @NeverDefault
        public static FromNativePointerNode inline(@RequiredField(bits = 10, value = StateField.class)@RequiredField(ByteField.class) InlineTarget target) {
            return new FromNativePointerNodeGen.Inlined(target);
        }

        @GeneratedBy(FromNativePointerNode.class)
        @DenyReplace
        private static final class Inlined extends FromNativePointerNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *        Parameter: {@link InlinedConditionProfile} utf8Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-3: InlinedCache
             *        Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *        Parameter: {@link InlinedConditionProfile} utf8BrokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   4-5: InlinedCache
             *        Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *        Parameter: {@link InlinedConditionProfile} utf16Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   6-7: InlinedCache
             *        Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *        Parameter: {@link InlinedConditionProfile} utf32Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *        Parameter: {@link InlinedByteValueProfile} unlikelyEncodingProfile
             *        Inline method: {@link InlinedByteValueProfile#inline}
             * </pre> */
            private final StateField state_0_;
            private final ByteField unlikelyEncodingProfile__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *   Parameter: {@link InlinedConditionProfile} utf8Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *   Parameter: {@link InlinedConditionProfile} utf8BrokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8BrokenProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *   Parameter: {@link InlinedConditionProfile} utf16Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *   Parameter: {@link InlinedConditionProfile} utf32Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromNativePointerNode#fromNativePointerInternal}
             *   Parameter: {@link InlinedByteValueProfile} unlikelyEncodingProfile
             *   Inline method: {@link InlinedByteValueProfile#inline}</pre> */
            private final InlinedByteValueProfile unlikelyEncodingProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(FromNativePointerNode.class);
                this.state_0_ = target.getState(0, 10);
                this.unlikelyEncodingProfile__field1_ = target.getPrimitive(1, ByteField.class);
                this.utf8Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.utf8BrokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(2, 2)));
                this.utf16Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
                this.utf32Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.unlikelyEncodingProfile_ = InlinedByteValueProfile.inline(InlineTarget.create(InlinedByteValueProfile.class, state_0_.subUpdater(8, 2), unlikelyEncodingProfile__field1_));
            }

            @Override
            TruffleString execute(Node arg0Value, NativePointer arg1Value, int arg2Value, int arg3Value, Encoding arg4Value, boolean arg5Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.unlikelyEncodingProfile__field1_);
                return FromNativePointerNode.fromNativePointerInternal(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.utf8Profile_, this.utf8BrokenProfile_, this.utf16Profile_, this.utf32Profile_, this.unlikelyEncodingProfile_);
            }

        }
        @GeneratedBy(FromNativePointerNode.class)
        @DenyReplace
        private static final class Uncached extends FromNativePointerNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, NativePointer arg1Value, int arg2Value, int arg3Value, Encoding arg4Value, boolean arg5Value) {
                return FromNativePointerNode.fromNativePointerInternal(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedByteValueProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ByteLengthOfCodePointNode#utf8}
     *     Activation probability: 0.38500
     *     With/without class size: 11/1 bytes
     *   Specialization {@link ByteLengthOfCodePointNode#utf16}
     *     Activation probability: 0.29500
     *     With/without class size: 9/1 bytes
     *   Specialization {@link ByteLengthOfCodePointNode#utf32}
     *     Activation probability: 0.20500
     *     With/without class size: 8/1 bytes
     *   Specialization {@link ByteLengthOfCodePointNode#unlikelyCases}
     *     Activation probability: 0.11500
     *     With/without class size: 6/2 bytes
     * </pre> */
    @GeneratedBy(ByteLengthOfCodePointNode.class)
    @SuppressWarnings("javadoc")
    static final class ByteLengthOfCodePointNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static ByteLengthOfCodePointNode getUncached() {
            return ByteLengthOfCodePointNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static ByteLengthOfCodePointNode inline(@RequiredField(bits = 24, value = StateField.class) InlineTarget target) {
            return new ByteLengthOfCodePointNodeGen.Inlined(target);
        }

        @GeneratedBy(ByteLengthOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined extends ByteLengthOfCodePointNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ByteLengthOfCodePointNode#utf8}
             *   1: SpecializationActive {@link ByteLengthOfCodePointNode#utf16}
             *   2: SpecializationActive {@link ByteLengthOfCodePointNode#utf32}
             *   3: SpecializationActive {@link ByteLengthOfCodePointNode#unlikelyCases}
             *   4-5: InlinedCache
             *        Specialization: {@link ByteLengthOfCodePointNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   6-7: InlinedCache
             *        Specialization: {@link ByteLengthOfCodePointNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} fixedProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link ByteLengthOfCodePointNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link ByteLengthOfCodePointNode#utf32}
             *        Parameter: {@link InlinedConditionProfile} returnNegativeProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   12-13: InlinedCache
             *        Specialization: {@link ByteLengthOfCodePointNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} fixedProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   14-15: InlinedCache
             *        Specialization: {@link ByteLengthOfCodePointNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} asciiBrokenReturnNegativeProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   16-17: InlinedCache
             *        Specialization: {@link ByteLengthOfCodePointNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   18-19: InlinedCache
             *        Specialization: {@link ByteLengthOfCodePointNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEBrokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   20-21: InlinedCache
             *        Specialization: {@link ByteLengthOfCodePointNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   22-23: InlinedCache
             *        Specialization: {@link ByteLengthOfCodePointNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf32FEBrokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ByteLengthOfCodePointNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8_validProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ByteLengthOfCodePointNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} fixedProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16_fixedProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ByteLengthOfCodePointNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16_validProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ByteLengthOfCodePointNode#utf32}
             *   Parameter: {@link InlinedConditionProfile} returnNegativeProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32_returnNegativeProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ByteLengthOfCodePointNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} fixedProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_fixedProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ByteLengthOfCodePointNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} asciiBrokenReturnNegativeProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_asciiBrokenReturnNegativeProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ByteLengthOfCodePointNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf16FEProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ByteLengthOfCodePointNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf16FEBrokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf16FEBrokenProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ByteLengthOfCodePointNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf32FEProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ByteLengthOfCodePointNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf32FEBrokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf32FEBrokenProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ByteLengthOfCodePointNode.class);
                this.state_0_ = target.getState(0, 24);
                this.utf8_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
                this.utf16_fixedProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.utf16_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(8, 2)));
                this.utf32_returnNegativeProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(10, 2)));
                this.fallback_fixedProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(12, 2)));
                this.fallback_asciiBrokenReturnNegativeProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(14, 2)));
                this.fallback_utf16FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(16, 2)));
                this.fallback_utf16FEBrokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(18, 2)));
                this.fallback_utf32FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(20, 2)));
                this.fallback_utf32FEBrokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(22, 2)));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, ErrorHandling arg7Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile)] */) && (TStringGuards.isUTF8(arg5Value))) {
                    return false;
                }
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) && (TStringGuards.isUTF16(arg5Value))) {
                    return false;
                }
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf32(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile)] */) && (TStringGuards.isUTF32(arg5Value))) {
                    return false;
                }
                return true;
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, ErrorHandling arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf32(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF8(arg5Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ByteLengthOfCodePointNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf8_validProfile_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF16(arg5Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return ByteLengthOfCodePointNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf16_fixedProfile_, this.utf16_validProfile_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf32(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF32(arg5Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ByteLengthOfCodePointNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf32_returnNegativeProfile_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value)) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_);
                            return ByteLengthOfCodePointNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fallback_fixedProfile_, this.fallback_asciiBrokenReturnNegativeProfile_, this.fallback_utf16FEProfile_, this.fallback_utf16FEBrokenProfile_, this.fallback_utf32FEProfile_, this.fallback_utf32FEBrokenProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, ErrorHandling arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isUTF8(arg5Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return ByteLengthOfCodePointNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf8_validProfile_);
                }
                if ((TStringGuards.isUTF16(arg5Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return ByteLengthOfCodePointNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf16_fixedProfile_, this.utf16_validProfile_);
                }
                if ((TStringGuards.isUTF32(arg5Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.utf32(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return ByteLengthOfCodePointNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf32_returnNegativeProfile_);
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.ByteLengthOfCodePointNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_);
                return ByteLengthOfCodePointNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fallback_fixedProfile_, this.fallback_asciiBrokenReturnNegativeProfile_, this.fallback_utf16FEProfile_, this.fallback_utf16FEBrokenProfile_, this.fallback_utf32FEProfile_, this.fallback_utf32FEBrokenProfile_);
            }

        }
        @GeneratedBy(ByteLengthOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends ByteLengthOfCodePointNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, ErrorHandling arg7Value) {
                if ((TStringGuards.isUTF8(arg5Value))) {
                    return ByteLengthOfCodePointNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg5Value))) {
                    return ByteLengthOfCodePointNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg5Value))) {
                    return ByteLengthOfCodePointNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()));
                }
                return ByteLengthOfCodePointNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link RawIndexToCodePointIndexNode#doFixed}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link RawIndexToCodePointIndexNode#utf8}
     *     Activation probability: 0.29500
     *     With/without class size: 9/1 bytes
     *   Specialization {@link RawIndexToCodePointIndexNode#utf16}
     *     Activation probability: 0.20500
     *     With/without class size: 8/1 bytes
     *   Specialization {@link RawIndexToCodePointIndexNode#unlikelyCases}
     *     Activation probability: 0.11500
     *     With/without class size: 6/1 bytes
     * </pre> */
    @GeneratedBy(RawIndexToCodePointIndexNode.class)
    @SuppressWarnings("javadoc")
    static final class RawIndexToCodePointIndexNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static RawIndexToCodePointIndexNode getUncached() {
            return RawIndexToCodePointIndexNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static RawIndexToCodePointIndexNode inline(@RequiredField(bits = 14, value = StateField.class) InlineTarget target) {
            return new RawIndexToCodePointIndexNodeGen.Inlined(target);
        }

        @GeneratedBy(RawIndexToCodePointIndexNode.class)
        @DenyReplace
        private static final class Inlined extends RawIndexToCodePointIndexNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RawIndexToCodePointIndexNode#doFixed}
             *   1: SpecializationActive {@link RawIndexToCodePointIndexNode#utf8}
             *   2: SpecializationActive {@link RawIndexToCodePointIndexNode#utf16}
             *   3: SpecializationActive {@link RawIndexToCodePointIndexNode#unlikelyCases}
             *   4-5: InlinedCache
             *        Specialization: {@link RawIndexToCodePointIndexNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   6-7: InlinedCache
             *        Specialization: {@link RawIndexToCodePointIndexNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} brokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link RawIndexToCodePointIndexNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link RawIndexToCodePointIndexNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   12-13: InlinedCache
             *        Specialization: {@link RawIndexToCodePointIndexNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RawIndexToCodePointIndexNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8_validProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RawIndexToCodePointIndexNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} brokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8_brokenProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RawIndexToCodePointIndexNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16_validProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RawIndexToCodePointIndexNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf16FEProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RawIndexToCodePointIndexNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf32FEProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(RawIndexToCodePointIndexNode.class);
                this.state_0_ = target.getState(0, 14);
                this.utf8_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
                this.utf8_brokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.utf16_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(8, 2)));
                this.fallback_utf16FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(10, 2)));
                this.fallback_utf32FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(12, 2)));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.doFixed(AbstractTruffleString, byte[], long, int, Encoding, int, int)] */) && (TStringGuards.isFixedWidth(arg4Value))) {
                    return false;
                }
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) && (TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return false;
                }
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, InlinedConditionProfile)] */) && (TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return false;
                }
                return true;
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.doFixed(AbstractTruffleString, byte[], long, int, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.doFixed(AbstractTruffleString, byte[], long, int, Encoding, int, int)] */) {
                        if ((TStringGuards.isFixedWidth(arg4Value))) {
                            return RawIndexToCodePointIndexNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return RawIndexToCodePointIndexNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf8_validProfile_, this.utf8_brokenProfile_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return RawIndexToCodePointIndexNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf16_validProfile_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value)) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return RawIndexToCodePointIndexNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fallback_utf16FEProfile_, this.fallback_utf32FEProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg4Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.doFixed(AbstractTruffleString, byte[], long, int, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return RawIndexToCodePointIndexNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return RawIndexToCodePointIndexNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf8_validProfile_, this.utf8_brokenProfile_);
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return RawIndexToCodePointIndexNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf16_validProfile_);
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.RawIndexToCodePointIndexNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                return RawIndexToCodePointIndexNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fallback_utf16FEProfile_, this.fallback_utf32FEProfile_);
            }

        }
        @GeneratedBy(RawIndexToCodePointIndexNode.class)
        @DenyReplace
        private static final class Uncached extends RawIndexToCodePointIndexNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value) {
                if ((TStringGuards.isFixedWidth(arg4Value))) {
                    return RawIndexToCodePointIndexNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return RawIndexToCodePointIndexNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return RawIndexToCodePointIndexNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()));
                }
                return RawIndexToCodePointIndexNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CodePointIndexToRawNode#doFixed}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link CodePointIndexToRawNode#utf8}
     *     Activation probability: 0.29500
     *     With/without class size: 9/1 bytes
     *   Specialization {@link CodePointIndexToRawNode#utf16}
     *     Activation probability: 0.20500
     *     With/without class size: 8/1 bytes
     *   Specialization {@link CodePointIndexToRawNode#unlikelyCases}
     *     Activation probability: 0.11500
     *     With/without class size: 6/1 bytes
     * </pre> */
    @GeneratedBy(CodePointIndexToRawNode.class)
    @SuppressWarnings("javadoc")
    static final class CodePointIndexToRawNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static CodePointIndexToRawNode getUncached() {
            return CodePointIndexToRawNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static CodePointIndexToRawNode inline(@RequiredField(bits = 12, value = StateField.class) InlineTarget target) {
            return new CodePointIndexToRawNodeGen.Inlined(target);
        }

        @GeneratedBy(CodePointIndexToRawNode.class)
        @DenyReplace
        private static final class Inlined extends CodePointIndexToRawNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CodePointIndexToRawNode#doFixed}
             *   1: SpecializationActive {@link CodePointIndexToRawNode#utf8}
             *   2: SpecializationActive {@link CodePointIndexToRawNode#utf16}
             *   3: SpecializationActive {@link CodePointIndexToRawNode#unlikelyCases}
             *   4-5: InlinedCache
             *        Specialization: {@link CodePointIndexToRawNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   6-7: InlinedCache
             *        Specialization: {@link CodePointIndexToRawNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link CodePointIndexToRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link CodePointIndexToRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointIndexToRawNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8_validProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointIndexToRawNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16_validProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointIndexToRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf16FEProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointIndexToRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf32FEProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CodePointIndexToRawNode.class);
                this.state_0_ = target.getState(0, 12);
                this.utf8_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
                this.utf16_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.fallback_utf16FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(8, 2)));
                this.fallback_utf32FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(10, 2)));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, boolean arg8Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.doFixed(AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean)] */) && (TStringGuards.isFixedWidth(arg4Value))) {
                    return false;
                }
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, InlinedConditionProfile)] */) && (TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return false;
                }
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, InlinedConditionProfile)] */) && (TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return false;
                }
                return true;
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, boolean arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.doFixed(AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean)] || SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.doFixed(AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean)] */) {
                        if ((TStringGuards.isFixedWidth(arg4Value))) {
                            return CodePointIndexToRawNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return CodePointIndexToRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.utf8_validProfile_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return CodePointIndexToRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.utf16_validProfile_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value)) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return CodePointIndexToRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fallback_utf16FEProfile_, this.fallback_utf32FEProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, boolean arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg4Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.doFixed(AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return CodePointIndexToRawNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return CodePointIndexToRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.utf8_validProfile_);
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return CodePointIndexToRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.utf16_validProfile_);
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.CodePointIndexToRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, InlinedConditionProfile, InlinedConditionProfile)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                return CodePointIndexToRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fallback_utf16FEProfile_, this.fallback_utf32FEProfile_);
            }

        }
        @GeneratedBy(CodePointIndexToRawNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointIndexToRawNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, boolean arg8Value) {
                if ((TStringGuards.isFixedWidth(arg4Value))) {
                    return CodePointIndexToRawNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return CodePointIndexToRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return CodePointIndexToRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InlinedConditionProfile.getUncached()));
                }
                return CodePointIndexToRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ReadByteNode#doUTF16}
     *     Activation probability: 0.48333
     *     With/without class size: 13/1 bytes
     *   Specialization {@link ReadByteNode#doUTF32}
     *     Activation probability: 0.33333
     *     With/without class size: 10/1 bytes
     *   Specialization {@link ReadByteNode#doRest}
     *     Activation probability: 0.18333
     *     With/without class size: 6/0 bytes
     * </pre> */
    @GeneratedBy(ReadByteNode.class)
    @SuppressWarnings("javadoc")
    static final class ReadByteNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException6LLLJIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, Object arg5Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        @NeverDefault
        public static ReadByteNode getUncached() {
            return ReadByteNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static ReadByteNode inline(@RequiredField(bits = 9, value = StateField.class) InlineTarget target) {
            return new ReadByteNodeGen.Inlined(target);
        }

        @GeneratedBy(ReadByteNode.class)
        @DenyReplace
        private static final class Inlined extends ReadByteNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReadByteNode#doUTF16}
             *   1: SpecializationActive {@link ReadByteNode#doUTF32}
             *   2: SpecializationActive {@link ReadByteNode#doRest}
             *   3-4: InlinedCache
             *        Specialization: {@link ReadByteNode#doUTF16}
             *        Parameter: {@link InlinedConditionProfile} stride0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   5-6: InlinedCache
             *        Specialization: {@link ReadByteNode#doUTF32}
             *        Parameter: {@link InlinedConditionProfile} stride0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   7-8: InlinedCache
             *        Specialization: {@link ReadByteNode#doUTF32}
             *        Parameter: {@link InlinedConditionProfile} stride1Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadByteNode#doUTF16}
             *   Parameter: {@link InlinedConditionProfile} stride0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile uTF16_stride0Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadByteNode#doUTF32}
             *   Parameter: {@link InlinedConditionProfile} stride0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile uTF32_stride0Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadByteNode#doUTF32}
             *   Parameter: {@link InlinedConditionProfile} stride1Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile uTF32_stride1Profile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ReadByteNode.class);
                this.state_0_ = target.getState(0, 9);
                this.uTF16_stride0Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(3, 2)));
                this.uTF32_stride0Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(5, 2)));
                this.uTF32_stride1Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(7, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[TStringInternalNodes.ReadByteNode.doUTF16(Node, AbstractTruffleString, byte[], long, int, Encoding, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.ReadByteNode.doUTF32(Node, AbstractTruffleString, byte[], long, int, Encoding, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.ReadByteNode.doRest(AbstractTruffleString, byte[], long, int, Encoding)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ReadByteNode.doUTF16(Node, AbstractTruffleString, byte[], long, int, Encoding, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF16(arg5Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ReadByteNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.uTF16_stride0Profile_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.ReadByteNode.doUTF32(Node, AbstractTruffleString, byte[], long, int, Encoding, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF32(arg5Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return ReadByteNode.doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.uTF32_stride0Profile_, this.uTF32_stride1Profile_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.ReadByteNode.doRest(AbstractTruffleString, byte[], long, int, Encoding)] */) {
                        if ((!(TStringGuards.isUTF16Or32(arg5Value)))) {
                            return ReadByteNode.doRest(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isUTF16(arg5Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ReadByteNode.doUTF16(Node, AbstractTruffleString, byte[], long, int, Encoding, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return ReadByteNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.uTF16_stride0Profile_);
                }
                if ((TStringGuards.isUTF32(arg5Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.ReadByteNode.doUTF32(Node, AbstractTruffleString, byte[], long, int, Encoding, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return ReadByteNode.doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.uTF32_stride0Profile_, this.uTF32_stride1Profile_);
                }
                if ((!(TStringGuards.isUTF16Or32(arg5Value)))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.ReadByteNode.doRest(AbstractTruffleString, byte[], long, int, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ReadByteNode.doRest(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                throw newUnsupportedSpecializationException6LLLJIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

        }
        @GeneratedBy(ReadByteNode.class)
        @DenyReplace
        private static final class Uncached extends ReadByteNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value) {
                if ((TStringGuards.isUTF16(arg5Value))) {
                    return ReadByteNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg5Value))) {
                    return ReadByteNode.doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((!(TStringGuards.isUTF16Or32(arg5Value)))) {
                    return ReadByteNode.doRest(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                throw newUnsupportedSpecializationException6LLLJIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CodePointAtNode#utf8}
     *     Activation probability: 0.38500
     *     With/without class size: 11/1 bytes
     *   Specialization {@link CodePointAtNode#utf16}
     *     Activation probability: 0.29500
     *     With/without class size: 9/1 bytes
     *   Specialization {@link CodePointAtNode#utf32}
     *     Activation probability: 0.20500
     *     With/without class size: 8/1 bytes
     *   Specialization {@link CodePointAtNode#unlikelyCases}
     *     Activation probability: 0.11500
     *     With/without class size: 6/2 bytes
     * </pre> */
    @GeneratedBy(CodePointAtNode.class)
    @SuppressWarnings("javadoc")
    static final class CodePointAtNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static CodePointAtNode getUncached() {
            return CodePointAtNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static CodePointAtNode inline(@RequiredField(bits = 28, value = StateField.class) InlineTarget target) {
            return new CodePointAtNodeGen.Inlined(target);
        }

        @GeneratedBy(CodePointAtNode.class)
        @DenyReplace
        private static final class Inlined extends CodePointAtNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CodePointAtNode#utf8}
             *   1: SpecializationActive {@link CodePointAtNode#utf16}
             *   2: SpecializationActive {@link CodePointAtNode#utf32}
             *   3: SpecializationActive {@link CodePointAtNode#unlikelyCases}
             *   4-5: InlinedCache
             *        Specialization: {@link CodePointAtNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   6-7: InlinedCache
             *        Specialization: {@link CodePointAtNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link CodePointAtNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link CodePointAtNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} stride0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   12-13: InlinedCache
             *        Specialization: {@link CodePointAtNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   14-15: InlinedCache
             *        Specialization: {@link CodePointAtNode#utf32}
             *        Parameter: {@link InlinedConditionProfile} stride0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   16-17: InlinedCache
             *        Specialization: {@link CodePointAtNode#utf32}
             *        Parameter: {@link InlinedConditionProfile} stride1Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   18-19: InlinedCache
             *        Specialization: {@link CodePointAtNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} fixedProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   20-21: InlinedCache
             *        Specialization: {@link CodePointAtNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} asciiBrokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   22-23: InlinedCache
             *        Specialization: {@link CodePointAtNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   24-25: InlinedCache
             *        Specialization: {@link CodePointAtNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEValidProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   26-27: InlinedCache
             *        Specialization: {@link CodePointAtNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8_fixedWidthProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8_validProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16_fixedWidthProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} stride0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16_stride0Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16_validProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#utf32}
             *   Parameter: {@link InlinedConditionProfile} stride0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32_stride0Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#utf32}
             *   Parameter: {@link InlinedConditionProfile} stride1Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32_stride1Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} fixedProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_fixedProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} asciiBrokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_asciiBrokenProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf16FEProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf16FEValidProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf16FEValidProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf32FEProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CodePointAtNode.class);
                this.state_0_ = target.getState(0, 28);
                this.utf8_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
                this.utf8_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.utf16_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(8, 2)));
                this.utf16_stride0Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(10, 2)));
                this.utf16_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(12, 2)));
                this.utf32_stride0Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(14, 2)));
                this.utf32_stride1Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(16, 2)));
                this.fallback_fixedProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(18, 2)));
                this.fallback_asciiBrokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(20, 2)));
                this.fallback_utf16FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(22, 2)));
                this.fallback_utf16FEValidProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(24, 2)));
                this.fallback_utf32FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(26, 2)));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, ErrorHandling arg7Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) && (TStringGuards.isUTF8(arg5Value))) {
                    return false;
                }
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) && (TStringGuards.isUTF16(arg5Value))) {
                    return false;
                }
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.utf32(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) && (TStringGuards.isUTF32(arg5Value))) {
                    return false;
                }
                return true;
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, ErrorHandling arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointAtNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointAtNode.utf32(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointAtNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF8(arg5Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return CodePointAtNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf8_fixedWidthProfile_, this.utf8_validProfile_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF16(arg5Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_);
                            return CodePointAtNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf16_fixedWidthProfile_, this.utf16_stride0Profile_, this.utf16_validProfile_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.utf32(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF32(arg5Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return CodePointAtNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf32_stride0Profile_, this.utf32_stride1Profile_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value)) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_);
                            return CodePointAtNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fallback_fixedProfile_, this.fallback_asciiBrokenProfile_, this.fallback_utf16FEProfile_, this.fallback_utf16FEValidProfile_, this.fallback_utf32FEProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, ErrorHandling arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isUTF8(arg5Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.CodePointAtNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return CodePointAtNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf8_fixedWidthProfile_, this.utf8_validProfile_);
                }
                if ((TStringGuards.isUTF16(arg5Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.CodePointAtNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_);
                    return CodePointAtNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf16_fixedWidthProfile_, this.utf16_stride0Profile_, this.utf16_validProfile_);
                }
                if ((TStringGuards.isUTF32(arg5Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.CodePointAtNode.utf32(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return CodePointAtNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf32_stride0Profile_, this.utf32_stride1Profile_);
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.CodePointAtNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_);
                return CodePointAtNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fallback_fixedProfile_, this.fallback_asciiBrokenProfile_, this.fallback_utf16FEProfile_, this.fallback_utf16FEValidProfile_, this.fallback_utf32FEProfile_);
            }

        }
        @GeneratedBy(CodePointAtNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointAtNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, ErrorHandling arg7Value) {
                if ((TStringGuards.isUTF8(arg5Value))) {
                    return CodePointAtNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg5Value))) {
                    return CodePointAtNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg5Value))) {
                    return CodePointAtNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                return CodePointAtNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CodePointAtRawNode#utf8}
     *     Activation probability: 0.38500
     *     With/without class size: 11/1 bytes
     *   Specialization {@link CodePointAtRawNode#utf16}
     *     Activation probability: 0.29500
     *     With/without class size: 9/1 bytes
     *   Specialization {@link CodePointAtRawNode#utf32}
     *     Activation probability: 0.20500
     *     With/without class size: 8/1 bytes
     *   Specialization {@link CodePointAtRawNode#unlikelyCases}
     *     Activation probability: 0.11500
     *     With/without class size: 6/2 bytes
     * </pre> */
    @GeneratedBy(CodePointAtRawNode.class)
    @SuppressWarnings("javadoc")
    static final class CodePointAtRawNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static CodePointAtRawNode getUncached() {
            return CodePointAtRawNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static CodePointAtRawNode inline(@RequiredField(bits = 28, value = StateField.class) InlineTarget target) {
            return new CodePointAtRawNodeGen.Inlined(target);
        }

        @GeneratedBy(CodePointAtRawNode.class)
        @DenyReplace
        private static final class Inlined extends CodePointAtRawNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CodePointAtRawNode#utf8}
             *   1: SpecializationActive {@link CodePointAtRawNode#utf16}
             *   2: SpecializationActive {@link CodePointAtRawNode#utf32}
             *   3: SpecializationActive {@link CodePointAtRawNode#unlikelyCases}
             *   4-5: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   6-7: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   12-13: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf16}
             *        Parameter: {@link InlinedConditionProfile} stride0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   14-15: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf32}
             *        Parameter: {@link InlinedConditionProfile} stride0Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   16-17: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#utf32}
             *        Parameter: {@link InlinedConditionProfile} stride1Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   18-19: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} fixedProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   20-21: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} asciiBrokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   22-23: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   24-25: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEValidProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   26-27: InlinedCache
             *        Specialization: {@link CodePointAtRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8_fixedWidthProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8_validProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} fixedWidthProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16_fixedWidthProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16_validProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf16}
             *   Parameter: {@link InlinedConditionProfile} stride0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16_stride0Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf32}
             *   Parameter: {@link InlinedConditionProfile} stride0Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32_stride0Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#utf32}
             *   Parameter: {@link InlinedConditionProfile} stride1Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32_stride1Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} fixedProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_fixedProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} asciiBrokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_asciiBrokenProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf16FEProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf16FEValidProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf16FEValidProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CodePointAtRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf32FEProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CodePointAtRawNode.class);
                this.state_0_ = target.getState(0, 28);
                this.utf8_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
                this.utf8_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.utf16_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(8, 2)));
                this.utf16_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(10, 2)));
                this.utf16_stride0Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(12, 2)));
                this.utf32_stride0Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(14, 2)));
                this.utf32_stride1Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(16, 2)));
                this.fallback_fixedProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(18, 2)));
                this.fallback_asciiBrokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(20, 2)));
                this.fallback_utf16FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(22, 2)));
                this.fallback_utf16FEValidProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(24, 2)));
                this.fallback_utf32FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(26, 2)));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, ErrorHandling arg7Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) && (TStringGuards.isUTF8(arg5Value))) {
                    return false;
                }
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) && (TStringGuards.isUTF16(arg5Value))) {
                    return false;
                }
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf32(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) && (TStringGuards.isUTF32(arg5Value))) {
                    return false;
                }
                return true;
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, ErrorHandling arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf32(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CodePointAtRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF8(arg5Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return CodePointAtRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf8_fixedWidthProfile_, this.utf8_validProfile_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF16(arg5Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_);
                            return CodePointAtRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf16_fixedWidthProfile_, this.utf16_validProfile_, this.utf16_stride0Profile_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf32(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF32(arg5Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return CodePointAtRawNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf32_stride0Profile_, this.utf32_stride1Profile_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.CodePointAtRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value)) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_);
                            return CodePointAtRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fallback_fixedProfile_, this.fallback_asciiBrokenProfile_, this.fallback_utf16FEProfile_, this.fallback_utf16FEValidProfile_, this.fallback_utf32FEProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, ErrorHandling arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isUTF8(arg5Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf8(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return CodePointAtRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf8_fixedWidthProfile_, this.utf8_validProfile_);
                }
                if ((TStringGuards.isUTF16(arg5Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf16(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_);
                    return CodePointAtRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf16_fixedWidthProfile_, this.utf16_validProfile_, this.utf16_stride0Profile_);
                }
                if ((TStringGuards.isUTF32(arg5Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.CodePointAtRawNode.utf32(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return CodePointAtRawNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf32_stride0Profile_, this.utf32_stride1Profile_);
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.CodePointAtRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, ErrorHandling, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_);
                return CodePointAtRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fallback_fixedProfile_, this.fallback_asciiBrokenProfile_, this.fallback_utf16FEProfile_, this.fallback_utf16FEValidProfile_, this.fallback_utf32FEProfile_);
            }

        }
        @GeneratedBy(CodePointAtRawNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointAtRawNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, ErrorHandling arg7Value) {
                if ((TStringGuards.isUTF8(arg5Value))) {
                    return CodePointAtRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg5Value))) {
                    return CodePointAtRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg5Value))) {
                    return CodePointAtRawNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                return CodePointAtRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IndexOfCodePointNode#doFixedWidth}
     *     Activation probability: 0.65000
     *     With/without class size: 17/2 bytes
     *   Specialization {@link IndexOfCodePointNode#decode}
     *     Activation probability: 0.35000
     *     With/without class size: 12/7 bytes
     * </pre> */
    @GeneratedBy(IndexOfCodePointNode.class)
    @SuppressWarnings("javadoc")
    static final class IndexOfCodePointNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException9LLLJILIII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
        }

        @NeverDefault
        public static IndexOfCodePointNode getUncached() {
            return IndexOfCodePointNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#decode_nextNode__field1_}
         * </ul> */
        @NeverDefault
        public static IndexOfCodePointNode inline(@RequiredField(bits = 14, value = StateField.class)@RequiredField(bits = 22, value = StateField.class)@RequiredField(IntField.class) InlineTarget target) {
            return new IndexOfCodePointNodeGen.Inlined(target);
        }

        @GeneratedBy(IndexOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined extends IndexOfCodePointNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IndexOfCodePointNode#doFixedWidth}
             *   1: SpecializationActive {@link IndexOfCodePointNode#decode}
             *   2-13: InlinedCache
             *        Specialization: {@link IndexOfCodePointNode#doFixedWidth}
             *        Parameter: {@link RawIndexOfCodePointNode} indexOfNode
             *        Inline method: {@link RawIndexOfCodePointNodeGen#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link IndexOfCodePointNode#decode}
             *        Parameter: {@link InternalNextNode} nextNode
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre> */
            private final StateField state_1_;
            private final IntField decode_nextNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfCodePointNode#doFixedWidth}
             *   Parameter: {@link RawIndexOfCodePointNode} indexOfNode
             *   Inline method: {@link RawIndexOfCodePointNodeGen#inline}</pre> */
            private final RawIndexOfCodePointNode fixedWidth_indexOfNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfCodePointNode#decode}
             *   Parameter: {@link InternalNextNode} nextNode
             *   Inline method: {@link InternalNextNodeGen#inline}</pre> */
            private final InternalNextNode decode_nextNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(IndexOfCodePointNode.class);
                this.state_0_ = target.getState(0, 14);
                this.state_1_ = target.getState(1, 22);
                this.decode_nextNode__field1_ = target.getPrimitive(2, IntField.class);
                this.fixedWidth_indexOfNode_ = RawIndexOfCodePointNodeGen.inline(InlineTarget.create(RawIndexOfCodePointNode.class, state_0_.subUpdater(2, 12)));
                this.decode_nextNode_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 22), decode_nextNode__field1_));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointNode.doFixedWidth(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawIndexOfCodePointNode)] || SpecializationActive[TStringInternalNodes.IndexOfCodePointNode.decode(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, InternalNextNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointNode.doFixedWidth(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawIndexOfCodePointNode)] */) {
                        if ((TStringGuards.isFixedWidth(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return IndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fixedWidth_indexOfNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointNode.decode(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, InternalNextNode)] */) {
                        if ((!(TStringGuards.isFixedWidth(arg4Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_1_, this.decode_nextNode__field1_);
                            return IndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.decode_nextNode_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg4Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointNode.doFixedWidth(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawIndexOfCodePointNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return IndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fixedWidth_indexOfNode_);
                }
                if ((!(TStringGuards.isFixedWidth(arg4Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointNode.decode(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_1_, this.decode_nextNode__field1_);
                    return IndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.decode_nextNode_);
                }
                throw newUnsupportedSpecializationException9LLLJILIII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

        }
        @GeneratedBy(IndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends IndexOfCodePointNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                if ((TStringGuards.isFixedWidth(arg4Value))) {
                    return IndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (RawIndexOfCodePointNodeGen.getUncached()));
                }
                if ((!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return IndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InternalNextNode.getUncached()));
                }
                throw newUnsupportedSpecializationException9LLLJILIII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IndexOfCodePointRawNode#fixed}
     *     Activation probability: 0.38500
     *     With/without class size: 11/2 bytes
     *   Specialization {@link IndexOfCodePointRawNode#utf8Variable}
     *     Activation probability: 0.29500
     *     With/without class size: 7/0 bytes
     *   Specialization {@link IndexOfCodePointRawNode#utf16Variable}
     *     Activation probability: 0.20500
     *     With/without class size: 6/0 bytes
     *   Specialization {@link IndexOfCodePointRawNode#unlikelyCases}
     *     Activation probability: 0.11500
     *     With/without class size: 6/1 bytes
     * </pre> */
    @GeneratedBy(IndexOfCodePointRawNode.class)
    @SuppressWarnings("javadoc")
    static final class IndexOfCodePointRawNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static IndexOfCodePointRawNode getUncached() {
            return IndexOfCodePointRawNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static IndexOfCodePointRawNode inline(@RequiredField(bits = 20, value = StateField.class) InlineTarget target) {
            return new IndexOfCodePointRawNodeGen.Inlined(target);
        }

        @GeneratedBy(IndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Inlined extends IndexOfCodePointRawNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IndexOfCodePointRawNode#fixed}
             *   1: SpecializationActive {@link IndexOfCodePointRawNode#utf8Variable}
             *   2: SpecializationActive {@link IndexOfCodePointRawNode#utf16Variable}
             *   3: SpecializationActive {@link IndexOfCodePointRawNode#unlikelyCases}
             *   4-15: InlinedCache
             *        Specialization: {@link IndexOfCodePointRawNode#fixed}
             *        Parameter: {@link RawIndexOfCodePointNode} indexOfNode
             *        Inline method: {@link RawIndexOfCodePointNodeGen#inline}
             *   16-17: InlinedCache
             *        Specialization: {@link IndexOfCodePointRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   18-19: InlinedCache
             *        Specialization: {@link IndexOfCodePointRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfCodePointRawNode#fixed}
             *   Parameter: {@link RawIndexOfCodePointNode} indexOfNode
             *   Inline method: {@link RawIndexOfCodePointNodeGen#inline}</pre> */
            private final RawIndexOfCodePointNode fixed_indexOfNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfCodePointRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf16FEProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfCodePointRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf32FEProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(IndexOfCodePointRawNode.class);
                this.state_0_ = target.getState(0, 20);
                this.fixed_indexOfNode_ = RawIndexOfCodePointNodeGen.inline(InlineTarget.create(RawIndexOfCodePointNode.class, state_0_.subUpdater(4, 12)));
                this.fallback_utf16FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(16, 2)));
                this.fallback_utf32FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(18, 2)));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.fixed(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawIndexOfCodePointNode)] */) && (TStringGuards.isFixedWidth(arg4Value))) {
                    return false;
                }
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf8Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int)] */) && (TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return false;
                }
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf16Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int)] */) && (TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return false;
                }
                return true;
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.fixed(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawIndexOfCodePointNode)] || SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf8Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int)] || SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf16Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int)] || SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.fixed(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawIndexOfCodePointNode)] */) {
                        if ((TStringGuards.isFixedWidth(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return IndexOfCodePointRawNode.fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fixed_indexOfNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf8Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int)] */) {
                        if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                            return IndexOfCodePointRawNode.utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf16Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int)] */) {
                        if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                            return IndexOfCodePointRawNode.utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value)) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return IndexOfCodePointRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fallback_utf16FEProfile_, this.fallback_utf32FEProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg4Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.fixed(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawIndexOfCodePointNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return IndexOfCodePointRawNode.fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fixed_indexOfNode_);
                }
                if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf8Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return IndexOfCodePointRawNode.utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.utf16Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return IndexOfCodePointRawNode.utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, InlinedConditionProfile, InlinedConditionProfile)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                return IndexOfCodePointRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fallback_utf16FEProfile_, this.fallback_utf32FEProfile_);
            }

        }
        @GeneratedBy(IndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Uncached extends IndexOfCodePointRawNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                if ((TStringGuards.isFixedWidth(arg4Value))) {
                    return IndexOfCodePointRawNode.fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (RawIndexOfCodePointNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return IndexOfCodePointRawNode.utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return IndexOfCodePointRawNode.utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                return IndexOfCodePointRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LastIndexOfCodePointNode#doFixedWidth}
     *     Activation probability: 0.65000
     *     With/without class size: 17/2 bytes
     *   Specialization {@link LastIndexOfCodePointNode#decode}
     *     Activation probability: 0.35000
     *     With/without class size: 12/7 bytes
     * </pre> */
    @GeneratedBy(LastIndexOfCodePointNode.class)
    @SuppressWarnings("javadoc")
    static final class LastIndexOfCodePointNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException9LLLJILIII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
        }

        @NeverDefault
        public static LastIndexOfCodePointNode getUncached() {
            return LastIndexOfCodePointNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#decode_nextNode__field1_}
         * </ul> */
        @NeverDefault
        public static LastIndexOfCodePointNode inline(@RequiredField(bits = 14, value = StateField.class)@RequiredField(bits = 22, value = StateField.class)@RequiredField(IntField.class) InlineTarget target) {
            return new LastIndexOfCodePointNodeGen.Inlined(target);
        }

        @GeneratedBy(LastIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined extends LastIndexOfCodePointNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LastIndexOfCodePointNode#doFixedWidth}
             *   1: SpecializationActive {@link LastIndexOfCodePointNode#decode}
             *   2-13: InlinedCache
             *        Specialization: {@link LastIndexOfCodePointNode#doFixedWidth}
             *        Parameter: {@link RawLastIndexOfCodePointNode} lastIndexOfNode
             *        Inline method: {@link RawLastIndexOfCodePointNodeGen#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link LastIndexOfCodePointNode#decode}
             *        Parameter: {@link InternalNextNode} nextNode
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre> */
            private final StateField state_1_;
            private final IntField decode_nextNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfCodePointNode#doFixedWidth}
             *   Parameter: {@link RawLastIndexOfCodePointNode} lastIndexOfNode
             *   Inline method: {@link RawLastIndexOfCodePointNodeGen#inline}</pre> */
            private final RawLastIndexOfCodePointNode fixedWidth_lastIndexOfNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfCodePointNode#decode}
             *   Parameter: {@link InternalNextNode} nextNode
             *   Inline method: {@link InternalNextNodeGen#inline}</pre> */
            private final InternalNextNode decode_nextNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(LastIndexOfCodePointNode.class);
                this.state_0_ = target.getState(0, 14);
                this.state_1_ = target.getState(1, 22);
                this.decode_nextNode__field1_ = target.getPrimitive(2, IntField.class);
                this.fixedWidth_lastIndexOfNode_ = RawLastIndexOfCodePointNodeGen.inline(InlineTarget.create(RawLastIndexOfCodePointNode.class, state_0_.subUpdater(2, 12)));
                this.decode_nextNode_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 22), decode_nextNode__field1_));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointNode.doFixedWidth(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] || SpecializationActive[TStringInternalNodes.LastIndexOfCodePointNode.decode(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, InternalNextNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointNode.doFixedWidth(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */) {
                        if ((TStringGuards.isFixedWidth(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return LastIndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fixedWidth_lastIndexOfNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointNode.decode(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, InternalNextNode)] */) {
                        if ((!(TStringGuards.isFixedWidth(arg4Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_1_, this.decode_nextNode__field1_);
                            return LastIndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.decode_nextNode_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg4Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.LastIndexOfCodePointNode.doFixedWidth(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return LastIndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fixedWidth_lastIndexOfNode_);
                }
                if ((!(TStringGuards.isFixedWidth(arg4Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.LastIndexOfCodePointNode.decode(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_1_, this.decode_nextNode__field1_);
                    return LastIndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.decode_nextNode_);
                }
                throw newUnsupportedSpecializationException9LLLJILIII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

        }
        @GeneratedBy(LastIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends LastIndexOfCodePointNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                if ((TStringGuards.isFixedWidth(arg4Value))) {
                    return LastIndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (RawLastIndexOfCodePointNodeGen.getUncached()));
                }
                if ((!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return LastIndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InternalNextNode.getUncached()));
                }
                throw newUnsupportedSpecializationException9LLLJILIII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LastIndexOfCodePointRawNode#utf8Fixed}
     *     Activation probability: 0.38500
     *     With/without class size: 10/0 bytes
     *   Specialization {@link LastIndexOfCodePointRawNode#utf8Variable}
     *     Activation probability: 0.29500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LastIndexOfCodePointRawNode#utf16Variable}
     *     Activation probability: 0.20500
     *     With/without class size: 7/0 bytes
     *   Specialization {@link LastIndexOfCodePointRawNode#unlikelyCases}
     *     Activation probability: 0.11500
     *     With/without class size: 6/1 bytes
     * </pre> */
    @GeneratedBy(LastIndexOfCodePointRawNode.class)
    @SuppressWarnings("javadoc")
    static final class LastIndexOfCodePointRawNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static LastIndexOfCodePointRawNode getUncached() {
            return LastIndexOfCodePointRawNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static LastIndexOfCodePointRawNode inline(@RequiredField(bits = 20, value = StateField.class) InlineTarget target) {
            return new LastIndexOfCodePointRawNodeGen.Inlined(target);
        }

        @GeneratedBy(LastIndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Inlined extends LastIndexOfCodePointRawNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LastIndexOfCodePointRawNode#utf8Fixed}
             *   1: SpecializationActive {@link LastIndexOfCodePointRawNode#utf8Variable}
             *   2: SpecializationActive {@link LastIndexOfCodePointRawNode#utf16Variable}
             *   3: SpecializationActive {@link LastIndexOfCodePointRawNode#unlikelyCases}
             *   4-15: InlinedCache
             *        Specialization: {@link LastIndexOfCodePointRawNode#utf8Fixed}
             *        Parameter: {@link RawLastIndexOfCodePointNode} lastIndexOfNode
             *        Inline method: {@link RawLastIndexOfCodePointNodeGen#inline}
             *   16-17: InlinedCache
             *        Specialization: {@link LastIndexOfCodePointRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   18-19: InlinedCache
             *        Specialization: {@link LastIndexOfCodePointRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfCodePointRawNode#utf8Fixed}
             *   Parameter: {@link RawLastIndexOfCodePointNode} lastIndexOfNode
             *   Inline method: {@link RawLastIndexOfCodePointNodeGen#inline}</pre> */
            private final RawLastIndexOfCodePointNode lastIndexOfNode;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfCodePointRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf16FEProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfCodePointRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf32FEProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(LastIndexOfCodePointRawNode.class);
                this.state_0_ = target.getState(0, 20);
                this.lastIndexOfNode = RawLastIndexOfCodePointNodeGen.inline(InlineTarget.create(RawLastIndexOfCodePointNode.class, state_0_.subUpdater(4, 12)));
                this.fallback_utf16FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(16, 2)));
                this.fallback_utf32FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(18, 2)));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Fixed(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */) && (TStringGuards.isFixedWidth(arg4Value))) {
                    return false;
                }
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */) && (TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return false;
                }
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf16Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */) && (TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return false;
                }
                return true;
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Fixed(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] || SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] || SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf16Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] || SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Fixed(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */) {
                        if ((TStringGuards.isFixedWidth(arg4Value))) {
                            return LastIndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.lastIndexOfNode);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */) {
                        if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                            return LastIndexOfCodePointRawNode.utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.lastIndexOfNode);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf16Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */) {
                        if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                            return LastIndexOfCodePointRawNode.utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.lastIndexOfNode);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value)) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return LastIndexOfCodePointRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fallback_utf16FEProfile_, this.fallback_utf32FEProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg4Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Fixed(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return LastIndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.lastIndexOfNode);
                }
                if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return LastIndexOfCodePointRawNode.utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.lastIndexOfNode);
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.utf16Variable(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, RawLastIndexOfCodePointNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return LastIndexOfCodePointRawNode.utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.lastIndexOfNode);
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.LastIndexOfCodePointRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, int, InlinedConditionProfile, InlinedConditionProfile)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                return LastIndexOfCodePointRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fallback_utf16FEProfile_, this.fallback_utf32FEProfile_);
            }

        }
        @GeneratedBy(LastIndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Uncached extends LastIndexOfCodePointRawNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, int arg8Value) {
                if ((TStringGuards.isFixedWidth(arg4Value))) {
                    return LastIndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (RawLastIndexOfCodePointNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF8(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return LastIndexOfCodePointRawNode.utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (RawLastIndexOfCodePointNodeGen.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg5Value)) && (!(TStringGuards.isFixedWidth(arg4Value)))) {
                    return LastIndexOfCodePointRawNode.utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (RawLastIndexOfCodePointNodeGen.getUncached()));
                }
                return LastIndexOfCodePointRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IndexOfCodePointSetNode#stride0}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link IndexOfCodePointSetNode#dynamicStride}
     *     Activation probability: 0.35000
     *     With/without class size: 11/4 bytes
     * </pre> */
    @GeneratedBy(IndexOfCodePointSetNode.class)
    @SuppressWarnings("javadoc")
    static final class IndexOfCodePointSetNodeGen extends IndexOfCodePointSetNode {

        static final ReferenceField<DynamicStrideData> DYNAMIC_STRIDE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "dynamicStride_cache", DynamicStrideData.class);

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link IndexOfCodePointSetNode#stride0}
         *   1: SpecializationActive {@link IndexOfCodePointSetNode#dynamicStride}
         * </pre> */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @CompilationFinal private DynamicStrideData dynamicStride_cache;

        private IndexOfCodePointSetNodeGen(IndexOfNode[] indexOfNodes, Encoding encoding) {
            super(indexOfNodes, encoding);
        }

        @ExplodeLoop
        @Override
        int execute(byte[] arg0Value, long arg1Value, int arg2Value, int arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointSetNode.stride0(byte[], long, int, int, int, int, int)] || SpecializationActive[TStringInternalNodes.IndexOfCodePointSetNode.dynamicStride(byte[], long, int, int, int, int, int, int)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointSetNode.stride0(byte[], long, int, int, int, int, int)] */) {
                    assert DSLSupport.assertIdempotence((!(isUTF16Or32)));
                    return stride0(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfCodePointSetNode.dynamicStride(byte[], long, int, int, int, int, int, int)] */) {
                    assert DSLSupport.assertIdempotence((isUTF16Or32));
                    DynamicStrideData s1_ = this.dynamicStride_cache;
                    while (s1_ != null) {
                        if ((arg3Value == s1_.cachedStride_)) {
                            return dynamicStride(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.cachedStride_);
                        }
                        s1_ = s1_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private int executeAndSpecialize(byte[] arg0Value, long arg1Value, int arg2Value, int arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if ((!(isUTF16Or32))) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointSetNode.stride0(byte[], long, int, int, int, int, int)] */;
                this.state_0_ = state_0;
                return stride0(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
            if ((isUTF16Or32)) {
                while (true) {
                    int count1_ = 0;
                    DynamicStrideData s1_ = DYNAMIC_STRIDE_CACHE_UPDATER.getVolatile(this);
                    DynamicStrideData s1_original = s1_;
                    while (s1_ != null) {
                        if ((arg3Value == s1_.cachedStride_)) {
                            break;
                        }
                        count1_++;
                        s1_ = s1_.next_;
                    }
                    if (s1_ == null) {
                        // assert (arg3Value == s1_.cachedStride_);
                        if (count1_ < (IndexOfCodePointSetNode.POSSIBLE_STRIDE_VALUES)) {
                            s1_ = new DynamicStrideData(s1_original);
                            s1_.cachedStride_ = (arg3Value);
                            if (!DYNAMIC_STRIDE_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.IndexOfCodePointSetNode.dynamicStride(byte[], long, int, int, int, int, int, int)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s1_ != null) {
                        return dynamicStride(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.cachedStride_);
                    }
                    break;
                }
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @NeverDefault
        public static IndexOfCodePointSetNode create(IndexOfNode[] indexOfNodes, Encoding encoding) {
            return new IndexOfCodePointSetNodeGen(indexOfNodes, encoding);
        }

        @GeneratedBy(IndexOfCodePointSetNode.class)
        @DenyReplace
        private static final class DynamicStrideData implements SpecializationDataNode {

            @CompilationFinal final DynamicStrideData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfCodePointSetNode#dynamicStride}
             *   Parameter: int cachedStride</pre> */
            @CompilationFinal int cachedStride_;

            DynamicStrideData(DynamicStrideData next_) {
                this.next_ = next_;
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link SubstringNode#lengthZero}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link SubstringNode#sameStr}
     *     Activation probability: 0.29500
     *     With/without class size: 7/0 bytes
     *   Specialization {@link SubstringNode#materializeSubstring}
     *     Activation probability: 0.20500
     *     With/without class size: 8/1 bytes
     *   Specialization {@link SubstringNode#createLazySubstring}
     *     Activation probability: 0.11500
     *     With/without class size: 6/1 bytes
     * </pre> */
    @GeneratedBy(SubstringNode.class)
    @SuppressWarnings("javadoc")
    static final class SubstringNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException9LLLJILIIZ(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, Object arg5Value, int arg6Value, int arg7Value, boolean arg8Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
        }

        @NeverDefault
        public static SubstringNode getUncached() {
            return SubstringNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * </ul> */
        @NeverDefault
        public static SubstringNode inline(@RequiredField(bits = 31, value = StateField.class)@RequiredField(bits = 2, value = StateField.class) InlineTarget target) {
            return new SubstringNodeGen.Inlined(target);
        }

        @GeneratedBy(SubstringNode.class)
        @DenyReplace
        private static final class Inlined extends SubstringNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link SubstringNode#lengthZero}
             *   1: SpecializationActive {@link SubstringNode#sameStr}
             *   2: SpecializationActive {@link SubstringNode#materializeSubstring}
             *   3: SpecializationActive {@link SubstringNode#createLazySubstring}
             *   4-24: InlinedCache
             *        Specialization: {@link SubstringNode#materializeSubstring}
             *        Parameter: {@link CalcStringAttributesNode} calcAttributesNode
             *        Inline method: {@link CalcStringAttributesNodeGen#inline}
             *   25-26: InlinedCache
             *        Specialization: {@link SubstringNode#materializeSubstring}
             *        Parameter: {@link InlinedConditionProfile} utf16Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   27-28: InlinedCache
             *        Specialization: {@link SubstringNode#materializeSubstring}
             *        Parameter: {@link InlinedConditionProfile} utf32Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   29-30: InlinedCache
             *        Specialization: {@link SubstringNode#createLazySubstring}
             *        Parameter: {@link InlinedConditionProfile} stride1MustMaterializeProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link SubstringNode#createLazySubstring}
             *        Parameter: {@link InlinedConditionProfile} stride2MustMaterializeProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubstringNode#materializeSubstring}
             *   Parameter: {@link CalcStringAttributesNode} calcAttributesNode
             *   Inline method: {@link CalcStringAttributesNodeGen#inline}</pre> */
            private final CalcStringAttributesNode attributes;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubstringNode#materializeSubstring}
             *   Parameter: {@link InlinedConditionProfile} utf16Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile materializeSubstring_utf16Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubstringNode#materializeSubstring}
             *   Parameter: {@link InlinedConditionProfile} utf32Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile materializeSubstring_utf32Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubstringNode#createLazySubstring}
             *   Parameter: {@link InlinedConditionProfile} stride1MustMaterializeProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile createLazySubstring_stride1MustMaterializeProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubstringNode#createLazySubstring}
             *   Parameter: {@link InlinedConditionProfile} stride2MustMaterializeProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile createLazySubstring_stride2MustMaterializeProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(SubstringNode.class);
                this.state_0_ = target.getState(0, 31);
                this.state_1_ = target.getState(1, 2);
                this.attributes = CalcStringAttributesNodeGen.inline(InlineTarget.create(CalcStringAttributesNode.class, state_0_.subUpdater(4, 21)));
                this.materializeSubstring_utf16Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(25, 2)));
                this.materializeSubstring_utf32Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(27, 2)));
                this.createLazySubstring_stride1MustMaterializeProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(29, 2)));
                this.createLazySubstring_stride2MustMaterializeProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_1_.subUpdater(0, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, boolean arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111) != 0 /* is SpecializationActive[TStringInternalNodes.SubstringNode.lengthZero(AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean)] || SpecializationActive[TStringInternalNodes.SubstringNode.sameStr(TruffleString, byte[], long, int, Encoding, int, int, boolean)] || SpecializationActive[TStringInternalNodes.SubstringNode.materializeSubstring(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, CalcStringAttributesNode, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.SubstringNode.createLazySubstring(Node, TruffleString, byte[], long, int, Encoding, int, int, boolean, CalcStringAttributesNode, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.SubstringNode.lengthZero(AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean)] */) {
                        if ((arg7Value == 0)) {
                            return SubstringNode.lengthZero(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.SubstringNode.sameStr(TruffleString, byte[], long, int, Encoding, int, int, boolean)] */ && arg1Value instanceof TruffleString) {
                        TruffleString arg1Value_ = (TruffleString) arg1Value;
                        if ((arg6Value == 0) && (arg7Value == TStringGuards.length(arg1Value_))) {
                            return SubstringNode.sameStr(arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.SubstringNode.materializeSubstring(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, CalcStringAttributesNode, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((arg7Value > 0) && (arg7Value != TStringGuards.length(arg1Value) || arg1Value.isMutable()) && (!(arg8Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return SubstringNode.materializeSubstring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.attributes, this.materializeSubstring_utf16Profile_, this.materializeSubstring_utf32Profile_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.SubstringNode.createLazySubstring(Node, TruffleString, byte[], long, int, Encoding, int, int, boolean, CalcStringAttributesNode, InlinedConditionProfile, InlinedConditionProfile)] */ && arg1Value instanceof TruffleString) {
                        TruffleString arg1Value_ = (TruffleString) arg1Value;
                        if ((arg7Value > 0) && (arg7Value != TStringGuards.length(arg1Value_)) && (arg8Value)) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_);
                            return SubstringNode.createLazySubstring(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.attributes, this.createLazySubstring_stride1MustMaterializeProfile_, this.createLazySubstring_stride2MustMaterializeProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private TruffleString executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, boolean arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((arg7Value == 0)) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.SubstringNode.lengthZero(AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return SubstringNode.lengthZero(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((arg6Value == 0) && (arg7Value == TStringGuards.length(arg1Value_))) {
                        state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.SubstringNode.sameStr(TruffleString, byte[], long, int, Encoding, int, int, boolean)] */;
                        this.state_0_.set(arg0Value, state_0);
                        return SubstringNode.sameStr(arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                    }
                }
                if ((arg7Value > 0) && (arg7Value != TStringGuards.length(arg1Value) || arg1Value.isMutable()) && (!(arg8Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.SubstringNode.materializeSubstring(Node, AbstractTruffleString, byte[], long, int, Encoding, int, int, boolean, CalcStringAttributesNode, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return SubstringNode.materializeSubstring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.attributes, this.materializeSubstring_utf16Profile_, this.materializeSubstring_utf32Profile_);
                }
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((arg7Value > 0) && (arg7Value != TStringGuards.length(arg1Value_)) && (arg8Value)) {
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.SubstringNode.createLazySubstring(Node, TruffleString, byte[], long, int, Encoding, int, int, boolean, CalcStringAttributesNode, InlinedConditionProfile, InlinedConditionProfile)] */;
                        this.state_0_.set(arg0Value, state_0);
                        assert InlineSupport.validate(arg0Value, this.state_0_, this.state_1_);
                        return SubstringNode.createLazySubstring(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.attributes, this.createLazySubstring_stride1MustMaterializeProfile_, this.createLazySubstring_stride2MustMaterializeProfile_);
                    }
                }
                throw newUnsupportedSpecializationException9LLLJILIIZ(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

        }
        @GeneratedBy(SubstringNode.class)
        @DenyReplace
        private static final class Uncached extends SubstringNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value, int arg7Value, boolean arg8Value) {
                if ((arg7Value == 0)) {
                    return SubstringNode.lengthZero(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((arg6Value == 0) && (arg7Value == TStringGuards.length(arg1Value_))) {
                        return SubstringNode.sameStr(arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                    }
                }
                if ((arg7Value > 0) && (arg7Value != TStringGuards.length(arg1Value) || arg1Value.isMutable()) && (!(arg8Value))) {
                    return SubstringNode.materializeSubstring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (CalcStringAttributesNode.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((arg7Value > 0) && (arg7Value != TStringGuards.length(arg1Value_)) && (arg8Value)) {
                        return SubstringNode.createLazySubstring(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (CalcStringAttributesNode.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                    }
                }
                throw newUnsupportedSpecializationException9LLLJILIIZ(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ConcatEagerNode#concat}
     *     Activation probability: 1.00000
     *     With/without class size: 28/5 bytes
     * </pre> */
    @GeneratedBy(ConcatEagerNode.class)
    @SuppressWarnings("javadoc")
    static final class ConcatEagerNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static ConcatEagerNode getUncached() {
            return ConcatEagerNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * </ul> */
        @NeverDefault
        public static ConcatEagerNode inline(@RequiredField(bits = 16, value = StateField.class)@RequiredField(bits = 21, value = StateField.class) InlineTarget target) {
            return new ConcatEagerNodeGen.Inlined(target);
        }

        @GeneratedBy(ConcatEagerNode.class)
        @DenyReplace
        private static final class Inlined extends ConcatEagerNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link InlinedConditionProfile} managedProfileA
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-3: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link InlinedConditionProfile} nativeProfileA
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   4-5: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link InlinedConditionProfile} managedProfileB
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   6-7: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link InlinedConditionProfile} nativeProfileB
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link GetCodePointLengthNode} getCodePointLengthANode
             *        Inline method: {@link GetCodePointLengthNodeGen#inline}
             *   10-11: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link GetCodePointLengthNode} getCodePointLengthBNode
             *        Inline method: {@link GetCodePointLengthNodeGen#inline}
             *   12-13: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link ConcatMaterializeBytesNode} materializeBytesNode
             *        Inline method: {@link ConcatMaterializeBytesNodeGen#inline}
             *   14-15: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link InlinedConditionProfile} brokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link ConcatEagerNode#concat}
             *        Parameter: {@link CalcStringAttributesNode} calculateAttributesNode
             *        Inline method: {@link CalcStringAttributesNodeGen#inline}
             * </pre> */
            private final StateField state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link InlinedConditionProfile} managedProfileA
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile managedProfileA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link InlinedConditionProfile} nativeProfileA
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile nativeProfileA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link InlinedConditionProfile} managedProfileB
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile managedProfileB_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link InlinedConditionProfile} nativeProfileB
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile nativeProfileB_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link GetCodePointLengthNode} getCodePointLengthANode
             *   Inline method: {@link GetCodePointLengthNodeGen#inline}</pre> */
            private final GetCodePointLengthNode getCodePointLengthANode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link GetCodePointLengthNode} getCodePointLengthBNode
             *   Inline method: {@link GetCodePointLengthNodeGen#inline}</pre> */
            private final GetCodePointLengthNode getCodePointLengthBNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link ConcatMaterializeBytesNode} materializeBytesNode
             *   Inline method: {@link ConcatMaterializeBytesNodeGen#inline}</pre> */
            private final ConcatMaterializeBytesNode materializeBytesNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link CalcStringAttributesNode} calculateAttributesNode
             *   Inline method: {@link CalcStringAttributesNodeGen#inline}</pre> */
            private final CalcStringAttributesNode calculateAttributesNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConcatEagerNode#concat}
             *   Parameter: {@link InlinedConditionProfile} brokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile brokenProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ConcatEagerNode.class);
                this.state_0_ = target.getState(0, 16);
                this.state_1_ = target.getState(1, 21);
                this.managedProfileA_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.nativeProfileA_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(2, 2)));
                this.managedProfileB_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(4, 2)));
                this.nativeProfileB_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
                this.getCodePointLengthANode_ = GetCodePointLengthNodeGen.inline(InlineTarget.create(GetCodePointLengthNode.class, state_0_.subUpdater(8, 2)));
                this.getCodePointLengthBNode_ = GetCodePointLengthNodeGen.inline(InlineTarget.create(GetCodePointLengthNode.class, state_0_.subUpdater(10, 2)));
                this.materializeBytesNode_ = ConcatMaterializeBytesNodeGen.inline(InlineTarget.create(ConcatMaterializeBytesNode.class, state_0_.subUpdater(12, 2)));
                this.calculateAttributesNode_ = CalcStringAttributesNodeGen.inline(InlineTarget.create(CalcStringAttributesNode.class, state_1_.subUpdater(0, 21)));
                this.brokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(14, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, AbstractTruffleString arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_1_, this.state_0_);
                return ConcatEagerNode.concat(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.managedProfileA_, this.nativeProfileA_, this.managedProfileB_, this.nativeProfileB_, this.getCodePointLengthANode_, this.getCodePointLengthBNode_, this.materializeBytesNode_, this.calculateAttributesNode_, this.brokenProfile_);
            }

        }
        @GeneratedBy(ConcatEagerNode.class)
        @DenyReplace
        private static final class Uncached extends ConcatEagerNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, AbstractTruffleString arg2Value, Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                return ConcatEagerNode.concat(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (GetCodePointLengthNode.getUncached()), (GetCodePointLengthNode.getUncached()), (ConcatMaterializeBytesNodeGen.getUncached()), (CalcStringAttributesNode.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ConcatMaterializeBytesNode#doWithCompression}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link ConcatMaterializeBytesNode#doNoCompression}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre> */
    @GeneratedBy(ConcatMaterializeBytesNode.class)
    @SuppressWarnings("javadoc")
    static final class ConcatMaterializeBytesNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException10LLLJLLJLII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, Object arg4Value, Object arg5Value, long arg6Value, Object arg7Value, int arg8Value, int arg9Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
        }

        @NeverDefault
        public static ConcatMaterializeBytesNode getUncached() {
            return ConcatMaterializeBytesNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static ConcatMaterializeBytesNode inline(@RequiredField(bits = 2, value = StateField.class) InlineTarget target) {
            return new ConcatMaterializeBytesNodeGen.Inlined(target);
        }

        @GeneratedBy(ConcatMaterializeBytesNode.class)
        @DenyReplace
        private static final class Inlined extends ConcatMaterializeBytesNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ConcatMaterializeBytesNode#doWithCompression}
             *   1: SpecializationActive {@link ConcatMaterializeBytesNode#doNoCompression}
             * </pre> */
            private final StateField state_0_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ConcatMaterializeBytesNode.class);
                this.state_0_ = target.getState(0, 2);
            }

            @Override
            byte[] execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, AbstractTruffleString arg4Value, byte[] arg5Value, long arg6Value, Encoding arg7Value, int arg8Value, int arg9Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0 /* is SpecializationActive[TStringInternalNodes.ConcatMaterializeBytesNode.doWithCompression(Node, AbstractTruffleString, byte[], long, AbstractTruffleString, byte[], long, Encoding, int, int)] || SpecializationActive[TStringInternalNodes.ConcatMaterializeBytesNode.doNoCompression(Node, AbstractTruffleString, byte[], long, AbstractTruffleString, byte[], long, Encoding, int, int)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ConcatMaterializeBytesNode.doWithCompression(Node, AbstractTruffleString, byte[], long, AbstractTruffleString, byte[], long, Encoding, int, int)] */) {
                        if ((TStringGuards.isUTF16(arg7Value) || TStringGuards.isUTF32(arg7Value))) {
                            return ConcatMaterializeBytesNode.doWithCompression(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.ConcatMaterializeBytesNode.doNoCompression(Node, AbstractTruffleString, byte[], long, AbstractTruffleString, byte[], long, Encoding, int, int)] */) {
                        if ((!(TStringGuards.isUTF16(arg7Value))) && (!(TStringGuards.isUTF32(arg7Value)))) {
                            return doNoCompression(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            private byte[] executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, AbstractTruffleString arg4Value, byte[] arg5Value, long arg6Value, Encoding arg7Value, int arg8Value, int arg9Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isUTF16(arg7Value) || TStringGuards.isUTF32(arg7Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ConcatMaterializeBytesNode.doWithCompression(Node, AbstractTruffleString, byte[], long, AbstractTruffleString, byte[], long, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ConcatMaterializeBytesNode.doWithCompression(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
                }
                if ((!(TStringGuards.isUTF16(arg7Value))) && (!(TStringGuards.isUTF32(arg7Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.ConcatMaterializeBytesNode.doNoCompression(Node, AbstractTruffleString, byte[], long, AbstractTruffleString, byte[], long, Encoding, int, int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doNoCompression(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
                }
                throw newUnsupportedSpecializationException10LLLJLLJLII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

        }
        @GeneratedBy(ConcatMaterializeBytesNode.class)
        @DenyReplace
        private static final class Uncached extends ConcatMaterializeBytesNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            byte[] execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, AbstractTruffleString arg4Value, byte[] arg5Value, long arg6Value, Encoding arg7Value, int arg8Value, int arg9Value) {
                if ((TStringGuards.isUTF16(arg7Value) || TStringGuards.isUTF32(arg7Value))) {
                    return ConcatMaterializeBytesNode.doWithCompression(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
                }
                if ((!(TStringGuards.isUTF16(arg7Value))) && (!(TStringGuards.isUTF32(arg7Value)))) {
                    return doNoCompression(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
                }
                throw newUnsupportedSpecializationException10LLLJLLJLII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link RegionEqualsNode#direct}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link RegionEqualsNode#decode}
     *     Activation probability: 0.35000
     *     With/without class size: 15/14 bytes
     * </pre> */
    @GeneratedBy(RegionEqualsNode.class)
    @SuppressWarnings("javadoc")
    static final class RegionEqualsNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException13LLLJIILLJIIIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, int arg5Value, Object arg6Value, Object arg7Value, long arg8Value, int arg9Value, int arg10Value, int arg11Value, Object arg12Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value);
        }

        @NeverDefault
        public static RegionEqualsNode getUncached() {
            return RegionEqualsNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#decode_nextNodeA__field1_}
         * <li>{@link Inlined#decode_nextNodeB__field1_}
         * </ul> */
        @NeverDefault
        public static RegionEqualsNode inline(@RequiredField(bits = 24, value = StateField.class)@RequiredField(bits = 22, value = StateField.class)@RequiredField(IntField.class)@RequiredField(IntField.class) InlineTarget target) {
            return new RegionEqualsNodeGen.Inlined(target);
        }

        @GeneratedBy(RegionEqualsNode.class)
        @DenyReplace
        private static final class Inlined extends RegionEqualsNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RegionEqualsNode#direct}
             *   1: SpecializationActive {@link RegionEqualsNode#decode}
             *   2-23: InlinedCache
             *        Specialization: {@link RegionEqualsNode#decode}
             *        Parameter: {@link InternalNextNode} nextNodeA
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link RegionEqualsNode#decode}
             *        Parameter: {@link InternalNextNode} nextNodeB
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre> */
            private final StateField state_1_;
            private final IntField decode_nextNodeA__field1_;
            private final IntField decode_nextNodeB__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RegionEqualsNode#decode}
             *   Parameter: {@link InternalNextNode} nextNodeA
             *   Inline method: {@link InternalNextNodeGen#inline}</pre> */
            private final InternalNextNode decode_nextNodeA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RegionEqualsNode#decode}
             *   Parameter: {@link InternalNextNode} nextNodeB
             *   Inline method: {@link InternalNextNodeGen#inline}</pre> */
            private final InternalNextNode decode_nextNodeB_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(RegionEqualsNode.class);
                this.state_0_ = target.getState(0, 24);
                this.state_1_ = target.getState(1, 22);
                this.decode_nextNodeA__field1_ = target.getPrimitive(2, IntField.class);
                this.decode_nextNodeB__field1_ = target.getPrimitive(3, IntField.class);
                this.decode_nextNodeA_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_0_.subUpdater(2, 22), decode_nextNodeA__field1_));
                this.decode_nextNodeB_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 22), decode_nextNodeB__field1_));
            }

            @Override
            boolean execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, AbstractTruffleString arg6Value, byte[] arg7Value, long arg8Value, int arg9Value, int arg10Value, int arg11Value, Encoding arg12Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.RegionEqualsNode.direct(AbstractTruffleString, byte[], long, int, int, AbstractTruffleString, byte[], long, int, int, int, Encoding)] || SpecializationActive[TStringInternalNodes.RegionEqualsNode.decode(Node, AbstractTruffleString, byte[], long, int, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, InternalNextNode, InternalNextNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.RegionEqualsNode.direct(AbstractTruffleString, byte[], long, int, int, AbstractTruffleString, byte[], long, int, int, int, Encoding)] */) {
                        if ((TStringGuards.isFixedWidth(arg4Value, arg9Value))) {
                            return direct(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.RegionEqualsNode.decode(Node, AbstractTruffleString, byte[], long, int, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, InternalNextNode, InternalNextNode)] */) {
                        if ((!(TStringGuards.isFixedWidth(arg4Value, arg9Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.decode_nextNodeA__field1_, this.state_1_, this.decode_nextNodeB__field1_);
                            return RegionEqualsNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value);
            }

            private boolean executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, AbstractTruffleString arg6Value, byte[] arg7Value, long arg8Value, int arg9Value, int arg10Value, int arg11Value, Encoding arg12Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg4Value, arg9Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.RegionEqualsNode.direct(AbstractTruffleString, byte[], long, int, int, AbstractTruffleString, byte[], long, int, int, int, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return direct(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value);
                }
                if ((!(TStringGuards.isFixedWidth(arg4Value, arg9Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.RegionEqualsNode.decode(Node, AbstractTruffleString, byte[], long, int, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, InternalNextNode, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.decode_nextNodeA__field1_, this.state_1_, this.decode_nextNodeB__field1_);
                    return RegionEqualsNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                }
                throw newUnsupportedSpecializationException13LLLJIILLJIIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value);
            }

        }
        @GeneratedBy(RegionEqualsNode.class)
        @DenyReplace
        private static final class Uncached extends RegionEqualsNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            boolean execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, AbstractTruffleString arg6Value, byte[] arg7Value, long arg8Value, int arg9Value, int arg10Value, int arg11Value, Encoding arg12Value) {
                if ((TStringGuards.isFixedWidth(arg4Value, arg9Value))) {
                    return direct(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value);
                }
                if ((!(TStringGuards.isFixedWidth(arg4Value, arg9Value)))) {
                    return RegionEqualsNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, (InternalNextNode.getUncached()), (InternalNextNode.getUncached()));
                }
                throw newUnsupportedSpecializationException13LLLJIILLJIIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link InternalIndexOfStringNode#direct}
     *     Activation probability: 0.65000
     *     With/without class size: 19/5 bytes
     *   Specialization {@link InternalIndexOfStringNode#decode}
     *     Activation probability: 0.35000
     *     With/without class size: 15/14 bytes
     * </pre> */
    @GeneratedBy(InternalIndexOfStringNode.class)
    @SuppressWarnings("javadoc")
    static final class InternalIndexOfStringNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException12LLLJILLJIIIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, Object arg5Value, Object arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, Object arg11Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value);
        }

        @NeverDefault
        public static InternalIndexOfStringNode getUncached() {
            return InternalIndexOfStringNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#direct_indexOfStringNode__field1_}
         * <li>{@link Inlined#decode_nextNodeA__field1_}
         * <li>{@link Inlined#decode_nextNodeB__field1_}
         * </ul> */
        @NeverDefault
        public static InternalIndexOfStringNode inline(@RequiredField(bits = 25, value = StateField.class)@RequiredField(bits = 22, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(IntField.class)@RequiredField(IntField.class) InlineTarget target) {
            return new InternalIndexOfStringNodeGen.Inlined(target);
        }

        @GeneratedBy(InternalIndexOfStringNode.class)
        @DenyReplace
        private static final class Inlined extends InternalIndexOfStringNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link InternalIndexOfStringNode#direct}
             *   1: SpecializationActive {@link InternalIndexOfStringNode#decode}
             *   2: InlinedCache
             *        Specialization: {@link InternalIndexOfStringNode#direct}
             *        Parameter: {@link RawIndexOfStringNode} indexOfStringNode
             *        Inline method: {@link RawIndexOfStringNodeGen#inline}
             *   3-24: InlinedCache
             *        Specialization: {@link InternalIndexOfStringNode#decode}
             *        Parameter: {@link InternalNextNode} nextNodeA
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link InternalIndexOfStringNode#decode}
             *        Parameter: {@link InternalNextNode} nextNodeB
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre> */
            private final StateField state_1_;
            private final ReferenceField<Node> direct_indexOfStringNode__field1_;
            private final IntField decode_nextNodeA__field1_;
            private final IntField decode_nextNodeB__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link InternalIndexOfStringNode#direct}
             *   Parameter: {@link RawIndexOfStringNode} indexOfStringNode
             *   Inline method: {@link RawIndexOfStringNodeGen#inline}</pre> */
            private final RawIndexOfStringNode direct_indexOfStringNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link InternalIndexOfStringNode#decode}
             *   Parameter: {@link InternalNextNode} nextNodeA
             *   Inline method: {@link InternalNextNodeGen#inline}</pre> */
            private final InternalNextNode decode_nextNodeA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link InternalIndexOfStringNode#decode}
             *   Parameter: {@link InternalNextNode} nextNodeB
             *   Inline method: {@link InternalNextNodeGen#inline}</pre> */
            private final InternalNextNode decode_nextNodeB_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(InternalIndexOfStringNode.class);
                this.state_0_ = target.getState(0, 25);
                this.state_1_ = target.getState(1, 22);
                this.direct_indexOfStringNode__field1_ = target.getReference(2, Node.class);
                this.decode_nextNodeA__field1_ = target.getPrimitive(3, IntField.class);
                this.decode_nextNodeB__field1_ = target.getPrimitive(4, IntField.class);
                this.direct_indexOfStringNode_ = RawIndexOfStringNodeGen.inline(InlineTarget.create(RawIndexOfStringNode.class, state_0_.subUpdater(2, 1), direct_indexOfStringNode__field1_));
                this.decode_nextNodeA_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_0_.subUpdater(3, 22), decode_nextNodeA__field1_));
                this.decode_nextNodeB_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 22), decode_nextNodeB__field1_));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, Encoding arg11Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.InternalIndexOfStringNode.direct(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, RawIndexOfStringNode)] || SpecializationActive[TStringInternalNodes.InternalIndexOfStringNode.decode(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, InternalNextNode, InternalNextNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.InternalIndexOfStringNode.direct(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, RawIndexOfStringNode)] */) {
                        if ((TStringGuards.isFixedWidth(arg4Value, arg8Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_);
                            return InternalIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, this.direct_indexOfStringNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.InternalIndexOfStringNode.decode(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, InternalNextNode, InternalNextNode)] */) {
                        if ((!(TStringGuards.isFixedWidth(arg4Value, arg8Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.decode_nextNodeA__field1_, this.state_1_, this.decode_nextNodeB__field1_);
                            return InternalIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, Encoding arg11Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg4Value, arg8Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.InternalIndexOfStringNode.direct(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, RawIndexOfStringNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_);
                    return InternalIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, this.direct_indexOfStringNode_);
                }
                if ((!(TStringGuards.isFixedWidth(arg4Value, arg8Value)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.InternalIndexOfStringNode.decode(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, InternalNextNode, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.decode_nextNodeA__field1_, this.state_1_, this.decode_nextNodeB__field1_);
                    return InternalIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                }
                throw newUnsupportedSpecializationException12LLLJILLJIIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value);
            }

        }
        @GeneratedBy(InternalIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached extends InternalIndexOfStringNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, Encoding arg11Value) {
                if ((TStringGuards.isFixedWidth(arg4Value, arg8Value))) {
                    return InternalIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, (RawIndexOfStringNodeGen.getUncached()));
                }
                if ((!(TStringGuards.isFixedWidth(arg4Value, arg8Value)))) {
                    return InternalIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, (InternalNextNode.getUncached()), (InternalNextNode.getUncached()));
                }
                throw newUnsupportedSpecializationException12LLLJILLJIIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IndexOfStringRawNode#supported}
     *     Activation probability: 0.65000
     *     With/without class size: 19/5 bytes
     *   Specialization {@link IndexOfStringRawNode#unlikelyCases}
     *     Activation probability: 0.35000
     *     With/without class size: 15/15 bytes
     * </pre> */
    @GeneratedBy(IndexOfStringRawNode.class)
    @SuppressWarnings("javadoc")
    static final class IndexOfStringRawNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static IndexOfStringRawNode getUncached() {
            return IndexOfStringRawNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#supported_indexOfStringNode__field1_}
         * <li>{@link Inlined#fallback_nextNodeA__field1_}
         * <li>{@link Inlined#fallback_nextNodeB__field1_}
         * </ul> */
        @NeverDefault
        public static IndexOfStringRawNode inline(@RequiredField(bits = 31, value = StateField.class)@RequiredField(bits = 22, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(IntField.class)@RequiredField(IntField.class) InlineTarget target) {
            return new IndexOfStringRawNodeGen.Inlined(target);
        }

        @GeneratedBy(IndexOfStringRawNode.class)
        @DenyReplace
        private static final class Inlined extends IndexOfStringRawNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IndexOfStringRawNode#supported}
             *   1: SpecializationActive {@link IndexOfStringRawNode#unlikelyCases}
             *   2: InlinedCache
             *        Specialization: {@link IndexOfStringRawNode#supported}
             *        Parameter: {@link RawIndexOfStringNode} indexOfStringNode
             *        Inline method: {@link RawIndexOfStringNodeGen#inline}
             *   3-24: InlinedCache
             *        Specialization: {@link IndexOfStringRawNode#unlikelyCases}
             *        Parameter: {@link InternalNextNode} nextNodeA
             *        Inline method: {@link InternalNextNodeGen#inline}
             *   25-26: InlinedCache
             *        Specialization: {@link IndexOfStringRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   27-28: InlinedCache
             *        Specialization: {@link IndexOfStringRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   29-30: InlinedCache
             *        Specialization: {@link IndexOfStringRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} oneLengthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link IndexOfStringRawNode#unlikelyCases}
             *        Parameter: {@link InternalNextNode} nextNodeB
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre> */
            private final StateField state_1_;
            private final ReferenceField<Node> supported_indexOfStringNode__field1_;
            private final IntField fallback_nextNodeA__field1_;
            private final IntField fallback_nextNodeB__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfStringRawNode#supported}
             *   Parameter: {@link RawIndexOfStringNode} indexOfStringNode
             *   Inline method: {@link RawIndexOfStringNodeGen#inline}</pre> */
            private final RawIndexOfStringNode supported_indexOfStringNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfStringRawNode#unlikelyCases}
             *   Parameter: {@link InternalNextNode} nextNodeA
             *   Inline method: {@link InternalNextNodeGen#inline}</pre> */
            private final InternalNextNode fallback_nextNodeA_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfStringRawNode#unlikelyCases}
             *   Parameter: {@link InternalNextNode} nextNodeB
             *   Inline method: {@link InternalNextNodeGen#inline}</pre> */
            private final InternalNextNode fallback_nextNodeB_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfStringRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf16FEProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfStringRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf32FEProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexOfStringRawNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} oneLengthProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_oneLengthProfile_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(IndexOfStringRawNode.class);
                this.state_0_ = target.getState(0, 31);
                this.state_1_ = target.getState(1, 22);
                this.supported_indexOfStringNode__field1_ = target.getReference(2, Node.class);
                this.fallback_nextNodeA__field1_ = target.getPrimitive(3, IntField.class);
                this.fallback_nextNodeB__field1_ = target.getPrimitive(4, IntField.class);
                this.supported_indexOfStringNode_ = RawIndexOfStringNodeGen.inline(InlineTarget.create(RawIndexOfStringNode.class, state_0_.subUpdater(2, 1), supported_indexOfStringNode__field1_));
                this.fallback_nextNodeA_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_0_.subUpdater(3, 22), fallback_nextNodeA__field1_));
                this.fallback_nextNodeB_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 22), fallback_nextNodeB__field1_));
                this.fallback_utf16FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(25, 2)));
                this.fallback_utf32FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(27, 2)));
                this.fallback_oneLengthProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(29, 2)));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, byte[] arg11Value, Encoding arg12Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.supported(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, RawIndexOfStringNode)] */) && (TStringGuards.isSupportedEncodingWithCompaction(arg12Value) || TStringGuards.isFixedWidth(arg4Value))) {
                    return false;
                }
                return true;
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, byte[] arg11Value, Encoding arg12Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.supported(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, RawIndexOfStringNode)] || SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, InternalNextNode, InternalNextNode, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.supported(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, RawIndexOfStringNode)] */) {
                        if ((TStringGuards.isSupportedEncodingWithCompaction(arg12Value) || TStringGuards.isFixedWidth(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.supported_indexOfStringNode__field1_);
                            return IndexOfStringRawNode.supported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, this.supported_indexOfStringNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, InternalNextNode, InternalNextNode, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value)) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.fallback_nextNodeA__field1_, this.state_1_, this.fallback_nextNodeB__field1_, this.state_0_, this.state_0_, this.state_0_);
                            return IndexOfStringRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, this.fallback_nextNodeA_, this.fallback_nextNodeB_, this.fallback_utf16FEProfile_, this.fallback_utf32FEProfile_, this.fallback_oneLengthProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, byte[] arg11Value, Encoding arg12Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg12Value) || TStringGuards.isFixedWidth(arg4Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.supported(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, RawIndexOfStringNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.supported_indexOfStringNode__field1_);
                    return IndexOfStringRawNode.supported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, this.supported_indexOfStringNode_);
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.IndexOfStringRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, InternalNextNode, InternalNextNode, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_0_, this.fallback_nextNodeA__field1_, this.state_1_, this.fallback_nextNodeB__field1_, this.state_0_, this.state_0_, this.state_0_);
                return IndexOfStringRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, this.fallback_nextNodeA_, this.fallback_nextNodeB_, this.fallback_utf16FEProfile_, this.fallback_utf32FEProfile_, this.fallback_oneLengthProfile_);
            }

        }
        @GeneratedBy(IndexOfStringRawNode.class)
        @DenyReplace
        private static final class Uncached extends IndexOfStringRawNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, byte[] arg11Value, Encoding arg12Value) {
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg12Value) || TStringGuards.isFixedWidth(arg4Value))) {
                    return IndexOfStringRawNode.supported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, (RawIndexOfStringNodeGen.getUncached()));
                }
                return IndexOfStringRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, (InternalNextNode.getUncached()), (InternalNextNode.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LastIndexOfStringNode#direct}
     *     Activation probability: 0.65000
     *     With/without class size: 19/5 bytes
     *   Specialization {@link LastIndexOfStringNode#decode}
     *     Activation probability: 0.35000
     *     With/without class size: 18/21 bytes
     * </pre> */
    @GeneratedBy(LastIndexOfStringNode.class)
    @SuppressWarnings("javadoc")
    static final class LastIndexOfStringNodeGen {

        private static final StateField DECODE_LAST_INDEX_OF_STRING_NODE_DECODE_STATE_0_UPDATER = StateField.create(DecodeData.lookup_(), "decode_state_0_");
        private static final InternalNextNode INLINED_DECODE_NEXT_NODE_A_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, DECODE_LAST_INDEX_OF_STRING_NODE_DECODE_STATE_0_UPDATER.subUpdater(0, 22), IntField.create(DecodeData.lookup_(), "decode_nextNodeA__field1_")));
        private static final StateField DECODE_LAST_INDEX_OF_STRING_NODE_DECODE_STATE_1_UPDATER = StateField.create(DecodeData.lookup_(), "decode_state_1_");
        private static final InternalPreviousNode INLINED_DECODE_PREV_NODE_A_ = InternalPreviousNodeGen.inline(InlineTarget.create(InternalPreviousNode.class, DECODE_LAST_INDEX_OF_STRING_NODE_DECODE_STATE_1_UPDATER.subUpdater(0, 22), IntField.create(DecodeData.lookup_(), "decode_prevNodeA__field1_")));
        private static final StateField DECODE_LAST_INDEX_OF_STRING_NODE_DECODE_STATE_2_UPDATER = StateField.create(DecodeData.lookup_(), "decode_state_2_");
        private static final InternalPreviousNode INLINED_DECODE_PREV_NODE_B_ = InternalPreviousNodeGen.inline(InlineTarget.create(InternalPreviousNode.class, DECODE_LAST_INDEX_OF_STRING_NODE_DECODE_STATE_2_UPDATER.subUpdater(0, 22), IntField.create(DecodeData.lookup_(), "decode_prevNodeB__field1_")));
        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException12LLLJILLJIIIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, Object arg5Value, Object arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, Object arg11Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value);
        }

        @NeverDefault
        public static LastIndexOfStringNode getUncached() {
            return LastIndexOfStringNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#direct_indexOfStringNode__field1_}
         * <li>{@link Inlined#decode_cache}
         * </ul> */
        @NeverDefault
        public static LastIndexOfStringNode inline(@RequiredField(bits = 3, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new LastIndexOfStringNodeGen.Inlined(target);
        }

        @GeneratedBy(LastIndexOfStringNode.class)
        @DenyReplace
        private static final class Inlined extends LastIndexOfStringNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LastIndexOfStringNode#direct}
             *   1: SpecializationActive {@link LastIndexOfStringNode#decode}
             *   2: InlinedCache
             *        Specialization: {@link LastIndexOfStringNode#direct}
             *        Parameter: {@link RawLastIndexOfStringNode} indexOfStringNode
             *        Inline method: {@link RawLastIndexOfStringNodeGen#inline}
             * </pre> */
            private final StateField state_0_;
            private final ReferenceField<Node> direct_indexOfStringNode__field1_;
            private final ReferenceField<DecodeData> decode_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringNode#direct}
             *   Parameter: {@link RawLastIndexOfStringNode} indexOfStringNode
             *   Inline method: {@link RawLastIndexOfStringNodeGen#inline}</pre> */
            private final RawLastIndexOfStringNode direct_indexOfStringNode_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(LastIndexOfStringNode.class);
                this.state_0_ = target.getState(0, 3);
                this.direct_indexOfStringNode__field1_ = target.getReference(1, Node.class);
                this.decode_cache = target.getReference(2, DecodeData.class);
                this.direct_indexOfStringNode_ = RawLastIndexOfStringNodeGen.inline(InlineTarget.create(RawLastIndexOfStringNode.class, state_0_.subUpdater(2, 1), direct_indexOfStringNode__field1_));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, Encoding arg11Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringNode.direct(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, RawLastIndexOfStringNode)] || SpecializationActive[TStringInternalNodes.LastIndexOfStringNode.decode(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, InternalNextNode, InternalPreviousNode, InternalPreviousNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringNode.direct(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, RawLastIndexOfStringNode)] */) {
                        if ((TStringGuards.isFixedWidth(arg4Value, arg8Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_);
                            return LastIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, this.direct_indexOfStringNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringNode.decode(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, InternalNextNode, InternalPreviousNode, InternalPreviousNode)] */) {
                        DecodeData s1_ = this.decode_cache.get(arg0Value);
                        if (s1_ != null) {
                            if ((!(TStringGuards.isFixedWidth(arg4Value, arg8Value)))) {
                                return LastIndexOfStringNode.decode(s1_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, INLINED_DECODE_NEXT_NODE_A_, INLINED_DECODE_PREV_NODE_A_, INLINED_DECODE_PREV_NODE_B_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, Encoding arg11Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isFixedWidth(arg4Value, arg8Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.LastIndexOfStringNode.direct(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, RawLastIndexOfStringNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_);
                    return LastIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, this.direct_indexOfStringNode_);
                }
                if ((!(TStringGuards.isFixedWidth(arg4Value, arg8Value)))) {
                    DecodeData s1_ = arg0Value.insert(new DecodeData());
                    VarHandle.storeStoreFence();
                    this.decode_cache.set(arg0Value, s1_);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.LastIndexOfStringNode.decode(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, Encoding, InternalNextNode, InternalPreviousNode, InternalPreviousNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return LastIndexOfStringNode.decode(s1_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, INLINED_DECODE_NEXT_NODE_A_, INLINED_DECODE_PREV_NODE_A_, INLINED_DECODE_PREV_NODE_B_);
                }
                throw newUnsupportedSpecializationException12LLLJILLJIIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value);
            }

        }
        @GeneratedBy(LastIndexOfStringNode.class)
        @DenyReplace
        private static final class DecodeData extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link LastIndexOfStringNode#decode}
             *        Parameter: {@link InternalNextNode} nextNodeA
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int decode_state_0_;
            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link LastIndexOfStringNode#decode}
             *        Parameter: {@link InternalPreviousNode} prevNodeA
             *        Inline method: {@link InternalPreviousNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int decode_state_1_;
            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link LastIndexOfStringNode#decode}
             *        Parameter: {@link InternalPreviousNode} prevNodeB
             *        Inline method: {@link InternalPreviousNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int decode_state_2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringNode#decode}
             *   Parameter: {@link InternalNextNode} nextNodeA
             *   Inline method: {@link InternalNextNodeGen#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int decode_nextNodeA__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringNode#decode}
             *   Parameter: {@link InternalPreviousNode} prevNodeA
             *   Inline method: {@link InternalPreviousNodeGen#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int decode_prevNodeA__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringNode#decode}
             *   Parameter: {@link InternalPreviousNode} prevNodeB
             *   Inline method: {@link InternalPreviousNodeGen#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int decode_prevNodeB__field1_;

            DecodeData() {
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
        @GeneratedBy(LastIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached extends LastIndexOfStringNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, Encoding arg11Value) {
                if ((TStringGuards.isFixedWidth(arg4Value, arg8Value))) {
                    return LastIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, (RawLastIndexOfStringNodeGen.getUncached()));
                }
                if ((!(TStringGuards.isFixedWidth(arg4Value, arg8Value)))) {
                    return LastIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, (InternalNextNode.getUncached()), (InternalPreviousNode.getUncached()), (InternalPreviousNode.getUncached()));
                }
                throw newUnsupportedSpecializationException12LLLJILLJIIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LastIndexOfStringRawNode#direct}
     *     Activation probability: 0.65000
     *     With/without class size: 19/5 bytes
     *   Specialization {@link LastIndexOfStringRawNode#unlikelyCases}
     *     Activation probability: 0.35000
     *     With/without class size: 18/21 bytes
     * </pre> */
    @GeneratedBy(LastIndexOfStringRawNode.class)
    @SuppressWarnings("javadoc")
    static final class LastIndexOfStringRawNodeGen {

        private static final StateField FALLBACK_LAST_INDEX_OF_STRING_RAW_NODE_FALLBACK_STATE_0_UPDATER = StateField.create(FallbackData.lookup_(), "fallback_state_0_");
        private static final InternalNextNode INLINED_FALLBACK_NEXT_NODE_A_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, FALLBACK_LAST_INDEX_OF_STRING_RAW_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 22), IntField.create(FallbackData.lookup_(), "fallback_nextNodeA__field1_")));
        private static final StateField FALLBACK_LAST_INDEX_OF_STRING_RAW_NODE_FALLBACK_STATE_1_UPDATER = StateField.create(FallbackData.lookup_(), "fallback_state_1_");
        private static final InternalPreviousNode INLINED_FALLBACK_PREV_NODE_A_ = InternalPreviousNodeGen.inline(InlineTarget.create(InternalPreviousNode.class, FALLBACK_LAST_INDEX_OF_STRING_RAW_NODE_FALLBACK_STATE_1_UPDATER.subUpdater(0, 22), IntField.create(FallbackData.lookup_(), "fallback_prevNodeA__field1_")));
        private static final StateField FALLBACK_LAST_INDEX_OF_STRING_RAW_NODE_FALLBACK_STATE_2_UPDATER = StateField.create(FallbackData.lookup_(), "fallback_state_2_");
        private static final InternalPreviousNode INLINED_FALLBACK_PREV_NODE_B_ = InternalPreviousNodeGen.inline(InlineTarget.create(InternalPreviousNode.class, FALLBACK_LAST_INDEX_OF_STRING_RAW_NODE_FALLBACK_STATE_2_UPDATER.subUpdater(0, 22), IntField.create(FallbackData.lookup_(), "fallback_prevNodeB__field1_")));
        private static final InlinedConditionProfile INLINED_FALLBACK_UTF16FE_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, FALLBACK_LAST_INDEX_OF_STRING_RAW_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(22, 2)));
        private static final InlinedConditionProfile INLINED_FALLBACK_UTF32FE_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, FALLBACK_LAST_INDEX_OF_STRING_RAW_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(24, 2)));
        private static final InlinedConditionProfile INLINED_FALLBACK_ONE_LENGTH_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, FALLBACK_LAST_INDEX_OF_STRING_RAW_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(26, 2)));
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static LastIndexOfStringRawNode getUncached() {
            return LastIndexOfStringRawNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#direct_indexOfStringNode__field1_}
         * <li>{@link Inlined#fallback_cache}
         * </ul> */
        @NeverDefault
        public static LastIndexOfStringRawNode inline(@RequiredField(bits = 3, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new LastIndexOfStringRawNodeGen.Inlined(target);
        }

        @GeneratedBy(LastIndexOfStringRawNode.class)
        @DenyReplace
        private static final class Inlined extends LastIndexOfStringRawNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LastIndexOfStringRawNode#direct}
             *   1: SpecializationActive {@link LastIndexOfStringRawNode#unlikelyCases}
             *   2: InlinedCache
             *        Specialization: {@link LastIndexOfStringRawNode#direct}
             *        Parameter: {@link RawLastIndexOfStringNode} indexOfStringNode
             *        Inline method: {@link RawLastIndexOfStringNodeGen#inline}
             * </pre> */
            private final StateField state_0_;
            private final ReferenceField<Node> direct_indexOfStringNode__field1_;
            private final ReferenceField<FallbackData> fallback_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringRawNode#direct}
             *   Parameter: {@link RawLastIndexOfStringNode} indexOfStringNode
             *   Inline method: {@link RawLastIndexOfStringNodeGen#inline}</pre> */
            private final RawLastIndexOfStringNode direct_indexOfStringNode_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(LastIndexOfStringRawNode.class);
                this.state_0_ = target.getState(0, 3);
                this.direct_indexOfStringNode__field1_ = target.getReference(1, Node.class);
                this.fallback_cache = target.getReference(2, FallbackData.class);
                this.direct_indexOfStringNode_ = RawLastIndexOfStringNodeGen.inline(InlineTarget.create(RawLastIndexOfStringNode.class, state_0_.subUpdater(2, 1), direct_indexOfStringNode__field1_));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, byte[] arg11Value, Encoding arg12Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.direct(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, RawLastIndexOfStringNode)] */) && (TStringGuards.isSupportedEncodingWithCompaction(arg12Value) || TStringGuards.isFixedWidth(arg4Value))) {
                    return false;
                }
                return true;
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, byte[] arg11Value, Encoding arg12Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.direct(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, RawLastIndexOfStringNode)] || SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, InternalNextNode, InternalPreviousNode, InternalPreviousNode, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.direct(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, RawLastIndexOfStringNode)] */) {
                        if ((TStringGuards.isSupportedEncodingWithCompaction(arg12Value) || TStringGuards.isFixedWidth(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_);
                            return LastIndexOfStringRawNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, this.direct_indexOfStringNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, InternalNextNode, InternalPreviousNode, InternalPreviousNode, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        FallbackData s1_ = this.fallback_cache.get(arg0Value);
                        if (s1_ != null) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value)) {
                                return LastIndexOfStringRawNode.unlikelyCases(s1_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, INLINED_FALLBACK_NEXT_NODE_A_, INLINED_FALLBACK_PREV_NODE_A_, INLINED_FALLBACK_PREV_NODE_B_, INLINED_FALLBACK_UTF16FE_PROFILE_, INLINED_FALLBACK_UTF32FE_PROFILE_, INLINED_FALLBACK_ONE_LENGTH_PROFILE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, byte[] arg11Value, Encoding arg12Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg12Value) || TStringGuards.isFixedWidth(arg4Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.direct(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, RawLastIndexOfStringNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_);
                    return LastIndexOfStringRawNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, this.direct_indexOfStringNode_);
                }
                FallbackData s1_ = arg0Value.insert(new FallbackData());
                VarHandle.storeStoreFence();
                this.fallback_cache.set(arg0Value, s1_);
                state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.LastIndexOfStringRawNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, AbstractTruffleString, byte[], long, int, int, int, byte[], Encoding, InternalNextNode, InternalPreviousNode, InternalPreviousNode, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                this.state_0_.set(arg0Value, state_0);
                return LastIndexOfStringRawNode.unlikelyCases(s1_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, INLINED_FALLBACK_NEXT_NODE_A_, INLINED_FALLBACK_PREV_NODE_A_, INLINED_FALLBACK_PREV_NODE_B_, INLINED_FALLBACK_UTF16FE_PROFILE_, INLINED_FALLBACK_UTF32FE_PROFILE_, INLINED_FALLBACK_ONE_LENGTH_PROFILE_);
            }

        }
        @GeneratedBy(LastIndexOfStringRawNode.class)
        @DenyReplace
        private static final class FallbackData extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link LastIndexOfStringRawNode#unlikelyCases}
             *        Parameter: {@link InternalNextNode} nextNodeA
             *        Inline method: {@link InternalNextNodeGen#inline}
             *   22-23: InlinedCache
             *        Specialization: {@link LastIndexOfStringRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   24-25: InlinedCache
             *        Specialization: {@link LastIndexOfStringRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   26-27: InlinedCache
             *        Specialization: {@link LastIndexOfStringRawNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} oneLengthProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int fallback_state_0_;
            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link LastIndexOfStringRawNode#unlikelyCases}
             *        Parameter: {@link InternalPreviousNode} prevNodeA
             *        Inline method: {@link InternalPreviousNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int fallback_state_1_;
            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link LastIndexOfStringRawNode#unlikelyCases}
             *        Parameter: {@link InternalPreviousNode} prevNodeB
             *        Inline method: {@link InternalPreviousNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int fallback_state_2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringRawNode#unlikelyCases}
             *   Parameter: {@link InternalNextNode} nextNodeA
             *   Inline method: {@link InternalNextNodeGen#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int fallback_nextNodeA__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringRawNode#unlikelyCases}
             *   Parameter: {@link InternalPreviousNode} prevNodeA
             *   Inline method: {@link InternalPreviousNodeGen#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int fallback_prevNodeA__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LastIndexOfStringRawNode#unlikelyCases}
             *   Parameter: {@link InternalPreviousNode} prevNodeB
             *   Inline method: {@link InternalPreviousNodeGen#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int fallback_prevNodeB__field1_;

            FallbackData() {
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
        @GeneratedBy(LastIndexOfStringRawNode.class)
        @DenyReplace
        private static final class Uncached extends LastIndexOfStringRawNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, AbstractTruffleString arg5Value, byte[] arg6Value, long arg7Value, int arg8Value, int arg9Value, int arg10Value, byte[] arg11Value, Encoding arg12Value) {
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg12Value) || TStringGuards.isFixedWidth(arg4Value))) {
                    return LastIndexOfStringRawNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, (RawLastIndexOfStringNodeGen.getUncached()));
                }
                return LastIndexOfStringRawNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, (InternalNextNode.getUncached()), (InternalPreviousNode.getUncached()), (InternalPreviousNode.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link StrideFromCodeRangeNode#doUTF16}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link StrideFromCodeRangeNode#doUTF32}
     *     Activation probability: 0.33333
     *     With/without class size: 8/0 bytes
     *   Specialization {@link StrideFromCodeRangeNode#doOther}
     *     Activation probability: 0.18333
     *     With/without class size: 6/0 bytes
     * </pre> */
    @GeneratedBy(StrideFromCodeRangeNode.class)
    @SuppressWarnings("javadoc")
    static final class StrideFromCodeRangeNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException3LIL(Node thisNode_, Object arg0Value, int arg1Value, Object arg2Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
        }

        @NeverDefault
        public static StrideFromCodeRangeNode getUncached() {
            return StrideFromCodeRangeNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static StrideFromCodeRangeNode inline(@RequiredField(bits = 3, value = StateField.class) InlineTarget target) {
            return new StrideFromCodeRangeNodeGen.Inlined(target);
        }

        @GeneratedBy(StrideFromCodeRangeNode.class)
        @DenyReplace
        private static final class Inlined extends StrideFromCodeRangeNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StrideFromCodeRangeNode#doUTF16}
             *   1: SpecializationActive {@link StrideFromCodeRangeNode#doUTF32}
             *   2: SpecializationActive {@link StrideFromCodeRangeNode#doOther}
             * </pre> */
            private final StateField state_0_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(StrideFromCodeRangeNode.class);
                this.state_0_ = target.getState(0, 3);
            }

            @Override
            int execute(Node arg0Value, int arg1Value, Encoding arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0 /* is SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doUTF16(int, Encoding)] || SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doUTF32(int, Encoding)] || SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doOther(int, Encoding)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doUTF16(int, Encoding)] */) {
                        if ((TStringGuards.isUTF16(arg2Value))) {
                            return doUTF16(arg1Value, arg2Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doUTF32(int, Encoding)] */) {
                        if ((TStringGuards.isUTF32(arg2Value))) {
                            return doUTF32(arg1Value, arg2Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doOther(int, Encoding)] */) {
                        if ((!(TStringGuards.isUTF16(arg2Value))) && (!(TStringGuards.isUTF32(arg2Value)))) {
                            return doOther(arg1Value, arg2Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private int executeAndSpecialize(Node arg0Value, int arg1Value, Encoding arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isUTF16(arg2Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doUTF16(int, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doUTF16(arg1Value, arg2Value);
                }
                if ((TStringGuards.isUTF32(arg2Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doUTF32(int, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doUTF32(arg1Value, arg2Value);
                }
                if ((!(TStringGuards.isUTF16(arg2Value))) && (!(TStringGuards.isUTF32(arg2Value)))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.StrideFromCodeRangeNode.doOther(int, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return doOther(arg1Value, arg2Value);
                }
                throw newUnsupportedSpecializationException3LIL(this, arg0Value, arg1Value, arg2Value);
            }

        }
        @GeneratedBy(StrideFromCodeRangeNode.class)
        @DenyReplace
        private static final class Uncached extends StrideFromCodeRangeNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, int arg1Value, Encoding arg2Value) {
                if ((TStringGuards.isUTF16(arg2Value))) {
                    return doUTF16(arg1Value, arg2Value);
                }
                if ((TStringGuards.isUTF32(arg2Value))) {
                    return doUTF32(arg1Value, arg2Value);
                }
                if ((!(TStringGuards.isUTF16(arg2Value))) && (!(TStringGuards.isUTF32(arg2Value)))) {
                    return doOther(arg1Value, arg2Value);
                }
                throw newUnsupportedSpecializationException3LIL(this, arg0Value, arg1Value, arg2Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CalcStringAttributesNode#calc}
     *     Activation probability: 1.00000
     *     With/without class size: 24/3 bytes
     * </pre> */
    @GeneratedBy(CalcStringAttributesNode.class)
    @SuppressWarnings("javadoc")
    static final class CalcStringAttributesNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static CalcStringAttributesNode getUncached() {
            return CalcStringAttributesNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static CalcStringAttributesNode inline(@RequiredField(bits = 21, value = StateField.class) InlineTarget target) {
            return new CalcStringAttributesNodeGen.Inlined(target);
        }

        @GeneratedBy(CalcStringAttributesNode.class)
        @DenyReplace
        private static final class Inlined extends CalcStringAttributesNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link CalcStringAttributesNode#calc}
             *        Parameter: {@link CalcStringAttributesInnerNode} calcNode
             *        Inline method: {@link CalcStringAttributesInnerNodeGen#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesNode#calc}
             *   Parameter: {@link CalcStringAttributesInnerNode} calcNode
             *   Inline method: {@link CalcStringAttributesInnerNodeGen#inline}</pre> */
            private final CalcStringAttributesInnerNode calcNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CalcStringAttributesNode.class);
                this.state_0_ = target.getState(0, 21);
                this.calcNode_ = CalcStringAttributesInnerNodeGen.inline(InlineTarget.create(CalcStringAttributesInnerNode.class, state_0_.subUpdater(0, 21)));
            }

            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, int arg7Value, int arg8Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_);
                return CalcStringAttributesNode.calc(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.calcNode_);
            }

        }
        @GeneratedBy(CalcStringAttributesNode.class)
        @DenyReplace
        private static final class Uncached extends CalcStringAttributesNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, int arg7Value, int arg8Value) {
                return CalcStringAttributesNode.calc(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (CalcStringAttributesInnerNodeGen.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CalcStringAttributesInnerNode#utf8}
     *     Activation probability: 0.48333
     *     With/without class size: 13/1 bytes
     *   Specialization {@link CalcStringAttributesInnerNode#utf16Or32}
     *     Activation probability: 0.33333
     *     With/without class size: 10/1 bytes
     *   Specialization {@link CalcStringAttributesInnerNode#unlikelyCases}
     *     Activation probability: 0.18333
     *     With/without class size: 7/1 bytes
     * </pre> */
    @GeneratedBy(CalcStringAttributesInnerNode.class)
    @SuppressWarnings("javadoc")
    static final class CalcStringAttributesInnerNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static CalcStringAttributesInnerNode getUncached() {
            return CalcStringAttributesInnerNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static CalcStringAttributesInnerNode inline(@RequiredField(bits = 21, value = StateField.class) InlineTarget target) {
            return new CalcStringAttributesInnerNodeGen.Inlined(target);
        }

        @GeneratedBy(CalcStringAttributesInnerNode.class)
        @DenyReplace
        private static final class Inlined extends CalcStringAttributesInnerNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CalcStringAttributesInnerNode#utf8}
             *   1: SpecializationActive {@link CalcStringAttributesInnerNode#utf16Or32}
             *   2: SpecializationActive {@link CalcStringAttributesInnerNode#unlikelyCases}
             *   3-4: InlinedCache
             *        Specialization: {@link CalcStringAttributesInnerNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} validProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   5-6: InlinedCache
             *        Specialization: {@link CalcStringAttributesInnerNode#utf8}
             *        Parameter: {@link InlinedConditionProfile} brokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   7-8: InlinedCache
             *        Specialization: {@link CalcStringAttributesInnerNode#utf16Or32}
             *        Parameter: {@link InlinedConditionProfile} oneByteProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   9-10: InlinedCache
             *        Specialization: {@link CalcStringAttributesInnerNode#utf16Or32}
             *        Parameter: {@link InlinedConditionProfile} twoByteProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   11-12: InlinedCache
             *        Specialization: {@link CalcStringAttributesInnerNode#utf16Or32}
             *        Parameter: {@link InlinedConditionProfile} utf16Profile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   13-14: InlinedCache
             *        Specialization: {@link CalcStringAttributesInnerNode#utf16Or32}
             *        Parameter: {@link InlinedConditionProfile} utf16ValidProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   15-16: InlinedCache
             *        Specialization: {@link CalcStringAttributesInnerNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} asciiBytesLatinProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   17-18: InlinedCache
             *        Specialization: {@link CalcStringAttributesInnerNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   19-20: InlinedCache
             *        Specialization: {@link CalcStringAttributesInnerNode#unlikelyCases}
             *        Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesInnerNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} validProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8_validProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesInnerNode#utf8}
             *   Parameter: {@link InlinedConditionProfile} brokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8_brokenProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesInnerNode#utf16Or32}
             *   Parameter: {@link InlinedConditionProfile} oneByteProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16Or32_oneByteProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesInnerNode#utf16Or32}
             *   Parameter: {@link InlinedConditionProfile} twoByteProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16Or32_twoByteProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesInnerNode#utf16Or32}
             *   Parameter: {@link InlinedConditionProfile} utf16Profile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16Or32_utf16Profile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesInnerNode#utf16Or32}
             *   Parameter: {@link InlinedConditionProfile} utf16ValidProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16Or32_utf16ValidProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesInnerNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} asciiBytesLatinProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_asciiBytesLatinProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesInnerNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf16FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf16FEProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CalcStringAttributesInnerNode#unlikelyCases}
             *   Parameter: {@link InlinedConditionProfile} utf32FEProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile fallback_utf32FEProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CalcStringAttributesInnerNode.class);
                this.state_0_ = target.getState(0, 21);
                this.utf8_validProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(3, 2)));
                this.utf8_brokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(5, 2)));
                this.utf16Or32_oneByteProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(7, 2)));
                this.utf16Or32_twoByteProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(9, 2)));
                this.utf16Or32_utf16Profile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(11, 2)));
                this.utf16Or32_utf16ValidProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(13, 2)));
                this.fallback_asciiBytesLatinProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(15, 2)));
                this.fallback_utf16FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(17, 2)));
                this.fallback_utf32FEProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(19, 2)));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, int arg7Value, int arg8Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.utf8(Node, AbstractTruffleString, byte[], long, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) && (TStringGuards.isUTF8(arg6Value))) {
                    return false;
                }
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.utf16Or32(Node, AbstractTruffleString, byte[], long, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) && (TStringGuards.isUTF16Or32(arg6Value))) {
                    return false;
                }
                return true;
            }

            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.utf8(Node, AbstractTruffleString, byte[], long, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.utf16Or32(Node, AbstractTruffleString, byte[], long, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.utf8(Node, AbstractTruffleString, byte[], long, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF8(arg6Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                            return CalcStringAttributesInnerNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.utf8_validProfile_, this.utf8_brokenProfile_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.utf16Or32(Node, AbstractTruffleString, byte[], long, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF16Or32(arg6Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_);
                            return CalcStringAttributesInnerNode.utf16Or32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.utf16Or32_oneByteProfile_, this.utf16Or32_twoByteProfile_, this.utf16Or32_utf16Profile_, this.utf16Or32_utf16ValidProfile_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value)) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_);
                            return CalcStringAttributesInnerNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fallback_asciiBytesLatinProfile_, this.fallback_utf16FEProfile_, this.fallback_utf32FEProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private long executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isUTF8(arg6Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.utf8(Node, AbstractTruffleString, byte[], long, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_);
                    return CalcStringAttributesInnerNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.utf8_validProfile_, this.utf8_brokenProfile_);
                }
                if ((TStringGuards.isUTF16Or32(arg6Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.utf16Or32(Node, AbstractTruffleString, byte[], long, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_);
                    return CalcStringAttributesInnerNode.utf16Or32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.utf16Or32_oneByteProfile_, this.utf16Or32_twoByteProfile_, this.utf16Or32_utf16Profile_, this.utf16Or32_utf16ValidProfile_);
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.CalcStringAttributesInnerNode.unlikelyCases(Node, AbstractTruffleString, byte[], long, int, int, Encoding, int, int, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_);
                return CalcStringAttributesInnerNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fallback_asciiBytesLatinProfile_, this.fallback_utf16FEProfile_, this.fallback_utf32FEProfile_);
            }

        }
        @GeneratedBy(CalcStringAttributesInnerNode.class)
        @DenyReplace
        private static final class Uncached extends CalcStringAttributesInnerNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, int arg7Value, int arg8Value) {
                if ((TStringGuards.isUTF8(arg6Value))) {
                    return CalcStringAttributesInnerNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF16Or32(arg6Value))) {
                    return CalcStringAttributesInnerNode.utf16Or32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                return CalcStringAttributesInnerNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ParseIntNode#do7Bit}
     *     Activation probability: 0.38500
     *     With/without class size: 13/5 bytes
     *   Specialization {@link ParseIntNode#do7Bit}
     *     Activation probability: 0.29500
     *     With/without class size: 11/5 bytes
     *   Specialization {@link ParseIntNode#do7Bit}
     *     Activation probability: 0.20500
     *     With/without class size: 8/5 bytes
     *   Specialization {@link ParseIntNode#doGeneric}
     *     Activation probability: 0.11500
     *     With/without class size: 6/7 bytes
     * </pre> */
    @GeneratedBy(ParseIntNode.class)
    @SuppressWarnings("javadoc")
    static final class ParseIntNodeGen {

        private static final StateField GENERIC_PARSE_INT_NODE_GENERIC_STATE_0_UPDATER = StateField.create(GenericData.lookup_(), "generic_state_0_");
        private static final InternalNextNode INLINED_GENERIC_NEXT_NODE_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, GENERIC_PARSE_INT_NODE_GENERIC_STATE_0_UPDATER.subUpdater(0, 22), IntField.create(GenericData.lookup_(), "generic_nextNode__field1_")));
        private static final InlinedBranchProfile INLINED_GENERIC_ERROR_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, GENERIC_PARSE_INT_NODE_GENERIC_STATE_0_UPDATER.subUpdater(22, 1)));
        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException7LLLJILI(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, Object arg5Value, int arg6Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @NeverDefault
        public static ParseIntNode getUncached() {
            return ParseIntNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#generic_cache}
         * </ul> */
        @NeverDefault
        public static ParseIntNode inline(@RequiredField(bits = 16, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new ParseIntNodeGen.Inlined(target);
        }

        @GeneratedBy(ParseIntNode.class)
        @DenyReplace
        private static final class Inlined extends ParseIntNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ParseIntNode#do7Bit}
             *   1-3: EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)]
             *   4: SpecializationActive {@link ParseIntNode#do7Bit}
             *   5-7: EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)]
             *   8: SpecializationActive {@link ParseIntNode#do7Bit}
             *   9-11: EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)]
             *   12: SpecializationActive {@link ParseIntNode#doGeneric}
             *   13: InlinedCache
             *        Specialization: {@link ParseIntNode#do7Bit}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   14: InlinedCache
             *        Specialization: {@link ParseIntNode#do7Bit}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   15: InlinedCache
             *        Specialization: {@link ParseIntNode#do7Bit}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            private final StateField state_0_;
            private final ReferenceField<GenericData> generic_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseIntNode#do7Bit}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private final InlinedBranchProfile do7Bit0_errorProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseIntNode#do7Bit}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private final InlinedBranchProfile do7Bit1_errorProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseIntNode#do7Bit}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private final InlinedBranchProfile do7Bit2_errorProfile_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ParseIntNode.class);
                this.state_0_ = target.getState(0, 16);
                this.generic_cache = target.getReference(1, GenericData.class);
                this.do7Bit0_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(13, 1)));
                this.do7Bit1_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(14, 1)));
                this.do7Bit2_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(15, 1)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) throws NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1000100010001) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseIntNode.doGeneric(Node, AbstractTruffleString, byte[], long, int, Encoding, int, InternalNextNode, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg4Value))) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit0_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg4Value))) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit1_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg4Value))) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit2_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.doGeneric(Node, AbstractTruffleString, byte[], long, int, Encoding, int, InternalNextNode, InlinedBranchProfile)] */) {
                        GenericData s3_ = this.generic_cache.get(arg0Value);
                        if (s3_ != null) {
                            if ((!(TStringGuards.is7Bit(arg4Value)))) {
                                return ParseIntNode.doGeneric(s3_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, INLINED_GENERIC_NEXT_NODE_, INLINED_GENERIC_ERROR_PROFILE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) throws NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Do7Bit0_duplicateFound_ = false;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg4Value))) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Do7Bit0_duplicateFound_ = true;
                            }
                        }
                        if (!Do7Bit0_duplicateFound_) {
                            if ((TStringGuards.is7Bit(arg4Value))) {
                                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                                if (((state_0 & 0b1)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                    compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                    state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 1) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */);
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    Do7Bit0_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Do7Bit0_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit0_errorProfile_);
                        }
                        break;
                    }
                }
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Do7Bit1_duplicateFound_ = false;
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg4Value))) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Do7Bit1_duplicateFound_ = true;
                            }
                        }
                        if (!Do7Bit1_duplicateFound_) {
                            if ((TStringGuards.is7Bit(arg4Value))) {
                                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                    compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                    state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 5) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */);
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    Do7Bit1_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Do7Bit1_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit1_errorProfile_);
                        }
                        break;
                    }
                }
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Do7Bit2_duplicateFound_ = false;
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg4Value))) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Do7Bit2_duplicateFound_ = true;
                            }
                        }
                        if (!Do7Bit2_duplicateFound_) {
                            if ((TStringGuards.is7Bit(arg4Value))) {
                                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                                if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                    compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                    state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 9) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */);
                                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[TStringInternalNodes.ParseIntNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    Do7Bit2_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Do7Bit2_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseIntNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit2_errorProfile_);
                        }
                        break;
                    }
                }
                if ((!(TStringGuards.is7Bit(arg4Value)))) {
                    GenericData s3_ = arg0Value.insert(new GenericData());
                    VarHandle.storeStoreFence();
                    this.generic_cache.set(arg0Value, s3_);
                    state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[TStringInternalNodes.ParseIntNode.doGeneric(Node, AbstractTruffleString, byte[], long, int, Encoding, int, InternalNextNode, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ParseIntNode.doGeneric(s3_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, INLINED_GENERIC_NEXT_NODE_, INLINED_GENERIC_ERROR_PROFILE_);
                }
                throw newUnsupportedSpecializationException7LLLJILI(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

        }
        @GeneratedBy(ParseIntNode.class)
        @DenyReplace
        private static final class GenericData extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link ParseIntNode#doGeneric}
             *        Parameter: {@link InternalNextNode} nextNode
             *        Inline method: {@link InternalNextNodeGen#inline}
             *   22: InlinedCache
             *        Specialization: {@link ParseIntNode#doGeneric}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int generic_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseIntNode#doGeneric}
             *   Parameter: {@link InternalNextNode} nextNode
             *   Inline method: {@link InternalNextNodeGen#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int generic_nextNode__field1_;

            GenericData() {
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
        @GeneratedBy(ParseIntNode.class)
        @DenyReplace
        private static final class Uncached extends ParseIntNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) throws NumberFormatException {
                if ((TStringGuards.is7Bit(arg4Value))) {
                    // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                    return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
                }
                if ((TStringGuards.is7Bit(arg4Value))) {
                    // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                    return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
                }
                if ((TStringGuards.is7Bit(arg4Value))) {
                    // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                    return ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
                }
                if ((!(TStringGuards.is7Bit(arg4Value)))) {
                    return ParseIntNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InternalNextNode.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                throw newUnsupportedSpecializationException7LLLJILI(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ParseLongNode#do7Bit}
     *     Activation probability: 0.38500
     *     With/without class size: 13/5 bytes
     *   Specialization {@link ParseLongNode#do7Bit}
     *     Activation probability: 0.29500
     *     With/without class size: 11/5 bytes
     *   Specialization {@link ParseLongNode#do7Bit}
     *     Activation probability: 0.20500
     *     With/without class size: 8/5 bytes
     *   Specialization {@link ParseLongNode#parseLong}
     *     Activation probability: 0.11500
     *     With/without class size: 6/7 bytes
     * </pre> */
    @GeneratedBy(ParseLongNode.class)
    @SuppressWarnings("javadoc")
    static final class ParseLongNodeGen {

        private static final StateField PARSE_LONG_PARSE_LONG_NODE_PARSE_LONG_STATE_0_UPDATER = StateField.create(ParseLongData.lookup_(), "parseLong_state_0_");
        private static final InternalNextNode INLINED_PARSE_LONG_NEXT_NODE_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, PARSE_LONG_PARSE_LONG_NODE_PARSE_LONG_STATE_0_UPDATER.subUpdater(0, 22), IntField.create(ParseLongData.lookup_(), "parseLong_nextNode__field1_")));
        private static final InlinedBranchProfile INLINED_PARSE_LONG_ERROR_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, PARSE_LONG_PARSE_LONG_NODE_PARSE_LONG_STATE_0_UPDATER.subUpdater(22, 1)));
        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException7LLLJILI(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, Object arg5Value, int arg6Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @NeverDefault
        public static ParseLongNode getUncached() {
            return ParseLongNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#parseLong_cache}
         * </ul> */
        @NeverDefault
        public static ParseLongNode inline(@RequiredField(bits = 16, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new ParseLongNodeGen.Inlined(target);
        }

        @GeneratedBy(ParseLongNode.class)
        @DenyReplace
        private static final class Inlined extends ParseLongNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ParseLongNode#do7Bit}
             *   1-3: EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)]
             *   4: SpecializationActive {@link ParseLongNode#do7Bit}
             *   5-7: EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)]
             *   8: SpecializationActive {@link ParseLongNode#do7Bit}
             *   9-11: EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)]
             *   12: SpecializationActive {@link ParseLongNode#parseLong}
             *   13: InlinedCache
             *        Specialization: {@link ParseLongNode#do7Bit}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   14: InlinedCache
             *        Specialization: {@link ParseLongNode#do7Bit}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   15: InlinedCache
             *        Specialization: {@link ParseLongNode#do7Bit}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            private final StateField state_0_;
            private final ReferenceField<ParseLongData> parseLong_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseLongNode#do7Bit}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private final InlinedBranchProfile do7Bit0_errorProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseLongNode#do7Bit}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private final InlinedBranchProfile do7Bit1_errorProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseLongNode#do7Bit}
             *   Parameter: {@link InlinedBranchProfile} errorProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private final InlinedBranchProfile do7Bit2_errorProfile_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ParseLongNode.class);
                this.state_0_ = target.getState(0, 16);
                this.parseLong_cache = target.getReference(1, ParseLongData.class);
                this.do7Bit0_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(13, 1)));
                this.do7Bit1_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(14, 1)));
                this.do7Bit2_errorProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(15, 1)));
            }

            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) throws NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1000100010001) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ParseLongNode.parseLong(Node, AbstractTruffleString, byte[], long, int, Encoding, int, InternalNextNode, InlinedBranchProfile)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg4Value))) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit0_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg4Value))) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit1_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                        if ((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg4Value))) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_);
                                return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit2_errorProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.parseLong(Node, AbstractTruffleString, byte[], long, int, Encoding, int, InternalNextNode, InlinedBranchProfile)] */) {
                        ParseLongData s3_ = this.parseLong_cache.get(arg0Value);
                        if (s3_ != null) {
                            if ((!(TStringGuards.is7Bit(arg4Value)))) {
                                return ParseLongNode.parseLong(s3_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, INLINED_PARSE_LONG_NEXT_NODE_, INLINED_PARSE_LONG_ERROR_PROFILE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private long executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) throws NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Do7Bit0_duplicateFound_ = false;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg4Value))) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Do7Bit0_duplicateFound_ = true;
                            }
                        }
                        if (!Do7Bit0_duplicateFound_) {
                            if ((TStringGuards.is7Bit(arg4Value))) {
                                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                                if (((state_0 & 0b1)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                    compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                    state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 1) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */);
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    Do7Bit0_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Do7Bit0_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit0_errorProfile_);
                        }
                        break;
                    }
                }
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Do7Bit1_duplicateFound_ = false;
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg4Value))) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Do7Bit1_duplicateFound_ = true;
                            }
                        }
                        if (!Do7Bit1_duplicateFound_) {
                            if ((TStringGuards.is7Bit(arg4Value))) {
                                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                    compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                    state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 5) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */);
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    Do7Bit1_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Do7Bit1_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit1_errorProfile_);
                        }
                        break;
                    }
                }
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Do7Bit2_duplicateFound_ = false;
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */ && (state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */  !=  0 && (TStringGuards.is7Bit(arg4Value))) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2))) {
                                Do7Bit2_duplicateFound_ = true;
                            }
                        }
                        if (!Do7Bit2_duplicateFound_) {
                            if ((TStringGuards.is7Bit(arg4Value))) {
                                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2));
                                if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */) {
                                    compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                    state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 9) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */);
                                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[TStringInternalNodes.ParseLongNode.do7Bit(Node, AbstractTruffleString, byte[], long, int, Encoding, int, CompactionLevel, CompactionLevel, InlinedBranchProfile)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    Do7Bit2_duplicateFound_ = true;
                                }
                            }
                        }
                        if (Do7Bit2_duplicateFound_) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseLongNode.do7Bit(..., CompactionLevel cachedCompaction, ...)] */) - 2), this.do7Bit2_errorProfile_);
                        }
                        break;
                    }
                }
                if ((!(TStringGuards.is7Bit(arg4Value)))) {
                    ParseLongData s3_ = arg0Value.insert(new ParseLongData());
                    VarHandle.storeStoreFence();
                    this.parseLong_cache.set(arg0Value, s3_);
                    state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[TStringInternalNodes.ParseLongNode.parseLong(Node, AbstractTruffleString, byte[], long, int, Encoding, int, InternalNextNode, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ParseLongNode.parseLong(s3_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, INLINED_PARSE_LONG_NEXT_NODE_, INLINED_PARSE_LONG_ERROR_PROFILE_);
                }
                throw newUnsupportedSpecializationException7LLLJILI(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

        }
        @GeneratedBy(ParseLongNode.class)
        @DenyReplace
        private static final class ParseLongData extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link ParseLongNode#parseLong}
             *        Parameter: {@link InternalNextNode} nextNode
             *        Inline method: {@link InternalNextNodeGen#inline}
             *   22: InlinedCache
             *        Specialization: {@link ParseLongNode#parseLong}
             *        Parameter: {@link InlinedBranchProfile} errorProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int parseLong_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ParseLongNode#parseLong}
             *   Parameter: {@link InternalNextNode} nextNode
             *   Inline method: {@link InternalNextNodeGen#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int parseLong_nextNode__field1_;

            ParseLongData() {
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
        @GeneratedBy(ParseLongNode.class)
        @DenyReplace
        private static final class Uncached extends ParseLongNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, Encoding arg5Value, int arg6Value) throws NumberFormatException {
                if ((TStringGuards.is7Bit(arg4Value))) {
                    // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                    return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
                }
                if ((TStringGuards.is7Bit(arg4Value))) {
                    // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                    return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
                }
                if ((TStringGuards.is7Bit(arg4Value))) {
                    // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                    return ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))), (InlinedBranchProfile.getUncached()));
                }
                if ((!(TStringGuards.is7Bit(arg4Value)))) {
                    return ParseLongNode.parseLong(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (InternalNextNode.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                throw newUnsupportedSpecializationException7LLLJILI(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ParseDoubleNode#doParse}
     *     Activation probability: 0.48333
     *     With/without class size: 11/4 bytes
     *   Specialization {@link ParseDoubleNode#doParse}
     *     Activation probability: 0.33333
     *     With/without class size: 9/4 bytes
     *   Specialization {@link ParseDoubleNode#doParse}
     *     Activation probability: 0.18333
     *     With/without class size: 6/4 bytes
     * </pre> */
    @GeneratedBy(ParseDoubleNode.class)
    @SuppressWarnings("javadoc")
    static final class ParseDoubleNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException4LLLJ(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value);
        }

        @NeverDefault
        public static ParseDoubleNode getUncached() {
            return ParseDoubleNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static ParseDoubleNode inline(@RequiredField(bits = 12, value = StateField.class) InlineTarget target) {
            return new ParseDoubleNodeGen.Inlined(target);
        }

        @GeneratedBy(ParseDoubleNode.class)
        @DenyReplace
        private static final class Inlined extends ParseDoubleNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ParseDoubleNode#doParse}
             *   1-3: EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)]
             *   4: SpecializationActive {@link ParseDoubleNode#doParse}
             *   5-7: EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)]
             *   8: SpecializationActive {@link ParseDoubleNode#doParse}
             *   9-11: EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)]
             * </pre> */
            private final StateField state_0_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ParseDoubleNode.class);
                this.state_0_ = target.getState(0, 12);
            }

            @Override
            double execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value) throws NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b100010001) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] || SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] || SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */) {
                        if ((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */  !=  0) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2))) {
                                return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2));
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */) {
                        if ((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */  !=  0) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2))) {
                                return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2));
                            }
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */) {
                        if ((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */  !=  0) {
                            CompactionLevel compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2))) {
                                return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2));
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private double executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value) throws NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Parse0_duplicateFound_ = false;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */ && (state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */  !=  0) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2))) {
                                Parse0_duplicateFound_ = true;
                            }
                        }
                        if (!Parse0_duplicateFound_) {
                            // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2));
                            if (((state_0 & 0b1)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */) {
                                compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 1) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */);
                                state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */;
                                this.state_0_.set(arg0Value, state_0);
                                Parse0_duplicateFound_ = true;
                            }
                        }
                        if (Parse0_duplicateFound_) {
                            return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, decodeCompactionLevel(((state_0 & 0b1110) >>> 1 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2));
                        }
                        break;
                    }
                }
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Parse1_duplicateFound_ = false;
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */ && (state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */  !=  0) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2))) {
                                Parse1_duplicateFound_ = true;
                            }
                        }
                        if (!Parse1_duplicateFound_) {
                            // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2));
                            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */) {
                                compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 5) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */);
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */;
                                this.state_0_.set(arg0Value, state_0);
                                Parse1_duplicateFound_ = true;
                            }
                        }
                        if (Parse1_duplicateFound_) {
                            return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, decodeCompactionLevel(((state_0 & 0b11100000) >>> 5 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2));
                        }
                        break;
                    }
                }
                {
                    CompactionLevel compaction__ = null;
                    while (true) {
                        boolean Parse2_duplicateFound_ = false;
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */ && (state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */  !=  0) {
                            compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                            if ((compaction__ == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2))) {
                                Parse2_duplicateFound_ = true;
                            }
                        }
                        if (!Parse2_duplicateFound_) {
                            // assert ((CompactionLevel.fromStride(arg1Value.stride())) == decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2));
                            if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */) {
                                compaction__ = (CompactionLevel.fromStride(arg1Value.stride()));
                                state_0 = (state_0 | ((encodeCompactionLevel((compaction__)) + 2) << 9) /* set-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */);
                                state_0 = state_0 | 0b100000000 /* add SpecializationActive[TStringInternalNodes.ParseDoubleNode.doParse(Node, AbstractTruffleString, byte[], long, CompactionLevel, CompactionLevel)] */;
                                this.state_0_.set(arg0Value, state_0);
                                Parse2_duplicateFound_ = true;
                            }
                        }
                        if (Parse2_duplicateFound_) {
                            return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, decodeCompactionLevel(((state_0 & 0b111000000000) >>> 9 /* get-int EncodedEnum[cache=TStringInternalNodes.ParseDoubleNode.doParse(..., CompactionLevel cachedCompaction)] */) - 2));
                        }
                        break;
                    }
                }
                throw newUnsupportedSpecializationException4LLLJ(this, arg0Value, arg1Value, arg2Value, arg3Value);
            }

        }
        @GeneratedBy(ParseDoubleNode.class)
        @DenyReplace
        private static final class Uncached extends ParseDoubleNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            double execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value) throws NumberFormatException {
                // assert ((CompactionLevel.fromStride(arg1Value.stride())) == ((CompactionLevel.fromStride(arg1Value.stride()))));
                return ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, arg3Value, (CompactionLevel.fromStride(arg1Value.stride())), ((CompactionLevel.fromStride(arg1Value.stride()))));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link FromJavaStringUTF16Node#doNonEmpty}
     *     Activation probability: 1.00000
     *     With/without class size: 24/1 bytes
     * </pre> */
    @GeneratedBy(FromJavaStringUTF16Node.class)
    @SuppressWarnings("javadoc")
    static final class FromJavaStringUTF16NodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static FromJavaStringUTF16Node getUncached() {
            return FromJavaStringUTF16NodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static FromJavaStringUTF16Node inline(@RequiredField(bits = 2, value = StateField.class) InlineTarget target) {
            return new FromJavaStringUTF16NodeGen.Inlined(target);
        }

        @GeneratedBy(FromJavaStringUTF16Node.class)
        @DenyReplace
        private static final class Inlined extends FromJavaStringUTF16Node implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link FromJavaStringUTF16Node#doNonEmpty}
             *        Parameter: {@link InlinedConditionProfile} utf16CompactProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromJavaStringUTF16Node#doNonEmpty}
             *   Parameter: {@link InlinedConditionProfile} utf16CompactProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf16CompactProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(FromJavaStringUTF16Node.class);
                this.state_0_ = target.getState(0, 2);
                this.utf16CompactProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, String arg1Value, int arg2Value, int arg3Value, boolean arg4Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_);
                return FromJavaStringUTF16Node.doNonEmpty(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.utf16CompactProfile_);
            }

        }
        @GeneratedBy(FromJavaStringUTF16Node.class)
        @DenyReplace
        private static final class Uncached extends FromJavaStringUTF16Node implements UnadoptableNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, String arg1Value, int arg2Value, int arg3Value, boolean arg4Value) {
                return FromJavaStringUTF16Node.doNonEmpty(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CreateJavaStringNode#createJavaString}
     *     Activation probability: 1.00000
     *     With/without class size: 24/1 bytes
     * </pre> */
    @GeneratedBy(CreateJavaStringNode.class)
    @SuppressWarnings("javadoc")
    static final class CreateJavaStringNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static CreateJavaStringNode getUncached() {
            return CreateJavaStringNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static CreateJavaStringNode inline(@RequiredField(bits = 2, value = StateField.class) InlineTarget target) {
            return new CreateJavaStringNodeGen.Inlined(target);
        }

        @GeneratedBy(CreateJavaStringNode.class)
        @DenyReplace
        private static final class Inlined extends CreateJavaStringNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link CreateJavaStringNode#createJavaString}
             *        Parameter: {@link InlinedConditionProfile} reuseProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CreateJavaStringNode#createJavaString}
             *   Parameter: {@link InlinedConditionProfile} reuseProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile reuseProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(CreateJavaStringNode.class);
                this.state_0_ = target.getState(0, 2);
                this.reuseProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
            }

            @Override
            String execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_);
                return CreateJavaStringNode.createJavaString(arg0Value, arg1Value, arg2Value, arg3Value, this.reuseProfile_);
            }

        }
        @GeneratedBy(CreateJavaStringNode.class)
        @DenyReplace
        private static final class Uncached extends CreateJavaStringNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            String execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value) {
                return CreateJavaStringNode.createJavaString(arg0Value, arg1Value, arg2Value, arg3Value, (InlinedConditionProfile.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ToValidStringNode#ascii}
     *     Activation probability: 0.32000
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ToValidStringNode#utf8}
     *     Activation probability: 0.26000
     *     With/without class size: 9/1 bytes
     *   Specialization {@link ToValidStringNode#utf16}
     *     Activation probability: 0.20000
     *     With/without class size: 6/0 bytes
     *   Specialization {@link ToValidStringNode#utf32}
     *     Activation probability: 0.14000
     *     With/without class size: 6/1 bytes
     *   Specialization {@link ToValidStringNode#unsupported}
     *     Activation probability: 0.08000
     *     With/without class size: 4/0 bytes
     * </pre> */
    @GeneratedBy(ToValidStringNode.class)
    @SuppressWarnings("javadoc")
    static final class ToValidStringNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException5LLLJL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, Object arg4Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        @NeverDefault
        public static ToValidStringNode getUncached() {
            return ToValidStringNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul> */
        @NeverDefault
        public static ToValidStringNode inline(@RequiredField(bits = 8, value = StateField.class) InlineTarget target) {
            return new ToValidStringNodeGen.Inlined(target);
        }

        @GeneratedBy(ToValidStringNode.class)
        @DenyReplace
        private static final class Inlined extends ToValidStringNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ToValidStringNode#ascii}
             *   1: SpecializationActive {@link ToValidStringNode#utf8}
             *   2: SpecializationActive {@link ToValidStringNode#utf16}
             *   3: SpecializationActive {@link ToValidStringNode#utf32}
             *   4: SpecializationActive {@link ToValidStringNode#unsupported}
             *   5: InlinedCache
             *        Specialization: {@link ToValidStringNode#utf8}
             *        Parameter: {@link InlinedBranchProfile} outOfMemoryProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   6-7: InlinedCache
             *        Specialization: {@link ToValidStringNode#utf32}
             *        Parameter: {@link InlinedConditionProfile} strideProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToValidStringNode#utf8}
             *   Parameter: {@link InlinedBranchProfile} outOfMemoryProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private final InlinedBranchProfile utf8_outOfMemoryProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToValidStringNode#utf32}
             *   Parameter: {@link InlinedConditionProfile} strideProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf32_strideProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ToValidStringNode.class);
                this.state_0_ = target.getState(0, 8);
                this.utf8_outOfMemoryProfile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(5, 1)));
                this.utf32_strideProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(6, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, Encoding arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11111) != 0 /* is SpecializationActive[TStringInternalNodes.ToValidStringNode.ascii(Node, AbstractTruffleString, byte[], long, Encoding)] || SpecializationActive[TStringInternalNodes.ToValidStringNode.utf8(Node, AbstractTruffleString, byte[], long, Encoding, InlinedBranchProfile)] || SpecializationActive[TStringInternalNodes.ToValidStringNode.utf16(Node, AbstractTruffleString, byte[], long, Encoding)] || SpecializationActive[TStringInternalNodes.ToValidStringNode.utf32(Node, AbstractTruffleString, byte[], long, Encoding, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.ToValidStringNode.unsupported(Node, AbstractTruffleString, byte[], long, Encoding)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.ToValidStringNode.ascii(Node, AbstractTruffleString, byte[], long, Encoding)] */) {
                        if ((TStringGuards.isAscii(arg4Value))) {
                            return ToValidStringNode.ascii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.ToValidStringNode.utf8(Node, AbstractTruffleString, byte[], long, Encoding, InlinedBranchProfile)] */) {
                        if ((TStringGuards.isUTF8(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ToValidStringNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.utf8_outOfMemoryProfile_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.ToValidStringNode.utf16(Node, AbstractTruffleString, byte[], long, Encoding)] */) {
                        if ((TStringGuards.isUTF16(arg4Value))) {
                            return ToValidStringNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.ToValidStringNode.utf32(Node, AbstractTruffleString, byte[], long, Encoding, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isUTF32(arg4Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return ToValidStringNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.utf32_strideProfile_);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.ToValidStringNode.unsupported(Node, AbstractTruffleString, byte[], long, Encoding)] */) {
                        assert DSLSupport.assertIdempotence((JCodings.JCODINGS_ENABLED));
                        if ((TStringGuards.isUnsupportedEncoding(arg4Value))) {
                            return ToValidStringNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private TruffleString executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, Encoding arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isAscii(arg4Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.ToValidStringNode.ascii(Node, AbstractTruffleString, byte[], long, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ToValidStringNode.ascii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if ((TStringGuards.isUTF8(arg4Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.ToValidStringNode.utf8(Node, AbstractTruffleString, byte[], long, Encoding, InlinedBranchProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return ToValidStringNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.utf8_outOfMemoryProfile_);
                }
                if ((TStringGuards.isUTF16(arg4Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.ToValidStringNode.utf16(Node, AbstractTruffleString, byte[], long, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ToValidStringNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if ((TStringGuards.isUTF32(arg4Value))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.ToValidStringNode.utf32(Node, AbstractTruffleString, byte[], long, Encoding, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return ToValidStringNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.utf32_strideProfile_);
                }
                if ((JCodings.JCODINGS_ENABLED) && (TStringGuards.isUnsupportedEncoding(arg4Value))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.ToValidStringNode.unsupported(Node, AbstractTruffleString, byte[], long, Encoding)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ToValidStringNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                throw newUnsupportedSpecializationException5LLLJL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

        }
        @GeneratedBy(ToValidStringNode.class)
        @DenyReplace
        private static final class Uncached extends ToValidStringNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, Encoding arg4Value) {
                if ((TStringGuards.isAscii(arg4Value))) {
                    return ToValidStringNode.ascii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if ((TStringGuards.isUTF8(arg4Value))) {
                    return ToValidStringNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (InlinedBranchProfile.getUncached()));
                }
                if ((TStringGuards.isUTF16(arg4Value))) {
                    return ToValidStringNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if ((TStringGuards.isUTF32(arg4Value))) {
                    return ToValidStringNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (InlinedConditionProfile.getUncached()));
                }
                if ((JCodings.JCODINGS_ENABLED) && (TStringGuards.isUnsupportedEncoding(arg4Value))) {
                    return ToValidStringNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                throw newUnsupportedSpecializationException5LLLJL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link TransCodeNode#transcode}
     *     Activation probability: 1.00000
     *     With/without class size: 48/26 bytes
     * </pre> */
    @GeneratedBy(TransCodeNode.class)
    @SuppressWarnings("javadoc")
    static final class TransCodeNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static TransCodeNode getUncached() {
            return TransCodeNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#state_2_}
         * <li>{@link Inlined#state_3_}
         * <li>{@link Inlined#state_4_}
         * <li>{@link Inlined#state_5_}
         * <li>{@link Inlined#transCodeIntlNode__field6_}
         * <li>{@link Inlined#transCodeIntlNode__field7_}
         * </ul> */
        @NeverDefault
        public static TransCodeNode inline(@RequiredField(bits = 26, value = StateField.class)@RequiredField(bits = 15, value = StateField.class)@RequiredField(bits = 24, value = StateField.class)@RequiredField(bits = 29, value = StateField.class)@RequiredField(bits = 21, value = StateField.class)@RequiredField(bits = 22, value = StateField.class)@RequiredField(IntField.class)@RequiredField(IntField.class) InlineTarget target) {
            return new TransCodeNodeGen.Inlined(target);
        }

        @GeneratedBy(TransCodeNode.class)
        @DenyReplace
        private static final class Inlined extends TransCodeNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0-1: InlinedCache
             *        Specialization: {@link TransCodeNode#transcode}
             *        Parameter: {@link InlinedConditionProfile} asciiBytesInvalidProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   2-25: InlinedCache
             *        Specialization: {@link TransCodeNode#transcode}
             *        Parameter: {@link TransCodeIntlWithErrorHandlerNode} transCodeIntlNode
             *        Inline method: {@link TransCodeIntlWithErrorHandlerNodeGen#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-14: InlinedCache
             *        Specialization: {@link TransCodeNode#transcode}
             *        Parameter: {@link TransCodeIntlWithErrorHandlerNode} transCodeIntlNode
             *        Inline method: {@link TransCodeIntlWithErrorHandlerNodeGen#inline}
             * </pre> */
            private final StateField state_1_;
            /**
             * State Info: <pre>
             *   0-23: InlinedCache
             *        Specialization: {@link TransCodeNode#transcode}
             *        Parameter: {@link TransCodeIntlWithErrorHandlerNode} transCodeIntlNode
             *        Inline method: {@link TransCodeIntlWithErrorHandlerNodeGen#inline}
             * </pre> */
            private final StateField state_2_;
            /**
             * State Info: <pre>
             *   0-28: InlinedCache
             *        Specialization: {@link TransCodeNode#transcode}
             *        Parameter: {@link TransCodeIntlWithErrorHandlerNode} transCodeIntlNode
             *        Inline method: {@link TransCodeIntlWithErrorHandlerNodeGen#inline}
             * </pre> */
            private final StateField state_3_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link TransCodeNode#transcode}
             *        Parameter: {@link TransCodeIntlWithErrorHandlerNode} transCodeIntlNode
             *        Inline method: {@link TransCodeIntlWithErrorHandlerNodeGen#inline}
             * </pre> */
            private final StateField state_4_;
            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link TransCodeNode#transcode}
             *        Parameter: {@link TransCodeIntlWithErrorHandlerNode} transCodeIntlNode
             *        Inline method: {@link TransCodeIntlWithErrorHandlerNodeGen#inline}
             * </pre> */
            private final StateField state_5_;
            private final IntField transCodeIntlNode__field6_;
            private final IntField transCodeIntlNode__field7_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeNode#transcode}
             *   Parameter: {@link InlinedConditionProfile} asciiBytesInvalidProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile asciiBytesInvalidProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeNode#transcode}
             *   Parameter: {@link TransCodeIntlWithErrorHandlerNode} transCodeIntlNode
             *   Inline method: {@link TransCodeIntlWithErrorHandlerNodeGen#inline}</pre> */
            private final TransCodeIntlWithErrorHandlerNode transCodeIntlNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(TransCodeNode.class);
                this.state_0_ = target.getState(0, 26);
                this.state_1_ = target.getState(1, 15);
                this.state_2_ = target.getState(2, 24);
                this.state_3_ = target.getState(3, 29);
                this.state_4_ = target.getState(4, 21);
                this.state_5_ = target.getState(5, 22);
                this.transCodeIntlNode__field6_ = target.getPrimitive(6, IntField.class);
                this.transCodeIntlNode__field7_ = target.getPrimitive(7, IntField.class);
                this.asciiBytesInvalidProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(0, 2)));
                this.transCodeIntlNode_ = TransCodeIntlWithErrorHandlerNodeGen.inline(InlineTarget.create(TransCodeIntlWithErrorHandlerNode.class, state_0_.subUpdater(2, 24), state_1_.subUpdater(0, 15), state_2_.subUpdater(0, 24), state_3_.subUpdater(0, 29), state_4_.subUpdater(0, 21), state_5_.subUpdater(0, 22), transCodeIntlNode__field6_, transCodeIntlNode__field7_));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, TranscodingErrorHandler arg7Value) {
                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_1_, this.state_2_, this.state_3_, this.state_4_, this.state_5_, this.transCodeIntlNode__field6_, this.transCodeIntlNode__field7_);
                return TransCodeNode.transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.asciiBytesInvalidProfile_, this.transCodeIntlNode_);
            }

        }
        @GeneratedBy(TransCodeNode.class)
        @DenyReplace
        private static final class Uncached extends TransCodeNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, TranscodingErrorHandler arg7Value) {
                return TransCodeNode.transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, (InlinedConditionProfile.getUncached()), (TransCodeIntlWithErrorHandlerNodeGen.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link TransCodeIntlWithErrorHandlerNode#supportedWithCustomErrorHandler}
     *     Activation probability: 0.65000
     *     With/without class size: 24/16 bytes
     *   Specialization {@link TransCodeIntlWithErrorHandlerNode#transcode}
     *     Activation probability: 0.35000
     *     With/without class size: 13/10 bytes
     * </pre> */
    @GeneratedBy(TransCodeIntlWithErrorHandlerNode.class)
    @SuppressWarnings("javadoc")
    static final class TransCodeIntlWithErrorHandlerNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static TransCodeIntlWithErrorHandlerNode getUncached() {
            return TransCodeIntlWithErrorHandlerNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#state_2_}
         * <li>{@link Inlined#state_3_}
         * <li>{@link Inlined#state_4_}
         * <li>{@link Inlined#state_5_}
         * <li>{@link Inlined#supportedWithCustomErrorHandler_iteratorNextNode__field1_}
         * <li>{@link Inlined#fallback_transCodeIntlNode__field2_}
         * </ul> */
        @NeverDefault
        public static TransCodeIntlWithErrorHandlerNode inline(@RequiredField(bits = 24, value = StateField.class)@RequiredField(bits = 15, value = StateField.class)@RequiredField(bits = 24, value = StateField.class)@RequiredField(bits = 29, value = StateField.class)@RequiredField(bits = 21, value = StateField.class)@RequiredField(bits = 22, value = StateField.class)@RequiredField(IntField.class)@RequiredField(IntField.class) InlineTarget target) {
            return new TransCodeIntlWithErrorHandlerNodeGen.Inlined(target);
        }

        @GeneratedBy(TransCodeIntlWithErrorHandlerNode.class)
        @DenyReplace
        private static final class Inlined extends TransCodeIntlWithErrorHandlerNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link TransCodeIntlWithErrorHandlerNode#supportedWithCustomErrorHandler}
             *   1: SpecializationActive {@link TransCodeIntlWithErrorHandlerNode#transcode}
             *   2-23: InlinedCache
             *        Specialization: {@link TransCodeIntlWithErrorHandlerNode#supportedWithCustomErrorHandler}
             *        Parameter: {@link InternalNextNode} iteratorNextNode
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-14: InlinedCache
             *        Specialization: {@link TransCodeIntlWithErrorHandlerNode#supportedWithCustomErrorHandler}
             *        Parameter: {@link AppendCodePointIntlNode} appendCodePointNode
             *        Inline method: {@link AppendCodePointIntlNodeGen#inline}
             * </pre> */
            private final StateField state_1_;
            /**
             * State Info: <pre>
             *   0-23: InlinedCache
             *        Specialization: {@link TransCodeIntlWithErrorHandlerNode#supportedWithCustomErrorHandler}
             *        Parameter: {@link AppendStringIntlNode} appendStringNode
             *        Inline method: {@link AppendStringIntlNodeGen#inline}
             * </pre> */
            private final StateField state_2_;
            /**
             * State Info: <pre>
             *   0-28: InlinedCache
             *        Specialization: {@link TransCodeIntlWithErrorHandlerNode#supportedWithCustomErrorHandler}
             *        Parameter: {@link ToStringIntlNode} toStringNode
             *        Inline method: {@link ToStringIntlNodeGen#inline}
             * </pre> */
            private final StateField state_3_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link TransCodeIntlWithErrorHandlerNode#transcode}
             *        Parameter: {@link TransCodeIntlNode} transCodeIntlNode
             *        Inline method: {@link TransCodeIntlNodeGen#inline}
             * </pre> */
            private final StateField state_4_;
            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link TransCodeIntlWithErrorHandlerNode#transcode}
             *        Parameter: {@link TransCodeIntlNode} transCodeIntlNode
             *        Inline method: {@link TransCodeIntlNodeGen#inline}
             * </pre> */
            private final StateField state_5_;
            private final IntField supportedWithCustomErrorHandler_iteratorNextNode__field1_;
            private final IntField fallback_transCodeIntlNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlWithErrorHandlerNode#supportedWithCustomErrorHandler}
             *   Parameter: {@link InternalNextNode} iteratorNextNode
             *   Inline method: {@link InternalNextNodeGen#inline}</pre> */
            private final InternalNextNode supportedWithCustomErrorHandler_iteratorNextNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlWithErrorHandlerNode#supportedWithCustomErrorHandler}
             *   Parameter: {@link AppendCodePointIntlNode} appendCodePointNode
             *   Inline method: {@link AppendCodePointIntlNodeGen#inline}</pre> */
            private final AppendCodePointIntlNode supportedWithCustomErrorHandler_appendCodePointNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlWithErrorHandlerNode#supportedWithCustomErrorHandler}
             *   Parameter: {@link AppendStringIntlNode} appendStringNode
             *   Inline method: {@link AppendStringIntlNodeGen#inline}</pre> */
            private final AppendStringIntlNode supportedWithCustomErrorHandler_appendStringNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlWithErrorHandlerNode#supportedWithCustomErrorHandler}
             *   Parameter: {@link ToStringIntlNode} toStringNode
             *   Inline method: {@link ToStringIntlNodeGen#inline}</pre> */
            private final ToStringIntlNode supportedWithCustomErrorHandler_toStringNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlWithErrorHandlerNode#transcode}
             *   Parameter: {@link TransCodeIntlNode} transCodeIntlNode
             *   Inline method: {@link TransCodeIntlNodeGen#inline}</pre> */
            private final TransCodeIntlNode fallback_transCodeIntlNode_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(TransCodeIntlWithErrorHandlerNode.class);
                this.state_0_ = target.getState(0, 24);
                this.state_1_ = target.getState(1, 15);
                this.state_2_ = target.getState(2, 24);
                this.state_3_ = target.getState(3, 29);
                this.state_4_ = target.getState(4, 21);
                this.state_5_ = target.getState(5, 22);
                this.supportedWithCustomErrorHandler_iteratorNextNode__field1_ = target.getPrimitive(6, IntField.class);
                this.fallback_transCodeIntlNode__field2_ = target.getPrimitive(7, IntField.class);
                this.supportedWithCustomErrorHandler_iteratorNextNode_ = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_0_.subUpdater(2, 22), supportedWithCustomErrorHandler_iteratorNextNode__field1_));
                this.supportedWithCustomErrorHandler_appendCodePointNode_ = AppendCodePointIntlNodeGen.inline(InlineTarget.create(AppendCodePointIntlNode.class, state_1_.subUpdater(0, 15)));
                this.supportedWithCustomErrorHandler_appendStringNode_ = AppendStringIntlNodeGen.inline(InlineTarget.create(AppendStringIntlNode.class, state_2_.subUpdater(0, 24)));
                this.supportedWithCustomErrorHandler_toStringNode_ = ToStringIntlNodeGen.inline(InlineTarget.create(ToStringIntlNode.class, state_3_.subUpdater(0, 29)));
                this.fallback_transCodeIntlNode_ = TransCodeIntlNodeGen.inline(InlineTarget.create(TransCodeIntlNode.class, state_4_.subUpdater(0, 21), state_5_.subUpdater(0, 22), fallback_transCodeIntlNode__field2_));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, Encoding arg7Value, TranscodingErrorHandler arg8Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.supportedWithCustomErrorHandler(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, AppendCodePointIntlNode, AppendStringIntlNode, ToStringIntlNode)] */) && (TStringGuards.isBroken(arg5Value) || TStringGuards.isAsciiBytesOrLatin1(arg7Value)) && (TStringGuards.isSupportedEncodingWithCompaction(arg6Value)) && (TStringGuards.isSupportedEncodingWithCompaction(arg7Value)) && (!(TStringGuards.isBuiltin(arg8Value)))) {
                    return false;
                }
                return true;
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, Encoding arg7Value, TranscodingErrorHandler arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.supportedWithCustomErrorHandler(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, AppendCodePointIntlNode, AppendStringIntlNode, ToStringIntlNode)] || SpecializationActive[TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, TransCodeIntlNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.supportedWithCustomErrorHandler(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, AppendCodePointIntlNode, AppendStringIntlNode, ToStringIntlNode)] */) {
                        if ((TStringGuards.isBroken(arg5Value) || TStringGuards.isAsciiBytesOrLatin1(arg7Value)) && (TStringGuards.isSupportedEncodingWithCompaction(arg6Value)) && (TStringGuards.isSupportedEncodingWithCompaction(arg7Value)) && (!(TStringGuards.isBuiltin(arg8Value)))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_, this.supportedWithCustomErrorHandler_iteratorNextNode__field1_, this.state_1_, this.state_2_, this.state_3_);
                            return TransCodeIntlWithErrorHandlerNode.supportedWithCustomErrorHandler(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.supportedWithCustomErrorHandler_iteratorNextNode_, this.supportedWithCustomErrorHandler_appendCodePointNode_, this.supportedWithCustomErrorHandler_appendStringNode_, this.supportedWithCustomErrorHandler_toStringNode_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, TransCodeIntlNode)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value)) {
                            assert InlineSupport.validate(arg0Value, this.state_4_, this.state_5_, this.fallback_transCodeIntlNode__field2_);
                            return TransCodeIntlWithErrorHandlerNode.transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fallback_transCodeIntlNode_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private TruffleString executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, Encoding arg7Value, TranscodingErrorHandler arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isBroken(arg5Value) || TStringGuards.isAsciiBytesOrLatin1(arg7Value)) && (TStringGuards.isSupportedEncodingWithCompaction(arg6Value)) && (TStringGuards.isSupportedEncodingWithCompaction(arg7Value)) && (!(TStringGuards.isBuiltin(arg8Value)))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.supportedWithCustomErrorHandler(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, AppendCodePointIntlNode, AppendStringIntlNode, ToStringIntlNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.supportedWithCustomErrorHandler_iteratorNextNode__field1_, this.state_1_, this.state_2_, this.state_3_);
                    return TransCodeIntlWithErrorHandlerNode.supportedWithCustomErrorHandler(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.supportedWithCustomErrorHandler_iteratorNextNode_, this.supportedWithCustomErrorHandler_appendCodePointNode_, this.supportedWithCustomErrorHandler_appendStringNode_, this.supportedWithCustomErrorHandler_toStringNode_);
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, TransCodeIntlNode)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_4_, this.state_5_, this.fallback_transCodeIntlNode__field2_);
                return TransCodeIntlWithErrorHandlerNode.transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.fallback_transCodeIntlNode_);
            }

        }
        @GeneratedBy(TransCodeIntlWithErrorHandlerNode.class)
        @DenyReplace
        private static final class Uncached extends TransCodeIntlWithErrorHandlerNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, Encoding arg7Value, TranscodingErrorHandler arg8Value) {
                if ((TStringGuards.isBroken(arg5Value) || TStringGuards.isAsciiBytesOrLatin1(arg7Value)) && (TStringGuards.isSupportedEncodingWithCompaction(arg6Value)) && (TStringGuards.isSupportedEncodingWithCompaction(arg7Value)) && (!(TStringGuards.isBuiltin(arg8Value)))) {
                    return TransCodeIntlWithErrorHandlerNode.supportedWithCustomErrorHandler(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InternalNextNode.getUncached()), (AppendCodePointIntlNodeGen.getUncached()), (AppendStringIntlNodeGen.getUncached()), (ToStringIntlNodeGen.getUncached()));
                }
                return TransCodeIntlWithErrorHandlerNode.transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (TransCodeIntlNodeGen.getUncached()));
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link TransCodeIntlNode#targetAscii}
     *     Activation probability: 0.11213
     *     With/without class size: 5/0 bytes
     *   Specialization {@link TransCodeIntlNode#latin1Transcode}
     *     Activation probability: 0.10551
     *     With/without class size: 5/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf8Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)}
     *     Activation probability: 0.09890
     *     With/without class size: 5/1 bytes
     *   Specialization {@link TransCodeIntlNode#utf16Fixed32Bit}
     *     Activation probability: 0.09228
     *     With/without class size: 5/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf16ByteSwapToFE}
     *     Activation probability: 0.08566
     *     With/without class size: 5/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf16ByteSwapFromFE}
     *     Activation probability: 0.07904
     *     With/without class size: 4/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf32ByteSwap}
     *     Activation probability: 0.07243
     *     With/without class size: 4/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf32ByteSwapToFE}
     *     Activation probability: 0.06581
     *     With/without class size: 4/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf16Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedBranchProfile, InlinedConditionProfile)}
     *     Activation probability: 0.05919
     *     With/without class size: 4/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf16FETranscode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedBranchProfile, InlinedConditionProfile)}
     *     Activation probability: 0.05257
     *     With/without class size: 4/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf32TranscodeRegular}
     *     Activation probability: 0.04596
     *     With/without class size: 4/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf32TranscodeLarge}
     *     Activation probability: 0.03934
     *     With/without class size: 4/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf32TranscodeUTF16}
     *     Activation probability: 0.03272
     *     With/without class size: 4/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf32FETranscodeRegular}
     *     Activation probability: 0.02610
     *     With/without class size: 4/0 bytes
     *   Specialization {@link TransCodeIntlNode#utf32FETranscodeLarge}
     *     Activation probability: 0.01949
     *     With/without class size: 4/0 bytes
     *   Specialization {@link TransCodeIntlNode#unsupported}
     *     Activation probability: 0.01287
     *     With/without class size: 4/0 bytes
     * </pre> */
    @GeneratedBy(TransCodeIntlNode.class)
    @SuppressWarnings("javadoc")
    static final class TransCodeIntlNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException9LLLJIILLL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, int arg5Value, Object arg6Value, Object arg7Value, Object arg8Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
        }

        @NeverDefault
        public static TransCodeIntlNode getUncached() {
            return TransCodeIntlNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#iteratorNextNode_field1_}
         * </ul> */
        @NeverDefault
        public static TransCodeIntlNode inline(@RequiredField(bits = 21, value = StateField.class)@RequiredField(bits = 22, value = StateField.class)@RequiredField(IntField.class) InlineTarget target) {
            return new TransCodeIntlNodeGen.Inlined(target);
        }

        @GeneratedBy(TransCodeIntlNode.class)
        @DenyReplace
        private static final class Inlined extends TransCodeIntlNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link TransCodeIntlNode#targetAscii}
             *   1: SpecializationActive {@link TransCodeIntlNode#latin1Transcode}
             *   2: SpecializationActive {@link TransCodeIntlNode#utf8Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)}
             *   3: SpecializationActive {@link TransCodeIntlNode#utf16Fixed32Bit}
             *   4: SpecializationActive {@link TransCodeIntlNode#utf16ByteSwapToFE}
             *   5: SpecializationActive {@link TransCodeIntlNode#utf16ByteSwapFromFE}
             *   6: SpecializationActive {@link TransCodeIntlNode#utf32ByteSwap}
             *   7: SpecializationActive {@link TransCodeIntlNode#utf32ByteSwapToFE}
             *   8: SpecializationActive {@link TransCodeIntlNode#utf16Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedBranchProfile, InlinedConditionProfile)}
             *   9: SpecializationActive {@link TransCodeIntlNode#utf16FETranscode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedBranchProfile, InlinedConditionProfile)}
             *   10: SpecializationActive {@link TransCodeIntlNode#utf32TranscodeRegular}
             *   11: SpecializationActive {@link TransCodeIntlNode#utf32TranscodeLarge}
             *   12: SpecializationActive {@link TransCodeIntlNode#utf32TranscodeUTF16}
             *   13: SpecializationActive {@link TransCodeIntlNode#utf32FETranscodeRegular}
             *   14: SpecializationActive {@link TransCodeIntlNode#utf32FETranscodeLarge}
             *   15: SpecializationActive {@link TransCodeIntlNode#unsupported}
             *   16-17: InlinedCache
             *        Specialization: {@link TransCodeIntlNode#utf8Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)}
             *        Parameter: {@link InlinedConditionProfile} brokenProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   18: InlinedCache
             *        Specialization: {@link TransCodeIntlNode#utf8Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)}
             *        Parameter: {@link InlinedBranchProfile} outOfMemoryProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   19-20: InlinedCache
             *        Specialization: {@link TransCodeIntlNode#utf8Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)}
             *        Parameter: {@link InlinedConditionProfile} largeProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-21: InlinedCache
             *        Specialization: {@link TransCodeIntlNode#targetAscii}
             *        Parameter: {@link InternalNextNode} iteratorNextNode
             *        Inline method: {@link InternalNextNodeGen#inline}
             * </pre> */
            private final StateField state_1_;
            private final IntField iteratorNextNode_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlNode#targetAscii}
             *   Parameter: {@link InternalNextNode} iteratorNextNode
             *   Inline method: {@link InternalNextNodeGen#inline}</pre> */
            private final InternalNextNode iteratorNextNode;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlNode#utf8Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)}
             *   Parameter: {@link InlinedBranchProfile} outOfMemoryProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private final InlinedBranchProfile outOfMemoryProfile;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlNode#utf8Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)}
             *   Parameter: {@link InlinedConditionProfile} largeProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile largeProfile;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TransCodeIntlNode#utf8Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)}
             *   Parameter: {@link InlinedConditionProfile} brokenProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile utf8Transcode_brokenProfile_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(TransCodeIntlNode.class);
                this.state_0_ = target.getState(0, 21);
                this.state_1_ = target.getState(1, 22);
                this.iteratorNextNode_field1_ = target.getPrimitive(2, IntField.class);
                this.iteratorNextNode = InternalNextNodeGen.inline(InlineTarget.create(InternalNextNode.class, state_1_.subUpdater(0, 22), iteratorNextNode_field1_));
                this.outOfMemoryProfile = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(18, 1)));
                this.largeProfile = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(19, 2)));
                this.utf8Transcode_brokenProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, state_0_.subUpdater(16, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, Encoding arg7Value, TranscodingErrorHandler arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1111111111111111) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.targetAscii(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.latin1Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf8Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16Fixed32Bit(AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16ByteSwapToFE(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16ByteSwapFromFE(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32ByteSwap(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32ByteSwapToFE(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedBranchProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16FETranscode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedBranchProfile, InlinedConditionProfile)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeRegular(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeLarge(AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeUTF16(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32FETranscodeRegular(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32FETranscodeLarge(AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] || SpecializationActive[TStringInternalNodes.TransCodeIntlNode.unsupported(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.targetAscii(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] */) {
                        if ((TStringGuards.isSupportedEncoding(arg6Value)) && (TStringGuards.isAscii(arg7Value) || TStringGuards.isBytes(arg7Value))) {
                            return TransCodeIntlNode.targetAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.latin1Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] */) {
                        if ((TStringGuards.isSupportedEncoding(arg6Value)) && (TStringGuards.isLatin1(arg7Value))) {
                            return TransCodeIntlNode.latin1Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf8Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isSupportedEncoding(arg6Value)) && (!(TransCodeIntlNode.isLarge(arg4Value))) && (TStringGuards.isUTF8(arg7Value))) {
                            assert InlineSupport.validate(arg0Value, this.state_0_);
                            return TransCodeIntlNode.utf8Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode, this.utf8Transcode_brokenProfile_, this.outOfMemoryProfile, this.largeProfile);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16Fixed32Bit(AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */) {
                        if ((TStringGuards.isUTF32(arg6Value)) && (TStringGuards.isUTF16(arg7Value))) {
                            return utf16Fixed32Bit(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16ByteSwapToFE(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */) {
                        if ((TStringGuards.isUTF16(arg6Value)) && (TStringGuards.isUTF16FE(arg7Value))) {
                            return TransCodeIntlNode.utf16ByteSwapToFE(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16ByteSwapFromFE(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */) {
                        if ((TStringGuards.isUTF16FE(arg6Value)) && (TStringGuards.isUTF16(arg7Value))) {
                            return TransCodeIntlNode.utf16ByteSwapFromFE(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32ByteSwap(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */) {
                        if ((TStringGuards.isUTF32FE(arg6Value)) && (TStringGuards.isUTF32(arg7Value))) {
                            return TransCodeIntlNode.utf32ByteSwap(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32ByteSwapToFE(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */) {
                        if ((TStringGuards.isUTF32(arg6Value)) && (TStringGuards.isUTF32FE(arg7Value))) {
                            return TransCodeIntlNode.utf32ByteSwapToFE(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedBranchProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF32FE(arg6Value)) && (!(TStringGuards.isFixedWidth(arg5Value))) && (TStringGuards.isUTF16(arg7Value))) {
                            return TransCodeIntlNode.utf16Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode, this.outOfMemoryProfile, this.largeProfile);
                        }
                    }
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16FETranscode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedBranchProfile, InlinedConditionProfile)] */) {
                        if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF32FE(arg6Value)) && (!(TStringGuards.isUTF16(arg6Value))) && (TStringGuards.isUTF16FE(arg7Value))) {
                            return TransCodeIntlNode.utf16FETranscode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode, this.outOfMemoryProfile, this.largeProfile);
                        }
                    }
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeRegular(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] */) {
                        if ((!(TStringGuards.isUTF16(arg6Value))) && (TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF16FE(arg6Value)) && (!(TStringGuards.isFixedWidth(arg5Value))) && (!(TransCodeIntlNode.isLarge(arg4Value))) && (TStringGuards.isUTF32(arg7Value))) {
                            return TransCodeIntlNode.utf32TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode);
                        }
                    }
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeLarge(AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */) {
                        if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF16FE(arg6Value)) && (!(TStringGuards.isFixedWidth(arg5Value))) && (TransCodeIntlNode.isLarge(arg4Value)) && (TStringGuards.isUTF32(arg7Value))) {
                            return TransCodeIntlNode.utf32TranscodeLarge(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeUTF16(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] */) {
                        if ((TStringGuards.isUTF16(arg6Value)) && (!(TStringGuards.isFixedWidth(arg5Value))) && (!(TransCodeIntlNode.isLarge(arg4Value))) && (TStringGuards.isUTF32(arg7Value))) {
                            return TransCodeIntlNode.utf32TranscodeUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode);
                        }
                    }
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32FETranscodeRegular(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] */) {
                        if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF16FE(arg6Value)) && (!(TStringGuards.isUTF32(arg6Value))) && (!(TransCodeIntlNode.isLarge(arg4Value))) && (TStringGuards.isUTF32FE(arg7Value))) {
                            return TransCodeIntlNode.utf32FETranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode);
                        }
                    }
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32FETranscodeLarge(AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */) {
                        if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF16FE(arg6Value)) && (!(TStringGuards.isUTF32(arg6Value))) && (TransCodeIntlNode.isLarge(arg4Value)) && (TStringGuards.isUTF32FE(arg7Value))) {
                            return TransCodeIntlNode.utf32FETranscodeLarge(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                    if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[TStringInternalNodes.TransCodeIntlNode.unsupported(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */) {
                        if ((TStringGuards.isUnsupportedEncoding(arg6Value) || TStringGuards.isUnsupportedEncoding(arg7Value))) {
                            return TransCodeIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private TruffleString executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, Encoding arg7Value, TranscodingErrorHandler arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isSupportedEncoding(arg6Value)) && (TStringGuards.isAscii(arg7Value) || TStringGuards.isBytes(arg7Value))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.targetAscii(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.targetAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isSupportedEncoding(arg6Value)) && (TStringGuards.isLatin1(arg7Value))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.latin1Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.latin1Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isSupportedEncoding(arg6Value)) && (!(TransCodeIntlNode.isLarge(arg4Value))) && (TStringGuards.isUTF8(arg7Value))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf8Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedConditionProfile, InlinedBranchProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    assert InlineSupport.validate(arg0Value, this.state_0_);
                    return TransCodeIntlNode.utf8Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode, this.utf8Transcode_brokenProfile_, this.outOfMemoryProfile, this.largeProfile);
                }
                if ((TStringGuards.isUTF32(arg6Value)) && (TStringGuards.isUTF16(arg7Value))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16Fixed32Bit(AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return utf16Fixed32Bit(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF16(arg6Value)) && (TStringGuards.isUTF16FE(arg7Value))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16ByteSwapToFE(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf16ByteSwapToFE(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF16FE(arg6Value)) && (TStringGuards.isUTF16(arg7Value))) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16ByteSwapFromFE(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf16ByteSwapFromFE(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF32FE(arg6Value)) && (TStringGuards.isUTF32(arg7Value))) {
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32ByteSwap(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf32ByteSwap(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF32(arg6Value)) && (TStringGuards.isUTF32FE(arg7Value))) {
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32ByteSwapToFE(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf32ByteSwapToFE(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF32FE(arg6Value)) && (!(TStringGuards.isFixedWidth(arg5Value))) && (TStringGuards.isUTF16(arg7Value))) {
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16Transcode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedBranchProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf16Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode, this.outOfMemoryProfile, this.largeProfile);
                }
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF32FE(arg6Value)) && (!(TStringGuards.isUTF16(arg6Value))) && (TStringGuards.isUTF16FE(arg7Value))) {
                    state_0 = state_0 | 0b1000000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf16FETranscode(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode, InlinedBranchProfile, InlinedConditionProfile)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf16FETranscode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode, this.outOfMemoryProfile, this.largeProfile);
                }
                if ((!(TStringGuards.isUTF16(arg6Value))) && (TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF16FE(arg6Value)) && (!(TStringGuards.isFixedWidth(arg5Value))) && (!(TransCodeIntlNode.isLarge(arg4Value))) && (TStringGuards.isUTF32(arg7Value))) {
                    state_0 = state_0 | 0b10000000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeRegular(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf32TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF16FE(arg6Value)) && (!(TStringGuards.isFixedWidth(arg5Value))) && (TransCodeIntlNode.isLarge(arg4Value)) && (TStringGuards.isUTF32(arg7Value))) {
                    state_0 = state_0 | 0b100000000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeLarge(AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf32TranscodeLarge(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF16(arg6Value)) && (!(TStringGuards.isFixedWidth(arg5Value))) && (!(TransCodeIntlNode.isLarge(arg4Value))) && (TStringGuards.isUTF32(arg7Value))) {
                    state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32TranscodeUTF16(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf32TranscodeUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF16FE(arg6Value)) && (!(TStringGuards.isUTF32(arg6Value))) && (!(TransCodeIntlNode.isLarge(arg4Value))) && (TStringGuards.isUTF32FE(arg7Value))) {
                    state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32FETranscodeRegular(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler, InternalNextNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf32FETranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.iteratorNextNode);
                }
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF16FE(arg6Value)) && (!(TStringGuards.isUTF32(arg6Value))) && (TransCodeIntlNode.isLarge(arg4Value)) && (TStringGuards.isUTF32FE(arg7Value))) {
                    state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.utf32FETranscodeLarge(AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.utf32FETranscodeLarge(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg6Value) || TStringGuards.isUnsupportedEncoding(arg7Value))) {
                    state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[TStringInternalNodes.TransCodeIntlNode.unsupported(Node, AbstractTruffleString, byte[], long, int, int, Encoding, Encoding, TranscodingErrorHandler)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return TransCodeIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                throw newUnsupportedSpecializationException9LLLJIILLL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

        }
        @GeneratedBy(TransCodeIntlNode.class)
        @DenyReplace
        private static final class Uncached extends TransCodeIntlNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, Encoding arg6Value, Encoding arg7Value, TranscodingErrorHandler arg8Value) {
                if ((TStringGuards.isSupportedEncoding(arg6Value)) && (TStringGuards.isAscii(arg7Value) || TStringGuards.isBytes(arg7Value))) {
                    return TransCodeIntlNode.targetAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InternalNextNode.getUncached()));
                }
                if ((TStringGuards.isSupportedEncoding(arg6Value)) && (TStringGuards.isLatin1(arg7Value))) {
                    return TransCodeIntlNode.latin1Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InternalNextNode.getUncached()));
                }
                if ((TStringGuards.isSupportedEncoding(arg6Value)) && (!(TransCodeIntlNode.isLarge(arg4Value))) && (TStringGuards.isUTF8(arg7Value))) {
                    return TransCodeIntlNode.utf8Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InternalNextNode.getUncached()), (InlinedConditionProfile.getUncached()), (InlinedBranchProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isUTF32(arg6Value)) && (TStringGuards.isUTF16(arg7Value))) {
                    return utf16Fixed32Bit(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF16(arg6Value)) && (TStringGuards.isUTF16FE(arg7Value))) {
                    return TransCodeIntlNode.utf16ByteSwapToFE(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF16FE(arg6Value)) && (TStringGuards.isUTF16(arg7Value))) {
                    return TransCodeIntlNode.utf16ByteSwapFromFE(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF32FE(arg6Value)) && (TStringGuards.isUTF32(arg7Value))) {
                    return TransCodeIntlNode.utf32ByteSwap(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF32(arg6Value)) && (TStringGuards.isUTF32FE(arg7Value))) {
                    return TransCodeIntlNode.utf32ByteSwapToFE(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF32FE(arg6Value)) && (!(TStringGuards.isFixedWidth(arg5Value))) && (TStringGuards.isUTF16(arg7Value))) {
                    return TransCodeIntlNode.utf16Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InternalNextNode.getUncached()), (InlinedBranchProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF32FE(arg6Value)) && (!(TStringGuards.isUTF16(arg6Value))) && (TStringGuards.isUTF16FE(arg7Value))) {
                    return TransCodeIntlNode.utf16FETranscode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InternalNextNode.getUncached()), (InlinedBranchProfile.getUncached()), (InlinedConditionProfile.getUncached()));
                }
                if ((!(TStringGuards.isUTF16(arg6Value))) && (TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF16FE(arg6Value)) && (!(TStringGuards.isFixedWidth(arg5Value))) && (!(TransCodeIntlNode.isLarge(arg4Value))) && (TStringGuards.isUTF32(arg7Value))) {
                    return TransCodeIntlNode.utf32TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InternalNextNode.getUncached()));
                }
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF16FE(arg6Value)) && (!(TStringGuards.isFixedWidth(arg5Value))) && (TransCodeIntlNode.isLarge(arg4Value)) && (TStringGuards.isUTF32(arg7Value))) {
                    return TransCodeIntlNode.utf32TranscodeLarge(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUTF16(arg6Value)) && (!(TStringGuards.isFixedWidth(arg5Value))) && (!(TransCodeIntlNode.isLarge(arg4Value))) && (TStringGuards.isUTF32(arg7Value))) {
                    return TransCodeIntlNode.utf32TranscodeUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InternalNextNode.getUncached()));
                }
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF16FE(arg6Value)) && (!(TStringGuards.isUTF32(arg6Value))) && (!(TransCodeIntlNode.isLarge(arg4Value))) && (TStringGuards.isUTF32FE(arg7Value))) {
                    return TransCodeIntlNode.utf32FETranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (InternalNextNode.getUncached()));
                }
                if ((TStringGuards.isSupportedEncodingWithCompaction(arg6Value) || TStringGuards.isUTF16FE(arg6Value)) && (!(TStringGuards.isUTF32(arg6Value))) && (TransCodeIntlNode.isLarge(arg4Value)) && (TStringGuards.isUTF32FE(arg7Value))) {
                    return TransCodeIntlNode.utf32FETranscodeLarge(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if ((TStringGuards.isUnsupportedEncoding(arg6Value) || TStringGuards.isUnsupportedEncoding(arg7Value))) {
                    return TransCodeIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                throw newUnsupportedSpecializationException9LLLJIILLL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

        }
    }
}
