/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class ExpectError {
    private static final String[] EXPECT_ERROR_TYPES = new String[]{"com.oracle.truffle.api.dsl.test.ExpectError", "com.oracle.truffle.api.test.ExpectError"};

    public static void assertNoErrorExpected(ProcessingEnvironment processingEnv, Element element) {
        for (String errorType : EXPECT_ERROR_TYPES) {
            ExpectError.assertNoErrorExpectedImpl(processingEnv, element, ElementUtils.getTypeElement(processingEnv, errorType));
        }
    }

    private static void assertNoErrorExpectedImpl(ProcessingEnvironment processingEnv, Element element, TypeElement eee) {
        if (eee != null) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().equals(eee)) continue;
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Expected an error, but none found!", element);
            }
        }
    }

    public static boolean isExpectedError(ProcessingEnvironment processingEnv, Element element, String actualText) {
        List<String> expectedErrors = ExpectError.getExpectedErrors(processingEnv, element);
        for (String expectedText : expectedErrors) {
            String newExpectedText = expectedText.replaceAll("%n", System.lineSeparator());
            if (newExpectedText.endsWith("%") && actualText.startsWith(newExpectedText.substring(0, newExpectedText.length() - 1))) {
                return true;
            }
            if (!actualText.equals(newExpectedText)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getExpectedErrors(ProcessingEnvironment processingEnv, Element element) {
        if (element == null) {
            return Collections.emptyList();
        }
        ArrayList<String> expectedErrors = new ArrayList<String>();
        for (String errorType : EXPECT_ERROR_TYPES) {
            ExpectError.collectExpectedErrors(expectedErrors, element, processingEnv.getElementUtils().getTypeElement(errorType));
        }
        return expectedErrors;
    }

    private static void collectExpectedErrors(List<String> expectedErrors, Element element, TypeElement eee) {
        if (eee != null) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                AnnotationValue av;
                Map<? extends ExecutableElement, ? extends AnnotationValue> vals;
                if (!annotationMirror.getAnnotationType().asElement().equals(eee) || (vals = annotationMirror.getElementValues()).size() != 1 || !((av = vals.values().iterator().next()).getValue() instanceof List)) continue;
                List arr = (List)av.getValue();
                for (Object o : arr) {
                    if (!(o instanceof AnnotationValue)) continue;
                    AnnotationValue ov = (AnnotationValue)o;
                    expectedErrors.add((String)ov.getValue());
                }
            }
        }
    }
}

