/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.generator.BitSet;
import com.oracle.truffle.dsl.processor.generator.FlatNodeGenFactory;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import java.util.List;

class MultiBitSet<T extends BitSet> {
    private final List<T> sets;

    MultiBitSet(List<T> sets) {
        this.sets = sets;
    }

    public List<T> getSets() {
        return this.sets;
    }

    public int getCapacity() {
        int length = 0;
        for (BitSet a : this.sets) {
            length += a.getCapacity();
        }
        return length;
    }

    public CodeTree createContains(FlatNodeGenFactory.FrameState frameState, Object[] elements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        String sep = "";
        if (this.sets.size() > 1) {
            builder.string("(");
        }
        for (BitSet set : this.sets) {
            Object[] included = set.filter(elements);
            if (included.length <= 0) continue;
            builder.string(sep);
            builder.tree(set.createContains(frameState, included));
            sep = " || ";
        }
        if (this.sets.size() > 1) {
            builder.string(")");
        }
        return builder.build();
    }

    public CodeTree createSet(FlatNodeGenFactory.FrameState frameState, Object[] elements, boolean value, boolean persist) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        for (BitSet set : this.sets) {
            Object[] included = set.filter(elements);
            if (included.length <= 0 && !persist) continue;
            builder.tree(set.createSet(frameState, included, value, persist));
        }
        return builder.build();
    }

    public CodeTree createContainsOnly(FlatNodeGenFactory.FrameState frameState, int offset, int length, Object[] selectedElements, Object[] allElements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        String sep = "";
        for (BitSet set : this.sets) {
            CodeTree containsOnly;
            Object[] selected = set.filter(selectedElements);
            Object[] filteredAll = set.filter(allElements);
            if (filteredAll.length <= 0 || (containsOnly = set.createContainsOnly(frameState, offset, length, selected, filteredAll)) == null) continue;
            builder.string(sep);
            builder.tree(containsOnly);
            sep = " && ";
        }
        return builder.build();
    }

    public CodeTree createIs(FlatNodeGenFactory.FrameState frameState, Object[] selectedElements, Object[] maskedElements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        String sep = "";
        for (BitSet set : this.sets) {
            Object[] selected = set.filter(selectedElements);
            Object[] masked = set.filter(maskedElements);
            if (masked.length <= 0) continue;
            builder.string(sep);
            builder.tree(set.createIs(frameState, selected, masked));
            sep = " && ";
        }
        return builder.build();
    }

    public CodeTree createIsNotAny(FlatNodeGenFactory.FrameState frameState, Object[] elements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.string("(");
        String sep = "";
        for (BitSet set : this.sets) {
            Object[] setElements = set.filter(elements);
            if (setElements.length <= 0) continue;
            builder.string(sep);
            builder.tree(set.createIsNotAny(frameState, setElements));
            sep = " || ";
        }
        builder.string(")");
        return builder.build();
    }

    public CodeTree createExtractInteger(FlatNodeGenFactory.FrameState frameState, Object element) {
        for (BitSet set : this.sets) {
            if (!set.contains(element)) continue;
            return set.createExtractInteger(frameState, element);
        }
        throw new AssertionError((Object)"element not contained");
    }

    public CodeTree createNotContains(FlatNodeGenFactory.FrameState frameState, Object[] elements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        String sep = "";
        for (BitSet set : this.sets) {
            Object[] setElements = set.filter(elements);
            if (setElements.length <= 0) continue;
            builder.string(sep);
            builder.tree(set.createNotContains(frameState, setElements));
            sep = " && ";
        }
        return builder.build();
    }

    public CodeTree createSetInteger(FlatNodeGenFactory.FrameState frameState, Object element, CodeTree value) {
        for (BitSet set : this.sets) {
            if (!set.contains(element)) continue;
            return set.createSetInteger(frameState, element, value);
        }
        throw new AssertionError((Object)"element not contained");
    }
}

